/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.kernel.magic.command.functionality;

import com.twosigma.beakerx.TryResult;
import com.twosigma.beakerx.evaluator.EvaluationObjectFactory;
import com.twosigma.beakerx.jvm.object.EvaluationObject;
import com.twosigma.beakerx.kernel.CodeFrame;
import com.twosigma.beakerx.kernel.ExecutionOptions;
import com.twosigma.beakerx.kernel.GroupName;
import com.twosigma.beakerx.kernel.KernelFunctionality;
import com.twosigma.beakerx.kernel.KernelManager;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandExecutionParam;
import com.twosigma.beakerx.kernel.magic.command.MagicCommandFunctionality;
import com.twosigma.beakerx.kernel.magic.command.functionality.AsyncMagicCommandOptions;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutcomeItem;
import com.twosigma.beakerx.kernel.magic.command.outcome.MagicCommandOutput;
import com.twosigma.beakerx.kernel.msg.MessageCreator;
import com.twosigma.beakerx.message.Message;
import com.twosigma.beakerx.widget.HBox;
import com.twosigma.beakerx.widget.RESTButton;
import com.twosigma.beakerx.widget.Spinner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class AsyncMagicCommand
implements MagicCommandFunctionality {
    public static final String ASYNC = "%%async";
    public static final String CANCEL_EXECUTION = "cancel/execution/";
    private KernelFunctionality kernel;
    private EvaluationObjectFactory objectFactory;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    private AsyncMagicCommandOptions asyncMagicCommandOptions;

    public AsyncMagicCommand(KernelFunctionality kernel, EvaluationObjectFactory objectFactory) {
        this.kernel = kernel;
        this.objectFactory = objectFactory;
        this.asyncMagicCommandOptions = new AsyncMagicCommandOptions();
    }

    public String getMagicCommandName() {
        return ASYNC;
    }

    public MagicCommandOutcomeItem execute(MagicCommandExecutionParam param) {
        AsyncMagicCommandOptions.OptionsResult optionsResult = this.asyncMagicCommandOptions.parseOptions(this.getOptions(param));
        if (optionsResult.hasError()) {
            return new MagicCommandOutput(MagicCommandOutcomeItem.Status.ERROR, optionsResult.errorMsg(), MessageCreator.get());
        }
        return this.runAsync(param, optionsResult);
    }

    private MagicCommandOutcomeItem runAsync(MagicCommandExecutionParam param, AsyncMagicCommandOptions.OptionsResult optionsResult) {
        GroupName groupName = GroupName.generate();
        Message parentMessage = param.getCode().getMessage();
        HBox panel = this.createCancelPanel(parentMessage, groupName.asString());
        panel.display();
        this.executorService.submit(() -> {
            int executionCount = param.getExecutionCount();
            EvaluationObject seo = this.objectFactory.createSeo(param.getCommandCodeBlock(), this.kernel, parentMessage, executionCount);
            TryResult result = this.kernel.executeCode(param.getCommandCodeBlock(), seo, new ExecutionOptions(groupName));
            panel.close();
            CodeFrame.handleResult((EvaluationObject)seo, (TryResult)result);
            if (result.isResult()) {
                optionsResult.options().forEach(AsyncOptionCommand::run);
            }
        });
        return new MagicCommandOutput(MagicCommandOutcomeItem.Status.OK, MessageCreator.get());
    }

    private String[] getOptions(MagicCommandExecutionParam param) {
        String[] parts = param.getCommand().split(" ");
        if (parts.length == 1) {
            return new String[0];
        }
        return Arrays.copyOfRange(parts, 1, parts.length);
    }

    @NotNull
    private HBox createCancelPanel(Message parentMessage, String groupName) {
        Spinner spinner = new Spinner(parentMessage, "Running...");
        RESTButton xButton = new RESTButton(KernelManager.get().getBeakerXServer().getURL() + CANCEL_EXECUTION + groupName, parentMessage);
        xButton.setDomClasses(new ArrayList<String>(Arrays.asList("bx-button", "icon-close")));
        xButton.setTooltip("Cancel asynchronous computation");
        return new HBox(Arrays.asList(xButton, spinner), parentMessage);
    }

    static interface AsyncOptionCommand {
        public void run();
    }
}

