/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.serializer;

import java.util.Arrays;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;

public class HeatMapReducer {
    private final int nodeLimit;
    private final int columnLimit;
    private final int rowLimit;

    public HeatMapReducer(int columnLimit, int rowLimit) {
        this.columnLimit = columnLimit;
        this.rowLimit = rowLimit;
        this.nodeLimit = this.columnLimit * this.rowLimit;
    }

    public Number[][] limitHeatmap(Number[][] data) {
        boolean tooManyRows;
        Number[][] limitedElementsInRow = this.limitElementsInRow(data);
        int totalPoints = HeatMapReducer.totalPoints(limitedElementsInRow);
        boolean bl = tooManyRows = totalPoints > this.nodeLimit;
        if (tooManyRows) {
            return this.limitRows(limitedElementsInRow);
        }
        return limitedElementsInRow;
    }

    private Number[][] limitRows(Number[][] limitedElementsInRow) {
        int stepForRow = this.findStepForRow(limitedElementsInRow);
        Number[][] limitedRows = (Number[][])IntStream.range(0, limitedElementsInRow.length).filter(n -> n % stepForRow == 0).mapToObj(index -> limitedElementsInRow[index]).toArray(x$0 -> new Number[x$0][]);
        return limitedRows;
    }

    @NotNull
    private Number[][] limitElementsInRow(Number[][] data) {
        Number[][] limitedElements = (Number[][])Arrays.stream(data).map(row -> {
            if (((Number[])row).length > this.columnLimit) {
                int step = this.findStepForColumn((Number[])row);
                Number[] limitedRow = (Number[])IntStream.range(0, ((Number[])row).length).filter(n -> n % step == 0).mapToObj(index -> row[index]).toArray(Number[]::new);
                return limitedRow;
            }
            return row;
        }).toArray(x$0 -> new Number[x$0][]);
        return limitedElements;
    }

    private int findStepForRow(Number[][] data) {
        int step = 2;
        while (data.length / step > this.rowLimit) {
            ++step;
        }
        return step;
    }

    private int findStepForColumn(Number[] row) {
        int step = 2;
        while (row.length / step > this.columnLimit) {
            ++step;
        }
        return step;
    }

    public static int totalPoints(Number[][] data) {
        return Arrays.stream(data).mapToInt(x -> ((Number[])x).length).sum();
    }
}

