/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.OffsetTime;
import java.time.temporal.Temporal;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.error.ShouldBeEqualIgnoringTimezone;
import org.assertj.core.error.ShouldHaveSameHourAs;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public abstract class AbstractOffsetTimeAssert<S extends AbstractOffsetTimeAssert<S>>
extends AbstractAssert<S, OffsetTime> {
    public static final String NULL_OFFSET_TIME_PARAMETER_MESSAGE = "The OffsetTime to compare actual with should not be null";

    protected AbstractOffsetTimeAssert(OffsetTime actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected OffsetTime getActual() {
        return (OffsetTime)this.actual;
    }

    public S isBefore(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!((OffsetTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (S)((AbstractOffsetTimeAssert)this.myself);
    }

    public S isBefore(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return this.isBefore(OffsetTime.parse(offsetTimeAsString));
    }

    public S isBeforeOrEqualTo(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (((OffsetTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractOffsetTimeAssert)this.myself);
    }

    public S isBeforeOrEqualTo(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return this.isBeforeOrEqualTo(OffsetTime.parse(offsetTimeAsString));
    }

    public S isAfterOrEqualTo(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (((OffsetTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractOffsetTimeAssert)this.myself);
    }

    public S isAfterOrEqualTo(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return this.isAfterOrEqualTo(OffsetTime.parse(offsetTimeAsString));
    }

    public S isAfter(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!((OffsetTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (S)((AbstractOffsetTimeAssert)this.myself);
    }

    public S isAfter(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return this.isAfter(OffsetTime.parse(offsetTimeAsString));
    }

    public S isEqualTo(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return (S)((AbstractOffsetTimeAssert)this.isEqualTo(OffsetTime.parse(offsetTimeAsString)));
    }

    public S isNotEqualTo(String offsetTimeAsString) {
        AbstractOffsetTimeAssert.assertOffsetTimeAsStringParameterIsNotNull(offsetTimeAsString);
        return (S)((AbstractOffsetTimeAssert)this.isNotEqualTo(OffsetTime.parse(offsetTimeAsString)));
    }

    public S isIn(String ... offsetTimesAsString) {
        this.checkIsNotNullAndNotEmpty(offsetTimesAsString);
        return (S)((AbstractOffsetTimeAssert)this.isIn(AbstractOffsetTimeAssert.convertToOffsetTimeArray(offsetTimesAsString)));
    }

    public S isNotIn(String ... offsetTimesAsString) {
        this.checkIsNotNullAndNotEmpty(offsetTimesAsString);
        return (S)((AbstractOffsetTimeAssert)this.isNotIn(AbstractOffsetTimeAssert.convertToOffsetTimeArray(offsetTimesAsString)));
    }

    private static Object[] convertToOffsetTimeArray(String ... offsetTimesAsString) {
        Object[] dates = new OffsetTime[offsetTimesAsString.length];
        for (int i = 0; i < offsetTimesAsString.length; ++i) {
            dates[i] = OffsetTime.parse(offsetTimesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given OffsetTime array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given OffsetTime array should not be empty");
        }
    }

    private static void assertOffsetTimeAsStringParameterIsNotNull(String OffsetTimeAsString) {
        if (OffsetTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the OffsetTime to compare actual with should not be null");
        }
    }

    private static void assertOffsetTimeParameterIsNotNull(OffsetTime other) {
        if (other == null) {
            throw new IllegalArgumentException(NULL_OFFSET_TIME_PARAMETER_MESSAGE);
        }
    }

    public S isEqualToIgnoringNanos(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!AbstractOffsetTimeAssert.areEqualIgnoringNanos((OffsetTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos((OffsetTime)this.actual, other));
        }
        return (S)((AbstractOffsetTimeAssert)this.myself);
    }

    public S isEqualToIgnoringSeconds(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!AbstractOffsetTimeAssert.areEqualIgnoringSeconds((OffsetTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds((OffsetTime)this.actual, other));
        }
        return (S)((AbstractOffsetTimeAssert)this.myself);
    }

    public S isEqualToIgnoringTimezone(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!AbstractOffsetTimeAssert.areEqualIgnoringTimezone((OffsetTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringTimezone.shouldBeEqualIgnoringTimezone((OffsetTime)this.actual, other));
        }
        return (S)((AbstractOffsetTimeAssert)this.myself);
    }

    public S hasSameHourAs(OffsetTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractOffsetTimeAssert.assertOffsetTimeParameterIsNotNull(other);
        if (!AbstractOffsetTimeAssert.haveSameHourField((OffsetTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveSameHourAs.shouldHaveSameHourAs((Temporal)this.actual, other));
        }
        return (S)((AbstractOffsetTimeAssert)this.myself);
    }

    private static boolean areEqualIgnoringNanos(OffsetTime actual, OffsetTime other) {
        return AbstractOffsetTimeAssert.areEqualIgnoringSeconds(actual, other) && AbstractOffsetTimeAssert.haveSameSecond(actual, other);
    }

    private static boolean areEqualIgnoringSeconds(OffsetTime actual, OffsetTime other) {
        return AbstractOffsetTimeAssert.haveSameHourField(actual, other) && AbstractOffsetTimeAssert.haveSameMinute(actual, other);
    }

    private static boolean areEqualIgnoringTimezone(OffsetTime actual, OffsetTime other) {
        return AbstractOffsetTimeAssert.areEqualIgnoringNanos(actual, other) && AbstractOffsetTimeAssert.haveSameNano(actual, other);
    }

    private static boolean haveSameNano(OffsetTime actual, OffsetTime other) {
        return actual.getNano() == other.getNano();
    }

    private static boolean haveSameSecond(OffsetTime actual, OffsetTime other) {
        return actual.getSecond() == other.getSecond();
    }

    private static boolean haveSameMinute(OffsetTime actual, OffsetTime other) {
        return actual.getMinute() == other.getMinute();
    }

    private static boolean haveSameHourField(OffsetTime actual, OffsetTime other) {
        return actual.getHour() == other.getHour();
    }
}

