"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("@aws-cdk/aws-codepipeline");
const sns = require("@aws-cdk/aws-sns");
const subs = require("@aws-cdk/aws-sns-subscriptions");
const action_1 = require("./action");
/**
 * Manual approval action.
 */
class ManualApprovalAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        this.props = props;
    }
    get notificationTopic() {
        return this._notificationTopic;
    }
    bound(scope, _stage, options) {
        var _a;
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_a = this._notificationTopic) === null || _a === void 0 ? void 0 : _a.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,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