"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const codepipeline = require("@aws-cdk/aws-codepipeline");
const cdk = require("@aws-cdk/core");
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends cdk.Construct {
    constructor(parent, id, props) {
        super(parent, id);
        new codepipeline.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: props.actionProperties === undefined ? undefined : props.actionProperties.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
//# sourceMappingURL=data:application/json;base64,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