"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The ArtifactBounds that make sense for source Actions -
 * they don't have any inputs, and have exactly one output.
 */
function sourceArtifactBounds() {
    return {
        minInputs: 0,
        maxInputs: 0,
        minOutputs: 1,
        maxOutputs: 1,
    };
}
exports.sourceArtifactBounds = sourceArtifactBounds;
/**
 * The ArtifactBounds that make sense for deploy Actions -
 * they have exactly one input, and don't produce any outputs.
 */
function deployArtifactBounds() {
    return {
        minInputs: 1,
        maxInputs: 1,
        minOutputs: 0,
        maxOutputs: 0,
    };
}
exports.deployArtifactBounds = deployArtifactBounds;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tbW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBRUE7OztHQUdHO0FBQ0gsU0FBZ0Isb0JBQW9CO0lBQ2xDLE9BQU87UUFDTCxTQUFTLEVBQUUsQ0FBQztRQUNaLFNBQVMsRUFBRSxDQUFDO1FBQ1osVUFBVSxFQUFFLENBQUM7UUFDYixVQUFVLEVBQUUsQ0FBQztLQUNkLENBQUM7QUFDSixDQUFDO0FBUEQsb0RBT0M7QUFFRDs7O0dBR0c7QUFDSCxTQUFnQixvQkFBb0I7SUFDbEMsT0FBTztRQUNMLFNBQVMsRUFBRSxDQUFDO1FBQ1osU0FBUyxFQUFFLENBQUM7UUFDWixVQUFVLEVBQUUsQ0FBQztRQUNiLFVBQVUsRUFBRSxDQUFDO0tBQ2QsQ0FBQztBQUNKLENBQUM7QUFQRCxvREFPQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNvZGVwaXBlbGluZSBmcm9tICdAYXdzLWNkay9hd3MtY29kZXBpcGVsaW5lJztcblxuLyoqXG4gKiBUaGUgQXJ0aWZhY3RCb3VuZHMgdGhhdCBtYWtlIHNlbnNlIGZvciBzb3VyY2UgQWN0aW9ucyAtXG4gKiB0aGV5IGRvbid0IGhhdmUgYW55IGlucHV0cywgYW5kIGhhdmUgZXhhY3RseSBvbmUgb3V0cHV0LlxuICovXG5leHBvcnQgZnVuY3Rpb24gc291cmNlQXJ0aWZhY3RCb3VuZHMoKTogY29kZXBpcGVsaW5lLkFjdGlvbkFydGlmYWN0Qm91bmRzIHtcbiAgcmV0dXJuIHtcbiAgICBtaW5JbnB1dHM6IDAsXG4gICAgbWF4SW5wdXRzOiAwLFxuICAgIG1pbk91dHB1dHM6IDEsXG4gICAgbWF4T3V0cHV0czogMSxcbiAgfTtcbn1cblxuLyoqXG4gKiBUaGUgQXJ0aWZhY3RCb3VuZHMgdGhhdCBtYWtlIHNlbnNlIGZvciBkZXBsb3kgQWN0aW9ucyAtXG4gKiB0aGV5IGhhdmUgZXhhY3RseSBvbmUgaW5wdXQsIGFuZCBkb24ndCBwcm9kdWNlIGFueSBvdXRwdXRzLlxuICovXG5leHBvcnQgZnVuY3Rpb24gZGVwbG95QXJ0aWZhY3RCb3VuZHMoKTogY29kZXBpcGVsaW5lLkFjdGlvbkFydGlmYWN0Qm91bmRzIHtcbiAgcmV0dXJuIHtcbiAgICBtaW5JbnB1dHM6IDEsXG4gICAgbWF4SW5wdXRzOiAxLFxuICAgIG1pbk91dHB1dHM6IDAsXG4gICAgbWF4T3V0cHV0czogMCxcbiAgfTtcbn1cbiJdfQ==