# coding: utf-8

"""
    CyberSource Flex API

    Simple PAN tokenization service

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V2paymentsProcessingInformationAuthorizationOptions(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'auth_type': 'str',
        'verbal_auth_code': 'str',
        'verbal_auth_transaction_id': 'str',
        'auth_indicator': 'str',
        'partial_auth_indicator': 'bool',
        'balance_inquiry': 'bool',
        'ignore_avs_result': 'bool',
        'decline_avs_flags': 'list[str]',
        'ignore_cv_result': 'bool',
        'initiator': 'V2paymentsProcessingInformationAuthorizationOptionsInitiator'
    }

    attribute_map = {
        'auth_type': 'authType',
        'verbal_auth_code': 'verbalAuthCode',
        'verbal_auth_transaction_id': 'verbalAuthTransactionId',
        'auth_indicator': 'authIndicator',
        'partial_auth_indicator': 'partialAuthIndicator',
        'balance_inquiry': 'balanceInquiry',
        'ignore_avs_result': 'ignoreAvsResult',
        'decline_avs_flags': 'declineAvsFlags',
        'ignore_cv_result': 'ignoreCvResult',
        'initiator': 'initiator'
    }

    def __init__(self, auth_type=None, verbal_auth_code=None, verbal_auth_transaction_id=None, auth_indicator=None, partial_auth_indicator=None, balance_inquiry=None, ignore_avs_result=False, decline_avs_flags=None, ignore_cv_result=False, initiator=None):
        """
        V2paymentsProcessingInformationAuthorizationOptions - a model defined in Swagger
        """

        self._auth_type = None
        self._verbal_auth_code = None
        self._verbal_auth_transaction_id = None
        self._auth_indicator = None
        self._partial_auth_indicator = None
        self._balance_inquiry = None
        self._ignore_avs_result = None
        self._decline_avs_flags = None
        self._ignore_cv_result = None
        self._initiator = None

        if auth_type is not None:
          self.auth_type = auth_type
        if verbal_auth_code is not None:
          self.verbal_auth_code = verbal_auth_code
        if verbal_auth_transaction_id is not None:
          self.verbal_auth_transaction_id = verbal_auth_transaction_id
        if auth_indicator is not None:
          self.auth_indicator = auth_indicator
        if partial_auth_indicator is not None:
          self.partial_auth_indicator = partial_auth_indicator
        if balance_inquiry is not None:
          self.balance_inquiry = balance_inquiry
        if ignore_avs_result is not None:
          self.ignore_avs_result = ignore_avs_result
        if decline_avs_flags is not None:
          self.decline_avs_flags = decline_avs_flags
        if ignore_cv_result is not None:
          self.ignore_cv_result = ignore_cv_result
        if initiator is not None:
          self.initiator = initiator

    @property
    def auth_type(self):
        """
        Gets the auth_type of this V2paymentsProcessingInformationAuthorizationOptions.
        Authorization type. Possible values:   - **AUTOCAPTURE**: automatic capture.  - **STANDARDCAPTURE**: standard capture.  - **VERBAL**: forced capture. Include it in the payment request for a forced capture. Include it in the capture  request for a verbal payment.  For processor-specific information, see the auth_type field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :return: The auth_type of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._auth_type

    @auth_type.setter
    def auth_type(self, auth_type):
        """
        Sets the auth_type of this V2paymentsProcessingInformationAuthorizationOptions.
        Authorization type. Possible values:   - **AUTOCAPTURE**: automatic capture.  - **STANDARDCAPTURE**: standard capture.  - **VERBAL**: forced capture. Include it in the payment request for a forced capture. Include it in the capture  request for a verbal payment.  For processor-specific information, see the auth_type field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :param auth_type: The auth_type of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """
        if auth_type is not None and len(auth_type) > 15:
            raise ValueError("Invalid value for `auth_type`, length must be less than or equal to `15`")

        self._auth_type = auth_type

    @property
    def verbal_auth_code(self):
        """
        Gets the verbal_auth_code of this V2paymentsProcessingInformationAuthorizationOptions.
        Authorization code.  **Forced Capture**  Use this field to send the authorization code you received from a payment that you authorized outside the CyberSource system.  **Verbal Authorization**  Use this field in CAPTURE API to send the verbally received authorization code.  For processor-specific information, see the auth_code field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :return: The verbal_auth_code of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._verbal_auth_code

    @verbal_auth_code.setter
    def verbal_auth_code(self, verbal_auth_code):
        """
        Sets the verbal_auth_code of this V2paymentsProcessingInformationAuthorizationOptions.
        Authorization code.  **Forced Capture**  Use this field to send the authorization code you received from a payment that you authorized outside the CyberSource system.  **Verbal Authorization**  Use this field in CAPTURE API to send the verbally received authorization code.  For processor-specific information, see the auth_code field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :param verbal_auth_code: The verbal_auth_code of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """
        if verbal_auth_code is not None and len(verbal_auth_code) > 7:
            raise ValueError("Invalid value for `verbal_auth_code`, length must be less than or equal to `7`")

        self._verbal_auth_code = verbal_auth_code

    @property
    def verbal_auth_transaction_id(self):
        """
        Gets the verbal_auth_transaction_id of this V2paymentsProcessingInformationAuthorizationOptions.
        Transaction ID (TID).

        :return: The verbal_auth_transaction_id of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._verbal_auth_transaction_id

    @verbal_auth_transaction_id.setter
    def verbal_auth_transaction_id(self, verbal_auth_transaction_id):
        """
        Sets the verbal_auth_transaction_id of this V2paymentsProcessingInformationAuthorizationOptions.
        Transaction ID (TID).

        :param verbal_auth_transaction_id: The verbal_auth_transaction_id of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """
        if verbal_auth_transaction_id is not None and len(verbal_auth_transaction_id) > 15:
            raise ValueError("Invalid value for `verbal_auth_transaction_id`, length must be less than or equal to `15`")

        self._verbal_auth_transaction_id = verbal_auth_transaction_id

    @property
    def auth_indicator(self):
        """
        Gets the auth_indicator of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that specifies the purpose of the authorization.  Possible values:  - **0**: Preauthorization  - **1**: Final authorization  For processor-specific information, see the auth_indicator field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :return: The auth_indicator of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: str
        """
        return self._auth_indicator

    @auth_indicator.setter
    def auth_indicator(self, auth_indicator):
        """
        Sets the auth_indicator of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that specifies the purpose of the authorization.  Possible values:  - **0**: Preauthorization  - **1**: Final authorization  For processor-specific information, see the auth_indicator field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :param auth_indicator: The auth_indicator of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: str
        """
        if auth_indicator is not None and len(auth_indicator) > 1:
            raise ValueError("Invalid value for `auth_indicator`, length must be less than or equal to `1`")

        self._auth_indicator = auth_indicator

    @property
    def partial_auth_indicator(self):
        """
        Gets the partial_auth_indicator of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether the transaction is enabled for partial authorization or not. When your request includes this field, this value overrides the information in your CyberSource account.  For processor-specific information, see the auth_partial_auth_indicator field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :return: The partial_auth_indicator of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._partial_auth_indicator

    @partial_auth_indicator.setter
    def partial_auth_indicator(self, partial_auth_indicator):
        """
        Sets the partial_auth_indicator of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether the transaction is enabled for partial authorization or not. When your request includes this field, this value overrides the information in your CyberSource account.  For processor-specific information, see the auth_partial_auth_indicator field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :param partial_auth_indicator: The partial_auth_indicator of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._partial_auth_indicator = partial_auth_indicator

    @property
    def balance_inquiry(self):
        """
        Gets the balance_inquiry of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether to return balance information.

        :return: The balance_inquiry of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._balance_inquiry

    @balance_inquiry.setter
    def balance_inquiry(self, balance_inquiry):
        """
        Sets the balance_inquiry of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether to return balance information.

        :param balance_inquiry: The balance_inquiry of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._balance_inquiry = balance_inquiry

    @property
    def ignore_avs_result(self):
        """
        Gets the ignore_avs_result of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether to allow the capture service to run even when the payment receives an AVS decline. 

        :return: The ignore_avs_result of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._ignore_avs_result

    @ignore_avs_result.setter
    def ignore_avs_result(self, ignore_avs_result):
        """
        Sets the ignore_avs_result of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether to allow the capture service to run even when the payment receives an AVS decline. 

        :param ignore_avs_result: The ignore_avs_result of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._ignore_avs_result = ignore_avs_result

    @property
    def decline_avs_flags(self):
        """
        Gets the decline_avs_flags of this V2paymentsProcessingInformationAuthorizationOptions.
        An array of AVS flags that cause the reply flag to be returned.  `Important` To receive declines for the AVS code N, include the value N in the array. 

        :return: The decline_avs_flags of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: list[str]
        """
        return self._decline_avs_flags

    @decline_avs_flags.setter
    def decline_avs_flags(self, decline_avs_flags):
        """
        Sets the decline_avs_flags of this V2paymentsProcessingInformationAuthorizationOptions.
        An array of AVS flags that cause the reply flag to be returned.  `Important` To receive declines for the AVS code N, include the value N in the array. 

        :param decline_avs_flags: The decline_avs_flags of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: list[str]
        """
        allowed_values = ["D", "A", "V", "S", "N", "O"]
        if not set(decline_avs_flags).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `decline_avs_flags` [{0}], must be a subset of [{1}]"
                .format(", ".join(map(str, set(decline_avs_flags)-set(allowed_values))),
                        ", ".join(map(str, allowed_values)))
            )

        self._decline_avs_flags = decline_avs_flags

    @property
    def ignore_cv_result(self):
        """
        Gets the ignore_cv_result of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether to allow the capture service to run even when the payment receives a CVN decline. 

        :return: The ignore_cv_result of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: bool
        """
        return self._ignore_cv_result

    @ignore_cv_result.setter
    def ignore_cv_result(self, ignore_cv_result):
        """
        Sets the ignore_cv_result of this V2paymentsProcessingInformationAuthorizationOptions.
        Flag that indicates whether to allow the capture service to run even when the payment receives a CVN decline. 

        :param ignore_cv_result: The ignore_cv_result of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: bool
        """

        self._ignore_cv_result = ignore_cv_result

    @property
    def initiator(self):
        """
        Gets the initiator of this V2paymentsProcessingInformationAuthorizationOptions.

        :return: The initiator of this V2paymentsProcessingInformationAuthorizationOptions.
        :rtype: V2paymentsProcessingInformationAuthorizationOptionsInitiator
        """
        return self._initiator

    @initiator.setter
    def initiator(self, initiator):
        """
        Sets the initiator of this V2paymentsProcessingInformationAuthorizationOptions.

        :param initiator: The initiator of this V2paymentsProcessingInformationAuthorizationOptions.
        :type: V2paymentsProcessingInformationAuthorizationOptionsInitiator
        """

        self._initiator = initiator

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V2paymentsProcessingInformationAuthorizationOptions):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
