# coding: utf-8

"""
    CyberSource Flex API

    Simple PAN tokenization service

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class V2paymentsMerchantInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'merchant_descriptor': 'V2paymentsMerchantInformationMerchantDescriptor',
        'sales_organization_id': 'str',
        'category_code': 'int',
        'vat_registration_number': 'str',
        'card_acceptor_reference_number': 'str',
        'transaction_local_date_time': 'str'
    }

    attribute_map = {
        'merchant_descriptor': 'merchantDescriptor',
        'sales_organization_id': 'salesOrganizationId',
        'category_code': 'categoryCode',
        'vat_registration_number': 'vatRegistrationNumber',
        'card_acceptor_reference_number': 'cardAcceptorReferenceNumber',
        'transaction_local_date_time': 'transactionLocalDateTime'
    }

    def __init__(self, merchant_descriptor=None, sales_organization_id=None, category_code=None, vat_registration_number=None, card_acceptor_reference_number=None, transaction_local_date_time=None):
        """
        V2paymentsMerchantInformation - a model defined in Swagger
        """

        self._merchant_descriptor = None
        self._sales_organization_id = None
        self._category_code = None
        self._vat_registration_number = None
        self._card_acceptor_reference_number = None
        self._transaction_local_date_time = None

        if merchant_descriptor is not None:
          self.merchant_descriptor = merchant_descriptor
        if sales_organization_id is not None:
          self.sales_organization_id = sales_organization_id
        if category_code is not None:
          self.category_code = category_code
        if vat_registration_number is not None:
          self.vat_registration_number = vat_registration_number
        if card_acceptor_reference_number is not None:
          self.card_acceptor_reference_number = card_acceptor_reference_number
        if transaction_local_date_time is not None:
          self.transaction_local_date_time = transaction_local_date_time

    @property
    def merchant_descriptor(self):
        """
        Gets the merchant_descriptor of this V2paymentsMerchantInformation.

        :return: The merchant_descriptor of this V2paymentsMerchantInformation.
        :rtype: V2paymentsMerchantInformationMerchantDescriptor
        """
        return self._merchant_descriptor

    @merchant_descriptor.setter
    def merchant_descriptor(self, merchant_descriptor):
        """
        Sets the merchant_descriptor of this V2paymentsMerchantInformation.

        :param merchant_descriptor: The merchant_descriptor of this V2paymentsMerchantInformation.
        :type: V2paymentsMerchantInformationMerchantDescriptor
        """

        self._merchant_descriptor = merchant_descriptor

    @property
    def sales_organization_id(self):
        """
        Gets the sales_organization_id of this V2paymentsMerchantInformation.
        Company ID assigned to an independent sales organization. Get this value from Mastercard.  For processor-specific information, see the sales_organization_ID field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :return: The sales_organization_id of this V2paymentsMerchantInformation.
        :rtype: str
        """
        return self._sales_organization_id

    @sales_organization_id.setter
    def sales_organization_id(self, sales_organization_id):
        """
        Sets the sales_organization_id of this V2paymentsMerchantInformation.
        Company ID assigned to an independent sales organization. Get this value from Mastercard.  For processor-specific information, see the sales_organization_ID field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :param sales_organization_id: The sales_organization_id of this V2paymentsMerchantInformation.
        :type: str
        """
        if sales_organization_id is not None and len(sales_organization_id) > 11:
            raise ValueError("Invalid value for `sales_organization_id`, length must be less than or equal to `11`")

        self._sales_organization_id = sales_organization_id

    @property
    def category_code(self):
        """
        Gets the category_code of this V2paymentsMerchantInformation.
        Four-digit number that the payment card industry uses to classify merchants into market segments. Visa assigned one or more of these values to your business when you started accepting Visa cards.  If you do not include this field in your request, CyberSource uses the value in your CyberSource account.  For processor-specific information, see the merchant_category_code field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :return: The category_code of this V2paymentsMerchantInformation.
        :rtype: int
        """
        return self._category_code

    @category_code.setter
    def category_code(self, category_code):
        """
        Sets the category_code of this V2paymentsMerchantInformation.
        Four-digit number that the payment card industry uses to classify merchants into market segments. Visa assigned one or more of these values to your business when you started accepting Visa cards.  If you do not include this field in your request, CyberSource uses the value in your CyberSource account.  For processor-specific information, see the merchant_category_code field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :param category_code: The category_code of this V2paymentsMerchantInformation.
        :type: int
        """
        if category_code is not None and category_code > 9999:
            raise ValueError("Invalid value for `category_code`, must be a value less than or equal to `9999`")

        self._category_code = category_code

    @property
    def vat_registration_number(self):
        """
        Gets the vat_registration_number of this V2paymentsMerchantInformation.
        Your government-assigned tax identification number.  For CtV processors, the maximum length is 20.  For other processor-specific information, see the merchant_vat_registration_number field in [Level II and Level III Processing Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/Level_2_3_SCMP_API/html) 

        :return: The vat_registration_number of this V2paymentsMerchantInformation.
        :rtype: str
        """
        return self._vat_registration_number

    @vat_registration_number.setter
    def vat_registration_number(self, vat_registration_number):
        """
        Sets the vat_registration_number of this V2paymentsMerchantInformation.
        Your government-assigned tax identification number.  For CtV processors, the maximum length is 20.  For other processor-specific information, see the merchant_vat_registration_number field in [Level II and Level III Processing Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/Level_2_3_SCMP_API/html) 

        :param vat_registration_number: The vat_registration_number of this V2paymentsMerchantInformation.
        :type: str
        """
        if vat_registration_number is not None and len(vat_registration_number) > 21:
            raise ValueError("Invalid value for `vat_registration_number`, length must be less than or equal to `21`")

        self._vat_registration_number = vat_registration_number

    @property
    def card_acceptor_reference_number(self):
        """
        Gets the card_acceptor_reference_number of this V2paymentsMerchantInformation.
        Reference number that facilitates card acceptor/corporation communication and record keeping.  For processor-specific information, see the card_acceptor_ref_number field in [Level II and Level III Processing Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/Level_2_3_SCMP_API/html) 

        :return: The card_acceptor_reference_number of this V2paymentsMerchantInformation.
        :rtype: str
        """
        return self._card_acceptor_reference_number

    @card_acceptor_reference_number.setter
    def card_acceptor_reference_number(self, card_acceptor_reference_number):
        """
        Sets the card_acceptor_reference_number of this V2paymentsMerchantInformation.
        Reference number that facilitates card acceptor/corporation communication and record keeping.  For processor-specific information, see the card_acceptor_ref_number field in [Level II and Level III Processing Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/Level_2_3_SCMP_API/html) 

        :param card_acceptor_reference_number: The card_acceptor_reference_number of this V2paymentsMerchantInformation.
        :type: str
        """
        if card_acceptor_reference_number is not None and len(card_acceptor_reference_number) > 25:
            raise ValueError("Invalid value for `card_acceptor_reference_number`, length must be less than or equal to `25`")

        self._card_acceptor_reference_number = card_acceptor_reference_number

    @property
    def transaction_local_date_time(self):
        """
        Gets the transaction_local_date_time of this V2paymentsMerchantInformation.
        Local date and time at your physical location. Include both the date and time in this field or leave it blank. This field is supported only for **CyberSource through VisaNet**.  For processor-specific information, see the transaction_local_date_time field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html)  `Format: YYYYMMDDhhmmss`, where:   - YYYY = year  - MM = month  - DD = day  - hh = hour  - mm = minutes  - ss = seconds 

        :return: The transaction_local_date_time of this V2paymentsMerchantInformation.
        :rtype: str
        """
        return self._transaction_local_date_time

    @transaction_local_date_time.setter
    def transaction_local_date_time(self, transaction_local_date_time):
        """
        Sets the transaction_local_date_time of this V2paymentsMerchantInformation.
        Local date and time at your physical location. Include both the date and time in this field or leave it blank. This field is supported only for **CyberSource through VisaNet**.  For processor-specific information, see the transaction_local_date_time field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html)  `Format: YYYYMMDDhhmmss`, where:   - YYYY = year  - MM = month  - DD = day  - hh = hour  - mm = minutes  - ss = seconds 

        :param transaction_local_date_time: The transaction_local_date_time of this V2paymentsMerchantInformation.
        :type: str
        """
        if transaction_local_date_time is not None and len(transaction_local_date_time) > 14:
            raise ValueError("Invalid value for `transaction_local_date_time`, length must be less than or equal to `14`")

        self._transaction_local_date_time = transaction_local_date_time

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, V2paymentsMerchantInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
