# coding: utf-8

"""
    CyberSource Flex API

    Simple PAN tokenization service

    OpenAPI spec version: 0.0.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class InlineResponse2002MerchantInformation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category_code': 'int',
        'vat_registration_number': 'str',
        'merchant_descriptor': 'V2paymentsMerchantInformationMerchantDescriptor'
    }

    attribute_map = {
        'category_code': 'categoryCode',
        'vat_registration_number': 'vatRegistrationNumber',
        'merchant_descriptor': 'merchantDescriptor'
    }

    def __init__(self, category_code=None, vat_registration_number=None, merchant_descriptor=None):
        """
        InlineResponse2002MerchantInformation - a model defined in Swagger
        """

        self._category_code = None
        self._vat_registration_number = None
        self._merchant_descriptor = None

        if category_code is not None:
          self.category_code = category_code
        if vat_registration_number is not None:
          self.vat_registration_number = vat_registration_number
        if merchant_descriptor is not None:
          self.merchant_descriptor = merchant_descriptor

    @property
    def category_code(self):
        """
        Gets the category_code of this InlineResponse2002MerchantInformation.
        Four-digit number that the payment card industry uses to classify merchants into market segments. Visa assigned one or more of these values to your business when you started accepting Visa cards.  If you do not include this field in your request, CyberSource uses the value in your CyberSource account.  For processor-specific information, see the merchant_category_code field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :return: The category_code of this InlineResponse2002MerchantInformation.
        :rtype: int
        """
        return self._category_code

    @category_code.setter
    def category_code(self, category_code):
        """
        Sets the category_code of this InlineResponse2002MerchantInformation.
        Four-digit number that the payment card industry uses to classify merchants into market segments. Visa assigned one or more of these values to your business when you started accepting Visa cards.  If you do not include this field in your request, CyberSource uses the value in your CyberSource account.  For processor-specific information, see the merchant_category_code field in [Credit Card Services Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html) 

        :param category_code: The category_code of this InlineResponse2002MerchantInformation.
        :type: int
        """
        if category_code is not None and category_code > 9999:
            raise ValueError("Invalid value for `category_code`, must be a value less than or equal to `9999`")

        self._category_code = category_code

    @property
    def vat_registration_number(self):
        """
        Gets the vat_registration_number of this InlineResponse2002MerchantInformation.
        Your government-assigned tax identification number.  For CtV processors, the maximum length is 20.  For other processor-specific information, see the merchant_vat_registration_number field in [Level II and Level III Processing Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/Level_2_3_SCMP_API/html) 

        :return: The vat_registration_number of this InlineResponse2002MerchantInformation.
        :rtype: str
        """
        return self._vat_registration_number

    @vat_registration_number.setter
    def vat_registration_number(self, vat_registration_number):
        """
        Sets the vat_registration_number of this InlineResponse2002MerchantInformation.
        Your government-assigned tax identification number.  For CtV processors, the maximum length is 20.  For other processor-specific information, see the merchant_vat_registration_number field in [Level II and Level III Processing Using the SCMP API.](http://apps.cybersource.com/library/documentation/dev_guides/Level_2_3_SCMP_API/html) 

        :param vat_registration_number: The vat_registration_number of this InlineResponse2002MerchantInformation.
        :type: str
        """
        if vat_registration_number is not None and len(vat_registration_number) > 21:
            raise ValueError("Invalid value for `vat_registration_number`, length must be less than or equal to `21`")

        self._vat_registration_number = vat_registration_number

    @property
    def merchant_descriptor(self):
        """
        Gets the merchant_descriptor of this InlineResponse2002MerchantInformation.

        :return: The merchant_descriptor of this InlineResponse2002MerchantInformation.
        :rtype: V2paymentsMerchantInformationMerchantDescriptor
        """
        return self._merchant_descriptor

    @merchant_descriptor.setter
    def merchant_descriptor(self, merchant_descriptor):
        """
        Sets the merchant_descriptor of this InlineResponse2002MerchantInformation.

        :param merchant_descriptor: The merchant_descriptor of this InlineResponse2002MerchantInformation.
        :type: V2paymentsMerchantInformationMerchantDescriptor
        """

        self._merchant_descriptor = merchant_descriptor

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, InlineResponse2002MerchantInformation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
