"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPythonSampleSource = void 0;
/**
 * Return a map of file name to contents for the sample python source code
 */
exports.getPythonSampleSource = (options) => ({
    "__init__.py": "#",
    // This file provides a type-safe interface to the exported OpenApiGatewayRestApi construct
    "api.py": `from dataclasses import fields
from ${options.openApiGatewayPackageName} import OpenApiGatewayRestApi, OpenApiIntegration
from ${options.pythonClientPackageName}.apis.tags.default_api_operation_config import OperationLookup, OperationConfig
from ${options.moduleName}.spec_utils import SPEC, SPEC_PATH

class Api(OpenApiGatewayRestApi):
    """
    Type-safe construct for the API Gateway resources defined by the spec.
    You will likely not need to modify this file, and can instead extend it and define your integrations.
    """
    def __init__(self, scope, id, integrations: OperationConfig[OpenApiIntegration], **kwargs):
        super().__init__(scope, id,
            **kwargs,
            integrations={ field.name: getattr(integrations, field.name) for field in fields(integrations) },
            spec=SPEC,
            spec_path=SPEC_PATH,
            operation_lookup=OperationLookup,
        )
`,
    ...(options.sampleCode !== false
        ? {
            // Generate an example which instantiates the Api construct
            // TODO: Consider generating this sample from the parsed spec
            "sample_api.py": `from ${options.openApiGatewayPackageName} import Authorizers, Integrations, OpenApiIntegration
from ${options.pythonClientPackageName}.apis.tags.default_api_operation_config import OperationConfig
from aws_cdk.aws_lambda import LayerVersion, Code, Function, Runtime
from .api import Api
from constructs import Construct
from ${options.moduleName}.spec_utils import get_generated_client_layer_directory
from pathlib import Path
from os import path

class SampleApi(Construct):
  """
  An example of how to add integrations to your api
  """
  def __init__(self, scope, id):
      super().__init__(scope, id)

      # Layer which contains the generated client.
      self.generated_client_layer = LayerVersion(self, 'GeneratedClientLayer',
          code=Code.from_asset(get_generated_client_layer_directory())
      )

      self.api = Api(self, 'Api',
          default_authorizer=Authorizers.iam(),
          integrations=OperationConfig(
              say_hello=OpenApiIntegration(
                  integration=Integrations.lambda_(Function(self, 'SayHello',
                      runtime=Runtime.PYTHON_3_9,
                      code=Code.from_asset(path.join(str(Path(__file__).parent.absolute()), 'handlers')),
                      handler="say_hello_handler_sample.handler",
                      layers=[self.generated_client_layer],
                  )),
              ),
          ),
      )
`,
            // Generate an example lambda handler
            "handlers/say_hello_handler_sample.py": `from ${options.pythonClientPackageName}.apis.tags.default_api_operation_config import say_hello_handler, SayHelloRequest, ApiResponse, SayHelloOperationResponses
from ${options.pythonClientPackageName}.model.hello_response import SayHelloResponseContent

@say_hello_handler
def handler(input: SayHelloRequest, **kwargs) -> SayHelloOperationResponses:
    """
    An example lambda handler which uses the generated handler wrapper to manage marshalling inputs/outputs
    """
    return ApiResponse(
        status_code=200,
        body=SayHelloResponseContent(message="Hello {}!".format(input.request_parameters["name"])),
        headers={}
    )
`,
        }
        : {}),
});
//# sourceMappingURL=data:application/json;base64,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