/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { Component, Project } from "projen";
import { ClientLanguageConfig, DocumentationFormatConfig } from "../../client-config";
import { ClientLanguage, DocumentationFormat } from "../../languages";
/**
 * Configuration for the ClientConfig component
 */
export interface ClientSettingsOptions {
    /**
     * The name of the client config file.
     * @default ".client-settings.json"
     */
    readonly clientSettingsFilename?: string;
    /**
     * The path to the generated code dir.
     */
    readonly generatedCodeDir: string;
    /**
     * Client languages set at current run.
     */
    readonly clientLanguages: ClientLanguage[];
    /**
     * Default client language.
     */
    readonly defaultClientLanguage: ClientLanguage;
    /**
     * Documentation formats set at current run.
     */
    readonly documentationFormats: DocumentationFormat[];
    /**
     * Indicates whether the OpenApiSpec has changed.
     */
    readonly specChanged: boolean;
    /**
     * Indicates whether the user set the forceGenerate flag.
     */
    readonly forceGenerateCodeAndDocs: boolean;
}
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
export declare class ClientSettings extends Component {
    readonly clientSettingsPath: string;
    readonly clientSettingsFilename: string;
    readonly clientLanguageConfigs: ClientLanguageConfig[];
    readonly documentationFormatConfigs: DocumentationFormatConfig[];
    private readonly options;
    constructor(project: Project, options: ClientSettingsOptions);
    synthesize(): void;
}
