"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCliLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
/**
 * An AWS Lambda layer that includes the AWS CLI.
 *
 * @stability stable
 */
class AwsCliLayer extends lambda.LayerVersion {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id, {
            code: lambda.Code.fromAsset(path.join(__dirname, 'layer.zip'), {
                // we hash the Dockerfile (it contains the tools versions) because hashing the zip is non-deterministic
                assetHash: hashFile(path.join(__dirname, '..', 'layer', 'Dockerfile')),
            }),
            description: '/opt/awscli/aws',
        });
    }
}
exports.AwsCliLayer = AwsCliLayer;
_a = JSII_RTTI_SYMBOL_1;
AwsCliLayer[_a] = { fqn: "@aws-cdk/lambda-layer-awscli.AwsCliLayer", version: "1.134.0" };
function hashFile(fileName) {
    return crypto
        .createHash('sha256')
        .update(fs.readFileSync(fileName))
        .digest('hex');
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXdzY2xpLWxheWVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXdzY2xpLWxheWVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsaUNBQWlDO0FBQ2pDLHlCQUF5QjtBQUN6Qiw2QkFBNkI7QUFDN0IsOENBQThDOzs7Ozs7QUFJOUMsTUFBYSxXQUFZLFNBQVEsTUFBTSxDQUFDLFlBQVk7Ozs7SUFDbEQsWUFBWSxLQUFnQixFQUFFLEVBQVU7UUFDdEMsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixJQUFJLEVBQUUsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsV0FBVyxDQUFDLEVBQUU7Z0JBQzdELHVHQUF1RztnQkFDdkcsU0FBUyxFQUFFLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxJQUFJLEVBQUUsT0FBTyxFQUFFLFlBQVksQ0FBQyxDQUFDO2FBQ3ZFLENBQUM7WUFDRixXQUFXLEVBQUUsaUJBQWlCO1NBQy9CLENBQUMsQ0FBQztLQUNKOztBQVRILGtDQVVDOzs7QUFFRCxTQUFTLFFBQVEsQ0FBQyxRQUFnQjtJQUNoQyxPQUFPLE1BQU07U0FDVixVQUFVLENBQUMsUUFBUSxDQUFDO1NBQ3BCLE1BQU0sQ0FBQyxFQUFFLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxDQUFDO1NBQ2pDLE1BQU0sQ0FBQyxLQUFLLENBQUMsQ0FBQztBQUNuQixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY3J5cHRvIGZyb20gJ2NyeXB0byc7XG5pbXBvcnQgKiBhcyBmcyBmcm9tICdmcyc7XG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gJ3BhdGgnO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIEF3c0NsaUxheWVyIGV4dGVuZHMgbGFtYmRhLkxheWVyVmVyc2lvbiB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIGNvZGU6IGxhbWJkYS5Db2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnbGF5ZXIuemlwJyksIHtcbiAgICAgICAgLy8gd2UgaGFzaCB0aGUgRG9ja2VyZmlsZSAoaXQgY29udGFpbnMgdGhlIHRvb2xzIHZlcnNpb25zKSBiZWNhdXNlIGhhc2hpbmcgdGhlIHppcCBpcyBub24tZGV0ZXJtaW5pc3RpY1xuICAgICAgICBhc3NldEhhc2g6IGhhc2hGaWxlKHBhdGguam9pbihfX2Rpcm5hbWUsICcuLicsICdsYXllcicsICdEb2NrZXJmaWxlJykpLFxuICAgICAgfSksXG4gICAgICBkZXNjcmlwdGlvbjogJy9vcHQvYXdzY2xpL2F3cycsXG4gICAgfSk7XG4gIH1cbn1cblxuZnVuY3Rpb24gaGFzaEZpbGUoZmlsZU5hbWU6IHN0cmluZykge1xuICByZXR1cm4gY3J5cHRvXG4gICAgLmNyZWF0ZUhhc2goJ3NoYTI1NicpXG4gICAgLnVwZGF0ZShmcy5yZWFkRmlsZVN5bmMoZmlsZU5hbWUpKVxuICAgIC5kaWdlc3QoJ2hleCcpO1xufSJdfQ==