"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedPythonClientSourceCode = void 0;
const projen_1 = require("projen");
const languages_1 = require("../../languages");
const utils_1 = require("./utils");
/**
 * Generates the python client using OpenAPI Generator
 */
class GeneratedPythonClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        // Generate the python client
        utils_1.generateClientCode({
            generator: "python-experimental",
            specPath: this.options.specPath,
            outputPath: this.project.outdir,
            language: languages_1.ClientLanguage.PYTHON,
            additionalProperties: {
                packageName: this.project.moduleName,
            },
        });
    }
}
exports.GeneratedPythonClientSourceCode = GeneratedPythonClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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