/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as lambda from '@aws-cdk/aws-lambda';
import * as elasticsearch from '@aws-cdk/aws-elasticsearch';
import * as iam from '@aws-cdk/aws-iam';
import { DynamoEventSourceProps } from '@aws-cdk/aws-lambda-event-sources';
import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as cognito from '@aws-cdk/aws-cognito';
import * as cloudwatch from '@aws-cdk/aws-cloudwatch';
import { Construct } from '@aws-cdk/core';
/**
 * @summary The properties for the DynamoDBStreamToLambdaToElastciSearchAndKibana Construct
 */
export interface DynamoDBStreamToLambdaToElasticSearchAndKibanaProps {
    /**
     * Existing instance of Lambda Function object, if this is set then the lambdaFunctionProps is ignored.
     *
     * @default - None
     */
    readonly existingLambdaObj?: lambda.Function;
    /**
     * User provided props to override the default props for the Lambda function.
     *
     * @default - Default props are used
     */
    readonly lambdaFunctionProps?: lambda.FunctionProps;
    /**
     * Optional user provided props to override the default props.
     *
     * @default - Default props are used
     */
    readonly dynamoTableProps?: dynamodb.TableProps;
    /**
     * Existing instance of DynamoDB table object, If this is set then the dynamoTableProps is ignored.
     *
     * @default - None
     */
    readonly existingTableObj?: dynamodb.Table;
    /**
     * Optional user provided props to override the default props.
     *
     * @default - Default props are used
     */
    readonly dynamoEventSourceProps?: DynamoEventSourceProps;
    /**
     * Optional user provided props to override the default props for the API Gateway.
     *
     * @default - Default props are used
     */
    readonly esDomainProps?: elasticsearch.CfnDomainProps;
    /**
     * Cognito & ES Domain Name.
     *
     * @default - None
     */
    readonly domainName: string;
    /**
     * Optional Cognito Domain Name, if provided it will be used for Cognito Domain, and domainName will be used for the Elasticsearch Domain.
     *
     * @default - None
     */
    readonly cognitoDomainName?: string;
}
export declare class DynamoDBStreamToLambdaToElasticSearchAndKibana extends Construct {
    private dynamoDBStreamToLambda;
    private lambdaToElasticSearchAndKibana;
    readonly lambdaFunction: lambda.Function;
    readonly dynamoTable: dynamodb.Table;
    readonly userPool: cognito.UserPool;
    readonly userPoolClient: cognito.UserPoolClient;
    readonly identityPool: cognito.CfnIdentityPool;
    readonly elasticsearchDomain: elasticsearch.CfnDomain;
    readonly elasticsearchRole: iam.Role;
    readonly cloudwatchAlarms: cloudwatch.Alarm[];
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the LambdaToDynamoDB class.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: DynamoDBStreamToLambdaToElasticSearchAndKibanaProps);
}
