/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
export interface JavaSampleCodeOptions {
    /**
     * The package name which exports the OpenApiGatewayRestApi construct (ie this pdk package!)
     */
    readonly openApiGatewayPackageName: string;
    /**
     * Whether or not to generate sample code
     */
    readonly sampleCode?: boolean;
    /**
     * Api source code directory, relative to the project root
     */
    readonly apiSrcDir: string;
    /**
     * Directory where the parsed spec is output
     */
    readonly specDir: string;
    /**
     * Name of the parsed spec file
     */
    readonly parsedSpecFileName: string;
    /**
     * The package from which to import generated java client classes
     */
    readonly javaClientPackage: string;
}
export declare const getJavaSampleSource: (options: JavaSampleCodeOptions) => {
    [fileName: string]: string;
};
