# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['hyperfastpy']

package_data = \
{'': ['*']}

entry_points = \
{'console_scripts': ['hyperfastpy = hyperfastpy.__cli__:main']}

setup_kwargs = {
    'name': 'hyperfast-python-template',
    'version': '0.0.1rc14',
    'description': 'A python template that helps you jump start your project',
    'long_description': '# Hyperfast Python Template\n\n[![license-image]][license-url]\n[![version-image]][release-url]\n[![release-date-image]][release-url]\n[![conventional-commits-image]][conventional commits]\n[![jupyter-book-image]][jupyter book]\n\n<!-- Links: -->\n[hyperfast python template]: https://github.com/entelecheia/hyperfast-python-template\n\n[license-image]: https://img.shields.io/github/license/entelecheia/hyperfast-python-template\n[license-url]: https://github.com/entelecheia/hyperfast-python-template/blob/main/LICENSE\n[version-image]: https://img.shields.io/github/v/release/entelecheia/hyperfast-python-template?sort=semver\n[release-date-image]: https://img.shields.io/github/release-date/entelecheia/hyperfast-python-template\n[release-url]: https://github.com/entelecheia/hyperfast-python-template/releases\n[conventional-commits-image]: https://img.shields.io/badge/Conventional%20Commits-1.0.0-%23FE5196?logo=conventionalcommits&logoColor=white\n[jupyter-book-image]: https://jupyterbook.org/en/stable/_images/badge.svg\n\n[repo-url]: https://github.com/entelecheia/hyperfast-python-template\n[pypi-url]: https://pypi.org/project/hyperfast-python-template\n[docs-url]: https://entelecheia.github.io/hyperfast-python-template\n[changelog]: https://github.com/entelecheia/hyperfast-python-template/blob/main/CHANGELOG.md\n[contributing guidelines]: https://github.com/entelecheia/hyperfast-python-template/blob/main/CONTRIBUTING.md\n<!-- Links: -->\n\nA python template that helps you jump start your project\n\n- Documentation: [https://entelecheia.github.io/hyperfast-python-template][docs-url]\n- GitHub: [https://github.com/entelecheia/hyperfast-python-template][repo-url]\n- PyPI: [https://pypi.org/project/hyperfast-python-template][pypi-url]\n\nHyperfast Python Template is a self-contained template that helps you initialize your Python project inside the template. It is hyperfast in the sense that the template itself is converted into a Python project in the blink of an eye. It is also hyperfast in the sense that it helps you jump start your project with the best practices in the Python community.\n\n## Quickstart\n\nThere are three ways to use this project:\n\n- Use [Hyperfast Python Template] to create a new repository\n- Use [Copier] to create a project to your local machine directly\n- Inject [Hyperfast Python Template] into an existing project\n\n### I. Use the template\n\n1. Click the `Use this template` button\n2. Enter a name for your repository\n3. Click `Create repository from template`\n4. Clone your new repository to your local machine\n5. Initialize your project with `make init-project`\n6. Do your work\n\n### II. Use Copier\n\n1. Install Copier with `pipx install copier`\n2. Run `copier gh:entelecheia/hyperfast-python-template path/to/destination`\n3. Initialize your project with `make init-git`\n4. Do your work\n\n### III. Inject the template\n\n1. Install Copier with `pipx install copier`\n2. From the root of your project, run `copier gh:entelecheia/hyperfast-python-template .`\n3. If your project is not a git repository, initialize it with `make init-git`\n4. Do your work\n\n## Features\n\n\n- [x] Automated changelog with [Conventional Commits] and [Python Semantic Release]\n- [x] Automated labeling to pull requests based on [Conventional Commits] with [Conventional Release Labels]\n- [x] Automated semantic versioning with [Python Semantic Release]\n- [x] Automated uploads to [PyPI] and [TestPyPI]\n- [x] Code coverage with [Pytest-Cov]\n- [x] Code formatting with [Black] and [Prettier]\n- [x] Continuous integration with [GitHub Actions]\n- [x] Coverage reporting with [Codecov]\n- [x] Documentation with [MkDocs], [Jupyter Book], and [Read the Docs]\n- [x] Import sorting with [isort]\n- [x] Linting with [pre-commit] and [Flake8]\n- [x] Managing project labels with [GitHub Labeler]\n- [x] Managing projects with [Make]\n- [x] Packaging and dependency management with [Poetry]\n- [x] Hyperfast rendering of the template into a new project with [Copier]\n- [x] Static type-checking with [mypy]\n- [x] Support for [Conventional Commits]\n- [x] Support for [Semantic Versioning]\n- [x] Testing with [pytest]\n\n- [ ] Automated dependency updates with [Dependabot]\n- [ ] Automated Python syntax upgrades with [pyupgrade]\n- [ ] Automated release notes with [Release Drafter]\n- [ ] Automatic documentation from sources for [MkDocs] with [mkdocstrings]\n- [ ] Check documentation examples with [xdoctest]\n- [ ] Runtime type-checking with [Typeguard]\n- [ ] Security audit with [Bandit] and [Safety]\n- [ ] Test automation with [Nox]\n\nThe template supports Python 3.7, 3.8, 3.9, and 3.10.\n\n[bandit]: https://github.com/PyCQA/bandit\n[black]: https://github.com/psf/black\n[click]: https://click.palletsprojects.com/\n[codecov]: https://codecov.io/\n[conventional commits]: https://conventionalcommits.org\n[conventional release labels]: https://github.com/marketplace/actions/conventional-release-labels\n[copier]: https://copier.readthedocs.io\n[coverage.py]: https://coverage.readthedocs.io/\n[dependabot]: https://dependabot.com/\n[flake8]: http://flake8.pycqa.org\n[github actions]: https://github.com/features/actions\n[github labeler]: https://github.com/marketplace/actions/github-labeler\n[isort]: https://pycqa.github.io/isort/\n[jupyter book]: https://jupyterbook.org\n[make]: https://www.gnu.org/software/make/\n[mkdocs]: https://www.mkdocs.org\n[mkdocstrings]: https://mkdocstrings.github.io\n[mypy]: http://mypy-lang.org/\n[myst]: https://myst-parser.readthedocs.io/\n[nox]: https://nox.thea.codes/\n[poetry]: https://python-poetry.org/\n[pre-commit]: https://pre-commit.com/\n[prettier]: https://prettier.io/\n[pypi]: https://pypi.org/\n[pytest-cov]: https://pytest-cov.readthedocs.io/\n[pytest]: https://docs.pytest.org/en/latest/\n[python semantic release]: https://python-semantic-release.readthedocs.io/en/latest/\n[pyupgrade]: https://github.com/asottile/pyupgrade\n[read the docs]: https://readthedocs.org/\n[release drafter]: https://github.com/release-drafter/release-drafter\n[safety]: https://github.com/pyupio/safety\n[semantic versioning]: https://semver.org\n[testpypi]: https://test.pypi.org/\n[typeguard]: https://github.com/agronholm/typeguard\n[xdoctest]: https://github.com/Erotemic/xdoctest\n\n## Changelog\n\nSee the [CHANGELOG] for more information.\n\n## Contributing\n\nContributions are welcome! Please see the [contributing guidelines] for more information.\n\n## License\n\nThis project is released under the [MIT License][license-url].\n',
    'author': 'Young Joon Lee',
    'author_email': 'entelecheia@hotmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'entry_points': entry_points,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
