import { Component, Project } from "projen";
/**
 * Configuration for the ParsedSpec component
 */
export interface ParsedSpecOptions {
    /**
     * Absolute path to the OpenAPI specification (spec.yaml)
     */
    readonly specPath: string;
    /**
     * Absolute path to write the parsed spec json file to
     */
    readonly outputPath: string;
}
/**
 * Component for parsing the yaml OpenAPI spec as a single json object, resolving references etc.
 */
export declare class ParsedSpec extends Component {
    static parse(specPath: string, outputPath: string): void;
    private options;
    constructor(project: Project, options: ParsedSpecOptions);
    synthesize(): void;
}
