import { RestApiBaseProps, SpecRestApi } from "aws-cdk-lib/aws-apigateway";
import { CfnIPSet, CfnWebACL, CfnWebACLAssociation } from "aws-cdk-lib/aws-wafv2";
import { Construct } from "constructs";
import { OpenApiOptions } from "./spec";
import { OpenApiGatewayWebAclOptions } from "./waf/types";
/**
 * Configuration for the OpenApiGatewayRestApi construct
 */
export interface OpenApiGatewayRestApiProps extends RestApiBaseProps, OpenApiOptions {
    /**
     * The parsed OpenAPI specification
     */
    readonly spec: any;
    /**
     * Path to the JSON open api spec
     */
    readonly specPath: string;
    /**
     * Options for the AWS WAF v2 WebACL associated with the api. By default, a Web ACL with the AWS default managed
     * rule set will be associated with the API. These options may disable or override the defaults.
     */
    readonly webAclOptions?: OpenApiGatewayWebAclOptions;
}
/**
 * A construct for creating an api gateway rest api based on the definition in the OpenAPI spec.
 */
export declare class OpenApiGatewayRestApi extends Construct {
    readonly api: SpecRestApi;
    readonly webAcl?: CfnWebACL;
    readonly ipSet?: CfnIPSet;
    readonly webAclAssociation?: CfnWebACLAssociation;
    constructor(scope: Construct, id: string, props: OpenApiGatewayRestApiProps);
}
