# coding: utf-8

"""
    NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OUTPUTOpenAPI spec version: 0.3.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VersionedFlowDifference(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bucket_id': 'str',
        'flow_id': 'str',
        'version_a': 'int',
        'version_b': 'int',
        'component_difference_groups': 'list[ComponentDifferenceGroup]'
    }

    attribute_map = {
        'bucket_id': 'bucketId',
        'flow_id': 'flowId',
        'version_a': 'versionA',
        'version_b': 'versionB',
        'component_difference_groups': 'componentDifferenceGroups'
    }

    def __init__(self, bucket_id=None, flow_id=None, version_a=None, version_b=None, component_difference_groups=None):
        """
        VersionedFlowDifference - a model defined in Swagger
        """

        self._bucket_id = None
        self._flow_id = None
        self._version_a = None
        self._version_b = None
        self._component_difference_groups = None

        if bucket_id is not None:
          self.bucket_id = bucket_id
        if flow_id is not None:
          self.flow_id = flow_id
        if version_a is not None:
          self.version_a = version_a
        if version_b is not None:
          self.version_b = version_b
        if component_difference_groups is not None:
          self.component_difference_groups = component_difference_groups

    @property
    def bucket_id(self):
        """
        Gets the bucket_id of this VersionedFlowDifference.
        The id of the bucket that the flow is stored in.

        :return: The bucket_id of this VersionedFlowDifference.
        :rtype: str
        """
        return self._bucket_id

    @bucket_id.setter
    def bucket_id(self, bucket_id):
        """
        Sets the bucket_id of this VersionedFlowDifference.
        The id of the bucket that the flow is stored in.

        :param bucket_id: The bucket_id of this VersionedFlowDifference.
        :type: str
        """

        self._bucket_id = bucket_id

    @property
    def flow_id(self):
        """
        Gets the flow_id of this VersionedFlowDifference.
        The id of the flow that is being examined.

        :return: The flow_id of this VersionedFlowDifference.
        :rtype: str
        """
        return self._flow_id

    @flow_id.setter
    def flow_id(self, flow_id):
        """
        Sets the flow_id of this VersionedFlowDifference.
        The id of the flow that is being examined.

        :param flow_id: The flow_id of this VersionedFlowDifference.
        :type: str
        """

        self._flow_id = flow_id

    @property
    def version_a(self):
        """
        Gets the version_a of this VersionedFlowDifference.
        The earlier version from the diff operation.

        :return: The version_a of this VersionedFlowDifference.
        :rtype: int
        """
        return self._version_a

    @version_a.setter
    def version_a(self, version_a):
        """
        Sets the version_a of this VersionedFlowDifference.
        The earlier version from the diff operation.

        :param version_a: The version_a of this VersionedFlowDifference.
        :type: int
        """

        self._version_a = version_a

    @property
    def version_b(self):
        """
        Gets the version_b of this VersionedFlowDifference.
        The latter version from the diff operation.

        :return: The version_b of this VersionedFlowDifference.
        :rtype: int
        """
        return self._version_b

    @version_b.setter
    def version_b(self, version_b):
        """
        Sets the version_b of this VersionedFlowDifference.
        The latter version from the diff operation.

        :param version_b: The version_b of this VersionedFlowDifference.
        :type: int
        """

        self._version_b = version_b

    @property
    def component_difference_groups(self):
        """
        Gets the component_difference_groups of this VersionedFlowDifference.

        :return: The component_difference_groups of this VersionedFlowDifference.
        :rtype: list[ComponentDifferenceGroup]
        """
        return self._component_difference_groups

    @component_difference_groups.setter
    def component_difference_groups(self, component_difference_groups):
        """
        Sets the component_difference_groups of this VersionedFlowDifference.

        :param component_difference_groups: The component_difference_groups of this VersionedFlowDifference.
        :type: list[ComponentDifferenceGroup]
        """

        self._component_difference_groups = component_difference_groups

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VersionedFlowDifference):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
