# coding: utf-8

"""
    NiFi Registry REST API

    The REST API provides an interface to a registry with operations for saving, versioning, reading NiFi flows and components.

    OUTPUTOpenAPI spec version: 0.3.0
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class CurrentUser(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'identity': 'str',
        'anonymous': 'bool',
        'resource_permissions': 'ResourcePermissions'
    }

    attribute_map = {
        'identity': 'identity',
        'anonymous': 'anonymous',
        'resource_permissions': 'resourcePermissions'
    }

    def __init__(self, identity=None, anonymous=None, resource_permissions=None):
        """
        CurrentUser - a model defined in Swagger
        """

        self._identity = None
        self._anonymous = None
        self._resource_permissions = None

        if identity is not None:
          self.identity = identity
        if anonymous is not None:
          self.anonymous = anonymous
        if resource_permissions is not None:
          self.resource_permissions = resource_permissions

    @property
    def identity(self):
        """
        Gets the identity of this CurrentUser.
        The identity of the current user

        :return: The identity of this CurrentUser.
        :rtype: str
        """
        return self._identity

    @identity.setter
    def identity(self, identity):
        """
        Sets the identity of this CurrentUser.
        The identity of the current user

        :param identity: The identity of this CurrentUser.
        :type: str
        """

        self._identity = identity

    @property
    def anonymous(self):
        """
        Gets the anonymous of this CurrentUser.
        Indicates if the current user is anonymous

        :return: The anonymous of this CurrentUser.
        :rtype: bool
        """
        return self._anonymous

    @anonymous.setter
    def anonymous(self, anonymous):
        """
        Sets the anonymous of this CurrentUser.
        Indicates if the current user is anonymous

        :param anonymous: The anonymous of this CurrentUser.
        :type: bool
        """

        self._anonymous = anonymous

    @property
    def resource_permissions(self):
        """
        Gets the resource_permissions of this CurrentUser.
        The access that the current user has to top level resources

        :return: The resource_permissions of this CurrentUser.
        :rtype: ResourcePermissions
        """
        return self._resource_permissions

    @resource_permissions.setter
    def resource_permissions(self, resource_permissions):
        """
        Sets the resource_permissions of this CurrentUser.
        The access that the current user has to top level resources

        :param resource_permissions: The resource_permissions of this CurrentUser.
        :type: ResourcePermissions
        """

        self._resource_permissions = resource_permissions

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, CurrentUser):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
