# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.9.1
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class VariableRegistryUpdateRequestDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'request_id': 'str',
        'process_group_id': 'str',
        'uri': 'str',
        'submission_time': 'str',
        'last_updated': 'str',
        'complete': 'bool',
        'failure_reason': 'str',
        'update_steps': 'list[VariableRegistryUpdateStepDTO]',
        'affected_components': 'list[AffectedComponentEntity]'
    }

    attribute_map = {
        'request_id': 'requestId',
        'process_group_id': 'processGroupId',
        'uri': 'uri',
        'submission_time': 'submissionTime',
        'last_updated': 'lastUpdated',
        'complete': 'complete',
        'failure_reason': 'failureReason',
        'update_steps': 'updateSteps',
        'affected_components': 'affectedComponents'
    }

    def __init__(self, request_id=None, process_group_id=None, uri=None, submission_time=None, last_updated=None, complete=None, failure_reason=None, update_steps=None, affected_components=None):
        """
        VariableRegistryUpdateRequestDTO - a model defined in Swagger
        """

        self._request_id = None
        self._process_group_id = None
        self._uri = None
        self._submission_time = None
        self._last_updated = None
        self._complete = None
        self._failure_reason = None
        self._update_steps = None
        self._affected_components = None

        if request_id is not None:
          self.request_id = request_id
        if process_group_id is not None:
          self.process_group_id = process_group_id
        if uri is not None:
          self.uri = uri
        if submission_time is not None:
          self.submission_time = submission_time
        if last_updated is not None:
          self.last_updated = last_updated
        if complete is not None:
          self.complete = complete
        if failure_reason is not None:
          self.failure_reason = failure_reason
        if update_steps is not None:
          self.update_steps = update_steps
        if affected_components is not None:
          self.affected_components = affected_components

    @property
    def request_id(self):
        """
        Gets the request_id of this VariableRegistryUpdateRequestDTO.
        The unique ID of this request.

        :return: The request_id of this VariableRegistryUpdateRequestDTO.
        :rtype: str
        """
        return self._request_id

    @request_id.setter
    def request_id(self, request_id):
        """
        Sets the request_id of this VariableRegistryUpdateRequestDTO.
        The unique ID of this request.

        :param request_id: The request_id of this VariableRegistryUpdateRequestDTO.
        :type: str
        """

        self._request_id = request_id

    @property
    def process_group_id(self):
        """
        Gets the process_group_id of this VariableRegistryUpdateRequestDTO.
        The unique ID of the Process Group that the variable registry belongs to

        :return: The process_group_id of this VariableRegistryUpdateRequestDTO.
        :rtype: str
        """
        return self._process_group_id

    @process_group_id.setter
    def process_group_id(self, process_group_id):
        """
        Sets the process_group_id of this VariableRegistryUpdateRequestDTO.
        The unique ID of the Process Group that the variable registry belongs to

        :param process_group_id: The process_group_id of this VariableRegistryUpdateRequestDTO.
        :type: str
        """

        self._process_group_id = process_group_id

    @property
    def uri(self):
        """
        Gets the uri of this VariableRegistryUpdateRequestDTO.
        The URI for future requests to this drop request.

        :return: The uri of this VariableRegistryUpdateRequestDTO.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this VariableRegistryUpdateRequestDTO.
        The URI for future requests to this drop request.

        :param uri: The uri of this VariableRegistryUpdateRequestDTO.
        :type: str
        """

        self._uri = uri

    @property
    def submission_time(self):
        """
        Gets the submission_time of this VariableRegistryUpdateRequestDTO.
        The time at which this request was submitted.

        :return: The submission_time of this VariableRegistryUpdateRequestDTO.
        :rtype: str
        """
        return self._submission_time

    @submission_time.setter
    def submission_time(self, submission_time):
        """
        Sets the submission_time of this VariableRegistryUpdateRequestDTO.
        The time at which this request was submitted.

        :param submission_time: The submission_time of this VariableRegistryUpdateRequestDTO.
        :type: str
        """

        self._submission_time = submission_time

    @property
    def last_updated(self):
        """
        Gets the last_updated of this VariableRegistryUpdateRequestDTO.
        The last time this request was updated.

        :return: The last_updated of this VariableRegistryUpdateRequestDTO.
        :rtype: str
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """
        Sets the last_updated of this VariableRegistryUpdateRequestDTO.
        The last time this request was updated.

        :param last_updated: The last_updated of this VariableRegistryUpdateRequestDTO.
        :type: str
        """

        self._last_updated = last_updated

    @property
    def complete(self):
        """
        Gets the complete of this VariableRegistryUpdateRequestDTO.
        Whether or not this request has completed

        :return: The complete of this VariableRegistryUpdateRequestDTO.
        :rtype: bool
        """
        return self._complete

    @complete.setter
    def complete(self, complete):
        """
        Sets the complete of this VariableRegistryUpdateRequestDTO.
        Whether or not this request has completed

        :param complete: The complete of this VariableRegistryUpdateRequestDTO.
        :type: bool
        """

        self._complete = complete

    @property
    def failure_reason(self):
        """
        Gets the failure_reason of this VariableRegistryUpdateRequestDTO.
        An explanation of why this request failed, or null if this request has not failed

        :return: The failure_reason of this VariableRegistryUpdateRequestDTO.
        :rtype: str
        """
        return self._failure_reason

    @failure_reason.setter
    def failure_reason(self, failure_reason):
        """
        Sets the failure_reason of this VariableRegistryUpdateRequestDTO.
        An explanation of why this request failed, or null if this request has not failed

        :param failure_reason: The failure_reason of this VariableRegistryUpdateRequestDTO.
        :type: str
        """

        self._failure_reason = failure_reason

    @property
    def update_steps(self):
        """
        Gets the update_steps of this VariableRegistryUpdateRequestDTO.
        The steps that are required in order to complete the request, along with the status of each

        :return: The update_steps of this VariableRegistryUpdateRequestDTO.
        :rtype: list[VariableRegistryUpdateStepDTO]
        """
        return self._update_steps

    @update_steps.setter
    def update_steps(self, update_steps):
        """
        Sets the update_steps of this VariableRegistryUpdateRequestDTO.
        The steps that are required in order to complete the request, along with the status of each

        :param update_steps: The update_steps of this VariableRegistryUpdateRequestDTO.
        :type: list[VariableRegistryUpdateStepDTO]
        """

        self._update_steps = update_steps

    @property
    def affected_components(self):
        """
        Gets the affected_components of this VariableRegistryUpdateRequestDTO.
        A set of all components that will be affected if the value of this variable is changed

        :return: The affected_components of this VariableRegistryUpdateRequestDTO.
        :rtype: list[AffectedComponentEntity]
        """
        return self._affected_components

    @affected_components.setter
    def affected_components(self, affected_components):
        """
        Sets the affected_components of this VariableRegistryUpdateRequestDTO.
        A set of all components that will be affected if the value of this variable is changed

        :param affected_components: The affected_components of this VariableRegistryUpdateRequestDTO.
        :type: list[AffectedComponentEntity]
        """

        self._affected_components = affected_components

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, VariableRegistryUpdateRequestDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
