# coding: utf-8

"""
    NiFi Rest Api

    The Rest Api provides programmatic access to command and control a NiFi instance in real time. Start and                                              stop processors, monitor queues, query provenance data, and more. Each endpoint below includes a description,                                             definitions of the expected input and output, potential response codes, and the authorizations required                                             to invoke each service.

    OpenAPI spec version: 1.9.1
    Contact: dev@nifi.apache.org
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from pprint import pformat
from six import iteritems
import re


class BucketDTO(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'name': 'str',
        'description': 'str',
        'created': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'description': 'description',
        'created': 'created'
    }

    def __init__(self, id=None, name=None, description=None, created=None):
        """
        BucketDTO - a model defined in Swagger
        """

        self._id = None
        self._name = None
        self._description = None
        self._created = None

        if id is not None:
          self.id = id
        if name is not None:
          self.name = name
        if description is not None:
          self.description = description
        if created is not None:
          self.created = created

    @property
    def id(self):
        """
        Gets the id of this BucketDTO.
        The bucket identifier

        :return: The id of this BucketDTO.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BucketDTO.
        The bucket identifier

        :param id: The id of this BucketDTO.
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """
        Gets the name of this BucketDTO.
        The bucket name

        :return: The name of this BucketDTO.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this BucketDTO.
        The bucket name

        :param name: The name of this BucketDTO.
        :type: str
        """

        self._name = name

    @property
    def description(self):
        """
        Gets the description of this BucketDTO.
        The bucket description

        :return: The description of this BucketDTO.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BucketDTO.
        The bucket description

        :param description: The description of this BucketDTO.
        :type: str
        """

        self._description = description

    @property
    def created(self):
        """
        Gets the created of this BucketDTO.
        The created timestamp of this bucket

        :return: The created of this BucketDTO.
        :rtype: int
        """
        return self._created

    @created.setter
    def created(self, created):
        """
        Sets the created of this BucketDTO.
        The created timestamp of this bucket

        :param created: The created of this BucketDTO.
        :type: int
        """

        self._created = created

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        if not isinstance(other, BucketDTO):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other
