#!/usr/bin/env python
import os
import sys

import django


def runtests(*test_args):
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "account.tests.settings")
    django.setup()

    parent = os.path.dirname(os.path.abspath(__file__))
    sys.path.insert(0, parent)

    from django.test.runner import DiscoverRunner
    runner_class = DiscoverRunner
    if not test_args:
        test_args = ["account.tests"]

    failures = runner_class(verbosity=1, interactive=True, failfast=False).run_tests(test_args)
    sys.exit(failures)


if __name__ == "__main__":
    runtests(*sys.argv[1:])
