# -*- coding: utf-8 -*-

"""
firstlanguage_python

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
import os
from firstlanguage_python.utilities.schema_validator_wrapper import SchemaValidatorWrapper
from jsonschema import ValidationError
from firstlanguage_python.api_helper import APIHelper


class Input2(object):

    """Implementation of the 'Input2' model.

    TODO: type model description here.

    Attributes:
        context (string): Word or sentence or a paragraph. Special characters
            will not be stripped.
        lang (string): Allowed language code. Refer Allowed languages
            section.
        labels (list of object): Labels to classify

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "context": 'context',
        "lang": 'lang',
        "labels": 'labels'
    }

    def __init__(self,
                 context=None,
                 lang=None,
                 labels=None):
        """Constructor for the Input2 class"""

        # Initialize members of the class
        self.context = context
        self.lang = lang
        self.labels = labels

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """
        if dictionary is None:
            return None

        # Extract variables from the dictionary
        context = dictionary.get('context')
        lang = dictionary.get('lang')
        labels = dictionary.get('labels')

        # Return an object of this model
        return cls(context,
                   lang,
                   labels)

    @classmethod
    def validate(cls, val):
        """Validates value against class schema

        Args:
            val: the value to be validated

        Returns:
            boolean : if value is valid against schema.

        """
        return SchemaValidatorWrapper.getValidator(APIHelper.get_schema_path(os.path.abspath(__file__))).is_valid(val)
