# -*- coding: utf-8 -*-

"""
firstlanguage_python

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""

from firstlanguage_python.api_helper import APIHelper
from firstlanguage_python.configuration import Server
from firstlanguage_python.controllers.base_controller import BaseController
from firstlanguage_python.models.responsestem import Responsestem
from firstlanguage_python.models.responselemma import Responselemma
from firstlanguage_python.models.responsemorph import Responsemorph
from firstlanguage_python.models.responsepo import Responsepo
from firstlanguage_python.exceptions.errors_exception import ErrorsException
from firstlanguage_python.exceptions.api_stemmer_426_error_exception import ApiStemmer426ErrorException
from firstlanguage_python.exceptions.api_exception import APIException
from firstlanguage_python.exceptions.api_lemmatize_426_error_exception import ApiLemmatize426ErrorException
from firstlanguage_python.exceptions.api_morph_426_error_exception import ApiMorph426ErrorException
from firstlanguage_python.exceptions.api_postag_426_error_exception import ApiPostag426ErrorException


class BasicAPIsController(BaseController):

    """A Controller to access Endpoints in the firstlanguage_python API."""
    def __init__(self, config, auth_managers, call_back=None):
        super(BasicAPIsController, self).__init__(config, auth_managers, call_back)

    def get_stemmer(self,
                    body):
        """Does a POST request to /api/stemmer.

        # Stemmer : Defintion and it's usage
        A word takes different inflectional forms. For instance, the word,
        "Compute" can take the forms, "computing", "computation",  and
        "computerize". The NLP applications such as Search Engines and
        Information Extraction would want to store the base or stem of the
        word, i.e "Compute" instead of accomodating all its inflected forms.
        This will yield in dimensionality reduction and incerases the
        efficiency of the system. The stemmer cuts the prefix and suffix of a
        word. 
         # Languages covered:
          Our stemmer works for the following  26 languages. 
          
        | Languages    | ISO Code   |
        |--------------|------------|
        |  Arabic      |  ar        |
        |  Catalan     |  ca        |
        |  Danish      |  da        |
        |  German      |  de        |
        |  Greek       |  el        |
        |  English     |  en        |
        |  Spanish     |  es        |
        |  Basque      |  eu        |
        |  Finnish     |  fi        |
        |  French      |  fr        |
        |  Irish       |  ga        |
        |  Hindi       |  hi        |
        |  Hungarian   |  hu        |
        |  Indonesian  |  id        |
        |  Italian     |  it        |
        |  Lithuanian  |  lt        |
        |  Nepali      |  ne        |
        |  Dutch       |  nl        |
        |  Norwegian   |  no        |
        |  Portuguese  |  pt        |
        |  Romanian    |  ro        |
        |  Russian     |  ru        |
        |  Serbian     |  sr        |
        |  Swedish     |  sv        |
        |  Tamil       |  ta        |
        |  Turkish     |  tr        |

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            list of Responsestem: Response from the API. Stemmed output.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/stemmer'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiStemmer426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responsestem.from_dictionary)

        return decoded

    def get_lemma(self,
                  body):
        """Does a POST request to /api/lemmatize.

        # Lemmatizer : Defintion and it's usage
        Lemmatizer is similar to stemmer that gives the stemmed version of a
        word but lemmatizer differs from the stemmer in giving a meaningful
        stem or the lemma. For instance, for the word, "smiling", the stemmer
        would give, "smil", stemming the suffix, "ing" but the lemmatizer
        would give the meaningful stem, "smile". lemmatizers can be used in
        applications such as,  Machine Translation, Search Engines, Text
        Summarization etc.
        # Languages covered:
        | Languages          | ISO Code |
        |--------------------|----------|
        | Catalan            | ca       |
        | Danish             | da       |
        | Dutch              | nl       |
        | English            | en       |
        | French             | fr       |
        | German             | de       |
        | Greek              | el       |
        | Italian            | it       |
        | Lithuanian         | lt       |
        | Macedonian         | mk       |
        | Norwegian (Bokmål) | nb       |
        | Polish             | pl       |
        | Portuguese         | pt       |
        | Romanian           | ro       |
        | Russian            | ru       |
        | Spanish            | es       |

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            list of Responselemma: Response from the API. Lemmatized output.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/lemmatize'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiLemmatize426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responselemma.from_dictionary)

        return decoded

    def get_morph(self,
                  body):
        """Does a POST request to /api/morph.

        # Morphological Analyzer : Defintion and it's usage
        Morphological Analyzer analyzes how a word is formed. It breaks a word
        into smaller units called, "morphemes" and gives a clue on the pattern
        of words of a particular langauge.  It can be used for building
        applications such as,  Machine Translation, Text Summarization, Search
        systems etc. 
        # Languages covered:
        | Languages          | ISO Code |
        |--------------------|----------|
        | Catalan            | ca       |
        | Danish             | da       |
        | Dutch              | nl       |
        | English            | en       |
        | French             | fr       |
        | German             | de       |
        | Greek              | el       |
        | Italian            | it       |
        | Japanese           | ja       |
        | Lithuanian         | lt       |
        | Macedonian         | mk       |
        | Norwegian (Bokmål) | nb       |
        | Polish             | pl       |
        | Portuguese         | pt       |
        | Russian            | ru       |
        | Spanish            | es       |

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            Responsemorph: Response from the API. Morphological output.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/morph'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiMorph426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responsemorph.from_dictionary)

        return decoded

    def get_postag(self,
                   body):
        """Does a POST request to /api/postag.

         # Parts of Speech Tagger : Defintion and it's usage
          Parts of Speech Tagger, which is shortly known as POS Tagger is a
          software that automatically finds the word classes, when a text
          input is given. The text input can be a word, a sentence or a set of
          sentences. The word classes are the grammatical categories such as,
          Noun, Verb, Adverb etc. The category assigned to each word is called
          as a tag. A set of tags, each indicating a grammatical category is
          called, "tagsets". POS tagging is a mandatory pre-processing for
          most of the Natural Language Processing Applications such as,
          Information Extraction, Information Retreival systems and Summary
          generation systems. A POS Tagger is a language-dependent software as
          the grammar rules will differ for every language. For instance, a
          word ending with "ing" might indicate a "Verb" in English but this
          will not be applicable for other languages. 
        # Languages covered:
        | Languages          | ISO Code |
        |--------------------|----------|
        | Chinese            | zh       |
        | Dutch              | nl       |
        | English            | en       |
        | German             | de       |
        | Italian            | it       |
        | Lithuanian         | lt       |
        | Polish             | pl       |
        | Romanian           | ro       |
        | Tamil              | ta       |
         

        Args:
            body (object): Add a JSON Input as per the schema defined below

        Returns:
            list of Responsepo: Response from the API. POSTAG output.

        Raises:
            APIException: When an error occurs while fetching the data from
                the remote API. This exception includes the HTTP Response
                code, an error message, and the HTTP body that was received in
                the request.

        """

        # Prepare query URL
        _url_path = '/api/postag'
        _query_builder = self.config.get_base_uri()
        _query_builder += _url_path
        _query_url = APIHelper.clean_url(_query_builder)

        # Prepare headers
        _headers = {
            'accept': 'application/json',
            'Content-Type': 'application/json'
        }

        # Prepare and execute request
        _request = self.config.http_client.post(_query_url, headers=_headers, parameters=APIHelper.json_serialize(body))
        # Apply authentication scheme on request
        self.apply_auth_schemes(_request, 'global')

        _response = self.execute_request(_request)

        # Endpoint and global error handling using HTTP status codes.
        if _response.status_code == 400:
            raise ErrorsException('Error output', _response)
        elif _response.status_code == 426:
            raise ApiPostag426ErrorException('Please use HTTPS protocol', _response)
        elif _response.status_code == 429:
            raise APIException('Too Many Requests', _response)
        self.validate_response(_response)

        decoded = APIHelper.json_deserialize(_response.text, Responsepo.from_dictionary)

        return decoded
