# -*- coding: utf-8 -*-
"""Module to transliterate text."""
#
# (C) Pywikibot team, 2006-2020
#
# Distributed under the terms of the MIT license.
#
_trans = {
    'À': 'A', 'Á': 'A', 'Â': 'A', 'Ầ': 'A', 'Ấ': 'A', 'Ẫ': 'A', 'Ẩ': 'A',
    'Ậ': 'A', 'Ã': 'A', 'Ā': 'A', 'Ă': 'A', 'Ằ': 'A', 'Ắ': 'A', 'Ẵ': 'A',
    'Ặ': 'A', 'Ẳ': 'A', 'Ȧ': 'A', 'Ǡ': 'A', 'Ạ': 'A', 'Ḁ': 'A', 'Ȃ': 'A',
    'Ą': 'A', 'Ǎ': 'A', 'Ả': 'A', 'Ȁ': 'Ä', 'Ǟ': 'Ä', 'Ǻ': 'Å', 'Ä': 'Ae',
    'Å': 'Aa', 'à': 'a', 'á': 'a', 'â': 'a', 'ầ': 'a', 'ấ': 'a', 'ẫ': 'a',
    'ẩ': 'a', 'ậ': 'a', 'ã': 'a', 'ā': 'a', 'ă': 'a', 'ằ': 'a', 'ắ': 'a',
    'ẵ': 'a', 'ặ': 'a', 'ẳ': 'a', 'ȧ': 'a', 'ǡ': 'a', 'ạ': 'a', 'ḁ': 'a',
    'ȃ': 'a', 'ą': 'a', 'ǎ': 'a', 'ả': 'a', 'ẚ': 'a', 'ȁ': 'ä', 'ǟ': 'ä',
    'ǻ': 'å', 'ä': 'ae', 'å': 'aa', 'Ḃ': 'B', 'Ḅ': 'B', 'Ḇ': 'B', 'Ɓ': 'B',
    'Ƃ': 'B', 'ḃ': 'b', 'ḅ': 'b', 'ḇ': 'b', 'ƀ': 'b', 'ɓ': 'b', 'ƃ': 'b',
    'Ć': 'C', 'Ĉ': 'C', 'Ċ': 'C', 'Ç': 'C', 'Č': 'C', 'Ƈ': 'C', 'ć': 'c',
    'ĉ': 'c', 'ċ': 'c', 'ç': 'c', 'č': 'c', 'ƈ': 'c', 'ȼ': 'c', 'Ḉ': 'Ç',
    'ḉ': 'ç', 'Ð': 'Dh', 'ð': 'dh', 'Ď': 'D', 'Ḋ': 'D', 'Ḍ': 'D', 'Ḏ': 'D',
    'Ḑ': 'D', 'Ḓ': 'D', 'Đ': 'D', 'Ɖ': 'D', 'Ɗ': 'D', 'Ƌ': 'D', 'ď': 'd',
    'ḋ': 'd', 'ḍ': 'd', 'ḏ': 'd', 'ḑ': 'd', 'ḓ': 'd', 'đ': 'd', 'ɖ': 'd',
    'ɗ': 'd', 'ƌ': 'd', 'È': 'E', 'Ȅ': 'E', 'É': 'E', 'Ê': 'E', 'Ḛ': 'E',
    'Ë': 'E', 'Ē': 'E', 'Ḕ': 'E', 'Ḗ': 'E', 'Ĕ': 'E', 'Ė': 'E', 'Ẹ': 'E',
    'E': 'E', '̩': 'e', 'Ȇ': 'E', 'Ȩ': 'E', 'Ḝ': 'E', 'Ę': 'E', 'Ě': 'E',
    'Ẽ': 'E', 'Ḙ': 'E', 'Ẻ': 'E', 'Ề': 'Ê', 'Ế': 'Ê', 'Ễ': 'Ê', 'Ệ': 'Ê',
    'Ể': 'Ê', 'è': 'e', 'ȅ': 'e', 'é': 'e', 'ê': 'e', 'ḛ': 'e', 'ë': 'e',
    'ē': 'e', 'ḕ': 'e', 'ḗ': 'e', 'ĕ': 'e', 'ė': 'e', 'ẹ': 'e', 'e': 'e',
    'ȇ': 'e', 'ȩ': 'e', 'ḝ': 'e', 'ę': 'e', 'ě': 'e', 'ẽ': 'e', 'ḙ': 'e',
    'ẻ': 'e', 'ề': 'ê', 'ế': 'ê', 'ễ': 'ê', 'ệ': 'ê', 'ể': 'ê', 'Ḟ': 'F',
    'Ƒ': 'F', 'ḟ': 'f', 'ƒ': 'f', 'Ǵ': 'G', 'Ḡ': 'G', 'Ğ': 'G', 'Ġ': 'G',
    'Ģ': 'G', 'Ǧ': 'G', 'Ǥ': 'G', 'Ɠ': 'G', 'ǵ': 'g', 'ḡ': 'g', 'ğ': 'g',
    'ġ': 'g', 'ģ': 'g', 'ǧ': 'g', 'ǥ': 'g', 'ɠ': 'g', 'Ĝ': 'Gx', 'ĝ': 'gx',
    'Ḣ': 'H', 'Ḥ': 'H', 'Ḧ': 'H', 'Ȟ': 'H', 'Ḩ': 'H', 'Ḫ': 'H',
    '̱': 'h', 'Ħ': 'H', 'ḣ': 'h', 'ḥ': 'h', 'ḧ': 'h', 'ȟ': 'h',
    'ḩ': 'h', 'ḫ': 'h', 'ẖ': 'h', 'ħ': 'h', 'I': 'I', 'Ì': 'I',
    'Ȉ': 'I', 'Í': 'I', 'Î': 'I', 'Ĩ': 'I', 'Ḭ': 'I', 'Ï': 'I', 'Ḯ': 'I',
    'Ī': 'I', 'Ĭ': 'I', 'Ȋ': 'I', 'Į': 'I', 'Ǐ': 'I', 'İ': 'I', 'Ị': 'I',
    'Ỉ': 'I', 'Ɨ': 'I', 'ı': 'i', 'ì': 'i', 'ȉ': 'i', 'í': 'i', 'î': 'i',
    'ĩ': 'i', 'ḭ': 'i', 'ï': 'i', 'ḯ': 'i', 'ī': 'i', 'ĭ': 'i', 'ȋ': 'i',
    'į': 'i', 'ǐ': 'i', 'i': 'i', 'ị': 'i', 'ỉ': 'i', 'ɨ': 'i', 'Ĵ': 'J',
    'J': 'J', 'ɟ': 'j', 'ĵ': 'j', '̌': 'j', 'ǰ': 'j', 'Ḱ': 'K', 'Ǩ': 'K',
    'Ķ': 'K', 'Ḳ': 'K', 'Ḵ': 'K', 'Ƙ': 'K', 'ḱ': 'k', 'ǩ': 'k', 'ķ': 'k',
    'ḳ': 'k', 'ḵ': 'k', 'ƙ': 'k', 'Ĺ': 'L', 'Ļ': 'L', 'Ľ': 'L', 'Ḷ': 'L',
    'Ḹ': 'L', 'Ḻ': 'L', 'Ḽ': 'L', 'Ƚ': 'L', 'Ł': 'L', 'ĺ': 'l', 'ļ': 'l',
    'ľ': 'l', 'ḷ': 'l', 'ḹ': 'l', 'ḻ': 'l', 'ḽ': 'l', 'ƚ': 'l', 'ł': 'l',
    'ɫ': 'l', 'Ḿ': 'M', 'Ṁ': 'M', 'Ṃ': 'M', 'ḿ': 'm', 'ṁ': 'm', 'ṃ': 'm',
    'ɱ': 'm', 'Ǹ': 'N', 'Ń': 'N', 'Ñ': 'N', 'Ņ': 'N', 'Ň': 'N', 'Ṅ': 'N',
    'Ṇ': 'N', 'Ṉ': 'N', 'Ṋ': 'N', 'Ɲ': 'N', 'ɲ': 'n', 'Ƞ': 'N',
    'ǹ': 'n', 'ń': 'n', 'ñ': 'n', 'ņ': 'n', 'ň': 'n', 'ṅ': 'n', 'ṇ': 'n',
    'ṉ': 'n', 'ṋ': 'n', 'ƞ': 'n', 'Ò': 'O', 'Ó': 'O', 'Ô': 'O',
    'Õ': 'O', 'Ṍ': 'O', 'Ṏ': 'O', 'Ȭ': 'O', 'Ö': 'O', 'Ō': 'O', 'Ṑ': 'O',
    'Ṓ': 'O', 'Ŏ': 'O', 'Ǒ': 'O', 'Ȯ': 'O', 'Ȱ': 'O', 'Ọ': 'O', 'Ǫ': 'O',
    'Ǭ': 'O', 'Ơ': 'O', 'Ờ': 'O', 'Ớ': 'O', 'Ỡ': 'O', 'Ợ': 'O', 'Ở': 'O',
    'Ỏ': 'O', 'Ɵ': 'O', 'Ø': 'O', 'Ǿ': 'O', 'ò': 'o', 'ó': 'o', 'ô': 'o',
    'õ': 'o', 'ṍ': 'o', 'ṏ': 'o', 'ȭ': 'o', 'ö': 'o', 'ō': 'o', 'ṑ': 'o',
    'ṓ': 'o', 'ŏ': 'o', 'ǒ': 'o', 'ȯ': 'o', 'ȱ': 'o', 'ọ': 'o', 'ǫ': 'o',
    'ǭ': 'o', 'ơ': 'o', 'ờ': 'o', 'ớ': 'o', 'ỡ': 'o', 'ợ': 'o', 'ở': 'o',
    'ỏ': 'o', 'ɵ': 'o', 'ø': 'o', 'ǿ': 'o', 'Ȍ': 'Ö', 'Ő': 'Ö', 'Ȫ': 'Ö',
    'ȍ': 'ö', 'ő': 'ö', 'ȫ': 'ö', 'Ồ': 'Ô', 'Ố': 'Ô', 'Ỗ': 'Ô', 'Ộ': 'Ô',
    'Ổ': 'Ô', 'Ȏ': 'Ô', 'ồ': 'ô', 'ố': 'ô', 'ỗ': 'ô', 'ộ': 'ô', 'ổ': 'ô',
    'ȏ': 'ô', 'Ṕ': 'P', 'Ṗ': 'P', 'Ƥ': 'P', 'ṕ': 'p', 'ṗ': 'p', 'ƥ': 'p',
    'ᵽ': 'q', 'Ȑ': 'R', 'Ŕ': 'R', 'Ŗ': 'R', 'Ř': 'R', 'Ȓ': 'R', 'Ṙ': 'R',
    'Ṛ': 'R', 'Ṝ': 'R', 'Ṟ': 'R', 'ȑ': 'r', 'ŕ': 'r', 'ŗ': 'r', 'ř': 'r',
    'ȓ': 'r', 'ṙ': 'r', 'ṛ': 'r', 'ṝ': 'r', 'ṟ': 'r', 'ɽ': 'r', 'Ś': 'S',
    'Ṥ': 'S', 'Ş': 'S', 'Ș': 'S', 'Š': 'S', 'Ṧ': 'S', 'Ṡ': 'S', 'Ṣ': 'S',
    'Ṩ': 'S', 'ś': 's', 'ṥ': 's', 'ş': 's', 'ș': 's', 'š': 's', 'ṧ': 's',
    'ṡ': 's', 'ṣ': 's', 'ṩ': 's', 'ȿ': 's', 'Ŝ': 'Sx', 'ŝ': 'sx', 'Ţ': 'T',
    'Ț': 'T', 'Ť': 'T', 'Ṫ': 'T', 'Ṭ': 'T', 'Ṯ': 'T', 'Ṱ': 'T', 'Ŧ': 'T',
    'Ƭ': 'T', 'Ʈ': 'T', 'ţ': 't', 'ț': 't', 'ť': 't', 'ṫ': 't', 'ṭ': 't',
    'ṯ': 't', 'ṱ': 't', 'ŧ': 't', 'Ⱦ': 't', 'ƭ': 't', 'ʈ': 't', 'Ù': 'U',
    'Ú': 'U', 'Ũ': 'U', 'Ṹ': 'U', 'Ṵ': 'U', 'Ü': 'U', 'Ṳ': 'U', 'Ū': 'U',
    'Ṻ': 'U', 'Ŭ': 'U', 'Ụ': 'U', 'Ů': 'U', 'Ų': 'U', 'Ǔ': 'U', 'Ṷ': 'U',
    'Ủ': 'U', 'Ư': 'U', 'Ữ': 'U', 'Ự': 'U', 'Ử': 'U', 'ù': 'u', 'ú': 'u',
    'ũ': 'u', 'ṹ': 'u', 'ṵ': 'u', 'ü': 'u', 'ṳ': 'u', 'ū': 'u', 'ṻ': 'u',
    'ŭ': 'u', 'ụ': 'u', 'ů': 'u', 'ų': 'u', 'ǔ': 'u', 'ṷ': 'u', 'ủ': 'u',
    'ư': 'u', 'ữ': 'u', 'ự': 'u', 'ử': 'u', 'Ȕ': 'Ü', 'Ű': 'Ü',
    'Ǜ': 'Ü', 'Ǘ': 'Ü', 'Ǖ': 'Ü', 'Ǚ': 'Ü', 'ȕ': 'ü', 'ű': 'ü', 'ǜ': 'ü',
    'ǘ': 'ü', 'ǖ': 'ü', 'ǚ': 'ü', 'Û': 'Ux', 'û': 'ux', 'Ȗ': 'Û', 'ȗ': 'û',
    'Ừ': 'Ù', 'ừ': 'ù', 'Ứ': 'Ú', 'ứ': 'ú', 'Ṽ': 'V', 'Ṿ': 'V', 'ṽ': 'v',
    'ṿ': 'v', 'Ẁ': 'W', 'Ẃ': 'W', 'Ŵ': 'W', 'Ẅ': 'W', 'Ẇ': 'W', 'Ẉ': 'W',
    'ẁ': 'w', 'ẃ': 'w', 'ŵ': 'w', 'ẅ': 'w', 'ẇ': 'w', 'ẉ': 'w', 'Ẋ': 'X',
    'Ẍ': 'X', 'ẋ': 'x', 'ẍ': 'x', 'Ỳ': 'Y', 'Ý': 'Y', 'Ŷ': 'Y', 'Ÿ': 'Y',
    'Ỹ': 'Y', 'Ȳ': 'Y', 'Ẏ': 'Y', 'Ỵ': 'Y', 'Ỷ': 'Y', 'Ƴ': 'Y', 'ỳ': 'y',
    'ý': 'y', 'ŷ': 'y', 'ÿ': 'y', 'ỹ': 'y', 'ȳ': 'y', 'ẏ': 'y', 'ỵ': 'y',
    'ỷ': 'y', 'ƴ': 'y', 'Ź': 'Z', 'Ẑ': 'Z', 'Ż': 'Z', 'Ẓ': 'Z', 'Ž': 'Z',
    'Ẕ': 'Z', 'Ƶ': 'Z', 'Ȥ': 'Z', 'ź': 'z', 'ẑ': 'z', 'ż': 'z', 'ẓ': 'z',
    'ž': 'z', 'ẕ': 'z', 'ƶ': 'z', 'ȥ': 'z', 'ɀ': 'zv',
    # Latin: extended Latin alphabet
    'ɑ': 'a', 'Æ': 'AE', 'Ǽ': 'AE', 'Ǣ': 'AE', 'æ': 'ae', 'ǽ': 'ae',
    'ǣ': 'ae', 'Ǝ': 'E', 'Ə': 'E', 'Ɛ': 'E', 'ǝ': 'e',
    'ə': 'e', 'ɛ': 'e', 'Ɣ': 'G', 'Ƣ': 'G', 'ᵷ': 'g', 'ɣ': 'g', 'ƣ': 'g',
    'ᵹ': 'g', 'Ƅ': 'H', 'ƅ': 'h', 'Ƕ': 'Wh', 'ƕ': 'wh', 'Ɩ': 'I', 'ɩ': 'i',
    'Ŋ': 'Ng', 'ŋ': 'ng', 'Œ': 'OE', 'œ': 'oe', 'Ɔ': 'O', 'ɔ': 'o',
    'Ȣ': 'Ou', 'ȣ': 'ou', 'Ƽ': 'Q', 'ĸ': 'q', 'ƽ': 'q', 'ȹ': 'qp',
    '\uf20e': 'r', 'ſ': 's', 'ß': 'ss', 'Ʃ': 'Sh', 'ʃ': 'sh', 'ᶋ': 'sh',
    'Ʉ': 'U', 'ʉ': 'u', 'Ʌ': 'V', 'ʌ': 'v', 'Ɯ': 'W', 'Ƿ': 'W', 'ɯ': 'w',
    'ƿ': 'w', 'Ȝ': 'Y', 'ȝ': 'y', 'Ĳ': 'IJ', 'ĳ': 'ij', 'Ƨ': 'Z', 'ʮ': 'z',
    'ƨ': 'z', 'Ʒ': 'Zh', 'ʒ': 'zh', 'Ǯ': 'Dzh', 'ǯ': 'dzh', 'Ƹ': "'", 'ƹ': "'",
    'ʔ': "'", 'ˀ': "'", 'Ɂ': "'", 'ɂ': "'", 'Þ': 'Th', 'þ': 'th', 'C': '!',
    'ʗ': '!', 'ǃ': '!',
    # Punctuation and typography
    '«': '"', '»': '"', '“': '"', '”': '"', '„': '"', '¨': '"', '‘': "'",
    '’': "'", '′': "'", '@': '(at)', '¤': '$', '¢': 'c', '€': 'E',
    '£': 'L', '¥': 'yen', '†': '+', '‡': '++', '°': ':', '¡': '!', '¿': '?',
    '‰': 'o/oo', '‱': 'o/ooo', '¶': '>', '§': '>', '‒': '-',
    '–': '-', '—': '-', '―': '-', '¦': '|', '⁂': '***', '◊': '<>',
    '‽': '?!', '¹': '1', '²': '2', '³': '3',
    # Cyrillic
    'А': 'A', 'а': 'a', 'Б': 'B', 'б': 'b', 'В': 'V', 'в': 'v', 'Г': 'G',
    'г': 'g', 'Д': 'D', 'д': 'd', 'Е': 'E', 'е': 'e', 'Ж': 'Zh', 'ж': 'zh',
    'З': 'Z', 'з': 'z', 'И': 'I', 'и': 'i', 'Й': 'J', 'й': 'j', 'К': 'K',
    'к': 'k', 'Л': 'L', 'л': 'l', 'М': 'M', 'м': 'm', 'Н': 'N', 'н': 'n',
    'О': 'O', 'о': 'o', 'П': 'P', 'п': 'p', 'Р': 'R', 'р': 'r', 'С': 'S',
    'с': 's', 'Т': 'T', 'т': 't', 'У': 'U', 'у': 'u', 'Ф': 'F', 'ф': 'f',
    'х': 'kh', 'Ц': 'C', 'ц': 'c', 'Ч': 'Ch', 'ч': 'ch', 'Ш': 'Sh', 'ш': 'sh',
    'Щ': 'Shch', 'щ': 'shch', 'Ь': "'", 'ь': "'", 'Ъ': '"', 'ъ': '"',
    'Ю': 'Yu', 'ю': 'yu', 'Я': 'Ya', 'я': 'ya', 'Х': 'Kh', 'Χ': 'Kh',
    # Additional Cyrillic letters, most occurring in only a few languages
    'Ы': 'Y', 'ы': 'y', 'Ё': 'Ë', 'ё': 'ë', 'Э': 'È', 'Ѐ': 'È', 'э': 'è',
    'ѐ': 'è', 'І': 'I', 'і': 'i', 'Ї': 'Ji', 'ї': 'ji', 'Є': 'Je', 'є': 'je',
    'Ґ': 'G', 'Ҝ': 'G', 'ґ': 'g', 'ҝ': 'g', 'Ђ': 'Dj', 'ђ': 'dj', 'Љ': 'Lj',
    'љ': 'lj', 'Њ': 'Nj', 'њ': 'nj', 'Ћ': 'Cj', 'ћ': 'cj', 'Җ': 'Zhj',
    'Ѓ': 'Gj', 'ѓ': 'gj', 'Ќ': 'Kj', 'ќ': 'kj', 'Ӣ': 'Ii', 'ӣ': 'ii', 'Ҳ': 'H',
    'ҳ': 'h', 'Ҷ': 'Dzh', 'Ө': 'Ô', 'Ӫ': 'Ô', 'ө': 'ô', 'ӫ': 'ô',
    'Һ': 'H', 'һ': 'h', 'Ә': 'AE', 'Ӕ': 'AE', 'ә': 'ae',
    'Ӛ': 'Ë', 'Ӭ': 'Ë', 'ӛ': 'ë', 'ӭ': 'ë', 'җ': 'zhj', 'Ұ': 'U', 'ў': 'ù',
    'Ў': 'Ù', 'ѝ': 'ì', 'Ѝ': 'Ì', 'Ӑ': 'A', 'Ӓ': 'Ä', 'Ҽ': 'Ts',
    'Ҿ': 'Ts', 'ҽ': 'ts', 'ҿ': 'ts', 'Ҙ': 'Dh', 'ҙ': 'dh', 'Ӏ': '', 'ӏ': '',
    'Ӆ': 'L', 'ӆ': 'l', 'Ӎ': 'M', 'ӎ': 'm', 'Ӧ': 'Ö', 'ӧ': 'ö', 'Ҩ': 'u',
    'ҩ': 'u', 'Ҧ': 'Ph', 'ҧ': 'ph', 'Ҏ': 'R', 'ҏ': 'r', 'Ҫ': 'Th', 'ҫ': 'th',
    'Ҭ': 'T', 'ҭ': 't', 'Ӯ': 'Û', 'ӯ': 'û', 'Ӹ': 'U', 'ұ': 'u', 'ӹ': 'u',
    'Ҵ': 'Tts', 'ҵ': 'tts', 'Ӵ': 'Ch', 'ӵ': 'ch',
    'Ј': 'J', 'Ӥ': 'J', 'Ҋ': 'J', 'ј': 'j', 'ӥ': 'j', 'ҋ': 'j', 'Џ': 'Dzh',
    'Ӂ': 'Dzh', 'Ӝ': 'Dzh', 'џ': 'dzh', 'ӂ': 'dzh', 'ӝ': 'dzh',
    'ҷ': 'dzh', 'Ѕ': 'Dz', 'Ӟ': 'Dz', 'Ӡ': 'Dz', 'Ӌ': 'Dz', 'Ҹ': 'Dz',
    'ѕ': 'dz', 'ӟ': 'dz', 'ӡ': 'dz', 'ӌ': 'dz', 'ҹ': 'dz', 'Ғ': 'G',
    'Ӷ': 'G', 'Ҕ': 'G', 'ғ': 'g', 'ӷ': 'g', 'ҕ': 'g', 'Қ': 'Q', 'Ҟ': 'Q',
    'Ҡ': 'Q', 'Ӄ': 'Q', 'қ': 'q', 'ҟ': 'q', 'ҡ': 'q', 'ӄ': 'q', 'Ң': 'Ng',
    'Ҥ': 'Ng', 'Ӊ': 'Ng', 'Ӈ': 'Ng', 'ң': 'ng', 'ҥ': 'ng', 'ӊ': 'ng',
    'ӈ': 'ng', 'Ӗ': 'E', 'Ҍ': 'E', 'ӗ': 'e', 'ҍ': 'e',
    'Ӳ': 'Ü', 'Ӱ': 'Ü', 'Ү': 'Ü', 'ӳ': 'ü', 'ӱ': 'ü', 'ү': 'ü',
    # Archaic Cyrillic letters
    'Ѹ': 'Ou', 'ѹ': 'ou', 'Ѡ': 'O', 'Ѻ': 'O', 'ѡ': 'o', 'ѻ': 'o', 'Ѿ': 'Ot',
    'ѿ': 'ot', 'Ѣ': 'E', 'ѣ': 'e', 'Ѥ': 'Ei', 'Ѧ': 'Ei', 'ѥ': 'ei', 'ѧ': 'ei',
    'Ѫ': 'Ai', 'ѫ': 'ai', 'Ѯ': 'X', 'ѯ': 'x', 'Ѱ': 'Ps', 'ѱ': 'ps', 'Ѳ': 'Th',
    'ѳ': 'th', 'Ѵ': 'Ü', 'Ѷ': 'Ü', 'ѵ': 'ü',
    # Hebrew alphabet
    'א': "'", 'ע': "'", 'ב': 'b', 'ג': 'g', 'ד': 'd', 'ה': 'h', 'ו': 'v',
    'ז': 'z', 'ח': 'kh', 'ט': 't', 'י': 'y', 'ך': 'k', 'כ': 'k', 'ל': 'l',
    'ם': 'm', 'מ': 'm', 'ן': 'n', 'נ': 'n', 'ס': 's', 'ף': 'ph', 'פ': 'ph',
    'ץ': 'ts', 'צ': 'ts', 'ק': 'q', 'ר': 'r', 'ש': 'sh', 'ת': 'th',
    # Arab alphabet
    'ا': 'a', 'ﺍ': 'a', 'ﺎ': 'a', 'ب': 'b', 'ﺏ': 'b', 'ﺐ': 'b', 'ﺒ': 'b',
    'ﺑ': 'b', 'ت': 't', 'ﺕ': 't', 'ﺖ': 't', 'ﺘ': 't', 'ﺗ': 't', 'ث': 'th',
    'ﺙ': 'th', 'ﺚ': 'th', 'ﺜ': 'th', 'ﺛ': 'th', 'ج': 'g', 'ﺝ': 'g', 'ﺞ': 'g',
    'ﺠ': 'g', 'ﺟ': 'g', 'ح': 'h', 'ﺡ': 'h', 'ﺢ': 'h', 'ﺤ': 'h', 'ﺣ': 'h',
    'خ': 'kh', 'ﺥ': 'kh', 'ﺦ': 'kh', 'ﺨ': 'kh', 'ﺧ': 'kh', 'د': 'd', 'ﺩ': 'd',
    'ﺪ': 'd', 'ذ': 'dh', 'ﺫ': 'dh', 'ﺬ': 'dh', 'ر': 'r', 'ﺭ': 'r', 'ﺮ': 'r',
    'ز': 'z', 'ﺯ': 'z', 'ﺰ': 'z', 'س': 's', 'ﺱ': 's', 'ﺲ': 's', 'ﺴ': 's',
    'ﺳ': 's', 'ش': 'sh', 'ﺵ': 'sh', 'ﺶ': 'sh', 'ﺸ': 'sh', 'ﺷ': 'sh', 'ص': 's',
    'ﺹ': 's', 'ﺺ': 's', 'ﺼ': 's', 'ﺻ': 's', 'ض': 'd', 'ﺽ': 'd', 'ﺾ': 'd',
    'ﻀ': 'd', 'ﺿ': 'd', 'ط': 't', 'ﻁ': 't', 'ﻂ': 't', 'ﻄ': 't', 'ﻃ': 't',
    'ظ': 'z', 'ﻅ': 'z', 'ﻆ': 'z', 'ﻈ': 'z', 'ﻇ': 'z', 'ع': "'", 'ﻉ': "'",
    'ﻊ': "'", 'ﻌ': "'", 'ﻋ': "'", 'غ': 'gh', 'ﻍ': 'gh', 'ﻎ': 'gh', 'ﻐ': 'gh',
    'ﻏ': 'gh', 'ف': 'f', 'ﻑ': 'f', 'ﻒ': 'f', 'ﻔ': 'f', 'ﻓ': 'f', 'ق': 'q',
    'ﻕ': 'q', 'ﻖ': 'q', 'ﻘ': 'q', 'ﻗ': 'q', 'ك': 'k', 'ﻙ': 'k', 'ﻚ': 'k',
    'ﻜ': 'k', 'ﻛ': 'k', 'ک': 'k', 'ل': 'l', 'ﻝ': 'l', 'ﻞ': 'l', 'ﻠ': 'l',
    'ﻟ': 'l', 'م': 'm', 'ﻡ': 'm', 'ﻢ': 'm', 'ﻤ': 'm', 'ﻣ': 'm', 'ن': 'n',
    'ﻥ': 'n', 'ﻦ': 'n', 'ﻨ': 'n', 'ﻧ': 'n', 'ه': 'h', 'ﻩ': 'h', 'ﻪ': 'h',
    'ﻬ': 'h', 'ﻫ': 'h', 'و': 'w', 'ﻭ': 'w', 'ﻮ': 'w', 'ی': 'y', 'ي': 'y',
    'ﻱ': 'y', 'ﻲ': 'y', 'ﻴ': 'y', 'ﻳ': 'y',
    # Arabic - additional letters, modified letters and ligatures
    'ﺀ': "'", 'آ': "'a", 'ﺁ': "'a", 'ﺂ': "'a", 'ة': 'th', 'ﺓ': 'th',
    'ﺔ': 'th', 'ى': 'á', 'ﻯ': 'á', 'ﻰ': 'á', 'ﯼ': 'y', 'ﯽ': 'y',
    'ﯿ': 'y', 'ﯾ': 'y', 'ﻻ': 'la', 'ﻼ': 'la', 'ﷲ': 'llah',
    'إ': "a'", 'أ': "a'", 'ؤ': "w'", 'ئ': "y'",
    '◌': 'iy',  # indicates absence of vowels
    # Arab numerals
    '٠': '0', '۰': '0', '١': '1', '۱': '1', '٢': '2', '۲': '2', '٣': '3',
    '۳': '3', '٤': '4', '۴': '4', '٥': '5', '۵': '5', '٦': '6', '۶': '6',
    '٧': '7', '۷': '7', '٨': '8', '۸': '8', '٩': '9', '۹': '9',
    # Perso-Arabic
    'پ': 'p', 'ﭙ': 'p', 'چ': 'ch', 'ژ': 'zh', 'گ': 'g', 'ﮔ': 'g', 'ﮕ': 'g',
    'ﮓ': 'g',
    # Greek
    'Α': 'A', 'α': 'a', 'Β': 'B', 'β': 'b', 'Γ': 'G', 'γ': 'g', 'Δ': 'D',
    'δ': 'd', 'Ε': 'E', 'ε': 'e', 'Ζ': 'Z', 'ζ': 'z', 'Η': 'I', 'η': 'i',
    'θ': 'th', 'Θ': 'Th', 'Ι': 'I', 'ι': 'i', 'Κ': 'K', 'κ': 'k', 'Λ': 'L',
    'λ': 'l', 'Μ': 'M', 'μ': 'm', 'Ν': 'N', 'ν': 'n', 'Ξ': 'X', 'ξ': 'x',
    'Ο': 'O', 'ο': 'o', 'Π': 'P', 'π': 'p', 'Ρ': 'R', 'ρ': 'r', 'Σ': 'S',
    'σ': 's', 'ς': 's', 'Τ': 'T', 'τ': 't', 'Υ': 'Y', 'υ': 'y', 'Φ': 'F',
    'φ': 'f', 'Ψ': 'Ps', 'ψ': 'ps', 'Ω': 'O', 'ω': 'o', 'ϗ': '&', 'Ϛ': 'St',
    'ϛ': 'st', 'Ϙ': 'Q', 'Ϟ': 'Q', 'ϙ': 'q', 'ϟ': 'q', 'Ϻ': 'S', 'ϻ': 's',
    'Ϡ': 'Ss', 'ϡ': 'ss', 'Ϸ': 'Sh', 'ϸ': 'sh', 'Ά': 'Á',
    'ά': 'á', 'Έ': 'É', 'Ή': 'É', 'έ': 'é', 'ή': 'é', 'Ί': 'Í', 'ί': 'í',
    'Ϊ': 'Ï', 'ϊ': 'ï', 'ΐ': 'ï', 'Ό': 'Ó', 'ό': 'ó', 'Ύ': 'Ý', 'ύ': 'ý',
    'Ϋ': 'Y', 'ϋ': 'ÿ', 'ΰ': 'ÿ', 'Ώ': 'Ó', 'ώ': 'ó',
    # Japanese (katakana and hiragana)
    'ア': 'a', 'ァ': 'a', 'あ': 'a', 'イ': 'i', 'ィ': 'i', 'い': 'i', 'ウ': 'u',
    'う': 'u', 'エ': 'e', 'ェ': 'e', 'え': 'e', 'オ': 'o', 'ォ': 'o', 'お': 'o',
    'ャ': 'ya', 'や': 'ya', 'ュ': 'yu', 'ゆ': 'yu', 'ョ': 'yo', 'よ': 'yo',
    'カ': 'ka', 'か': 'ka', 'キ': 'ki', 'き': 'ki', 'ク': 'ku', 'く': 'ku',
    'ケ': 'ke', 'け': 'ke', 'コ': 'ko', 'こ': 'ko', 'サ': 'sa', 'さ': 'sa',
    'シ': 'shi', 'し': 'shi', 'ス': 'su', 'す': 'su', 'セ': 'se', 'せ': 'se',
    'ソ': 'so', 'そ': 'so', 'タ': 'ta', 'た': 'ta', 'チ': 'chi', 'ち': 'chi',
    'ツ': 'tsu', 'つ': 'tsu', 'テ': 'te', 'て': 'te', 'ト': 'to', 'と': 'to',
    'ナ': 'na', 'な': 'na', 'ニ': 'ni', 'に': 'ni', 'ヌ': 'nu', 'ぬ': 'nu',
    'ネ': 'ne', 'ね': 'ne', 'ノ': 'no', 'の': 'no', 'ハ': 'ha', 'は': 'ha',
    'ヒ': 'hi', 'ひ': 'hi', 'フ': 'fu', 'ふ': 'fu', 'ヘ': 'he', 'へ': 'he',
    'ホ': 'ho', 'ほ': 'ho', 'マ': 'ma', 'ま': 'ma', 'ミ': 'mi', 'み': 'mi',
    'ム': 'mu', 'む': 'mu', 'メ': 'me', 'め': 'me', 'モ': 'mo', 'も': 'mo',
    'ラ': 'ra', 'ら': 'ra', 'リ': 'ri', 'り': 'ri', 'ル': 'ru', 'る': 'ru',
    'レ': 're', 'れ': 're', 'ロ': 'ro', 'ろ': 'ro', 'ワ': 'wa', 'わ': 'wa',
    'ヰ': 'wi', 'ゐ': 'wi', 'ヱ': 'we', 'ゑ': 'we', 'ヲ': 'wo', 'を': 'wo',
    'ン': 'n', 'ん': 'n', 'ガ': 'ga', 'が': 'ga', 'ギ': 'gi', 'ぎ': 'gi',
    'グ': 'gu', 'ぐ': 'gu', 'ゲ': 'ge', 'げ': 'ge', 'ゴ': 'go', 'ご': 'go',
    'ザ': 'za', 'ざ': 'za', 'ジ': 'ji', 'じ': 'ji', 'ズ': 'zu', 'ず': 'zu',
    'ゼ': 'ze', 'ぜ': 'ze', 'ゾ': 'zo', 'ぞ': 'zo', 'ダ': 'da', 'だ': 'da',
    'ヂ': 'dji', 'ぢ': 'dji', 'ヅ': 'dzu', 'づ': 'dzu', 'デ': 'de', 'で': 'de',
    'ド': 'do', 'ど': 'do', 'バ': 'ba', 'ば': 'ba', 'ビ': 'bi', 'び': 'bi',
    'ブ': 'bu', 'ぶ': 'bu', 'ベ': 'be', 'べ': 'be', 'ボ': 'bo', 'ぼ': 'bo',
    'パ': 'pa', 'ぱ': 'pa', 'ピ': 'pi', 'ぴ': 'pi', 'プ': 'pu', 'ぷ': 'pu',
    'ペ': 'pe', 'ぺ': 'pe', 'ポ': 'po', 'ぽ': 'po', 'ヴ': 'vu', 'ゔ': 'vu',
    'ヷ': 'va', 'ヸ': 'vi', 'ヹ': 've', 'ヺ': 'vo',
    # Japanese and Chinese punctuation and typography
    '・': ' ', '·': ' ', '〃': '"', '『': '"', '』': '"', '《': '"', '》': '"',
    '「': "'", '」': "'", '〈': "'", '〉': "'", '〘': "'", '〙': "'", '〚': "'",
    '〛': "'", '（': '(', '〔': '(', '）': ')', '〕': ')', '［': '[', '【': '[',
    '〖': '[', '］': ']', '】': ']', '〗': ']', '｛': '{', '｝': '}', 'っ': ':',
    'ー': 'h', '゛': "'", '゜': 'p', '。': '.', '、': ',', '〆': 'shime',
    '〜': '-', '…': '...', '‥': '..', 'ヶ': 'months', '•': '_', '◦': '_',
    '※': '*', '＊': '*', 'Ⓧ': '(X)', 'Ⓨ': '(Y)', '！': '!', '？': '?',
    '；': ';', '：': ':', '，': ',',
    # Georgian
    'ა': 'a', 'ბ': 'b', 'გ': 'g', 'დ': 'd', 'ე': 'e', 'ჱ': 'e', 'ვ': 'v',
    'ზ': 'z', 'თ': 'th', 'ი': 'i', 'კ': 'k', 'ლ': 'l', 'მ': 'm', 'ნ': 'n',
    'ო': 'o', 'პ': 'p', 'ჟ': 'zh', 'რ': 'r', 'ს': 's', 'ტ': 't', 'უ': 'u',
    'ფ': 'ph', 'ქ': 'q', 'ღ': 'gh', 'ყ': "q'", 'შ': 'sh', 'ჩ': 'ch', 'ც': 'ts',
    'ძ': 'dz', 'წ': "ts'", 'ჭ': "ch'", 'ხ': 'kh', 'ჯ': 'j', 'ჰ': 'h', 'ჳ': 'w',
    'ჵ': 'o', 'ჶ': 'f',
    # Devanagari
    'प': 'pa', 'आ': 'aa', 'ा': 'aa', 'इ': 'i', 'ि': 'i',
    'ई': 'ii', 'ी': 'ii', 'उ': 'u', 'ु': 'u', 'ऊ': 'uu', 'ू': 'uu',
    'ए': 'e', 'े': 'e', 'ऐ': 'ai', 'ै': 'ai', 'ओ': 'o', 'ो': 'o', 'औ': 'au',
    'ौ': 'au', 'ऋ': 'r', 'ृ': 'r', 'र': 'r', 'ॠ': 'rr', 'ॄ': 'rr', 'ऌ': 'l',
    'ॢ': 'l', 'ल': 'l', 'ॡ': 'll', 'ॣ': 'll', 'क': 'q', 'ग': 'g',
    'घ': 'gh', 'ङ': 'ng', 'च': 'c', 'छ': 'ch', 'ज': 'z', 'झ': 'jh',
    'ञ': 'ñ', 'ट': 't', 'ठ': 'th', 'थ': 'th', 'ड': 'r',
    'ढ': 'r', 'ध': 'dh', 'ण': 'n', 'न': 'n', 'फ': 'f', 'ब': 'b', 'भ': 'bh',
    'म': 'm', 'य': 'y', 'व': 'v', 'ष': 's', 'स': 's',
    '़': 'q', 'H': 'gh',
    # Devanagari ligatures (possibly incomplete and/or incorrect)
    'ख': 'khn', '्': 'fn', 'त': 'tn', 'द': 'dn', 'श': 'cn', 'ह': 'fn',
    'अ': 'm', 'ँ': 'm', '॒': '', '॑': '', '०': '0', '१': '1', '२': '2',
    '३': '3', '४': '4', '५': '5', '६': '6', '७': '7', '८': '8', '९': '9',
    # Armenian
    'Ա': 'A', 'ա': 'a', 'Բ': 'B', 'բ': 'b', 'Գ': 'G', 'գ': 'g', 'Դ': 'D',
    'դ': 'd', 'Ե': 'Je', 'ե': 'e', 'Զ': 'Z', 'զ': 'z', 'Է': 'É', 'է': 'é',
    'Ը': 'Ë', 'ը': 'ë', 'Թ': 'Th', 'թ': 'th', 'Ժ': 'Zh', 'ժ': 'zh',
    'Ի': 'I', 'ի': 'i', 'Լ': 'L', 'լ': 'l', 'Խ': 'Ch', 'խ': 'ch', 'Ծ': 'Ts',
    'ծ': 'ts', 'Կ': 'K', 'կ': 'k', 'Հ': 'H', 'հ': 'h', 'Ձ': 'Dz', 'ձ': 'dz',
    'Ղ': 'R', 'ղ': 'r', 'Ճ': 'Cz', 'ճ': 'cz', 'Մ': 'M', 'մ': 'm', 'Յ': 'J',
    'յ': 'j', 'Ն': 'N', 'ն': 'n', 'Շ': 'Vo', 'շ': 'o', 'Չ': 'Tsh',
    'չ': 'tsh', 'Պ': 'P', 'պ': 'p', 'Ջ': 'Dz', 'ջ': 'dz', 'Ռ': 'R',
    'ռ': 'r', 'Ս': 'S', 'ս': 's', 'Վ': 'V', 'վ': 'v', 'Տ': "T'", 'տ': "t'",
    'Ր': 'R', 'ր': 'r', 'Ց': 'Tsh', 'ց': 'tsh', 'Ւ': 'V', 'ւ': 'v',
    'Փ': 'Ph', 'փ': 'ph', 'Ք': 'Kh', 'ք': 'kh', 'Օ': 'O', 'օ': 'o',
    'Ֆ': 'F', 'ֆ': 'f', 'և': '&', '՟': '.', '՝': ';', '՛': '',
    # Tamil
    'க': 'x', '்': 'x', 'ங': 'n', 'ண': 'n', 'ந': 'n', 'ன': 'n', 'ச': 'c',
    'ஞ': 'ñ', 'ட': 'th', 'த': 't', 'ப': 'p', 'ம': 'm', 'ய': 'y', 'ர': 'r',
    'ழ': 'r', 'ற': 'r', 'ல': 'l', 'ள': 'l', 'வ': 'v', 'ஜ': 'j', 'ஷ': 'x',
    'ஸ': 's', 'ஹ': 'h', 'அ': 'a', 'ஆ': 'aa', 'இ': 'i', 'ஈ': 'ii', 'உ': 'u',
    'ஊ': 'uu', 'எ': 'e', 'ஏ': 'ee', 'ஐ': 'ai', 'ஒ': 'o', 'ஓ': 'oo',
    'ஔ': 'au', 'ஃ': '',
    # Bengali
    'অ': 'ô', 'আ': 'a', 'া': 'a', 'ই': 'i', 'ি': 'i', 'ঈ': 'i', 'ী': 'i',
    'উ': 'u', 'ু': 'u', 'ঊ': 'u', 'ূ': 'u', 'ঋ': 'ri', 'ৃ': 'ri', 'এ': 'e',
    'ে': 'e', 'য': '-', '়': 'r', 'ঐ': 'oi', 'ৈ': 'oi', 'ও': 'o', 'ো': 'o',
    'ঔ': 'ou', 'ৌ': 'ou', '্': '', 'ৎ': 't', 'ং': 'n', 'ঃ': 'h', 'ঁ': 'ñ',
    'ক': 'k', 'খ': 'kh', 'গ': 'g', 'ঘ': 'gh', 'ঙ': 'ng', 'চ': 'ch',
    'ছ': 'chh', 'জ': 'j', 'ঝ': 'jh', 'ঞ': 'n', 'ট': 't', 'ত': 't',
    'ঠ': 'th', 'থ': 'th', 'ড': 'r', 'দ': 'd', 'ঢ': 'rh', 'ধ': 'dh',
    'ণ': 'n', 'ন': 'n', 'প': 'p', 'ফ': 'ph', 'ব': 'b', 'ভ': 'bh', 'ম': 'm',
    'র': 'r', 'ল': 'l', 'শ': 's', 'হ': 'h', '০': '0', '১': '1', '২': '2',
    '৩': '3', '৪': '4', '৫': '5', '৬': '6', '৭': '7', '৮': '8', '৯': '9',
    # Thai (because of complications of the alphabet, self.transliterations
    # are very imprecise here)
    'ก': 'k', 'ข': 'kh', 'ฃ': 'kh', 'ค': 'kh', 'ฅ': 'kh', 'ฆ': 'kh', 'ง':
        'ng', 'จ': 'ch', 'ฉ': 'ch', 'ช': 'ch', 'ฌ': 'ch', 'ซ': 's',
    'ศ': 's', 'ษ': 's', 'ส': 's', 'ญ': 'y', 'ย': 'y', 'ฎ': 'd', 'ด': 'd',
    'ฏ': 't', 'ต': 't', 'ฐ': 'th', 'ฑ': 'th', 'ฒ': 'th', 'ถ': 'th',
    'ท': 'th', 'ธ': 'th', 'ณ': 'n', 'น': 'n', 'บ': 'b', 'ป': 'p', 'ผ': 'ph',
    'พ': 'ph', 'ภ': 'ph', 'ฝ': 'f', 'ฟ': 'f', 'ม': 'm', 'ร': 'ü',
    'ฤ': 'rue', 'ๅ': ':', 'ล': 'l', 'ฬ': 'l', 'ฦ': 'lue', 'ว': 'u',
    'ห': 'h', 'ฮ': 'h', 'อ': 'o', 'โ': 'o', 'ิ': 'i', 'ะ': 'a', 'ั': 'a',
    'า': 'a', 'ำ': 'am', 'ี': 'i:', 'ึ': 'ue', 'ื': 'ue:', 'ุ': 'u',
    'ู': 'u:', 'เ': 'e', '็': '', 'แ': 'ae', 'ใ': 'ai', 'ไ': 'ai', '่': '',
    '้': '', '๊': '', '๋': '', '์': '', 'ฯ': '.', 'ๆ': '(2)',
    # Korean (Revised Romanization system within possible, incomplete)
    '국': 'guk', '명': 'myeong', '검': 'geom', '타': 'ta', '분': 'bun', '사':
        'sa', '류': 'ryu', '포': 'po', '르': 'reu', '투': 'tu', '갈': 'gal',
    '어': 'eo', '노': 'no', '웨': 'we', '이': 'i', '라': 'ra', '틴': 'tin',
    '루': 'ru', '마': 'ma', '니': 'ni', '아': 'a', '독': 'dok', '일': 'il',
    '모': 'mo', '크': 'keu', '샤': 'sya', '영': 'yeong', '불': 'bul', '가': 'ga',
    '리': 'ri', '그': 'geu', '지': 'ji', '야': 'ya', '바': 'ba', '슈': 'syu',
    '키': 'ki', '프': 'peu', '랑': 'rang', '스': 'seu', '로': 'ro', '메': 'me',
    '역': 'yeok', '도': 'do',
    # Kannada
    'ಅ': 'a', 'ಆ': 'aa', 'ಾ': 'aa', 'ಇ': 'i', 'ಿ': 'i', 'ಈ': 'ii',
    'ೀ': 'ii', 'ಉ': 'u', 'ು': 'u', 'ಊ': 'uu', 'ೂ': "r'", 'ಋ': "r'",
    'ಎ': 'e', 'ೆ': 'e', 'ಏ': 'ee', 'ೇ': 'ee', 'ಐ': 'ai', 'ೈ': 'ai',
    'ಒ': 'o', 'ೊ': 'o', 'ಓ': 'oo', 'ೋ': 'oo', 'ಔ': 'au', 'ೌ': 'au',
    'ಂ': "m'", 'ಃ': "h'", 'ಕ': 'k', 'ಖ': 'kh', 'ಗ': 'g', 'ಘ': 'gh',
    'ಙ': 'ng', 'ಚ': 'c', 'ಛ': 'ch', 'ಜ': 'j', 'ಝ': 'ny', 'ಟ': 'tt',
    'ಠ': 'tth', 'ಡ': 'dd', 'ಢ': 'ddh', 'ಣ': 'nn', 'ತ': 't', 'ಥ': 'th',
    'ದ': 'd', 'ಧ': 'dh', 'ನ': 'n', 'ಪ': 'p', 'ಫ': 'ph', 'ಬ': 'b', 'ಭ': 'bh',
    'ಮ': 'm', 'ಯ': 'y', 'ರ': 'r', 'ಲ': 'l', 'ವ': 'v', 'ಶ': 'sh', 'ಷ': 'ss',
    'ಸ': 's', 'ಹ': 'h', 'ಳ': 'll', '೦': '0', '೧': '1', '೨': '2', '೩': '3',
    '೪': '4', '೫': '5', '೬': '6', '೭': '7', '೮': '8', '೯': '9',
    # Telugu
    'అ': 'a', 'ఆ': 'aa', 'ా': 'aa', 'ఇ': 'i', 'ి': 'i', 'ఈ': 'ii', 'ీ':
        'ii', 'ఉ': 'u', 'ు': 'u', 'ఊ': 'uu', 'ూ': 'uu', 'ఋ': "r'",
    'ృ': "r'", 'ౠ': 'r"', 'ౄ': 'r"', 'ఌ': "l'", 'ౡ': 'l"', 'ఎ': 'e',
    'ె': 'e', 'ఏ': 'ee', 'ే': 'ee', 'ఐ': 'ai', 'ై': 'ai', 'ఒ': 'o',
    'ొ': 'o', 'ఓ': 'oo', 'ో': 'oo', 'ఔ': 'au', 'ౌ': 'au', 'ం': '^',
    'ః': '-', 'క': 'k', 'ఖ': 'kh', 'గ': 'g', 'ఘ': 'gh', 'ఙ': 'ng',
    'చ': 'ts', 'ఛ': 'tsh', 'జ': 'j', 'ఝ': 'jh', 'ఞ': 'ñ', 'ట': 't',
    'త': 't', 'ఠ': 'th', 'థ': 'th', 'డ': 'd', 'ద': 'd', 'ఢ': 'dh',
    'ధ': 'dh', 'ణ': 'n', 'న': 'n', 'ప': 'p', 'ఫ': 'ph', 'బ': 'b', 'భ': 'bh',
    'మ': 'm', 'య': 'y', 'ర': 'r', 'ఱ': 'r', 'ల': 'l', 'ళ': 'l', 'వ': 'v',
    'శ': 'sh', 'ష': 's', 'స': 's', 'హ': 'h', '్': '', 'ఁ': '^', '౦': '0',
    '౧': '1', '౨': '2', '౩': '3', '౪': '4', '౫': '5', '౬': '6', '౭': '7',
    '౮': '8', '౯': '9', '౹': '1/4', '౺': '1/2', '౻': '3/4', '౼': '1/16',
    '౽': '1/8', '౾': '3/16',
    # Lao - note: pronunciation in initial position is used;
    # different pronunciation in final position is ignored
    'ກ': 'k', 'ຂ': 'kh', 'ຄ': 'kh', 'ງ': 'ng', 'ຈ': 'ch', 'ສ': 's', 'ຊ':
        's', 'ຍ': 'i', 'ດ': 'd', 'ຕ': 't', 'ຖ': 'th', 'ທ': 'th', 'ນ': 'n',
    'ບ': 'b', 'ປ': 'p', 'ຜ': 'ph', 'ພ': 'ph', 'ຝ': 'f', 'ຟ': 'f', 'ມ': 'm',
    'ໝ': 'm', 'ຢ': 'y', 'ຣ': 'r', 'ຼ': 'l', 'ລ': 'l', 'ວ': 'v', 'ຮ': 'h',
    'ອ': "'", 'ະ': 'a', 'ັ': 'a', 'ິ': 'i', 'ຶ': 'ue', 'ຸ': 'u', 'ເ': 'e',
    'ແ': 'ei', 'ໂ': 'o', 'ົ': 'o', 'າ': 'aa', 'ໍ': 'o', 'ຽ': 'ia',
    'ເຶ': 'uea', 'ໄ': 'ai', 'ໃ': 'ai', 'ຳ': 'am', 'ີ': 'ii', 'ື': 'yy',
    'ູ': 'uu', '໐': '0', '໑': '1', '໒': '2', '໓': '3', '໔': '4', '໕': '5',
    '໖': '6', '໗': '7', '໘': '8', '໙': '9',
    # Chinese -- note: incomplete
    '埃': 'ai', '挨': 'ai', '哎': 'ai', '唉': 'ai', '哀': 'ai', '皑': 'ai', '癌':
        'ai', '蔼': 'ai', '矮': 'ai', '艾': 'ai', '碍': 'ai', '爱': 'ai',
    '隘': 'ai', '鞍': 'an', '氨': 'an', '安': 'an', '俺': 'an', '按': 'an',
    '暗': 'an', '岸': 'an', '胺': 'an', '案': 'an', '肮': 'ang', '昂': 'ang',
    '盎': 'ang', '凹': 'ao', '敖': 'ao', '熬': 'ao', '翱': 'ao', '袄': 'ao',
    '傲': 'ao', '奥': 'ao', '懊': 'ao', '澳': 'ao', '芭': 'ba', '捌': 'ba',
    '扒': 'ba', '叭': 'ba', '吧': 'ba', '笆': 'ba', '八': 'ba', '疤': 'ba',
    '巴': 'ba', '拔': 'ba', '跋': 'ba', '靶': 'ba', '把': 'ba', '耙': 'ba',
    '坝': 'ba', '霸': 'ba', '罢': 'ba', '爸': 'ba', '白': 'bai', '柏': 'bai',
    '百': 'bai', '摆': 'bai', '佰': 'bai', '败': 'bai', '拜': 'bai', '稗': 'bai',
    '斑': 'ban', '班': 'ban', '搬': 'ban', '扳': 'ban', '般': 'ban', '颁': 'ban',
    '板': 'ban', '版': 'ban', '扮': 'ban', '拌': 'ban', '伴': 'ban', '瓣': 'ban',
    '半': 'ban', '办': 'ban', '绊': 'ban', '邦': 'bang', '帮': 'bang',
    '梆': 'bang', '榜': 'bang', '膀': 'bang', '绑': 'bang', '棒': 'bang',
    '磅': 'bang', '蚌': 'bang', '镑': 'bang', '傍': 'bang', '谤': 'bang',
    '苞': 'bao', '胞': 'bao', '包': 'bao', '褒': 'bao', '剥': 'bao', '薄': 'bao',
    '雹': 'bao', '保': 'bao', '堡': 'bao', '饱': 'bao', '宝': 'bao', '抱': 'bao',
    '报': 'bao', '暴': 'bao', '豹': 'bao', '鲍': 'bao', '爆': 'bao', '杯': 'bei',
    '碑': 'bei', '悲': 'bei', '卑': 'bei', '北': 'bei', '辈': 'bei', '背': 'bei',
    '贝': 'bei', '钡': 'bei', '倍': 'bei', '狈': 'bei', '备': 'bei', '惫': 'bei',
    '焙': 'bei', '被': 'bei', '奔': 'ben', '苯': 'ben', '本': 'ben', '笨': 'ben',
    '崩': 'beng', '绷': 'beng', '甭': 'beng', '泵': 'beng', '蹦': 'beng',
    '迸': 'beng', '逼': 'bi', '鼻': 'bi', '比': 'bi', '鄙': 'bi', '笔': 'bi',
    '彼': 'bi', '碧': 'bi', '蓖': 'bi', '蔽': 'bi', '毕': 'bi', '毙': 'bi',
    '毖': 'bi', '币': 'bi', '庇': 'bi', '痹': 'bi', '闭': 'bi', '敝': 'bi',
    '弊': 'bi', '必': 'bi', '辟': 'bi', '壁': 'bi', '臂': 'bi', '避': 'bi',
    '陛': 'bi', '鞭': 'bian', '边': 'bian', '编': 'bian', '贬': 'bian',
    '扁': 'bian', '便': 'bian', '变': 'bian', '卞': 'bian', '辨': 'bian',
    '辩': 'bian', '辫': 'bian', '遍': 'bian', '标': 'biao', '彪': 'biao',
    '膘': 'biao', '表': 'biao', '鳖': 'bie', '憋': 'bie', '别': 'bie',
    '瘪': 'bie', '彬': 'bin', '斌': 'bin', '濒': 'bin', '滨': 'bin', '宾': 'bin',
    '摈': 'bin', '兵': 'bing', '冰': 'bing', '柄': 'bing', '丙': 'bing',
    '秉': 'bing', '饼': 'bing', '炳': 'bing', '病': 'bing', '并': 'bing',
    '玻': 'bo', '菠': 'bo', '播': 'bo', '拨': 'bo', '钵': 'bo', '波': 'bo',
    '博': 'bo', '勃': 'bo', '搏': 'bo', '铂': 'bo', '箔': 'bo', '伯': 'bo',
    '帛': 'bo', '舶': 'bo', '脖': 'bo', '膊': 'bo', '渤': 'bo', '泊': 'bo',
    '驳': 'bo', '捕': 'bo', '卜': 'bo', '亳': 'bo', '哺': 'bu', '补': 'bu',
    '埠': 'bu', '不': 'bu', '布': 'bu', '步': 'bu', '簿': 'bu', '部': 'bu',
    '怖': 'bu', '猜': 'cai', '裁': 'cai', '材': 'cai', '才': 'cai', '财': 'cai',
    '睬': 'cai', '踩': 'cai', '采': 'cai', '彩': 'cai', '菜': 'cai', '蔡': 'cai',
    '餐': 'can', '参': 'can', '蚕': 'can', '残': 'can', '惭': 'can', '惨': 'can',
    '灿': 'can', '苍': 'cang', '舱': 'cang', '仓': 'cang', '沧': 'cang',
    '藏': 'cang', '操': 'cao', '糙': 'cao', '槽': 'cao', '曹': 'cao', '草': 'cao',
    '厕': 'ce', '策': 'ce', '侧': 'ce', '册': 'ce', '测': 'ce', '层': 'ceng',
    '蹭': 'ceng', '插': 'cha', '叉': 'cha', '茬': 'cha', '茶': 'cha', '查': 'cha',
    '碴': 'cha', '搽': 'cha', '察': 'cha', '岔': 'cha', '差': 'cha', '诧': 'cha',
    '拆': 'chai', '柴': 'chai', '豺': 'chai', '搀': 'chan', '掺': 'chan',
    '蝉': 'chan', '馋': 'chan', '谗': 'chan', '缠': 'chan', '铲': 'chan',
    '产': 'chan', '阐': 'chan', '颤': 'chan', '昌': 'chang', '猖': 'chang',
    '场': 'chang', '尝': 'chang', '常': 'chang', '长': 'chang', '偿': 'chang',
    '肠': 'chang', '厂': 'chang', '敞': 'chang', '畅': 'chang', '唱': 'chang',
    '倡': 'chang', '超': 'chao', '抄': 'chao', '钞': 'chao', '朝': 'chao',
    '嘲': 'chao', '潮': 'chao', '巢': 'chao', '吵': 'chao', '炒': 'chao',
    '车': 'che', '扯': 'che', '撤': 'che', '掣': 'che', '彻': 'che', '澈': 'che',
    '郴': 'chen', '臣': 'chen', '辰': 'chen', '尘': 'chen', '晨': 'chen',
    '忱': 'chen', '沉': 'chen', '陈': 'chen', '趁': 'chen', '衬': 'chen',
    '撑': 'cheng', '称': 'cheng', '城': 'cheng', '橙': 'cheng', '成': 'cheng',
    '呈': 'cheng', '乘': 'cheng', '程': 'cheng', '惩': 'cheng', '澄': 'cheng',
    '诚': 'cheng', '承': 'cheng', '逞': 'cheng', '骋': 'cheng', '秤': 'cheng',
    '吃': 'chi', '痴': 'chi', '持': 'chi', '匙': 'chi', '池': 'chi', '迟': 'chi',
    '弛': 'chi', '驰': 'chi', '耻': 'chi', '齿': 'chi', '侈': 'chi', '尺': 'chi',
    '赤': 'chi', '翅': 'chi', '斥': 'chi', '炽': 'chi', '充': 'chong',
    '冲': 'chong', '虫': 'chong', '崇': 'chong', '宠': 'chong', '抽': 'chou',
    '酬': 'chou', '畴': 'chou', '踌': 'chou', '稠': 'chou', '愁': 'chou',
    '筹': 'chou', '仇': 'chou', '绸': 'chou', '瞅': 'chou', '丑': 'chou',
    '臭': 'chou', '初': 'chu', '出': 'chu', '橱': 'chu', '厨': 'chu', '躇': 'chu',
    '锄': 'chu', '雏': 'chu', '滁': 'chu', '除': 'chu', '楚': 'chu', '储': 'chu',
    '矗': 'chu', '搐': 'chu', '触': 'chu', '处': 'chu', '揣': 'chuai',
    '川': 'chuan', '穿': 'chuan', '椽': 'chuan', '传': 'chuan', '船': 'chuan',
    '喘': 'chuan', '串': 'chuan', '疮': 'chuang', '窗': 'chuang', '幢': 'chuang',
    '床': 'chuang', '闯': 'chuang', '创': 'chuang', '吹': 'chui', '炊': 'chui',
    '捶': 'chui', '锤': 'chui', '垂': 'chui', '春': 'chun', '椿': 'chun',
    '醇': 'chun', '唇': 'chun', '淳': 'chun', '纯': 'chun', '蠢': 'chun',
    '戳': 'chuo', '绰': 'chuo', '疵': 'ci', '茨': 'ci', '磁': 'ci', '雌': 'ci',
    '辞': 'ci', '慈': 'ci', '瓷': 'ci', '词': 'ci', '此': 'ci', '刺': 'ci',
    '赐': 'ci', '次': 'ci', '聪': 'cong', '葱': 'cong', '囱': 'cong',
    '匆': 'cong', '从': 'cong', '丛': 'cong', '凑': 'cou', '粗': 'cu', '醋': 'cu',
    '簇': 'cu', '促': 'cu', '蹿': 'cuan', '篡': 'cuan', '窜': 'cuan', '摧': 'cui',
    '崔': 'cui', '催': 'cui', '脆': 'cui', '瘁': 'cui', '粹': 'cui', '淬': 'cui',
    '翠': 'cui', '村': 'cun', '存': 'cun', '寸': 'cun', '磋': 'cuo', '撮': 'cuo',
    '搓': 'cuo', '措': 'cuo', '挫': 'cuo', '错': 'cuo', '搭': 'da', '达': 'da',
    '答': 'da', '瘩': 'da', '打': 'da', '大': 'da', '呆': 'dai', '歹': 'dai',
    '傣': 'dai', '戴': 'dai', '带': 'dai', '殆': 'dai', '代': 'dai', '贷': 'dai',
    '袋': 'dai', '待': 'dai', '逮': 'dai', '怠': 'dai', '耽': 'dan', '担': 'dan',
    '丹': 'dan', '单': 'dan', '郸': 'dan', '掸': 'dan', '胆': 'dan', '旦': 'dan',
    '氮': 'dan', '但': 'dan', '惮': 'dan', '淡': 'dan', '诞': 'dan', '弹': 'dan',
    '蛋': 'dan', '儋': 'dan', '当': 'dang', '挡': 'dang', '党': 'dang',
    '荡': 'dang', '档': 'dang', '刀': 'dao', '捣': 'dao', '蹈': 'dao',
    '倒': 'dao', '岛': 'dao', '祷': 'dao', '导': 'dao', '到': 'dao', '稻': 'dao',
    '悼': 'dao', '道': 'dao', '盗': 'dao', '德': 'de', '得': 'de', '的': 'de',
    '蹬': 'deng', '灯': 'deng', '登': 'deng', '等': 'deng', '瞪': 'deng',
    '凳': 'deng', '邓': 'deng', '堤': 'di', '低': 'di', '滴': 'di', '迪': 'di',
    '敌': 'di', '笛': 'di', '狄': 'di', '涤': 'di', '翟': 'di', '嫡': 'di',
    '抵': 'di', '底': 'di', '地': 'di', '蒂': 'di', '第': 'di', '帝': 'di',
    '弟': 'di', '递': 'di', '缔': 'di', '颠': 'dian', '掂': 'dian', '滇': 'dian',
    '碘': 'dian', '点': 'dian', '典': 'dian', '靛': 'dian', '垫': 'dian',
    '电': 'dian', '佃': 'dian', '甸': 'dian', '店': 'dian', '惦': 'dian',
    '奠': 'dian', '淀': 'dian', '殿': 'dian', '碉': 'diao', '叼': 'diao',
    '雕': 'diao', '凋': 'diao', '刁': 'diao', '掉': 'diao', '吊': 'diao',
    '钓': 'diao', '调': 'diao', '跌': 'die', '爹': 'die', '碟': 'die',
    '蝶': 'die', '迭': 'die', '谍': 'die', '叠': 'die', '丁': 'ding',
    '盯': 'ding', '叮': 'ding', '钉': 'ding', '顶': 'ding', '鼎': 'ding',
    '锭': 'ding', '定': 'ding', '订': 'ding', '丢': 'diu', '东': 'dong',
    '冬': 'dong', '董': 'dong', '懂': 'dong', '动': 'dong', '栋': 'dong',
    '侗': 'dong', '恫': 'dong', '冻': 'dong', '洞': 'dong', '兜': 'dou',
    '抖': 'dou', '斗': 'dou', '陡': 'dou', '豆': 'dou', '逗': 'dou', '痘': 'dou',
    '都': 'du', '督': 'du', '毒': 'du', '犊': 'du', '独': 'du', '读': 'du',
    '堵': 'du', '睹': 'du', '赌': 'du', '杜': 'du', '镀': 'du', '肚': 'du',
    '度': 'du', '渡': 'du', '妒': 'du', '端': 'duan', '短': 'duan', '锻': 'duan',
    '段': 'duan', '断': 'duan', '缎': 'duan', '堆': 'dui', '兑': 'dui',
    '队': 'dui', '对': 'dui', '墩': 'dun', '吨': 'dun', '蹲': 'dun', '敦': 'dun',
    '顿': 'dun', '囤': 'dun', '钝': 'dun', '盾': 'dun', '遁': 'dun', '掇': 'duo',
    '哆': 'duo', '多': 'duo', '夺': 'duo', '垛': 'duo', '躲': 'duo', '朵': 'duo',
    '跺': 'duo', '舵': 'duo', '剁': 'duo', '惰': 'duo', '堕': 'duo', '蛾': 'e',
    '峨': 'e', '鹅': 'e', '俄': 'e', '额': 'e', '讹': 'e', '娥': 'e', '恶': 'e',
    '厄': 'e', '扼': 'e', '遏': 'e', '鄂': 'e', '饿': 'e', '恩': 'en', '嗯': 'en',
    '而': 'er', '儿': 'er', '耳': 'er', '尔': 'er', '饵': 'er', '洱': 'er',
    '二': 'er', '贰': 'er', '发': 'fa', '罚': 'fa', '筏': 'fa', '伐': 'fa',
    '乏': 'fa', '阀': 'fa', '法': 'fa', '珐': 'fa', '藩': 'fan', '帆': 'fan',
    '番': 'fan', '翻': 'fan', '樊': 'fan', '矾': 'fan', '钒': 'fan', '繁': 'fan',
    '凡': 'fan', '烦': 'fan', '反': 'fan', '返': 'fan', '范': 'fan', '贩': 'fan',
    '犯': 'fan', '饭': 'fan', '泛': 'fan', '坊': 'fang', '芳': 'fang',
    '方': 'fang', '肪': 'fang', '房': 'fang', '防': 'fang', '妨': 'fang',
    '仿': 'fang', '访': 'fang', '纺': 'fang', '放': 'fang', '菲': 'fei',
    '非': 'fei', '啡': 'fei', '飞': 'fei', '肥': 'fei', '匪': 'fei', '诽': 'fei',
    '吠': 'fei', '肺': 'fei', '废': 'fei', '沸': 'fei', '费': 'fei', '芬': 'fen',
    '酚': 'fen', '吩': 'fen', '氛': 'fen', '分': 'fen', '纷': 'fen', '坟': 'fen',
    '焚': 'fen', '汾': 'fen', '粉': 'fen', '奋': 'fen', '份': 'fen', '忿': 'fen',
    '愤': 'fen', '粪': 'fen', '丰': 'feng', '封': 'feng', '枫': 'feng',
    '蜂': 'feng', '峰': 'feng', '锋': 'feng', '风': 'feng', '疯': 'feng',
    '烽': 'feng', '逢': 'feng', '冯': 'feng', '缝': 'feng', '讽': 'feng',
    '奉': 'feng', '凤': 'feng', '佛': 'fo', '否': 'fou', '夫': 'fu', '敷': 'fu',
    '肤': 'fu', '孵': 'fu', '扶': 'fu', '拂': 'fu', '辐': 'fu', '幅': 'fu',
    '氟': 'fu', '符': 'fu', '伏': 'fu', '俘': 'fu', '服': 'fu', '浮': 'fu',
    '涪': 'fu', '福': 'fu', '袱': 'fu', '弗': 'fu', '甫': 'fu', '抚': 'fu',
    '辅': 'fu', '俯': 'fu', '釜': 'fu', '斧': 'fu', '脯': 'fu', '腑': 'fu',
    '府': 'fu', '腐': 'fu', '赴': 'fu', '副': 'fu', '覆': 'fu', '赋': 'fu',
    '复': 'fu', '傅': 'fu', '付': 'fu', '阜': 'fu', '父': 'fu', '腹': 'fu',
    '负': 'fu', '富': 'fu', '讣': 'fu', '附': 'fu', '妇': 'fu', '缚': 'fu',
    '咐': 'fu', '噶': 'ga', '嘎': 'ga', '该': 'gai', '改': 'gai', '概': 'gai',
    '钙': 'gai', '盖': 'gai', '溉': 'gai', '干': 'gan', '甘': 'gan', '杆': 'gan',
    '柑': 'gan', '竿': 'gan', '肝': 'gan', '赶': 'gan', '感': 'gan', '秆': 'gan',
    '敢': 'gan', '赣': 'gan', '冈': 'gang', '刚': 'gang', '钢': 'gang',
    '缸': 'gang', '肛': 'gang', '纲': 'gang', '岗': 'gang', '港': 'gang',
    '杠': 'gang', '篙': 'gao', '皋': 'gao', '高': 'gao', '膏': 'gao', '羔': 'gao',
    '糕': 'gao', '搞': 'gao', '镐': 'gao', '稿': 'gao', '告': 'gao', '哥': 'ge',
    '歌': 'ge', '搁': 'ge', '戈': 'ge', '鸽': 'ge', '胳': 'ge', '疙': 'ge',
    '割': 'ge', '革': 'ge', '葛': 'ge', '格': 'ge', '蛤': 'ge', '阁': 'ge',
    '隔': 'ge', '铬': 'ge', '个': 'ge', '各': 'ge', '给': 'gei', '根': 'gen',
    '跟': 'gen', '耕': 'geng', '更': 'geng', '庚': 'geng', '羹': 'geng',
    '埂': 'geng', '耿': 'geng', '梗': 'geng', '工': 'gong', '攻': 'gong',
    '功': 'gong', '恭': 'gong', '龚': 'gong', '供': 'gong', '躬': 'gong',
    '公': 'gong', '宫': 'gong', '弓': 'gong', '巩': 'gong', '汞': 'gong',
    '拱': 'gong', '贡': 'gong', '共': 'gong', '钩': 'gou', '勾': 'gou',
    '沟': 'gou', '苟': 'gou', '狗': 'gou', '垢': 'gou', '构': 'gou', '购': 'gou',
    '够': 'gou', '辜': 'gu', '菇': 'gu', '咕': 'gu', '箍': 'gu', '估': 'gu',
    '沽': 'gu', '孤': 'gu', '姑': 'gu', '鼓': 'gu', '古': 'gu', '蛊': 'gu',
    '骨': 'gu', '谷': 'gu', '股': 'gu', '故': 'gu', '顾': 'gu', '固': 'gu',
    '雇': 'gu', '刮': 'gua', '瓜': 'gua', '剐': 'gua', '寡': 'gua', '挂': 'gua',
    '褂': 'gua', '乖': 'guai', '拐': 'guai', '怪': 'guai', '棺': 'guan',
    '关': 'guan', '官': 'guan', '冠': 'guan', '观': 'guan', '管': 'guan',
    '馆': 'guan', '罐': 'guan', '惯': 'guan', '灌': 'guan', '贯': 'guan',
    '光': 'guang', '广': 'guang', '逛': 'guang', '瑰': 'gui', '规': 'gui',
    '圭': 'gui', '硅': 'gui', '归': 'gui', '龟': 'gui', '闺': 'gui', '轨': 'gui',
    '鬼': 'gui', '诡': 'gui', '癸': 'gui', '桂': 'gui', '柜': 'gui', '跪': 'gui',
    '贵': 'gui', '刽': 'gui', '辊': 'gun', '滚': 'gun', '棍': 'gun', '锅': 'guo',
    '郭': 'guo', '国': 'guo', '果': 'guo', '裹': 'guo', '过': 'guo', '哈': 'ha',
    '骸': 'hai', '孩': 'hai', '海': 'hai', '氦': 'hai', '亥': 'hai', '害': 'hai',
    '骇': 'hai', '酣': 'han', '憨': 'han', '邯': 'han', '韩': 'han', '含': 'han',
    '涵': 'han', '寒': 'han', '函': 'han', '喊': 'han', '罕': 'han', '翰': 'han',
    '撼': 'han', '捍': 'han', '旱': 'han', '憾': 'han', '悍': 'han', '焊': 'han',
    '汗': 'han', '汉': 'han', '夯': 'hang', '杭': 'hang', '航': 'hang',
    '壕': 'hao', '嚎': 'hao', '豪': 'hao', '毫': 'hao', '郝': 'hao', '好': 'hao',
    '耗': 'hao', '号': 'hao', '浩': 'hao', '呵': 'he', '喝': 'he', '荷': 'he',
    '菏': 'he', '核': 'he', '禾': 'he', '和': 'he', '何': 'he', '合': 'he',
    '盒': 'he', '貉': 'he', '阂': 'he', '河': 'he', '涸': 'he', '赫': 'he',
    '褐': 'he', '鹤': 'he', '贺': 'he', '嘿': 'hei', '黑': 'hei', '痕': 'hen',
    '很': 'hen', '狠': 'hen', '恨': 'hen', '哼': 'heng', '亨': 'heng',
    '横': 'heng', '衡': 'heng', '恒': 'heng', '轰': 'hong', '哄': 'hong',
    '烘': 'hong', '虹': 'hong', '鸿': 'hong', '洪': 'hong', '宏': 'hong',
    '弘': 'hong', '红': 'hong', '喉': 'hou', '侯': 'hou', '猴': 'hou',
    '吼': 'hou', '厚': 'hou', '候': 'hou', '后': 'hou', '呼': 'hu', '乎': 'hu',
    '忽': 'hu', '瑚': 'hu', '壶': 'hu', '葫': 'hu', '胡': 'hu', '蝴': 'hu',
    '狐': 'hu', '糊': 'hu', '湖': 'hu', '弧': 'hu', '虎': 'hu', '唬': 'hu',
    '护': 'hu', '互': 'hu', '沪': 'hu', '户': 'hu', '花': 'hua', '哗': 'hua',
    '华': 'hua', '猾': 'hua', '滑': 'hua', '画': 'hua', '划': 'hua', '化': 'hua',
    '话': 'hua', '槐': 'huai', '徊': 'huai', '怀': 'huai', '淮': 'huai',
    '坏': 'huai', '欢': 'huan', '环': 'huan', '桓': 'huan', '还': 'huan',
    '缓': 'huan', '换': 'huan', '患': 'huan', '唤': 'huan', '痪': 'huan',
    '豢': 'huan', '焕': 'huan', '涣': 'huan', '宦': 'huan', '幻': 'huan',
    '荒': 'huang', '慌': 'huang', '黄': 'huang', '磺': 'huang', '蝗': 'huang',
    '簧': 'huang', '皇': 'huang', '凰': 'huang', '惶': 'huang', '煌': 'huang',
    '晃': 'huang', '幌': 'huang', '恍': 'huang', '谎': 'huang', '灰': 'hui',
    '挥': 'hui', '辉': 'hui', '徽': 'hui', '恢': 'hui', '蛔': 'hui', '回': 'hui',
    '毁': 'hui', '悔': 'hui', '慧': 'hui', '卉': 'hui', '惠': 'hui', '晦': 'hui',
    '贿': 'hui', '秽': 'hui', '会': 'hui', '烩': 'hui', '汇': 'hui', '讳': 'hui',
    '诲': 'hui', '绘': 'hui', '荤': 'hun', '昏': 'hun', '婚': 'hun', '魂': 'hun',
    '浑': 'hun', '混': 'hun', '豁': 'huo', '活': 'huo', '伙': 'huo', '火': 'huo',
    '获': 'huo', '或': 'huo', '惑': 'huo', '霍': 'huo', '货': 'huo', '祸': 'huo',
    '击': 'ji', '圾': 'ji', '基': 'ji', '机': 'ji', '畸': 'ji', '稽': 'ji',
    '积': 'ji', '箕': 'ji', '肌': 'ji', '饥': 'ji', '迹': 'ji', '激': 'ji',
    '讥': 'ji', '鸡': 'ji', '姬': 'ji', '绩': 'ji', '缉': 'ji', '吉': 'ji',
    '极': 'ji', '棘': 'ji', '辑': 'ji', '籍': 'ji', '集': 'ji', '及': 'ji',
    '急': 'ji', '疾': 'ji', '汲': 'ji', '即': 'ji', '嫉': 'ji', '级': 'ji',
    '挤': 'ji', '几': 'ji', '脊': 'ji', '己': 'ji', '蓟': 'ji', '技': 'ji',
    '冀': 'ji', '季': 'ji', '伎': 'ji', '祭': 'ji', '剂': 'ji', '悸': 'ji',
    '济': 'ji', '寄': 'ji', '寂': 'ji', '计': 'ji', '记': 'ji', '既': 'ji',
    '忌': 'ji', '际': 'ji', '妓': 'ji', '继': 'ji', '纪': 'ji', '嘉': 'jia',
    '枷': 'jia', '夹': 'jia', '佳': 'jia', '家': 'jia', '加': 'jia', '荚': 'jia',
    '颊': 'jia', '贾': 'jia', '甲': 'jia', '钾': 'jia', '假': 'jia', '稼': 'jia',
    '价': 'jia', '架': 'jia', '驾': 'jia', '嫁': 'jia', '歼': 'jian',
    '监': 'jian', '坚': 'jian', '尖': 'jian', '笺': 'jian', '间': 'jian',
    '煎': 'jian', '兼': 'jian', '肩': 'jian', '艰': 'jian', '奸': 'jian',
    '缄': 'jian', '茧': 'jian', '检': 'jian', '柬': 'jian', '碱': 'jian',
    '硷': 'jian', '拣': 'jian', '捡': 'jian', '简': 'jian', '俭': 'jian',
    '剪': 'jian', '减': 'jian', '荐': 'jian', '槛': 'jian', '鉴': 'jian',
    '践': 'jian', '贱': 'jian', '见': 'jian', '键': 'jian', '箭': 'jian',
    '件': 'jian', '健': 'jian', '舰': 'jian', '剑': 'jian', '饯': 'jian',
    '渐': 'jian', '溅': 'jian', '涧': 'jian', '建': 'jian', '僵': 'jiang',
    '姜': 'jiang', '将': 'jiang', '浆': 'jiang', '江': 'jiang', '疆': 'jiang',
    '蒋': 'jiang', '桨': 'jiang', '奖': 'jiang', '讲': 'jiang', '匠': 'jiang',
    '酱': 'jiang', '降': 'jiang', '蕉': 'jiao', '椒': 'jiao', '礁': 'jiao',
    '焦': 'jiao', '胶': 'jiao', '交': 'jiao', '郊': 'jiao', '浇': 'jiao',
    '骄': 'jiao', '娇': 'jiao', '嚼': 'jiao', '搅': 'jiao', '铰': 'jiao',
    '矫': 'jiao', '侥': 'jiao', '脚': 'jiao', '狡': 'jiao', '角': 'jiao',
    '饺': 'jiao', '缴': 'jiao', '绞': 'jiao', '剿': 'jiao', '教': 'jiao',
    '酵': 'jiao', '轿': 'jiao', '较': 'jiao', '叫': 'jiao', '窖': 'jiao',
    '揭': 'jie', '接': 'jie', '皆': 'jie', '秸': 'jie', '街': 'jie', '阶': 'jie',
    '截': 'jie', '劫': 'jie', '节': 'jie', '桔': 'jie', '杰': 'jie', '捷': 'jie',
    '睫': 'jie', '竭': 'jie', '洁': 'jie', '结': 'jie', '解': 'jie', '姐': 'jie',
    '戒': 'jie', '藉': 'jie', '芥': 'jie', '界': 'jie', '借': 'jie', '介': 'jie',
    '疥': 'jie', '诫': 'jie', '届': 'jie', '巾': 'jin', '筋': 'jin', '斤': 'jin',
    '金': 'jin', '今': 'jin', '津': 'jin', '襟': 'jin', '紧': 'jin', '锦': 'jin',
    '仅': 'jin', '谨': 'jin', '进': 'jin', '靳': 'jin', '晋': 'jin', '禁': 'jin',
    '近': 'jin', '烬': 'jin', '浸': 'jin', '尽': 'jin', '劲': 'jin', '荆': 'jing',
    '兢': 'jing', '茎': 'jing', '睛': 'jing', '晶': 'jing', '鲸': 'jing',
    '京': 'jing', '惊': 'jing', '精': 'jing', '粳': 'jing', '经': 'jing',
    '井': 'jing', '警': 'jing', '景': 'jing', '颈': 'jing', '静': 'jing',
    '境': 'jing', '敬': 'jing', '镜': 'jing', '径': 'jing', '痉': 'jing',
    '靖': 'jing', '竟': 'jing', '竞': 'jing', '净': 'jing', '囧': 'jiong',
    '炯': 'jiong', '窘': 'jiong', '揪': 'jiu', '究': 'jiu', '纠': 'jiu',
    '玖': 'jiu', '韭': 'jiu', '久': 'jiu', '灸': 'jiu', '九': 'jiu', '酒': 'jiu',
    '厩': 'jiu', '救': 'jiu', '旧': 'jiu', '臼': 'jiu', '舅': 'jiu', '咎': 'jiu',
    '就': 'jiu', '疚': 'jiu', '鞠': 'ju', '拘': 'ju', '狙': 'ju', '疽': 'ju',
    '居': 'ju', '驹': 'ju', '菊': 'ju', '局': 'ju', '咀': 'ju', '矩': 'ju',
    '举': 'ju', '沮': 'ju', '聚': 'ju', '拒': 'ju', '据': 'ju', '巨': 'ju',
    '具': 'ju', '距': 'ju', '踞': 'ju', '锯': 'ju', '俱': 'ju', '句': 'ju',
    '惧': 'ju', '炬': 'ju', '剧': 'ju', '捐': 'juan', '鹃': 'juan', '娟': 'juan',
    '倦': 'juan', '眷': 'juan', '卷': 'juan', '绢': 'juan', '撅': 'jue',
    '攫': 'jue', '抉': 'jue', '掘': 'jue', '倔': 'jue', '爵': 'jue', '觉': 'jue',
    '决': 'jue', '诀': 'jue', '绝': 'jue', '均': 'jun', '菌': 'jun', '钧': 'jun',
    '军': 'jun', '君': 'jun', '峻': 'jun', '俊': 'jun', '竣': 'jun', '浚': 'jun',
    '郡': 'jun', '骏': 'jun', '喀': 'ka', '咖': 'ka', '卡': 'ka', '咯': 'ka',
    '开': 'kai', '揩': 'kai', '楷': 'kai', '凯': 'kai', '慨': 'kai', '刊': 'kan',
    '堪': 'kan', '勘': 'kan', '坎': 'kan', '砍': 'kan', '看': 'kan', '康': 'kang',
    '慷': 'kang', '糠': 'kang', '扛': 'kang', '抗': 'kang', '亢': 'kang',
    '炕': 'kang', '考': 'kao', '拷': 'kao', '烤': 'kao', '靠': 'kao', '坷': 'ke',
    '苛': 'ke', '柯': 'ke', '棵': 'ke', '磕': 'ke', '颗': 'ke', '科': 'ke',
    '壳': 'ke', '咳': 'ke', '可': 'ke', '渴': 'ke', '克': 'ke', '刻': 'ke',
    '客': 'ke', '课': 'ke', '肯': 'ken', '啃': 'ken', '垦': 'ken', '恳': 'ken',
    '坑': 'keng', '吭': 'keng', '空': 'kong', '恐': 'kong', '孔': 'kong',
    '控': 'kong', '抠': 'kou', '口': 'kou', '扣': 'kou', '寇': 'kou', '枯': 'ku',
    '哭': 'ku', '窟': 'ku', '苦': 'ku', '酷': 'ku', '库': 'ku', '裤': 'ku',
    '夸': 'kua', '垮': 'kua', '挎': 'kua', '跨': 'kua', '胯': 'kua', '块': 'kuai',
    '筷': 'kuai', '侩': 'kuai', '快': 'kuai', '宽': 'kuan', '款': 'kuan',
    '匡': 'kuang', '筐': 'kuang', '狂': 'kuang', '框': 'kuang', '矿': 'kuang',
    '眶': 'kuang', '旷': 'kuang', '况': 'kuang', '亏': 'kui', '盔': 'kui',
    '岿': 'kui', '窥': 'kui', '葵': 'kui', '奎': 'kui', '魁': 'kui', '傀': 'kui',
    '馈': 'kui', '愧': 'kui', '溃': 'kui', '坤': 'kun', '昆': 'kun', '捆': 'kun',
    '困': 'kun', '括': 'kuo', '扩': 'kuo', '廓': 'kuo', '阔': 'kuo', '垃': 'la',
    '拉': 'la', '喇': 'la', '蜡': 'la', '腊': 'la', '辣': 'la', '啦': 'la',
    '莱': 'lai', '来': 'lai', '赖': 'lai', '蓝': 'lan', '婪': 'lan', '栏': 'lan',
    '拦': 'lan', '篮': 'lan', '阑': 'lan', '兰': 'lan', '澜': 'lan', '谰': 'lan',
    '揽': 'lan', '览': 'lan', '懒': 'lan', '缆': 'lan', '烂': 'lan', '滥': 'lan',
    '琅': 'lang', '榔': 'lang', '狼': 'lang', '廊': 'lang', '郎': 'lang',
    '朗': 'lang', '浪': 'lang', '捞': 'lao', '劳': 'lao', '牢': 'lao',
    '老': 'lao', '佬': 'lao', '姥': 'lao', '酪': 'lao', '烙': 'lao', '涝': 'lao',
    '勒': 'le', '乐': 'le', '雷': 'lei', '镭': 'lei', '蕾': 'lei', '磊': 'lei',
    '累': 'lei', '儡': 'lei', '垒': 'lei', '擂': 'lei', '肋': 'lei', '类': 'lei',
    '泪': 'lei', '棱': 'leng', '楞': 'leng', '冷': 'leng', '厘': 'li', '梨': 'li',
    '犁': 'li', '黎': 'li', '篱': 'li', '狸': 'li', '离': 'li', '漓': 'li',
    '理': 'li', '李': 'li', '里': 'li', '鲤': 'li', '礼': 'li', '莉': 'li',
    '荔': 'li', '吏': 'li', '栗': 'li', '丽': 'li', '厉': 'li', '励': 'li',
    '砾': 'li', '历': 'li', '利': 'li', '傈': 'li', '例': 'li', '俐': 'li',
    '痢': 'li', '立': 'li', '粒': 'li', '沥': 'li', '隶': 'li', '力': 'li',
    '璃': 'li', '哩': 'li', '俩': 'lia', '联': 'lian', '莲': 'lian', '连': 'lian',
    '镰': 'lian', '廉': 'lian', '怜': 'lian', '涟': 'lian', '帘': 'lian',
    '敛': 'lian', '脸': 'lian', '链': 'lian', '恋': 'lian', '炼': 'lian',
    '练': 'lian', '粮': 'liang', '凉': 'liang', '梁': 'liang', '粱': 'liang',
    '良': 'liang', '两': 'liang', '辆': 'liang', '量': 'liang', '晾': 'liang',
    '亮': 'liang', '谅': 'liang', '撩': 'liao', '聊': 'liao', '僚': 'liao',
    '疗': 'liao', '燎': 'liao', '寥': 'liao', '辽': 'liao', '潦': 'liao',
    '了': 'liao', '撂': 'liao', '镣': 'liao', '廖': 'liao', '料': 'liao',
    '列': 'lie', '裂': 'lie', '烈': 'lie', '劣': 'lie', '猎': 'lie', '琳': 'lin',
    '林': 'lin', '磷': 'lin', '霖': 'lin', '临': 'lin', '邻': 'lin', '鳞': 'lin',
    '淋': 'lin', '凛': 'lin', '赁': 'lin', '吝': 'lin', '拎': 'lin', '玲': 'ling',
    '菱': 'ling', '零': 'ling', '龄': 'ling', '铃': 'ling', '伶': 'ling',
    '羚': 'ling', '凌': 'ling', '灵': 'ling', '陵': 'ling', '岭': 'ling',
    '领': 'ling', '另': 'ling', '令': 'ling', '溜': 'liu', '琉': 'liu',
    '榴': 'liu', '硫': 'liu', '馏': 'liu', '留': 'liu', '刘': 'liu', '瘤': 'liu',
    '流': 'liu', '柳': 'liu', '六': 'liu', '龙': 'long', '聋': 'long',
    '咙': 'long', '笼': 'long', '窿': 'long', '隆': 'long', '垄': 'long',
    '拢': 'long', '陇': 'long', '楼': 'lou', '娄': 'lou', '搂': 'lou',
    '篓': 'lou', '漏': 'lou', '陋': 'lou', '芦': 'lu', '卢': 'lu', '颅': 'lu',
    '庐': 'lu', '炉': 'lu', '掳': 'lu', '卤': 'lu', '虏': 'lu', '鲁': 'lu',
    '麓': 'lu', '碌': 'lu', '露': 'lu', '路': 'lu', '赂': 'lu', '鹿': 'lu',
    '潞': 'lu', '禄': 'lu', '录': 'lu', '陆': 'lu', '戮': 'lu', '泸': 'lu',
    '峦': 'luan', '挛': 'luan', '孪': 'luan', '滦': 'luan', '卵': 'luan',
    '乱': 'luan', '掠': 'lue', '略': 'lue', '抡': 'lun', '轮': 'lun', '伦': 'lun',
    '仑': 'lun', '沦': 'lun', '纶': 'lun', '论': 'lun', '萝': 'luo', '螺': 'luo',
    '罗': 'luo', '逻': 'luo', '锣': 'luo', '箩': 'luo', '骡': 'luo', '裸': 'luo',
    '落': 'luo', '洛': 'luo', '骆': 'luo', '络': 'luo', '漯': 'luo', '驴': 'lv',
    '吕': 'lv', '铝': 'lv', '侣': 'lv', '旅': 'lv', '履': 'lv', '屡': 'lv',
    '缕': 'lv', '虑': 'lv', '氯': 'lv', '律': 'lv', '率': 'lv', '滤': 'lv',
    '绿': 'lv', '妈': 'ma', '麻': 'ma', '玛': 'ma', '码': 'ma', '蚂': 'ma',
    '马': 'ma', '骂': 'ma', '嘛': 'ma', '吗': 'ma', '埋': 'mai', '买': 'mai',
    '麦': 'mai', '卖': 'mai', '迈': 'mai', '脉': 'mai', '瞒': 'man', '馒': 'man',
    '蛮': 'man', '满': 'man', '蔓': 'man', '曼': 'man', '慢': 'man', '漫': 'man',
    '谩': 'man', '芒': 'mang', '茫': 'mang', '盲': 'mang', '氓': 'mang',
    '忙': 'mang', '莽': 'mang', '猫': 'mao', '茅': 'mao', '锚': 'mao',
    '毛': 'mao', '矛': 'mao', '铆': 'mao', '卯': 'mao', '茂': 'mao', '冒': 'mao',
    '帽': 'mao', '貌': 'mao', '贸': 'mao', '么': 'me', '玫': 'mei', '枚': 'mei',
    '梅': 'mei', '酶': 'mei', '霉': 'mei', '煤': 'mei', '没': 'mei', '眉': 'mei',
    '媒': 'mei', '镁': 'mei', '每': 'mei', '美': 'mei', '昧': 'mei', '寐': 'mei',
    '妹': 'mei', '媚': 'mei', '门': 'men', '闷': 'men', '们': 'men', '萌': 'meng',
    '蒙': 'meng', '檬': 'meng', '盟': 'meng', '锰': 'meng', '猛': 'meng',
    '梦': 'meng', '孟': 'meng', '眯': 'mi', '醚': 'mi', '靡': 'mi', '糜': 'mi',
    '迷': 'mi', '谜': 'mi', '弥': 'mi', '米': 'mi', '秘': 'mi', '觅': 'mi',
    '泌': 'mi', '蜜': 'mi', '密': 'mi', '幂': 'mi', '棉': 'mian', '眠': 'mian',
    '绵': 'mian', '冕': 'mian', '免': 'mian', '勉': 'mian', '娩': 'mian',
    '缅': 'mian', '面': 'mian', '苗': 'miao', '描': 'miao', '瞄': 'miao',
    '藐': 'miao', '秒': 'miao', '渺': 'miao', '庙': 'miao', '妙': 'miao',
    '蔑': 'mie', '灭': 'mie', '民': 'min', '抿': 'min', '皿': 'min', '敏': 'min',
    '悯': 'min', '闽': 'min', '明': 'ming', '螟': 'ming', '鸣': 'ming',
    '铭': 'ming', '名': 'ming', '命': 'ming', '谬': 'miu', '摸': 'mo', '摹': 'mo',
    '蘑': 'mo', '模': 'mo', '膜': 'mo', '磨': 'mo', '摩': 'mo', '魔': 'mo',
    '抹': 'mo', '末': 'mo', '莫': 'mo', '墨': 'mo', '默': 'mo', '沫': 'mo',
    '漠': 'mo', '寞': 'mo', '陌': 'mo', '谋': 'mou', '牟': 'mou', '某': 'mou',
    '拇': 'mu', '牡': 'mu', '亩': 'mu', '姆': 'mu', '母': 'mu', '墓': 'mu',
    '暮': 'mu', '幕': 'mu', '募': 'mu', '慕': 'mu', '木': 'mu', '目': 'mu',
    '睦': 'mu', '牧': 'mu', '穆': 'mu', '拿': 'na', '哪': 'na', '呐': 'na',
    '钠': 'na', '那': 'na', '娜': 'na', '纳': 'na', '氖': 'nai', '乃': 'nai',
    '奶': 'nai', '耐': 'nai', '奈': 'nai', '南': 'nan', '男': 'nan', '难': 'nan',
    '囊': 'nang', '挠': 'nao', '脑': 'nao', '恼': 'nao', '闹': 'nao', '淖': 'nao',
    '呢': 'ne', '馁': 'nei', '内': 'nei', '嫩': 'nen', '能': 'neng', '妮': 'ni',
    '霓': 'ni', '倪': 'ni', '泥': 'ni', '尼': 'ni', '拟': 'ni', '你': 'ni',
    '匿': 'ni', '腻': 'ni', '逆': 'ni', '溺': 'ni', '蔫': 'nian', '拈': 'nian',
    '年': 'nian', '碾': 'nian', '撵': 'nian', '捻': 'nian', '念': 'nian',
    '娘': 'niang', '酿': 'niang', '鸟': 'niao', '尿': 'niao', '捏': 'nie',
    '聂': 'nie', '孽': 'nie', '啮': 'nie', '镊': 'nie', '镍': 'nie', '涅': 'nie',
    '您': 'nin', '柠': 'ning', '狞': 'ning', '凝': 'ning', '宁': 'ning',
    '拧': 'ning', '泞': 'ning', '牛': 'niu', '扭': 'niu', '钮': 'niu',
    '纽': 'niu', '脓': 'nong', '浓': 'nong', '农': 'nong', '弄': 'nong',
    '奴': 'nu', '努': 'nu', '怒': 'nu', '暖': 'nuan', '虐': 'nue', '疟': 'nue',
    '挪': 'nuo', '懦': 'nuo', '糯': 'nuo', '诺': 'nuo', '女': 'nv', '哦': 'o',
    '欧': 'ou', '鸥': 'ou', '殴': 'ou', '藕': 'ou', '呕': 'ou', '偶': 'ou',
    '沤': 'ou', '啪': 'pa', '趴': 'pa', '爬': 'pa', '帕': 'pa', '怕': 'pa',
    '琶': 'pa', '拍': 'pai', '排': 'pai', '牌': 'pai', '徘': 'pai', '湃': 'pai',
    '派': 'pai', '攀': 'pan', '潘': 'pan', '盘': 'pan', '磐': 'pan', '盼': 'pan',
    '畔': 'pan', '判': 'pan', '叛': 'pan', '乓': 'pang', '庞': 'pang',
    '旁': 'pang', '耪': 'pang', '胖': 'pang', '抛': 'pao', '咆': 'pao',
    '刨': 'pao', '炮': 'pao', '袍': 'pao', '跑': 'pao', '泡': 'pao', '呸': 'pei',
    '胚': 'pei', '培': 'pei', '裴': 'pei', '赔': 'pei', '陪': 'pei', '配': 'pei',
    '佩': 'pei', '沛': 'pei', '喷': 'pen', '盆': 'pen', '砰': 'peng',
    '抨': 'peng', '烹': 'peng', '澎': 'peng', '彭': 'peng', '蓬': 'peng',
    '棚': 'peng', '硼': 'peng', '篷': 'peng', '膨': 'peng', '朋': 'peng',
    '鹏': 'peng', '捧': 'peng', '碰': 'peng', '坯': 'pi', '砒': 'pi', '霹': 'pi',
    '批': 'pi', '披': 'pi', '劈': 'pi', '琵': 'pi', '毗': 'pi', '啤': 'pi',
    '脾': 'pi', '疲': 'pi', '皮': 'pi', '匹': 'pi', '痞': 'pi', '僻': 'pi',
    '屁': 'pi', '譬': 'pi', '篇': 'pian', '偏': 'pian', '片': 'pian',
    '骗': 'pian', '飘': 'piao', '漂': 'piao', '瓢': 'piao', '票': 'piao',
    '撇': 'pie', '瞥': 'pie', '拼': 'pin', '频': 'pin', '贫': 'pin', '品': 'pin',
    '聘': 'pin', '乒': 'ping', '坪': 'ping', '苹': 'ping', '萍': 'ping',
    '平': 'ping', '凭': 'ping', '瓶': 'ping', '评': 'ping', '屏': 'ping',
    '坡': 'po', '泼': 'po', '颇': 'po', '婆': 'po', '破': 'po', '魄': 'po',
    '迫': 'po', '粕': 'po', '剖': 'po', '扑': 'pu', '铺': 'pu', '仆': 'pu',
    '莆': 'pu', '葡': 'pu', '菩': 'pu', '蒲': 'pu', '埔': 'pu', '朴': 'pu',
    '圃': 'pu', '普': 'pu', '浦': 'pu', '谱': 'pu', '曝': 'pu', '瀑': 'pu',
    '濮': 'pu', '期': 'qi', '欺': 'qi', '栖': 'qi', '戚': 'qi', '妻': 'qi',
    '七': 'qi', '凄': 'qi', '漆': 'qi', '柒': 'qi', '沏': 'qi', '其': 'qi',
    '棋': 'qi', '奇': 'qi', '歧': 'qi', '畦': 'qi', '崎': 'qi', '脐': 'qi',
    '齐': 'qi', '旗': 'qi', '祈': 'qi', '祁': 'qi', '骑': 'qi', '起': 'qi',
    '岂': 'qi', '乞': 'qi', '企': 'qi', '启': 'qi', '契': 'qi', '砌': 'qi',
    '器': 'qi', '气': 'qi', '迄': 'qi', '弃': 'qi', '汽': 'qi', '泣': 'qi',
    '讫': 'qi', '掐': 'qia', '恰': 'qia', '洽': 'qia', '牵': 'qian', '扦': 'qian',
    '钎': 'qian', '铅': 'qian', '千': 'qian', '迁': 'qian', '签': 'qian',
    '仟': 'qian', '谦': 'qian', '乾': 'qian', '黔': 'qian', '钱': 'qian',
    '钳': 'qian', '前': 'qian', '潜': 'qian', '遣': 'qian', '浅': 'qian',
    '谴': 'qian', '堑': 'qian', '嵌': 'qian', '欠': 'qian', '歉': 'qian',
    '枪': 'qiang', '呛': 'qiang', '腔': 'qiang', '羌': 'qiang', '墙': 'qiang',
    '蔷': 'qiang', '强': 'qiang', '抢': 'qiang', '橇': 'qiao', '锹': 'qiao',
    '敲': 'qiao', '悄': 'qiao', '桥': 'qiao', '瞧': 'qiao', '乔': 'qiao',
    '侨': 'qiao', '巧': 'qiao', '鞘': 'qiao', '撬': 'qiao', '翘': 'qiao',
    '峭': 'qiao', '俏': 'qiao', '窍': 'qiao', '切': 'qie', '茄': 'qie',
    '且': 'qie', '怯': 'qie', '窃': 'qie', '钦': 'qin', '侵': 'qin', '亲': 'qin',
    '秦': 'qin', '琴': 'qin', '勤': 'qin', '芹': 'qin', '擒': 'qin', '禽': 'qin',
    '寝': 'qin', '沁': 'qin', '青': 'qing', '轻': 'qing', '氢': 'qing',
    '倾': 'qing', '卿': 'qing', '清': 'qing', '擎': 'qing', '晴': 'qing',
    '氰': 'qing', '情': 'qing', '顷': 'qing', '请': 'qing', '庆': 'qing',
    '琼': 'qiong', '穷': 'qiong', '秋': 'qiu', '丘': 'qiu', '邱': 'qiu',
    '球': 'qiu', '求': 'qiu', '囚': 'qiu', '酋': 'qiu', '泅': 'qiu', '趋': 'qu',
    '区': 'qu', '蛆': 'qu', '曲': 'qu', '躯': 'qu', '屈': 'qu', '驱': 'qu',
    '渠': 'qu', '取': 'qu', '娶': 'qu', '龋': 'qu', '趣': 'qu', '去': 'qu',
    '圈': 'quan', '颧': 'quan', '权': 'quan', '醛': 'quan', '泉': 'quan',
    '全': 'quan', '痊': 'quan', '拳': 'quan', '犬': 'quan', '券': 'quan',
    '劝': 'quan', '缺': 'que', '炔': 'que', '瘸': 'que', '却': 'que', '鹊': 'que',
    '榷': 'que', '确': 'que', '雀': 'que', '裙': 'qun', '群': 'qun', '然': 'ran',
    '燃': 'ran', '冉': 'ran', '染': 'ran', '瓤': 'rang', '壤': 'rang',
    '攘': 'rang', '嚷': 'rang', '让': 'rang', '饶': 'rao', '扰': 'rao',
    '绕': 'rao', '惹': 're', '热': 're', '壬': 'ren', '仁': 'ren', '人': 'ren',
    '忍': 'ren', '韧': 'ren', '任': 'ren', '认': 'ren', '刃': 'ren', '妊': 'ren',
    '纫': 'ren', '扔': 'reng', '仍': 'reng', '日': 'ri', '戎': 'rong',
    '茸': 'rong', '蓉': 'rong', '荣': 'rong', '融': 'rong', '熔': 'rong',
    '溶': 'rong', '容': 'rong', '绒': 'rong', '冗': 'rong', '揉': 'rou',
    '柔': 'rou', '肉': 'rou', '茹': 'ru', '蠕': 'ru', '儒': 'ru', '孺': 'ru',
    '如': 'ru', '辱': 'ru', '乳': 'ru', '汝': 'ru', '入': 'ru', '褥': 'ru',
    '软': 'ruan', '阮': 'ruan', '蕊': 'rui', '瑞': 'rui', '锐': 'rui',
    '闰': 'run', '润': 'run', '若': 'ruo', '弱': 'ruo', '撒': 'sa', '洒': 'sa',
    '萨': 'sa', '腮': 'sai', '鳃': 'sai', '塞': 'sai', '赛': 'sai', '三': 'san',
    '叁': 'san', '伞': 'san', '散': 'san', '桑': 'sang', '嗓': 'sang',
    '丧': 'sang', '搔': 'sao', '骚': 'sao', '扫': 'sao', '嫂': 'sao', '瑟': 'se',
    '色': 'se', '涩': 'se', '森': 'sen', '僧': 'seng', '莎': 'sha', '砂': 'sha',
    '杀': 'sha', '刹': 'sha', '沙': 'sha', '纱': 'sha', '傻': 'sha', '啥': 'sha',
    '煞': 'sha', '筛': 'shai', '晒': 'shai', '珊': 'shan', '苫': 'shan',
    '杉': 'shan', '山': 'shan', '删': 'shan', '煽': 'shan', '衫': 'shan',
    '闪': 'shan', '陕': 'shan', '擅': 'shan', '赡': 'shan', '膳': 'shan',
    '善': 'shan', '汕': 'shan', '扇': 'shan', '缮': 'shan', '墒': 'shang',
    '伤': 'shang', '商': 'shang', '赏': 'shang', '晌': 'shang', '上': 'shang',
    '尚': 'shang', '裳': 'shang', '梢': 'shao', '捎': 'shao', '稍': 'shao',
    '烧': 'shao', '芍': 'shao', '勺': 'shao', '韶': 'shao', '少': 'shao',
    '哨': 'shao', '邵': 'shao', '绍': 'shao', '奢': 'she', '赊': 'she',
    '蛇': 'she', '舌': 'she', '舍': 'she', '赦': 'she', '摄': 'she', '射': 'she',
    '慑': 'she', '涉': 'she', '社': 'she', '设': 'she', '砷': 'shen',
    '申': 'shen', '呻': 'shen', '伸': 'shen', '身': 'shen', '深': 'shen',
    '娠': 'shen', '绅': 'shen', '神': 'shen', '沈': 'shen', '审': 'shen',
    '婶': 'shen', '甚': 'shen', '肾': 'shen', '慎': 'shen', '渗': 'shen',
    '声': 'sheng', '生': 'sheng', '甥': 'sheng', '牲': 'sheng', '升': 'sheng',
    '绳': 'sheng', '省': 'sheng', '盛': 'sheng', '剩': 'sheng', '胜': 'sheng',
    '圣': 'sheng', '师': 'shi', '失': 'shi', '狮': 'shi', '施': 'shi',
    '湿': 'shi', '诗': 'shi', '尸': 'shi', '虱': 'shi', '十': 'shi', '石': 'shi',
    '拾': 'shi', '时': 'shi', '什': 'shi', '食': 'shi', '蚀': 'shi', '实': 'shi',
    '识': 'shi', '史': 'shi', '矢': 'shi', '使': 'shi', '屎': 'shi', '驶': 'shi',
    '始': 'shi', '式': 'shi', '示': 'shi', '士': 'shi', '世': 'shi', '柿': 'shi',
    '事': 'shi', '拭': 'shi', '誓': 'shi', '逝': 'shi', '势': 'shi', '是': 'shi',
    '嗜': 'shi', '噬': 'shi', '适': 'shi', '仕': 'shi', '侍': 'shi', '释': 'shi',
    '饰': 'shi', '氏': 'shi', '市': 'shi', '恃': 'shi', '室': 'shi', '视': 'shi',
    '试': 'shi', '收': 'shou', '手': 'shou', '首': 'shou', '守': 'shou',
    '寿': 'shou', '授': 'shou', '售': 'shou', '受': 'shou', '瘦': 'shou',
    '兽': 'shou', '蔬': 'shu', '枢': 'shu', '梳': 'shu', '殊': 'shu', '抒': 'shu',
    '输': 'shu', '叔': 'shu', '舒': 'shu', '淑': 'shu', '疏': 'shu', '书': 'shu',
    '赎': 'shu', '孰': 'shu', '熟': 'shu', '薯': 'shu', '暑': 'shu', '曙': 'shu',
    '署': 'shu', '蜀': 'shu', '黍': 'shu', '鼠': 'shu', '属': 'shu', '术': 'shu',
    '述': 'shu', '树': 'shu', '束': 'shu', '戍': 'shu', '竖': 'shu', '墅': 'shu',
    '庶': 'shu', '数': 'shu', '漱': 'shu', '恕': 'shu', '刷': 'shua',
    '耍': 'shua', '摔': 'shuai', '衰': 'shuai', '甩': 'shuai', '帅': 'shuai',
    '栓': 'shuan', '拴': 'shuan', '霜': 'shuang', '双': 'shuang', '爽': 'shuang',
    '谁': 'shui', '水': 'shui', '睡': 'shui', '税': 'shui', '吮': 'shun',
    '瞬': 'shun', '顺': 'shun', '舜': 'shun', '说': 'shuo', '硕': 'shuo',
    '朔': 'shuo', '烁': 'shuo', '斯': 'si', '撕': 'si', '嘶': 'si', '思': 'si',
    '私': 'si', '司': 'si', '丝': 'si', '死': 'si', '肆': 'si', '寺': 'si',
    '嗣': 'si', '四': 'si', '伺': 'si', '似': 'si', '饲': 'si', '巳': 'si',
    '松': 'song', '耸': 'song', '怂': 'song', '颂': 'song', '送': 'song',
    '宋': 'song', '讼': 'song', '诵': 'song', '搜': 'sou', '艘': 'sou',
    '擞': 'sou', '嗽': 'su', '苏': 'su', '酥': 'su', '俗': 'su', '素': 'su',
    '速': 'su', '粟': 'su', '僳': 'su', '塑': 'su', '溯': 'su', '宿': 'su',
    '诉': 'su', '肃': 'su', '酸': 'suan', '蒜': 'suan', '算': 'suan', '虽': 'sui',
    '隋': 'sui', '随': 'sui', '绥': 'sui', '髓': 'sui', '碎': 'sui', '岁': 'sui',
    '穗': 'sui', '遂': 'sui', '隧': 'sui', '祟': 'sui', '孙': 'sun', '损': 'sun',
    '笋': 'sun', '蓑': 'suo', '梭': 'suo', '唆': 'suo', '缩': 'suo', '琐': 'suo',
    '索': 'suo', '锁': 'suo', '所': 'suo', '塌': 'ta', '他': 'ta', '它': 'ta',
    '她': 'ta', '塔': 'ta', '獭': 'ta', '挞': 'ta', '蹋': 'ta', '踏': 'ta',
    '胎': 'tai', '苔': 'tai', '抬': 'tai', '台': 'tai', '泰': 'tai', '酞': 'tai',
    '太': 'tai', '态': 'tai', '汰': 'tai', '坍': 'tan', '摊': 'tan', '贪': 'tan',
    '瘫': 'tan', '滩': 'tan', '坛': 'tan', '檀': 'tan', '痰': 'tan', '潭': 'tan',
    '谭': 'tan', '谈': 'tan', '坦': 'tan', '毯': 'tan', '袒': 'tan', '碳': 'tan',
    '探': 'tan', '叹': 'tan', '炭': 'tan', '汤': 'tang', '塘': 'tang',
    '搪': 'tang', '堂': 'tang', '棠': 'tang', '膛': 'tang', '唐': 'tang',
    '糖': 'tang', '倘': 'tang', '躺': 'tang', '淌': 'tang', '趟': 'tang',
    '烫': 'tang', '掏': 'tao', '涛': 'tao', '滔': 'tao', '绦': 'tao', '萄': 'tao',
    '桃': 'tao', '逃': 'tao', '淘': 'tao', '陶': 'tao', '讨': 'tao', '套': 'tao',
    '特': 'te', '藤': 'teng', '腾': 'teng', '疼': 'teng', '誊': 'teng',
    '梯': 'ti', '剔': 'ti', '踢': 'ti', '锑': 'ti', '提': 'ti', '题': 'ti',
    '蹄': 'ti', '啼': 'ti', '体': 'ti', '替': 'ti', '嚏': 'ti', '惕': 'ti',
    '涕': 'ti', '剃': 'ti', '屉': 'ti', '兲': 'tian', '天': 'tian', '添': 'tian',
    '填': 'tian', '田': 'tian', '甜': 'tian', '恬': 'tian', '舔': 'tian',
    '腆': 'tian', '挑': 'tiao', '条': 'tiao', '迢': 'tiao', '眺': 'tiao',
    '跳': 'tiao', '贴': 'tie', '铁': 'tie', '帖': 'tie', '厅': 'ting',
    '听': 'ting', '烃': 'ting', '汀': 'ting', '廷': 'ting', '停': 'ting',
    '亭': 'ting', '庭': 'ting', '挺': 'ting', '艇': 'ting', '通': 'tong',
    '桐': 'tong', '酮': 'tong', '瞳': 'tong', '同': 'tong', '铜': 'tong',
    '彤': 'tong', '童': 'tong', '桶': 'tong', '捅': 'tong', '筒': 'tong',
    '统': 'tong', '痛': 'tong', '偷': 'tou', '投': 'tou', '头': 'tou',
    '透': 'tou', '凸': 'tu', '秃': 'tu', '突': 'tu', '图': 'tu', '徒': 'tu',
    '途': 'tu', '涂': 'tu', '屠': 'tu', '土': 'tu', '吐': 'tu', '兔': 'tu',
    '湍': 'tuan', '团': 'tuan', '推': 'tui', '颓': 'tui', '腿': 'tui',
    '蜕': 'tui', '褪': 'tui', '退': 'tui', '吞': 'tun', '屯': 'tun', '臀': 'tun',
    '拖': 'tuo', '托': 'tuo', '脱': 'tuo', '鸵': 'tuo', '陀': 'tuo', '驮': 'tuo',
    '驼': 'tuo', '椭': 'tuo', '妥': 'tuo', '拓': 'tuo', '唾': 'tuo', '挖': 'wa',
    '哇': 'wa', '蛙': 'wa', '洼': 'wa', '娃': 'wa', '瓦': 'wa', '袜': 'wa',
    '歪': 'wai', '外': 'wai', '豌': 'wan', '弯': 'wan', '湾': 'wan', '玩': 'wan',
    '顽': 'wan', '丸': 'wan', '烷': 'wan', '完': 'wan', '碗': 'wan', '挽': 'wan',
    '晚': 'wan', '皖': 'wan', '惋': 'wan', '宛': 'wan', '婉': 'wan', '万': 'wan',
    '腕': 'wan', '莞': 'wan', '汪': 'wang', '王': 'wang', '亡': 'wang',
    '枉': 'wang', '网': 'wang', '往': 'wang', '旺': 'wang', '望': 'wang',
    '忘': 'wang', '妄': 'wang', '威': 'wei', '巍': 'wei', '微': 'wei',
    '危': 'wei', '韦': 'wei', '违': 'wei', '桅': 'wei', '围': 'wei', '唯': 'wei',
    '惟': 'wei', '为': 'wei', '潍': 'wei', '维': 'wei', '苇': 'wei', '萎': 'wei',
    '委': 'wei', '伟': 'wei', '伪': 'wei', '尾': 'wei', '纬': 'wei', '未': 'wei',
    '蔚': 'wei', '味': 'wei', '畏': 'wei', '胃': 'wei', '喂': 'wei', '魏': 'wei',
    '位': 'wei', '渭': 'wei', '谓': 'wei', '尉': 'wei', '慰': 'wei', '卫': 'wei',
    '瘟': 'wen', '温': 'wen', '蚊': 'wen', '文': 'wen', '闻': 'wen', '纹': 'wen',
    '吻': 'wen', '稳': 'wen', '紊': 'wen', '问': 'wen', '嗡': 'weng',
    '翁': 'weng', '瓮': 'weng', '挝': 'wo', '蜗': 'wo', '涡': 'wo', '窝': 'wo',
    '我': 'wo', '斡': 'wo', '卧': 'wo', '握': 'wo', '沃': 'wo', '巫': 'wu',
    '呜': 'wu', '钨': 'wu', '乌': 'wu', '污': 'wu', '诬': 'wu', '屋': 'wu',
    '无': 'wu', '芜': 'wu', '梧': 'wu', '吾': 'wu', '吴': 'wu', '毋': 'wu',
    '武': 'wu', '五': 'wu', '捂': 'wu', '午': 'wu', '舞': 'wu', '伍': 'wu',
    '侮': 'wu', '坞': 'wu', '戊': 'wu', '雾': 'wu', '晤': 'wu', '物': 'wu',
    '勿': 'wu', '务': 'wu', '悟': 'wu', '误': 'wu', '昔': 'xi', '熙': 'xi',
    '析': 'xi', '西': 'xi', '硒': 'xi', '矽': 'xi', '晰': 'xi', '嘻': 'xi',
    '吸': 'xi', '锡': 'xi', '牺': 'xi', '稀': 'xi', '息': 'xi', '希': 'xi',
    '悉': 'xi', '膝': 'xi', '夕': 'xi', '惜': 'xi', '熄': 'xi', '烯': 'xi',
    '溪': 'xi', '汐': 'xi', '犀': 'xi', '檄': 'xi', '袭': 'xi', '席': 'xi',
    '习': 'xi', '媳': 'xi', '喜': 'xi', '铣': 'xi', '洗': 'xi', '系': 'xi',
    '隙': 'xi', '戏': 'xi', '细': 'xi', '瞎': 'xia', '虾': 'xia', '匣': 'xia',
    '霞': 'xia', '辖': 'xia', '暇': 'xia', '峡': 'xia', '侠': 'xia', '狭': 'xia',
    '下': 'xia', '厦': 'xia', '夏': 'xia', '吓': 'xia', '掀': 'xian',
    '锨': 'xian', '先': 'xian', '仙': 'xian', '鲜': 'xian', '纤': 'xian',
    '咸': 'xian', '贤': 'xian', '衔': 'xian', '舷': 'xian', '闲': 'xian',
    '涎': 'xian', '弦': 'xian', '嫌': 'xian', '显': 'xian', '险': 'xian',
    '现': 'xian', '献': 'xian', '县': 'xian', '腺': 'xian', '馅': 'xian',
    '羡': 'xian', '宪': 'xian', '陷': 'xian', '限': 'xian', '线': 'xian',
    '相': 'xiang', '厢': 'xiang', '镶': 'xiang', '香': 'xiang', '箱': 'xiang',
    '襄': 'xiang', '湘': 'xiang', '乡': 'xiang', '翔': 'xiang', '祥': 'xiang',
    '详': 'xiang', '想': 'xiang', '响': 'xiang', '享': 'xiang', '项': 'xiang',
    '巷': 'xiang', '橡': 'xiang', '像': 'xiang', '向': 'xiang', '象': 'xiang',
    '萧': 'xiao', '硝': 'xiao', '霄': 'xiao', '削': 'xiao', '哮': 'xiao',
    '嚣': 'xiao', '销': 'xiao', '消': 'xiao', '宵': 'xiao', '淆': 'xiao',
    '晓': 'xiao', '小': 'xiao', '孝': 'xiao', '校': 'xiao', '肖': 'xiao',
    '啸': 'xiao', '笑': 'xiao', '效': 'xiao', '楔': 'xie', '些': 'xie',
    '歇': 'xie', '蝎': 'xie', '鞋': 'xie', '协': 'xie', '挟': 'xie', '携': 'xie',
    '邪': 'xie', '斜': 'xie', '胁': 'xie', '谐': 'xie', '写': 'xie', '械': 'xie',
    '卸': 'xie', '蟹': 'xie', '懈': 'xie', '泄': 'xie', '泻': 'xie', '谢': 'xie',
    '屑': 'xie', '薪': 'xin', '芯': 'xin', '锌': 'xin', '欣': 'xin', '辛': 'xin',
    '新': 'xin', '忻': 'xin', '心': 'xin', '信': 'xin', '衅': 'xin', '星': 'xing',
    '腥': 'xing', '猩': 'xing', '惺': 'xing', '兴': 'xing', '刑': 'xing',
    '型': 'xing', '形': 'xing', '邢': 'xing', '行': 'xing', '醒': 'xing',
    '幸': 'xing', '杏': 'xing', '性': 'xing', '姓': 'xing', '兄': 'xiong',
    '凶': 'xiong', '胸': 'xiong', '匈': 'xiong', '汹': 'xiong', '雄': 'xiong',
    '熊': 'xiong', '休': 'xiu', '修': 'xiu', '羞': 'xiu', '朽': 'xiu',
    '嗅': 'xiu', '锈': 'xiu', '秀': 'xiu', '袖': 'xiu', '绣': 'xiu', '墟': 'xu',
    '戌': 'xu', '需': 'xu', '虚': 'xu', '嘘': 'xu', '须': 'xu', '徐': 'xu',
    '许': 'xu', '蓄': 'xu', '酗': 'xu', '叙': 'xu', '旭': 'xu', '序': 'xu',
    '畜': 'xu', '恤': 'xu', '絮': 'xu', '婿': 'xu', '绪': 'xu', '续': 'xu',
    '轩': 'xuan', '喧': 'xuan', '宣': 'xuan', '悬': 'xuan', '旋': 'xuan',
    '玄': 'xuan', '选': 'xuan', '癣': 'xuan', '眩': 'xuan', '绚': 'xuan',
    '靴': 'xue', '薛': 'xue', '学': 'xue', '穴': 'xue', '雪': 'xue', '血': 'xue',
    '勋': 'xun', '熏': 'xun', '循': 'xun', '旬': 'xun', '询': 'xun', '寻': 'xun',
    '驯': 'xun', '巡': 'xun', '殉': 'xun', '汛': 'xun', '训': 'xun', '讯': 'xun',
    '逊': 'xun', '迅': 'xun', '压': 'ya', '押': 'ya', '鸦': 'ya', '鸭': 'ya',
    '呀': 'ya', '丫': 'ya', '芽': 'ya', '牙': 'ya', '蚜': 'ya', '崖': 'ya',
    '衙': 'ya', '涯': 'ya', '雅': 'ya', '哑': 'ya', '亚': 'ya', '讶': 'ya',
    '焉': 'yan', '咽': 'yan', '阉': 'yan', '烟': 'yan', '淹': 'yan', '盐': 'yan',
    '严': 'yan', '研': 'yan', '蜒': 'yan', '岩': 'yan', '延': 'yan', '言': 'yan',
    '颜': 'yan', '阎': 'yan', '炎': 'yan', '沿': 'yan', '奄': 'yan', '掩': 'yan',
    '眼': 'yan', '衍': 'yan', '演': 'yan', '艳': 'yan', '堰': 'yan', '燕': 'yan',
    '厌': 'yan', '砚': 'yan', '雁': 'yan', '唁': 'yan', '彦': 'yan', '焰': 'yan',
    '宴': 'yan', '谚': 'yan', '验': 'yan', '殃': 'yang', '央': 'yang',
    '鸯': 'yang', '秧': 'yang', '杨': 'yang', '扬': 'yang', '佯': 'yang',
    '疡': 'yang', '羊': 'yang', '洋': 'yang', '阳': 'yang', '氧': 'yang',
    '仰': 'yang', '痒': 'yang', '养': 'yang', '样': 'yang', '漾': 'yang',
    '邀': 'yao', '腰': 'yao', '妖': 'yao', '瑶': 'yao', '摇': 'yao', '尧': 'yao',
    '遥': 'yao', '窑': 'yao', '谣': 'yao', '姚': 'yao', '咬': 'yao', '舀': 'yao',
    '药': 'yao', '要': 'yao', '耀': 'yao', '椰': 'ye', '噎': 'ye', '耶': 'ye',
    '爷': 'ye', '野': 'ye', '冶': 'ye', '也': 'ye', '页': 'ye', '掖': 'ye',
    '业': 'ye', '叶': 'ye', '曳': 'ye', '腋': 'ye', '夜': 'ye', '液': 'ye',
    '一': 'yi', '壹': 'yi', '医': 'yi', '揖': 'yi', '铱': 'yi', '依': 'yi',
    '伊': 'yi', '衣': 'yi', '颐': 'yi', '夷': 'yi', '遗': 'yi', '移': 'yi',
    '仪': 'yi', '胰': 'yi', '疑': 'yi', '沂': 'yi', '宜': 'yi', '姨': 'yi',
    '彝': 'yi', '椅': 'yi', '蚁': 'yi', '倚': 'yi', '已': 'yi', '乙': 'yi',
    '矣': 'yi', '以': 'yi', '艺': 'yi', '抑': 'yi', '易': 'yi', '邑': 'yi',
    '屹': 'yi', '亿': 'yi', '役': 'yi', '臆': 'yi', '逸': 'yi', '肄': 'yi',
    '疫': 'yi', '亦': 'yi', '裔': 'yi', '意': 'yi', '毅': 'yi', '忆': 'yi',
    '义': 'yi', '益': 'yi', '溢': 'yi', '诣': 'yi', '议': 'yi', '谊': 'yi',
    '译': 'yi', '异': 'yi', '翼': 'yi', '翌': 'yi', '绎': 'yi', '茵': 'yin',
    '荫': 'yin', '因': 'yin', '殷': 'yin', '音': 'yin', '阴': 'yin', '姻': 'yin',
    '吟': 'yin', '银': 'yin', '淫': 'yin', '寅': 'yin', '饮': 'yin', '尹': 'yin',
    '引': 'yin', '隐': 'yin', '印': 'yin', '英': 'ying', '樱': 'ying',
    '婴': 'ying', '鹰': 'ying', '应': 'ying', '缨': 'ying', '莹': 'ying',
    '萤': 'ying', '营': 'ying', '荧': 'ying', '蝇': 'ying', '迎': 'ying',
    '赢': 'ying', '盈': 'ying', '影': 'ying', '颖': 'ying', '硬': 'ying',
    '映': 'ying', '哟': 'yo', '拥': 'yong', '佣': 'yong', '臃': 'yong',
    '痈': 'yong', '庸': 'yong', '雍': 'yong', '踊': 'yong', '蛹': 'yong',
    '咏': 'yong', '泳': 'yong', '涌': 'yong', '永': 'yong', '恿': 'yong',
    '勇': 'yong', '用': 'yong', '幽': 'you', '优': 'you', '悠': 'you',
    '忧': 'you', '尤': 'you', '由': 'you', '邮': 'you', '铀': 'you', '犹': 'you',
    '油': 'you', '游': 'you', '酉': 'you', '有': 'you', '友': 'you', '右': 'you',
    '佑': 'you', '釉': 'you', '诱': 'you', '又': 'you', '幼': 'you', '迂': 'you',
    '淤': 'yu', '于': 'yu', '盂': 'yu', '榆': 'yu', '虞': 'yu', '愚': 'yu',
    '舆': 'yu', '余': 'yu', '俞': 'yu', '逾': 'yu', '鱼': 'yu', '愉': 'yu',
    '渝': 'yu', '渔': 'yu', '隅': 'yu', '予': 'yu', '娱': 'yu', '雨': 'yu',
    '与': 'yu', '屿': 'yu', '禹': 'yu', '宇': 'yu', '语': 'yu', '羽': 'yu',
    '玉': 'yu', '域': 'yu', '芋': 'yu', '郁': 'yu', '吁': 'yu', '遇': 'yu',
    '喻': 'yu', '峪': 'yu', '御': 'yu', '愈': 'yu', '欲': 'yu', '狱': 'yu',
    '育': 'yu', '誉': 'yu', '浴': 'yu', '寓': 'yu', '裕': 'yu', '预': 'yu',
    '豫': 'yu', '驭': 'yu', '鸳': 'yuan', '渊': 'yuan', '冤': 'yuan',
    '元': 'yuan', '垣': 'yuan', '袁': 'yuan', '原': 'yuan', '援': 'yuan',
    '辕': 'yuan', '园': 'yuan', '员': 'yuan', '圆': 'yuan', '猿': 'yuan',
    '源': 'yuan', '缘': 'yuan', '远': 'yuan', '苑': 'yuan', '愿': 'yuan',
    '怨': 'yuan', '院': 'yuan', '曰': 'yue', '约': 'yue', '越': 'yue',
    '跃': 'yue', '钥': 'yue', '岳': 'yue', '粤': 'yue', '月': 'yue', '悦': 'yue',
    '阅': 'yue', '耘': 'yun', '云': 'yun', '郧': 'yun', '匀': 'yun', '陨': 'yun',
    '允': 'yun', '运': 'yun', '蕴': 'yun', '酝': 'yun', '晕': 'yun', '韵': 'yun',
    '孕': 'yun', '匝': 'za', '砸': 'za', '杂': 'za', '栽': 'zai', '哉': 'zai',
    '灾': 'zai', '宰': 'zai', '载': 'zai', '再': 'zai', '在': 'zai', '咱': 'zan',
    '攒': 'zan', '暂': 'zan', '赞': 'zan', '赃': 'zang', '脏': 'zang',
    '葬': 'zang', '遭': 'zao', '糟': 'zao', '凿': 'zao', '藻': 'zao', '枣': 'zao',
    '早': 'zao', '澡': 'zao', '蚤': 'zao', '躁': 'zao', '噪': 'zao', '造': 'zao',
    '皂': 'zao', '灶': 'zao', '燥': 'zao', '责': 'ze', '择': 'ze', '则': 'ze',
    '泽': 'ze', '贼': 'zei', '怎': 'zen', '增': 'zeng', '憎': 'zeng',
    '曾': 'zeng', '赠': 'zeng', '扎': 'zha', '喳': 'zha', '渣': 'zha',
    '札': 'zha', '轧': 'zha', '铡': 'zha', '闸': 'zha', '眨': 'zha', '栅': 'zha',
    '榨': 'zha', '咋': 'zha', '乍': 'zha', '炸': 'zha', '诈': 'zha', '摘': 'zhai',
    '斋': 'zhai', '宅': 'zhai', '窄': 'zhai', '债': 'zhai', '寨': 'zhai',
    '瞻': 'zhan', '毡': 'zhan', '詹': 'zhan', '粘': 'zhan', '沾': 'zhan',
    '盏': 'zhan', '斩': 'zhan', '辗': 'zhan', '崭': 'zhan', '展': 'zhan',
    '蘸': 'zhan', '栈': 'zhan', '占': 'zhan', '战': 'zhan', '站': 'zhan',
    '湛': 'zhan', '绽': 'zhan', '樟': 'zhang', '章': 'zhang', '彰': 'zhang',
    '漳': 'zhang', '张': 'zhang', '掌': 'zhang', '涨': 'zhang', '杖': 'zhang',
    '丈': 'zhang', '帐': 'zhang', '账': 'zhang', '仗': 'zhang', '胀': 'zhang',
    '瘴': 'zhang', '障': 'zhang', '招': 'zhao', '昭': 'zhao', '找': 'zhao',
    '沼': 'zhao', '赵': 'zhao', '照': 'zhao', '罩': 'zhao', '兆': 'zhao',
    '肇': 'zhao', '召': 'zhao', '遮': 'zhe', '折': 'zhe', '哲': 'zhe',
    '蛰': 'zhe', '辙': 'zhe', '者': 'zhe', '锗': 'zhe', '蔗': 'zhe', '这': 'zhe',
    '浙': 'zhe', '珍': 'zhen', '斟': 'zhen', '真': 'zhen', '甄': 'zhen',
    '砧': 'zhen', '臻': 'zhen', '贞': 'zhen', '针': 'zhen', '侦': 'zhen',
    '枕': 'zhen', '疹': 'zhen', '诊': 'zhen', '震': 'zhen', '振': 'zhen',
    '镇': 'zhen', '阵': 'zhen', '圳': 'zhen', '蒸': 'zheng', '挣': 'zheng',
    '睁': 'zheng', '征': 'zheng', '狰': 'zheng', '争': 'zheng', '怔': 'zheng',
    '整': 'zheng', '拯': 'zheng', '正': 'zheng', '政': 'zheng', '帧': 'zheng',
    '症': 'zheng', '郑': 'zheng', '证': 'zheng', '芝': 'zhi', '枝': 'zhi',
    '支': 'zhi', '吱': 'zhi', '蜘': 'zhi', '知': 'zhi', '肢': 'zhi', '脂': 'zhi',
    '汁': 'zhi', '之': 'zhi', '织': 'zhi', '职': 'zhi', '直': 'zhi', '植': 'zhi',
    '殖': 'zhi', '执': 'zhi', '值': 'zhi', '侄': 'zhi', '址': 'zhi', '指': 'zhi',
    '止': 'zhi', '趾': 'zhi', '只': 'zhi', '旨': 'zhi', '纸': 'zhi', '志': 'zhi',
    '挚': 'zhi', '掷': 'zhi', '至': 'zhi', '致': 'zhi', '置': 'zhi', '帜': 'zhi',
    '峙': 'zhi', '制': 'zhi', '智': 'zhi', '秩': 'zhi', '稚': 'zhi', '质': 'zhi',
    '炙': 'zhi', '痔': 'zhi', '滞': 'zhi', '治': 'zhi', '窒': 'zhi',
    '中': 'zhong', '盅': 'zhong', '忠': 'zhong', '钟': 'zhong', '衷': 'zhong',
    '终': 'zhong', '种': 'zhong', '肿': 'zhong', '重': 'zhong', '仲': 'zhong',
    '众': 'zhong', '舟': 'zhou', '周': 'zhou', '州': 'zhou', '洲': 'zhou',
    '诌': 'zhou', '粥': 'zhou', '轴': 'zhou', '肘': 'zhou', '帚': 'zhou',
    '咒': 'zhou', '皱': 'zhou', '宙': 'zhou', '昼': 'zhou', '骤': 'zhou',
    '珠': 'zhu', '株': 'zhu', '蛛': 'zhu', '朱': 'zhu', '猪': 'zhu', '诸': 'zhu',
    '诛': 'zhu', '逐': 'zhu', '竹': 'zhu', '烛': 'zhu', '煮': 'zhu', '拄': 'zhu',
    '瞩': 'zhu', '嘱': 'zhu', '主': 'zhu', '著': 'zhu', '柱': 'zhu', '助': 'zhu',
    '蛀': 'zhu', '贮': 'zhu', '铸': 'zhu', '筑': 'zhu', '住': 'zhu', '注': 'zhu',
    '祝': 'zhu', '驻': 'zhu', '抓': 'zhua', '爪': 'zhua', '拽': 'zhuai',
    '专': 'zhuan', '砖': 'zhuan', '转': 'zhuan', '撰': 'zhuan', '赚': 'zhuan',
    '篆': 'zhuan', '桩': 'zhuang', '庄': 'zhuang', '装': 'zhuang',
    '妆': 'zhuang', '撞': 'zhuang', '壮': 'zhuang', '状': 'zhuang', '椎': 'zhui',
    '锥': 'zhui', '追': 'zhui', '赘': 'zhui', '坠': 'zhui', '缀': 'zhui',
    '谆': 'zhun', '准': 'zhun', '捉': 'zhuo', '拙': 'zhuo', '卓': 'zhuo',
    '桌': 'zhuo', '琢': 'zhuo', '茁': 'zhuo', '酌': 'zhuo', '啄': 'zhuo',
    '着': 'zhuo', '灼': 'zhuo', '浊': 'zhuo', '兹': 'zi', '咨': 'zi', '资': 'zi',
    '姿': 'zi', '滋': 'zi', '淄': 'zi', '孜': 'zi', '紫': 'zi', '仔': 'zi',
    '籽': 'zi', '滓': 'zi', '子': 'zi', '自': 'zi', '渍': 'zi', '字': 'zi',
    '鬃': 'zong', '棕': 'zong', '踪': 'zong', '宗': 'zong', '综': 'zong',
    '总': 'zong', '纵': 'zong', '邹': 'zou', '走': 'zou', '奏': 'zou',
    '揍': 'zou', '租': 'zu', '足': 'zu', '卒': 'zu', '族': 'zu', '祖': 'zu',
    '诅': 'zu', '阻': 'zu', '组': 'zu', '钻': 'zuan', '纂': 'zuan', '嘴': 'zui',
    '醉': 'zui', '最': 'zui', '罪': 'zui', '尊': 'zun', '遵': 'zun', '昨': 'zuo',
    '左': 'zuo', '佐': 'zuo', '柞': 'zuo', '做': 'zuo', '作': 'zuo', '坐': 'zuo',
    '座': 'zuo',
    # from:
    # https://www.wikidata.org/wiki/MediaWiki:Gadget-SimpleTransliterate.js
    'ଂ': 'anusvara', 'ઇ': 'i', 'എ': 'e', 'ગ': 'ga', 'ਜ': 'ja', 'ഞ': 'nya',
    'ଢ': 'ddha', 'ધ': 'dha', 'ਬ': 'ba', 'മ': 'ma', 'ଲ': 'la', 'ષ': 'ssa',
    '਼': 'nukta', 'ാ': 'aa', 'ୂ': 'uu', 'ે': 'e', 'ੌ': 'au', 'ൎ': 'reph',
    'ੜ': 'rra', '՞': '?', 'ୢ': 'l', '૧': '1', '੬': '6', '൮': '8',
    '୲': 'quarter', 'ൾ': 'll', 'ਇ': 'i', 'ഉ': 'u', 'ઌ': 'l', 'ਗ': 'ga',
    'ങ': 'nga', 'ଝ': 'jha', 'જ': 'ja', '؟': '?', 'ਧ': 'dha', 'ഩ': 'nnna',
    'ଭ': 'bha', 'બ': 'ba', 'ഹ': 'ha', 'ଽ': 'avagraha', '઼': 'nukta',
    'ੇ': 'ee', '୍': 'virama', 'ૌ': 'au', '੧': '1', '൩': '3', '୭': '7',
    '૬': '6', '൹': 'mark', 'ਖ਼': 'khha', 'ਂ': 'bindi', 'ഈ': 'ii', 'ઍ': 'e',
    'ଌ': 'l', 'ഘ': 'gha', 'ઝ': 'jha', 'ଡ଼': 'rra', 'ਢ': 'ddha', 'ന': 'na',
    'ભ': 'bha', 'ବ': 'ba', 'ਲ': 'la', 'സ': 'sa', 'ઽ': 'avagraha',
    '଼': 'nukta', 'ੂ': 'uu', 'ൈ': 'ai', '્': 'virama', 'ୌ': 'au', '൨': '2',
    '૭': '7', '୬': '6', 'ੲ': 'iri', 'ഃ': 'visarga', 'ં': 'anusvara',
    'ଇ': 'i', 'ഓ': 'oo', 'ଗ': 'ga', 'ਝ': 'jha', 'ണ': 'nna',
    'ઢ': 'ddha', 'ଧ': 'dha', 'ਭ': 'bha', 'ള': 'lla', 'લ': 'la', 'ଷ': 'ssa',
    'ൃ': 'r', 'ૂ': 'uu', 'େ': 'e', '੍': 'virama', 'ୗ': 'mark', 'ൣ': 'll',
    'ૢ': 'l', '୧': '1', '੭': '7', '൳': '1/4', '୷': 'sixteenths', 'ଆ': 'aa',
    'ઋ': 'r', 'ഊ': 'uu', 'ਐ': 'ai', 'ଖ': 'kha', 'છ': 'cha', 'ച': 'ca',
    'ਠ': 'ttha', 'ଦ': 'da', 'ફ': 'pha', 'പ': 'pa', 'ਰ': 'ra', 'ଶ': 'sha',
    'ഺ': 'ttta', 'ੀ': 'ii', 'ો': 'o', 'ൊ': 'o', 'ୖ': 'mark', '୦': '0',
    '૫': '5', '൪': '4', 'ੰ': 'tippi', '୶': 'eighth', 'ൺ': 'nn',
    'ଁ': 'candrabindu', 'അ': 'a', 'ઐ': 'ai', 'ക': 'ka', 'ਸ਼': 'sha',
    'ਛ': 'cha', 'ଡ': 'dda', 'ઠ': 'ttha', 'ഥ': 'tha', 'ਫ': 'pha', 'ર': 'ra',
    'വ': 'va', 'ୁ': 'u', 'ી': 'ii', 'ੋ': 'oo', 'ૐ': 'om', 'ୡ': 'll',
    'ૠ': 'rr', '੫': '5', 'ୱ': 'wa', '૰': 'sign', '൵': 'quarters',
    'ਫ਼': 'fa', 'ઁ': 'candrabindu', 'ਆ': 'aa', 'ઑ': 'o', 'ଐ': 'ai',
    'ഔ': 'au', 'ਖ': 'kha', 'ડ': 'dda', 'ଠ': 'ttha', 'ത': 'ta', 'ਦ': 'da',
    'ର': 'ra', 'ഴ': 'llla', 'ુ': 'u', 'ୀ': 'ii', 'ൄ': 'rr', 'ૡ': 'll',
    'ୠ': 'rr', '੦': '0', '૱': 'sign', '୰': 'isshar', '൴': '1/2',
    'ਁ': 'bindi', 'આ': 'aa', 'ଋ': 'r', 'ഏ': 'ee', 'ખ': 'kha', 'ଛ': 'cha',
    'ട': 'tta', 'ਡ': 'dda', 'દ': 'da', 'ଫ': 'pha', 'യ': 'ya', 'શ': 'sha',
    'ി': 'i', 'ੁ': 'u', 'ୋ': 'o', 'ੑ': 'udaat', '૦': '0', '୫': '5',
    '൯': '9', 'ੱ': 'addak', 'ൿ': 'k', 'ആ': 'aa', 'ଊ': 'uu', 'એ': 'e',
    'ਔ': 'au', 'ഖ': 'kha', 'ଚ': 'ca', 'ટ': 'tta', 'ਤ': 'ta', 'ദ': 'da',
    'ପ': 'pa', 'ય': 'ya', 'ശ': 'sha', 'િ': 'i', 'െ': 'e', '൦': '0',
    '୪': '4', '૯': '9', 'ੴ': 'onkar', 'ଅ': 'a', 'ਏ': 'ee', 'କ': 'ka',
    'ઔ': 'au', 'ਟ': 'tta', 'ഡ': 'dda', 'ଥ': 'tha', 'ત': 'ta', 'ਯ': 'ya',
    'റ': 'rra', 'ଵ': 'va', 'ਿ': 'i', 'ു': 'u', 'ૄ': 'rr', 'ൡ': 'll',
    '੯': '9', '൱': '100', '୵': 'sixteenth', 'અ': 'a', 'ਊ': 'uu', 'ഐ': 'ai',
    'ક': 'ka', 'ଔ': 'au', 'ਚ': 'ca', 'ഠ': 'ttha', 'થ': 'tha', 'ତ': 'ta',
    'ਪ': 'pa', 'ര': 'ra', 'વ': 'va', 'ീ': 'ii', 'ૅ': 'e', 'ୄ': 'rr',
    'ൠ': 'rr', 'ਜ਼': 'za', '੪': '4', '൰': '10', '୴': 'quarters', 'ਅ': 'a',
    'ഋ': 'r', 'ઊ': 'uu', 'ଏ': 'e', 'ਕ': 'ka', 'ഛ': 'cha', 'ચ': 'ca',
    'ଟ': 'tta', 'ਥ': 'tha', 'ഫ': 'pha', 'પ': 'pa', 'ଯ': 'ya', 'ਵ': 'va',
    'ି': 'i', 'ോ': 'oo', 'ୟ': 'yya', '൫': '5', '૪': '4', '୯': '9',
    'ੵ': 'yakash', 'ൻ': 'n', 'ઃ': 'visarga', 'ം': 'anusvara', 'ਈ': 'ii',
    'ઓ': 'o', 'ഒ': 'o', 'ਘ': 'gha', 'ଞ': 'nya', 'ણ': 'nna', 'ഢ': 'ddha',
    'ਲ਼': 'lla', 'ਨ': 'na', 'ମ': 'ma', 'ળ': 'lla', 'ല': 'la', 'ਸ': 'sa',
    'ା': 'aa', 'ૃ': 'r', 'ൂ': 'uu', 'ੈ': 'ai', 'ૣ': 'll',
    'ൢ': 'l', '੨': '2', '୮': '8', '൲': '1000', 'ਃ': 'visarga', 'ଉ': 'u',
    'ઈ': 'ii', 'ਓ': 'oo', 'ଙ': 'nga', 'ઘ': 'gha', 'ഝ': 'jha', 'ਣ': 'nna',
    'ન': 'na', 'ഭ': 'bha', 'ଜ': 'ja', 'ହ': 'ha', 'સ': 'sa', 'ഽ': 'avagraha',
    'ૈ': 'ai', '്': 'virama', '୩': '3', '૨': '2', '൭': '7', 'ੳ': 'ura',
    'ൽ': 'l', 'ઉ': 'u', 'ଈ': 'ii', 'ഌ': 'l', 'ઙ': 'nga', 'ଘ': 'gha',
    'ജ': 'ja', 'ਞ': 'nya', 'ନ': 'na', 'ബ': 'ba', 'ਮ': 'ma', 'હ': 'ha',
    'ସ': 'sa', 'ਾ': 'aa', 'ૉ': 'o', 'ୈ': 'ai', 'ൌ': 'au', '૩': '3',
    '୨': '2', '൬': '6', '੮': '8', 'ർ': 'rr', 'ଃ': 'visarga', 'ഇ': 'i',
    'ਉ': 'u', 'ଓ': 'o', 'ഗ': 'ga', 'ਙ': 'nga', 'ઞ': 'nya', 'ଣ': 'nna',
    'ധ': 'dha', 'મ': 'ma', 'ଳ': 'lla', 'ഷ': 'ssa', 'ਹ': 'ha', 'ਗ਼': 'ghha',
    'ા': 'aa', 'ୃ': 'r', 'േ': 'ee', 'ൗ': 'mark', 'ଢ଼': 'rha', 'ୣ': 'll',
    '൧': '1', '੩': '3', '૮': '8', '୳': 'half',
}


class transliterator:

    """Class to transliterating text."""

    def __init__(self, encoding: str):
        """
        Initialize the transliteration mapping.

        @param encoding: the encoding available. Any transliterated character
            which can't be mapped, will be removed from the mapping.
        """
        trans = _trans.copy()
        for char, value in trans.items():
            if value == '?':
                continue
            while (value.encode(encoding, 'replace').decode(encoding) == '?'
                   and value in trans):
                assert value != trans[value], \
                    '{!r} == trans[{!r}]!'.format(value, value)
                value = trans[value]
            trans[char] = value
        self.trans = trans

    def transliterate(self, char: str, default='?', prev='-', next='-') -> str:
        """
        Transliterate the character.

        @param char: The character to transliterate.
        @param default: The character used when there is no transliteration.
        @type default: str
        @param prev: The previous character
        @type prev: str
        @param next: The next character
        @type next: str
        @return: The transliterated character which may be an empty string
        """
        if char in self.trans:
            return self.trans[char]
        # Arabic
        if char == '◌':
            return prev
        # Japanese
        if char == 'ッ':
            return self.transliterate(next)[0]
        if char in '々仝ヽヾゝゞ〱〲〳〵〴〵':
            return prev
        # Lao
        if char == 'ຫ':
            if next in 'ງຍນຣລຼຼວ':
                return ''
            else:
                return 'h'
        return default
