import { Project, ProjectOptions } from "projen";
import { SmithyBuildOptions } from "./types";
import { SmithyServiceName } from "../types";
/**
 * Options for a smithy build project
 */
export interface SmithyBuildProjectOptions extends ProjectOptions {
    /**
     * Smithy service name
     */
    readonly serviceName: SmithyServiceName;
    /**
     * Smithy build options
     */
    readonly smithyBuildOptions?: SmithyBuildOptions;
    /**
     * The build output directory, relative to the project outdir
     */
    readonly buildOutputDir: string;
}
/**
 * Creates a project which transforms a Smithy model to OpenAPI
 */
export declare class SmithyBuildProject extends Project {
    /**
     * Absolute path to the smithy-build.json file
     */
    smithyBuildConfigPath: string;
    /**
     * Absolute path to the smithy build output
     */
    smithyBuildOutputPath: string;
    private synthed;
    constructor(options: SmithyBuildProjectOptions);
    /**
     * @inheritDoc
     */
    synth(): void;
}
