"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyBuildGradleFile = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
/**
 * Synthesize a build.gradle file for Smithy projects
 */
class SmithyBuildGradleFile extends projen_1.FileBase {
    constructor(project, options) {
        super(project, "build.gradle", {
            marker: true,
            readonly: true,
        });
        this.modelDir = options.modelDir;
        this.dependencies = options.dependencies;
        this.repositories = options.repositoryUrls?.map((url) => `maven { url "${url}" }`) ?? ["mavenLocal()", "mavenCentral()"];
    }
    synthesizeContent(_) {
        return `// ${this.marker}
plugins {
    id "software.amazon.smithy" version "0.6.0"
}

sourceSets {
    main {
        java {
            srcDirs = ['${this.modelDir}']
        }
    }
}

// Dependencies can be added by configuring smithyBuildOptions in your .projenrc file
repositories {
${this.repositories.map((repository) => `    ${repository}`).join("\n")}
}

// Dependencies can be added by configuring smithyBuildOptions in your .projenrc file
dependencies {
${this.dependencies.map((dep) => `    implementation "${dep}"`).join("\n")}
}

task generate(type: JavaExec) {
    configurations.implementation.setCanBeResolved(true)

    classpath = configurations.implementation
    mainClass.set('software.amazon.smithy.cli.SmithyCli')

    if (project.hasProperty("config") && project.hasProperty("output") && project.hasProperty("discover")) {
        args("build",
                "--config",
                file(project.getProperty("config")).toString(),
                "--output",
                file(project.getProperty("output")).toString(),
                "--discover",
                file(project.getProperty("discover")).toString())
    }
}
`;
    }
}
exports.SmithyBuildGradleFile = SmithyBuildGradleFile;
//# sourceMappingURL=data:application/json;base64,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