"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientProject = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const projen_1 = require("projen");
const java_1 = require("projen/lib/java");
const generated_java_client_source_code_1 = require("./components/generated-java-client-source-code");
const open_api_generator_ignore_file_1 = require("./components/open-api-generator-ignore-file");
const DEPENDENCIES = [
    // Required for open api generated client
    "io.swagger/swagger-annotations@1.6.8",
    "com.google.code.findbugs/jsr305@3.0.2",
    "com.squareup.okhttp3/okhttp@4.10.0",
    "com.squareup.okhttp3/logging-interceptor@4.10.0",
    "com.google.code.gson/gson@2.9.1",
    "io.gsonfire/gson-fire@1.8.5",
    "org.apache.commons/commons-lang3@3.12.0",
    "jakarta.annotation/jakarta.annotation-api@1.3.5",
    "org.openapitools/jackson-databind-nullable@0.2.4",
    "javax.ws.rs/jsr311-api@1.1.1",
    "javax.ws.rs/javax.ws.rs-api@2.1.1",
    // For handler wrappers
    "com.amazonaws/aws-lambda-java-core@1.2.1",
    "com.amazonaws/aws-lambda-java-events@3.11.0",
    // Lombok is used to add the builder pattern to models for neater construction
    "org.projectlombok/lombok@1.18.24",
];
const TEST_DEPENDENCIES = [
    "org.junit.jupiter/junit-jupiter-api@5.9.1",
    "org.mockito/mockito-core@3.12.4",
];
/**
 * Java project containing a java client (and lambda handler wrappers) generated using OpenAPI Generator CLI
 */
class GeneratedJavaClientProject extends java_1.JavaProject {
    constructor(options) {
        super({
            sample: false,
            junit: false,
            ...options,
        });
        // Store whether we've synthesized the project
        this.synthed = false;
        // Ignore files that we will control via projen
        const ignoreFile = new open_api_generator_ignore_file_1.OpenApiGeneratorIgnoreFile(this);
        ignoreFile.addPatterns("pom.xml");
        // Add dependencies
        DEPENDENCIES.forEach((dep) => this.addDependency(dep));
        TEST_DEPENDENCIES.forEach((dep) => this.addTestDependency(dep));
        // Use a package.json to ensure the client is discoverable by nx
        new projen_1.JsonFile(this, "package.json", {
            obj: {
                name: this.name,
                __pdk__: true,
                version: options.version,
                scripts: Object.fromEntries(this.tasks.all.map((task) => [task.name, `npx projen ${task.name}`])),
            },
            readonly: true,
        });
        new generated_java_client_source_code_1.GeneratedJavaClientSourceCode(this, {
            specPath: options.specPath,
            invokeGenerator: options.generateClient,
        });
    }
    /**
     * @inheritDoc
     */
    synth() {
        // Save some time by only synthesizing once. We synthesize this project early so that it's available for the parent
        // project's install phase (pre-synth). Projen will call this method again at the usual time to synthesize this,
        // project, at which point we're already done so can skip.
        if (this.synthed) {
            return;
        }
        super.synth();
        this.synthed = true;
    }
}
exports.GeneratedJavaClientProject = GeneratedJavaClientProject;
//# sourceMappingURL=data:application/json;base64,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