"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedHtml2Docs = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const utils_1 = require("../utils");
/**
 * Generates the html2 documentation using OpenAPI Generator
 */
class GeneratedHtml2Docs extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        // Generate the html2 docs
        utils_1.invokeOpenApiGenerator({
            generator: "html2",
            specPath: this.options.specPath,
            outputPath: path.join(this.project.outdir, "html2"),
            generatorDirectory: utils_1.NonClientGeneratorDirectory.DOCS,
        });
    }
}
exports.GeneratedHtml2Docs = GeneratedHtml2Docs;
//# sourceMappingURL=data:application/json;base64,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