"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedHtmlRedocDocs = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const projen_1 = require("projen");
const utils_1 = require("../utils");
/**
 * Generates html documentation using Redoc
 */
class GeneratedHtmlRedocDocs extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        utils_1.invokeCustomDocsGenerator({
            generator: "html-redoc",
            args: `--spec-path ${this.options.specPath} --output-path ${path.join(this.project.outdir, "html_redoc", "index.html")}`,
        });
    }
}
exports.GeneratedHtmlRedocDocs = GeneratedHtmlRedocDocs;
//# sourceMappingURL=data:application/json;base64,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