# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['netbox_onboarding',
 'netbox_onboarding.api',
 'netbox_onboarding.migrations',
 'netbox_onboarding.tests',
 'netbox_onboarding.utils']

package_data = \
{'': ['*'], 'netbox_onboarding': ['templates/netbox_onboarding/*']}

install_requires = \
['invoke>=1.4.1,<2.0.0', 'napalm>=2.5.0,<3.0.0']

setup_kwargs = {
    'name': 'ntc-netbox-plugin-onboarding',
    'version': '1.3.0',
    'description': 'A plugin for NetBox to easily onboard new devices.',
    'long_description': '# NetBox Onboarding plugin\n\n<!-- Build status with linky to the builds for ease of access. -->\n[![Build Status](https://travis-ci.com/networktocode/ntc-netbox-plugin-onboarding.svg?token=29s5AiDXdkDPwzSmDpxg&branch=master)](https://travis-ci.com/networktocode/ntc-netbox-plugin-onboarding)\n\nA plugin for [NetBox](https://github.com/netbox-community/netbox) to easily onboard new devices.\n\n`ntc-netbox-plugin-onboarding` is using [Netmiko](https://github.com/ktbyers/netmiko), [NAPALM](https://napalm.readthedocs.io/en/latest/) & [Django-RQ](https://github.com/rq/django-rq) to simplify the onboarding process of a new device into NetBox down to an IP Address and a site.\nThe goal of this plugin is not to import everything about a device into NetBox but rather to help build quickly an inventory in NetBox that is often the first step into an automation journey.\n\n## Installation\n\nThe plugin is available as a Python package in pypi and can be installed with pip\n```shell\npip install ntc-netbox-plugin-onboarding\n```\n\n> The plugin is compatible with NetBox 2.8.1 and higher\n \nTo ensure NetBox Onboarding plugin is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the NetBox root directory (alongside `requirements.txt`) and list the `ntc-netbox-plugin-onboarding` package:\n\n```no-highlight\n# echo ntc-netbox-plugin-onboarding >> local_requirements.txt\n```\n\nOnce installed, the plugin needs to be enabled in your `configuration.py`\n```python\n# In your configuration.py\nPLUGINS = ["netbox_onboarding"]\n\n# PLUGINS_CONFIG = {\n#   "netbox_onboarding": {\n#     ADD YOUR SETTINGS HERE\n#   }\n# }\n```\n\nFinally, make sure to run the migrations for this plugin\n\n```bash\npython3 manage.py migrate\n```\n\nThe plugin behavior can be controlled with the following list of settings\n\n- `create_platform_if_missing` boolean (default True), If True, a new platform object will be created if the platform discovered by netmiko do not already exist and is in the list of supported platforms (`cisco_ios`, `cisco_nxos`, `arista_eos`, `juniper_junos`, `cisco_xr`)\n- `create_device_type_if_missing` boolean (default True), If True, a new device type object will be created if the model discovered by Napalm do not match an existing device type.\n- `create_manufacturer_if_missing` boolean (default True), If True, a new manufacturer object will be created if the manufacturer discovered by Napalm is do not match an existing manufacturer, this option is only valid if `create_device_type_if_missing` is True as well.\n- `create_device_role_if_missing` boolean (default True), If True, a new device role object will be created if the device role provided was not provided as part of the onboarding and if the `default_device_role` do not already exist.\n- `create_management_interface_if_missing` boolean (default True), If True, add management interface and IP address to the device. If False no management interfaces will be created, nor will the IP address be added to NetBox, while the device will still get added.\n- `default_device_status` string (default "active"), status assigned to a new device by default (must be lowercase).\n- `default_device_role` string (default "network")\n- `default_device_role_color` string (default FF0000), color assigned to the device role if it needs to be created.\n- `default_management_interface` string (default "PLACEHOLDER"), name of the management interface that will be created, if one can\'t be identified on the device.\n- `default_management_prefix_length` integer ( default 0), length of the prefix that will be used for the management IP address, if the IP can\'t be found.\n- `platform_map` (dictionary), mapping of an **auto-detected** Netmiko platform to the **NetBox slug** name of your Platform. The dictionary should be in the format:\n    ```python\n    {\n      <Netmiko Platform>: <NetBox Slug> \n    }\n    ```\n\n## Usage\n\n### Preparation\n\nTo work properly the plugin needs to know the Site, Platform, Device Type, Device Role of each\ndevice as well as its primary IP address or DNS Name. It\'s recommended to create these objects in\nNetBox ahead of time and to provide them when you want to start the onboarding process.\n\n> For DNS Name Resolution to work, the instance of NetBox must be able to resolve the name of the\n> device to IP address.\n\nIf `Platform`, `Device Type` and/or `Device Role` are not provided, the plugin will try to identify these information automatically and, based on the settings, it can create them in NetBox as needed.\n> If the Platform is provided, it must contains a valid Napalm driver available to the worker in Python\n\n### Onboard a new device\n\nA new device can be onboarded via :\n- A web form  `/plugins/onboarding/add/`\n- A CSV form to import multiple devices in bulk. `/plugins/onboarding/import/`\n- An API, `POST /api/plugins\u200b/onboarding\u200b/onboarding\u200b/`\n\nDuring a successful onboarding process, a new device will be created in NetBox with its management interface and its primary IP assigned. The management interface will be discovered on the device based on the IP address provided.\n\n> By default, the plugin is using the credentials defined in the main `configuration.py` for Napalm (`NAPALM_USERNAME`/`NAPALM_PASSWORD`). It\'s possible to define specific credentials for each onboarding task.\n\n### Consult the status of onboarding tasks\n\nThe status of the onboarding process for each device is maintained is a dedicated table in NetBox and can be retrived :\n- Via the UI `/plugins/onboarding/`\n- Via the API `GET /api/plugins\u200b/onboarding\u200b/onboarding\u200b/`\n\n### API\n\nThe plugin includes 4 API endpoints to manage the onbarding tasks\n\n```shell\nGET        /api/plugins\u200b/onboarding\u200b/onboarding\u200b/       Check status of all onboarding tasks.\nPOST    \u200b   /api/plugins\u200b/onboarding\u200b/onboarding\u200b/       Onboard a new device\nGET     \u200b   /api/plugins\u200b/onboarding\u200b/onboarding\u200b/{id}\u200b/  Check the status of a specific onboarding task\nDELETE    \u200b /api/plugins\u200b/onboarding\u200b/onboarding\u200b/{id}\u200b/  Delete a specific onboarding task\n```\n\n## Contributing\n\nPull requests are welcomed and automatically built and tested against multiple version of Python and multiple version of NetBox through TravisCI.\n\nThe project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.\n\nThe project is following Network to Code software development guideline and is leveraging:\n- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.\n- Django unit test to ensure the plugin is working properly.\n\n### CLI Helper Commands\n\nThe project is coming with a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`. \n\nEach command can be executed with `invoke <command>`. All commands support the arguments `--netbox-ver` and `--python-ver` if you want to manually define the version of Python and NetBox to use. Each command also has its own help `invoke <command> --help`\n\n#### Local dev environment\n```\n  build            Build all docker images.\n  debug            Start NetBox and its dependencies in debug mode.\n  destroy          Destroy all containers and volumes.\n  start            Start NetBox and its dependencies in detached mode.\n  stop             Stop NetBox and its dependencies.\n```\n\n#### Utility \n```\n  cli              Launch a bash shell inside the running NetBox container.\n  create-user      Create a new user in django (default: admin), will prompt for password.\n  makemigrations   Run Make Migration in Django.\n  nbshell          Launch a nbshell session.\n```\n#### Testing \n\n```\n  tests            Run all tests for this plugin.\n  pylint           Run pylint code analysis.\n  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.\n  bandit           Run bandit to validate basic static code security analysis.\n  black            Run black to check that Python files adhere to its style standards.\n  unittest         Run Django unit tests for the plugin.\n```\n\n## Questions\n\nFor any questions or comments, please check the [FAQ](FAQ.md) first and feel free to swing by the [Network to Code slack channel](https://networktocode.slack.com/) (channel #networktocode).\nSign up [here](http://slack.networktocode.com/)\n\n## Screenshots\n\nList of Onboarding Tasks\n![Onboarding Tasks](docs/images/onboarding_tasks_view.png)\n\nCSV form to import multiple devices\n![CSV Form](docs/images/csv_import_view.png)\n\nOnboard a single device\n![Single Device Form](docs/images/single_device_form.png)\n\nMenu \n![Menu](docs/images/menu.png)\n\n',
    'author': 'Network to Code, LLC',
    'author_email': 'info@networktocode.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/networktocode/ntc-netbox-plugin-onboarding',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
