# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['robotframework_zebrunner', 'robotframework_zebrunner.api']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.3.1,<6.0.0',
 'httpx>=0.22.0,<0.23.0',
 'pydantic>=1.0',
 'python-dotenv>=0.10',
 'robotframework-seleniumlibrary>=4.0.0',
 'robotframework>=3.2.2']

setup_kwargs = {
    'name': 'robotframework-zebrunner',
    'version': '0.1.4',
    'description': 'Robotframework connector for Zebrunner reporting',
    'long_description': "# python-agent-robot\n\nThe official Zebrunner Robotframework agent provides the reporting functionality. It can automatically track Selenium sessions\nand send the info about session details to Zebrunner backend. It can be easily integrated into a project by just installing the library\nand adding the configuration file.\n\nIncluding reporting into your project is easy - just install the agent and provide minimal valid configuration for reporting.\n\n\n## Installation\n\n    pip install robotframework-zebrunner\n\n\n## Configuration\nAfter the installation, reporting is disabled by default. It won't send any data to the Zebrunner service without a valid configuration.\n\nIt is currently possible to provide the configuration via:\n1. Environment variables\n2. YAML file\n\n`pyproject.toml`, `command arguments` are in plans for future releases.\n\n\n\n<!-- groups:start -->\n\n### Environment variables\nThe following configuration parameters are recognized by the agent:\n\n- `REPORTING_ENABLED` - enables or disables reporting. The default value is `true`.\n- `REPORTING_SERVER_HOSTNAME` - mandatory if reporting is enabled. It is Zebrunner server hostname. It can be obtained in Zebrunner on the 'Account & profile' page under the 'Service URL' section;\n- `REPORTING_SERVER_ACCESS_TOKEN` - mandatory if reporting is enabled. Access token must be used to perform API calls. It can be obtained in Zebrunner on the 'Account & profile' page under the 'Token' section;\n- `REPORTING_PROJECT_KEY` - optional value. It is the project that the test run belongs to. The default value is `DEF`. You can manage projects in Zebrunner in the appropriate section;\n- `REPORTING_RUN_DISPLAY_NAME` - optional value. It is the display name of the test run. The default value is `Default Suite`;\n- `REPORTING_RUN_BUILD` - optional value. It is the build number that is associated with the test run. It can depict either the test build number or the application build number;\n- `REPORTING_RUN_ENVIRONMENT` - optional value. It is the environment where the tests will run;\n- `REPORTING_SEND_LOGS` - Sends test logs to Zebrunner. Default: `true`;\n- `REPORTING_NOTIFICATION_NOTIFY_ON_EACH_FAILURE` - optional value. Specifies whether Zebrunner should send notification to Slack/Teams on each test failure. The notifications will be sent even if the suite is still running. The default value is `false`;\n- `REPORTING_NOTIFICATION_SLACK_CHANNELS` - optional value. The list of comma-separated Slack channels to send notifications to. Notification will be sent only if Slack integration is properly configured in Zebrunner with valid credentials for the project the tests are reported to. Zebrunner can send two type of notifications: on each test failure (if appropriate property is enabled) and on suite finish;\n- `REPORTING_NOTIFICATION_MS_TEAMS_CHANNELS` - optional value. The list of comma-separated Microsoft Teams channels to send notifications to. Notification will be sent only if Teams integration is configured in Zebrunner project with valid webhooks for the channels. Zebrunner can send two type of notifications: on each test failure (if appropriate property is enabled) and on suite finish;\n- `REPORTING_NOTIFICATION_EMAILS` - optional value. The list of comma-separated emails to send notifications to. This type of notification does not require further configuration on Zebrunner side. Unlike other notification mechanisms, Zebrunner can send emails only on suite finish;\n - `REPORTING_RUN_TREAT_SKIPS_AS_FAILURES` - optional value. If value is false all test-runs with skipped & passed tests\n would be marked as passed.\n\nAgent also recognizes `.env` file in the resources root folder.\n\n### Yaml file\nAgent recognizes agent.yaml or agent.yml file in the resources root folder. It is currently not possible to configure an alternative file location.\n\nBelow is a sample configuration file:\n```yaml\nreporting:\n  enabled: true\n  project-key: DEF\n  send-logs: true\n  server:\n    hostname: localhost:8080\n    access-token: <token>\n  notification:\n    notify-on-each-failure: true\n    slack-channels: automation, dev-team\n    ms-teams-channels: automation, qa-team\n    emails: example@example.com\n  run:\n    treat_skips_as_failures: false\n    display-name: Nightly Regression Suite\n    build: 1.12.1.96-SNAPSHOT\n    environment: TEST-1\n```\n\n- `reporting.enabled` - enables or disables reporting. The default value is `true`;\n- `reporting.server.hostname` - mandatory if reporting is enabled. Zebrunner server hostname. Can be obtained in Zebrunner on the 'Account & profile' page under the 'Service URL' section;\n- `reporting.server.access-token` - mandatory if reporting is enabled. Access token must be used to perform API calls. Can be obtained in Zebrunner on the 'Account & profile' page under the 'Token' section;\n- `reporting.project-key` - optional value. The project that the test run belongs to. The default value is `DEF`. You can manage projects in Zebrunner in the appropriate section;\n- `reporting.send-logs` - Sends test logs to Zebrunner. Default: `true`\n- `reporting.run.display-name` - optional value. The display name of the test run. The default value is Default Suite;\n- `reporting.run.build` - optional value. The build number that is associated with the test run. It can depict either the test build number or the application build number;\n- `reporting.run.environment` - optional value. The environment in which the tests will run.\n- `reporting.notification.notify-on-each-failure` - optional value. Specifies whether Zebrunner should send notification to Slack/Teams on each test failure. The notifications will be sent even if the suite is still running. The default value is `false`;\n- `reporting.notification.slack-channels` - optional value. The list of comma-separated Slack channels to send notifications to. Notification will be sent only if Slack integration is properly configured in Zebrunner with valid credentials for the project the tests are reported to. Zebrunner can send two type of notifications: on each test failure (if appropriate property is enabled) and on suite finish;\n- `reporting.notification.ms-teams-channels` - optional value. The list of comma-separated Microsoft Teams channels to send notifications to. Notification will be sent only if Teams integration is configured in Zebrunner project with valid webhooks for the channels. Zebrunner can send two type of notifications: on each test failure (if appropriate property is enabled) and on suite finish;\n- `reporting.notification.emails` - optional value. The list of comma-separated emails to send notifications to. This type of notification does not require further configuration on Zebrunner side. Unlike other notification mechanisms, Zebrunner can send emails only on suite finish;\n - `reporting.run.treat_skips_as_failures` - optional value. If value is false all test-runs with skipped & passed tests\n would be marked as passed.\n\nIf the required configurations are not provided, there is a warning displayed in logs with the problem description and the names of options\nwhich need to be specified. Parameter names are case insensitive and can be written in upper and lower registers.\n\n<!-- groups:end -->\n\n### Activate listener\n\nThere is two options for activation of Zebrunner listener.\n\nCommand line argument:\n```bash\nrobot --listener robotframework_zebrunner.ZebrunnerListener ...\n```\n\nImport Zebrunner library into your project:\n```\nLibrary  robotframework_zebrunner.ZebrunnerLib\n```\n",
    'author': 'Anatoliy Platonov',
    'author_email': 'platonoff.dev@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://zebrunner.com/documentation/agents/robot',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
