"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceCatalogDeployActionBeta1 = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const action_1 = require("../action");
/**
 * CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * @stability stable
 */
class ServiceCatalogDeployActionBeta1 extends action_1.Action {
    /**
     * @stability stable
     */
    constructor(props) {
        super({
            ...props,
            provider: 'ServiceCatalog',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.templatePath.artifact],
        });
        jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_actions_ServiceCatalogDeployActionBeta1Props(props);
        this.templatePath = props.templatePath.fileName;
        this.productVersionName = props.productVersionName;
        this.productVersionDescription = props.productVersionDescription;
        this.productId = props.productId;
        this.productType = 'CLOUD_FORMATION_TEMPLATE';
    }
    /**
     * This is a renamed version of the {@link IAction.bind} method.
     *
     * @stability stable
     */
    bound(_scope, _stage, options) {
        options.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSServiceCatalogAdminFullAccess'));
        // Attempt at least privilege; using this alone fails with "invalid template".
        // Should construct ARN: 'arn:aws:catalog:<region>:<accountID>:product/' + this.scProductId
        // options.role.addToPolicy(new PolicyStatement({
        //   resources: ['*'],
        //   actions: ['servicecatalog:UpdateProduct', 'servicecatalog:ListProvisioningArtifacts', 'servicecatalog:CreateProvisioningArtifact'],
        // }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                TemplateFilePath: this.templatePath,
                ProductVersionName: this.productVersionName,
                ProductVersionDescription: this.productVersionDescription,
                ProductType: this.productType,
                ProductId: this.productId,
            },
        };
    }
}
exports.ServiceCatalogDeployActionBeta1 = ServiceCatalogDeployActionBeta1;
_a = JSII_RTTI_SYMBOL_1;
ServiceCatalogDeployActionBeta1[_a] = { fqn: "@aws-cdk/aws-codepipeline-actions.ServiceCatalogDeployActionBeta1", version: "1.143.0" };
//# sourceMappingURL=data:application/json;base64,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