# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Policy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'default_fork_evict_ram': 'bool',
        'default_non_sharded_proxy_policy': 'str',
        'default_sharded_proxy_policy': 'str',
        'default_shards_placement': 'str',
        'rack_aware': 'bool',
        'shards_overbooking': 'bool'
    }

    attribute_map = {
        'default_fork_evict_ram': 'default_fork_evict_ram',
        'default_non_sharded_proxy_policy': 'default_non_sharded_proxy_policy',
        'default_sharded_proxy_policy': 'default_sharded_proxy_policy',
        'default_shards_placement': 'default_shards_placement',
        'rack_aware': 'rack_aware',
        'shards_overbooking': 'shards_overbooking'
    }

    def __init__(self, default_fork_evict_ram=False, default_non_sharded_proxy_policy='single', default_sharded_proxy_policy='all-master-shards', default_shards_placement=None, rack_aware=None, shards_overbooking=True):  # noqa: E501
        """Policy - a model defined in Swagger"""  # noqa: E501
        self._default_fork_evict_ram = None
        self._default_non_sharded_proxy_policy = None
        self._default_sharded_proxy_policy = None
        self._default_shards_placement = None
        self._rack_aware = None
        self._shards_overbooking = None
        self.discriminator = None
        if default_fork_evict_ram is not None:
            self.default_fork_evict_ram = default_fork_evict_ram
        if default_non_sharded_proxy_policy is not None:
            self.default_non_sharded_proxy_policy = default_non_sharded_proxy_policy
        if default_sharded_proxy_policy is not None:
            self.default_sharded_proxy_policy = default_sharded_proxy_policy
        if default_shards_placement is not None:
            self.default_shards_placement = default_shards_placement
        if rack_aware is not None:
            self.rack_aware = rack_aware
        if shards_overbooking is not None:
            self.shards_overbooking = shards_overbooking

    @property
    def default_fork_evict_ram(self):
        """Gets the default_fork_evict_ram of this Policy.  # noqa: E501

        If true, the bdb's should evict data from ram in order to succeed replication or persistency  # noqa: E501

        :return: The default_fork_evict_ram of this Policy.  # noqa: E501
        :rtype: bool
        """
        return self._default_fork_evict_ram

    @default_fork_evict_ram.setter
    def default_fork_evict_ram(self, default_fork_evict_ram):
        """Sets the default_fork_evict_ram of this Policy.

        If true, the bdb's should evict data from ram in order to succeed replication or persistency  # noqa: E501

        :param default_fork_evict_ram: The default_fork_evict_ram of this Policy.  # noqa: E501
        :type: bool
        """

        self._default_fork_evict_ram = default_fork_evict_ram

    @property
    def default_non_sharded_proxy_policy(self):
        """Gets the default_non_sharded_proxy_policy of this Policy.  # noqa: E501

        Default proxy_policy for newly-created non sharded databases' endpoints  # noqa: E501

        :return: The default_non_sharded_proxy_policy of this Policy.  # noqa: E501
        :rtype: str
        """
        return self._default_non_sharded_proxy_policy

    @default_non_sharded_proxy_policy.setter
    def default_non_sharded_proxy_policy(self, default_non_sharded_proxy_policy):
        """Sets the default_non_sharded_proxy_policy of this Policy.

        Default proxy_policy for newly-created non sharded databases' endpoints  # noqa: E501

        :param default_non_sharded_proxy_policy: The default_non_sharded_proxy_policy of this Policy.  # noqa: E501
        :type: str
        """
        allowed_values = ["single", "all-master-shards", "all-nodes"]  # noqa: E501
        if default_non_sharded_proxy_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `default_non_sharded_proxy_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(default_non_sharded_proxy_policy, allowed_values)
            )

        self._default_non_sharded_proxy_policy = default_non_sharded_proxy_policy

    @property
    def default_sharded_proxy_policy(self):
        """Gets the default_sharded_proxy_policy of this Policy.  # noqa: E501

        Default proxy_policy for newly-created sharded databases' endpoints  # noqa: E501

        :return: The default_sharded_proxy_policy of this Policy.  # noqa: E501
        :rtype: str
        """
        return self._default_sharded_proxy_policy

    @default_sharded_proxy_policy.setter
    def default_sharded_proxy_policy(self, default_sharded_proxy_policy):
        """Sets the default_sharded_proxy_policy of this Policy.

        Default proxy_policy for newly-created sharded databases' endpoints  # noqa: E501

        :param default_sharded_proxy_policy: The default_sharded_proxy_policy of this Policy.  # noqa: E501
        :type: str
        """
        allowed_values = ["single", "all-master-shards", "all-nodes"]  # noqa: E501
        if default_sharded_proxy_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `default_sharded_proxy_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(default_sharded_proxy_policy, allowed_values)
            )

        self._default_sharded_proxy_policy = default_sharded_proxy_policy

    @property
    def default_shards_placement(self):
        """Gets the default_shards_placement of this Policy.  # noqa: E501

        Default shards_placement for newly-created databases  # noqa: E501

        :return: The default_shards_placement of this Policy.  # noqa: E501
        :rtype: str
        """
        return self._default_shards_placement

    @default_shards_placement.setter
    def default_shards_placement(self, default_shards_placement):
        """Sets the default_shards_placement of this Policy.

        Default shards_placement for newly-created databases  # noqa: E501

        :param default_shards_placement: The default_shards_placement of this Policy.  # noqa: E501
        :type: str
        """
        allowed_values = ["sparse", "dense"]  # noqa: E501
        if default_shards_placement not in allowed_values:
            raise ValueError(
                "Invalid value for `default_shards_placement` ({0}), must be one of {1}"  # noqa: E501
                .format(default_shards_placement, allowed_values)
            )

        self._default_shards_placement = default_shards_placement

    @property
    def rack_aware(self):
        """Gets the rack_aware of this Policy.  # noqa: E501

        Cluster rack awareness.  # noqa: E501

        :return: The rack_aware of this Policy.  # noqa: E501
        :rtype: bool
        """
        return self._rack_aware

    @rack_aware.setter
    def rack_aware(self, rack_aware):
        """Sets the rack_aware of this Policy.

        Cluster rack awareness.  # noqa: E501

        :param rack_aware: The rack_aware of this Policy.  # noqa: E501
        :type: bool
        """

        self._rack_aware = rack_aware

    @property
    def shards_overbooking(self):
        """Gets the shards_overbooking of this Policy.  # noqa: E501

        If true, all bdbs' memory_size is ignored during shards placement  # noqa: E501

        :return: The shards_overbooking of this Policy.  # noqa: E501
        :rtype: bool
        """
        return self._shards_overbooking

    @shards_overbooking.setter
    def shards_overbooking(self, shards_overbooking):
        """Sets the shards_overbooking of this Policy.

        If true, all bdbs' memory_size is ignored during shards placement  # noqa: E501

        :param shards_overbooking: The shards_overbooking of this Policy.  # noqa: E501
        :type: bool
        """

        self._shards_overbooking = shards_overbooking

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Policy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Policy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
