# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class DbAlertsSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bdb_backup_delayed': 'AllOfdbAlertsSettingsBdbBackupDelayed',
        'bdb_crdt_src_high_syncer_lag': 'AllOfdbAlertsSettingsBdbCrdtSrcHighSyncerLag',
        'bdb_crdt_src_syncer_connection_error': 'AllOfdbAlertsSettingsBdbCrdtSrcSyncerConnectionError',
        'bdb_crdt_src_syncer_general_error': 'AllOfdbAlertsSettingsBdbCrdtSrcSyncerGeneralError',
        'bdb_high_latency': 'AllOfdbAlertsSettingsBdbHighLatency',
        'bdb_high_syncer_lag': 'AllOfdbAlertsSettingsBdbHighSyncerLag',
        'bdb_high_throughput': 'AllOfdbAlertsSettingsBdbHighThroughput',
        'bdb_long_running_action': 'AllOfdbAlertsSettingsBdbLongRunningAction',
        'bdb_low_throughput': 'AllOfdbAlertsSettingsBdbLowThroughput',
        'bdb_ram_dataset_overhead': 'AllOfdbAlertsSettingsBdbRamDatasetOverhead',
        'bdb_ram_values': 'AllOfdbAlertsSettingsBdbRamValues',
        'bdb_replica_src_high_syncer_lag': 'AllOfdbAlertsSettingsBdbReplicaSrcHighSyncerLag',
        'bdb_replica_src_syncer_connection_error': 'AllOfdbAlertsSettingsBdbReplicaSrcSyncerConnectionError',
        'bdb_replica_src_syncer_general_error': 'AllOfdbAlertsSettingsBdbReplicaSrcSyncerGeneralError',
        'bdb_shard_num_ram_values': 'AllOfdbAlertsSettingsBdbShardNumRamValues',
        'bdb_size': 'AllOfdbAlertsSettingsBdbSize',
        'bdb_syncer_connection_error': 'AllOfdbAlertsSettingsBdbSyncerConnectionError',
        'bdb_syncer_general_error': 'AllOfdbAlertsSettingsBdbSyncerGeneralError'
    }

    attribute_map = {
        'bdb_backup_delayed': 'bdb_backup_delayed',
        'bdb_crdt_src_high_syncer_lag': 'bdb_crdt_src_high_syncer_lag',
        'bdb_crdt_src_syncer_connection_error': 'bdb_crdt_src_syncer_connection_error',
        'bdb_crdt_src_syncer_general_error': 'bdb_crdt_src_syncer_general_error',
        'bdb_high_latency': 'bdb_high_latency',
        'bdb_high_syncer_lag': 'bdb_high_syncer_lag',
        'bdb_high_throughput': 'bdb_high_throughput',
        'bdb_long_running_action': 'bdb_long_running_action',
        'bdb_low_throughput': 'bdb_low_throughput',
        'bdb_ram_dataset_overhead': 'bdb_ram_dataset_overhead',
        'bdb_ram_values': 'bdb_ram_values',
        'bdb_replica_src_high_syncer_lag': 'bdb_replica_src_high_syncer_lag',
        'bdb_replica_src_syncer_connection_error': 'bdb_replica_src_syncer_connection_error',
        'bdb_replica_src_syncer_general_error': 'bdb_replica_src_syncer_general_error',
        'bdb_shard_num_ram_values': 'bdb_shard_num_ram_values',
        'bdb_size': 'bdb_size',
        'bdb_syncer_connection_error': 'bdb_syncer_connection_error',
        'bdb_syncer_general_error': 'bdb_syncer_general_error'
    }

    def __init__(self, bdb_backup_delayed=None, bdb_crdt_src_high_syncer_lag=None, bdb_crdt_src_syncer_connection_error=None, bdb_crdt_src_syncer_general_error=None, bdb_high_latency=None, bdb_high_syncer_lag=None, bdb_high_throughput=None, bdb_long_running_action=None, bdb_low_throughput=None, bdb_ram_dataset_overhead=None, bdb_ram_values=None, bdb_replica_src_high_syncer_lag=None, bdb_replica_src_syncer_connection_error=None, bdb_replica_src_syncer_general_error=None, bdb_shard_num_ram_values=None, bdb_size=None, bdb_syncer_connection_error=None, bdb_syncer_general_error=None):  # noqa: E501
        """DbAlertsSettings - a model defined in Swagger"""  # noqa: E501
        self._bdb_backup_delayed = None
        self._bdb_crdt_src_high_syncer_lag = None
        self._bdb_crdt_src_syncer_connection_error = None
        self._bdb_crdt_src_syncer_general_error = None
        self._bdb_high_latency = None
        self._bdb_high_syncer_lag = None
        self._bdb_high_throughput = None
        self._bdb_long_running_action = None
        self._bdb_low_throughput = None
        self._bdb_ram_dataset_overhead = None
        self._bdb_ram_values = None
        self._bdb_replica_src_high_syncer_lag = None
        self._bdb_replica_src_syncer_connection_error = None
        self._bdb_replica_src_syncer_general_error = None
        self._bdb_shard_num_ram_values = None
        self._bdb_size = None
        self._bdb_syncer_connection_error = None
        self._bdb_syncer_general_error = None
        self.discriminator = None
        if bdb_backup_delayed is not None:
            self.bdb_backup_delayed = bdb_backup_delayed
        if bdb_crdt_src_high_syncer_lag is not None:
            self.bdb_crdt_src_high_syncer_lag = bdb_crdt_src_high_syncer_lag
        if bdb_crdt_src_syncer_connection_error is not None:
            self.bdb_crdt_src_syncer_connection_error = bdb_crdt_src_syncer_connection_error
        if bdb_crdt_src_syncer_general_error is not None:
            self.bdb_crdt_src_syncer_general_error = bdb_crdt_src_syncer_general_error
        if bdb_high_latency is not None:
            self.bdb_high_latency = bdb_high_latency
        if bdb_high_syncer_lag is not None:
            self.bdb_high_syncer_lag = bdb_high_syncer_lag
        if bdb_high_throughput is not None:
            self.bdb_high_throughput = bdb_high_throughput
        if bdb_long_running_action is not None:
            self.bdb_long_running_action = bdb_long_running_action
        if bdb_low_throughput is not None:
            self.bdb_low_throughput = bdb_low_throughput
        if bdb_ram_dataset_overhead is not None:
            self.bdb_ram_dataset_overhead = bdb_ram_dataset_overhead
        if bdb_ram_values is not None:
            self.bdb_ram_values = bdb_ram_values
        if bdb_replica_src_high_syncer_lag is not None:
            self.bdb_replica_src_high_syncer_lag = bdb_replica_src_high_syncer_lag
        if bdb_replica_src_syncer_connection_error is not None:
            self.bdb_replica_src_syncer_connection_error = bdb_replica_src_syncer_connection_error
        if bdb_replica_src_syncer_general_error is not None:
            self.bdb_replica_src_syncer_general_error = bdb_replica_src_syncer_general_error
        if bdb_shard_num_ram_values is not None:
            self.bdb_shard_num_ram_values = bdb_shard_num_ram_values
        if bdb_size is not None:
            self.bdb_size = bdb_size
        if bdb_syncer_connection_error is not None:
            self.bdb_syncer_connection_error = bdb_syncer_connection_error
        if bdb_syncer_general_error is not None:
            self.bdb_syncer_general_error = bdb_syncer_general_error

    @property
    def bdb_backup_delayed(self):
        """Gets the bdb_backup_delayed of this DbAlertsSettings.  # noqa: E501

        Periodic backup has been delayed for longer than specified threshold value [minutes]  # noqa: E501

        :return: The bdb_backup_delayed of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbBackupDelayed
        """
        return self._bdb_backup_delayed

    @bdb_backup_delayed.setter
    def bdb_backup_delayed(self, bdb_backup_delayed):
        """Sets the bdb_backup_delayed of this DbAlertsSettings.

        Periodic backup has been delayed for longer than specified threshold value [minutes]  # noqa: E501

        :param bdb_backup_delayed: The bdb_backup_delayed of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbBackupDelayed
        """

        self._bdb_backup_delayed = bdb_backup_delayed

    @property
    def bdb_crdt_src_high_syncer_lag(self):
        """Gets the bdb_crdt_src_high_syncer_lag of this DbAlertsSettings.  # noqa: E501

        CRDB source - sync lag is higher than specified threshold value [seconds]  # noqa: E501

        :return: The bdb_crdt_src_high_syncer_lag of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbCrdtSrcHighSyncerLag
        """
        return self._bdb_crdt_src_high_syncer_lag

    @bdb_crdt_src_high_syncer_lag.setter
    def bdb_crdt_src_high_syncer_lag(self, bdb_crdt_src_high_syncer_lag):
        """Sets the bdb_crdt_src_high_syncer_lag of this DbAlertsSettings.

        CRDB source - sync lag is higher than specified threshold value [seconds]  # noqa: E501

        :param bdb_crdt_src_high_syncer_lag: The bdb_crdt_src_high_syncer_lag of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbCrdtSrcHighSyncerLag
        """

        self._bdb_crdt_src_high_syncer_lag = bdb_crdt_src_high_syncer_lag

    @property
    def bdb_crdt_src_syncer_connection_error(self):
        """Gets the bdb_crdt_src_syncer_connection_error of this DbAlertsSettings.  # noqa: E501

        CRDB source - sync has connection error while trying to connect replica source  # noqa: E501

        :return: The bdb_crdt_src_syncer_connection_error of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbCrdtSrcSyncerConnectionError
        """
        return self._bdb_crdt_src_syncer_connection_error

    @bdb_crdt_src_syncer_connection_error.setter
    def bdb_crdt_src_syncer_connection_error(self, bdb_crdt_src_syncer_connection_error):
        """Sets the bdb_crdt_src_syncer_connection_error of this DbAlertsSettings.

        CRDB source - sync has connection error while trying to connect replica source  # noqa: E501

        :param bdb_crdt_src_syncer_connection_error: The bdb_crdt_src_syncer_connection_error of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbCrdtSrcSyncerConnectionError
        """

        self._bdb_crdt_src_syncer_connection_error = bdb_crdt_src_syncer_connection_error

    @property
    def bdb_crdt_src_syncer_general_error(self):
        """Gets the bdb_crdt_src_syncer_general_error of this DbAlertsSettings.  # noqa: E501

        CRDB - sync encountered in general error  # noqa: E501

        :return: The bdb_crdt_src_syncer_general_error of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbCrdtSrcSyncerGeneralError
        """
        return self._bdb_crdt_src_syncer_general_error

    @bdb_crdt_src_syncer_general_error.setter
    def bdb_crdt_src_syncer_general_error(self, bdb_crdt_src_syncer_general_error):
        """Sets the bdb_crdt_src_syncer_general_error of this DbAlertsSettings.

        CRDB - sync encountered in general error  # noqa: E501

        :param bdb_crdt_src_syncer_general_error: The bdb_crdt_src_syncer_general_error of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbCrdtSrcSyncerGeneralError
        """

        self._bdb_crdt_src_syncer_general_error = bdb_crdt_src_syncer_general_error

    @property
    def bdb_high_latency(self):
        """Gets the bdb_high_latency of this DbAlertsSettings.  # noqa: E501

        Latency is higher than specified threshold value [micro-sec]  # noqa: E501

        :return: The bdb_high_latency of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbHighLatency
        """
        return self._bdb_high_latency

    @bdb_high_latency.setter
    def bdb_high_latency(self, bdb_high_latency):
        """Sets the bdb_high_latency of this DbAlertsSettings.

        Latency is higher than specified threshold value [micro-sec]  # noqa: E501

        :param bdb_high_latency: The bdb_high_latency of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbHighLatency
        """

        self._bdb_high_latency = bdb_high_latency

    @property
    def bdb_high_syncer_lag(self):
        """Gets the bdb_high_syncer_lag of this DbAlertsSettings.  # noqa: E501

        (Deprecated) Replica of - sync lag is higher than specified threshold value [seconds]  # noqa: E501

        :return: The bdb_high_syncer_lag of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbHighSyncerLag
        """
        return self._bdb_high_syncer_lag

    @bdb_high_syncer_lag.setter
    def bdb_high_syncer_lag(self, bdb_high_syncer_lag):
        """Sets the bdb_high_syncer_lag of this DbAlertsSettings.

        (Deprecated) Replica of - sync lag is higher than specified threshold value [seconds]  # noqa: E501

        :param bdb_high_syncer_lag: The bdb_high_syncer_lag of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbHighSyncerLag
        """

        self._bdb_high_syncer_lag = bdb_high_syncer_lag

    @property
    def bdb_high_throughput(self):
        """Gets the bdb_high_throughput of this DbAlertsSettings.  # noqa: E501

        Throughput is higher than specified threshold value [requests / sec.]  # noqa: E501

        :return: The bdb_high_throughput of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbHighThroughput
        """
        return self._bdb_high_throughput

    @bdb_high_throughput.setter
    def bdb_high_throughput(self, bdb_high_throughput):
        """Sets the bdb_high_throughput of this DbAlertsSettings.

        Throughput is higher than specified threshold value [requests / sec.]  # noqa: E501

        :param bdb_high_throughput: The bdb_high_throughput of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbHighThroughput
        """

        self._bdb_high_throughput = bdb_high_throughput

    @property
    def bdb_long_running_action(self):
        """Gets the bdb_long_running_action of this DbAlertsSettings.  # noqa: E501

        An alert for state-machines that are running for too long  # noqa: E501

        :return: The bdb_long_running_action of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbLongRunningAction
        """
        return self._bdb_long_running_action

    @bdb_long_running_action.setter
    def bdb_long_running_action(self, bdb_long_running_action):
        """Sets the bdb_long_running_action of this DbAlertsSettings.

        An alert for state-machines that are running for too long  # noqa: E501

        :param bdb_long_running_action: The bdb_long_running_action of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbLongRunningAction
        """

        self._bdb_long_running_action = bdb_long_running_action

    @property
    def bdb_low_throughput(self):
        """Gets the bdb_low_throughput of this DbAlertsSettings.  # noqa: E501

        Throughput is lower than specified threshold value [requests / sec.]  # noqa: E501

        :return: The bdb_low_throughput of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbLowThroughput
        """
        return self._bdb_low_throughput

    @bdb_low_throughput.setter
    def bdb_low_throughput(self, bdb_low_throughput):
        """Sets the bdb_low_throughput of this DbAlertsSettings.

        Throughput is lower than specified threshold value [requests / sec.]  # noqa: E501

        :param bdb_low_throughput: The bdb_low_throughput of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbLowThroughput
        """

        self._bdb_low_throughput = bdb_low_throughput

    @property
    def bdb_ram_dataset_overhead(self):
        """Gets the bdb_ram_dataset_overhead of this DbAlertsSettings.  # noqa: E501

        Dataset RAM overhead of a shard has reached the threshold value [% of its RAM limit]  # noqa: E501

        :return: The bdb_ram_dataset_overhead of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbRamDatasetOverhead
        """
        return self._bdb_ram_dataset_overhead

    @bdb_ram_dataset_overhead.setter
    def bdb_ram_dataset_overhead(self, bdb_ram_dataset_overhead):
        """Sets the bdb_ram_dataset_overhead of this DbAlertsSettings.

        Dataset RAM overhead of a shard has reached the threshold value [% of its RAM limit]  # noqa: E501

        :param bdb_ram_dataset_overhead: The bdb_ram_dataset_overhead of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbRamDatasetOverhead
        """

        self._bdb_ram_dataset_overhead = bdb_ram_dataset_overhead

    @property
    def bdb_ram_values(self):
        """Gets the bdb_ram_values of this DbAlertsSettings.  # noqa: E501

        Percent of values kept in a shard's RAM is lower than [% of its key count]  # noqa: E501

        :return: The bdb_ram_values of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbRamValues
        """
        return self._bdb_ram_values

    @bdb_ram_values.setter
    def bdb_ram_values(self, bdb_ram_values):
        """Sets the bdb_ram_values of this DbAlertsSettings.

        Percent of values kept in a shard's RAM is lower than [% of its key count]  # noqa: E501

        :param bdb_ram_values: The bdb_ram_values of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbRamValues
        """

        self._bdb_ram_values = bdb_ram_values

    @property
    def bdb_replica_src_high_syncer_lag(self):
        """Gets the bdb_replica_src_high_syncer_lag of this DbAlertsSettings.  # noqa: E501

        Replica-of source - sync lag is higher than specified threshold value [seconds]  # noqa: E501

        :return: The bdb_replica_src_high_syncer_lag of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbReplicaSrcHighSyncerLag
        """
        return self._bdb_replica_src_high_syncer_lag

    @bdb_replica_src_high_syncer_lag.setter
    def bdb_replica_src_high_syncer_lag(self, bdb_replica_src_high_syncer_lag):
        """Sets the bdb_replica_src_high_syncer_lag of this DbAlertsSettings.

        Replica-of source - sync lag is higher than specified threshold value [seconds]  # noqa: E501

        :param bdb_replica_src_high_syncer_lag: The bdb_replica_src_high_syncer_lag of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbReplicaSrcHighSyncerLag
        """

        self._bdb_replica_src_high_syncer_lag = bdb_replica_src_high_syncer_lag

    @property
    def bdb_replica_src_syncer_connection_error(self):
        """Gets the bdb_replica_src_syncer_connection_error of this DbAlertsSettings.  # noqa: E501

        Replica-of source - sync has connection error while trying to connect replica source  # noqa: E501

        :return: The bdb_replica_src_syncer_connection_error of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbReplicaSrcSyncerConnectionError
        """
        return self._bdb_replica_src_syncer_connection_error

    @bdb_replica_src_syncer_connection_error.setter
    def bdb_replica_src_syncer_connection_error(self, bdb_replica_src_syncer_connection_error):
        """Sets the bdb_replica_src_syncer_connection_error of this DbAlertsSettings.

        Replica-of source - sync has connection error while trying to connect replica source  # noqa: E501

        :param bdb_replica_src_syncer_connection_error: The bdb_replica_src_syncer_connection_error of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbReplicaSrcSyncerConnectionError
        """

        self._bdb_replica_src_syncer_connection_error = bdb_replica_src_syncer_connection_error

    @property
    def bdb_replica_src_syncer_general_error(self):
        """Gets the bdb_replica_src_syncer_general_error of this DbAlertsSettings.  # noqa: E501

        Replica-of - sync encountered in general error  # noqa: E501

        :return: The bdb_replica_src_syncer_general_error of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbReplicaSrcSyncerGeneralError
        """
        return self._bdb_replica_src_syncer_general_error

    @bdb_replica_src_syncer_general_error.setter
    def bdb_replica_src_syncer_general_error(self, bdb_replica_src_syncer_general_error):
        """Sets the bdb_replica_src_syncer_general_error of this DbAlertsSettings.

        Replica-of - sync encountered in general error  # noqa: E501

        :param bdb_replica_src_syncer_general_error: The bdb_replica_src_syncer_general_error of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbReplicaSrcSyncerGeneralError
        """

        self._bdb_replica_src_syncer_general_error = bdb_replica_src_syncer_general_error

    @property
    def bdb_shard_num_ram_values(self):
        """Gets the bdb_shard_num_ram_values of this DbAlertsSettings.  # noqa: E501

        Number of values kept in a shard's RAM is lower than [values]  # noqa: E501

        :return: The bdb_shard_num_ram_values of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbShardNumRamValues
        """
        return self._bdb_shard_num_ram_values

    @bdb_shard_num_ram_values.setter
    def bdb_shard_num_ram_values(self, bdb_shard_num_ram_values):
        """Sets the bdb_shard_num_ram_values of this DbAlertsSettings.

        Number of values kept in a shard's RAM is lower than [values]  # noqa: E501

        :param bdb_shard_num_ram_values: The bdb_shard_num_ram_values of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbShardNumRamValues
        """

        self._bdb_shard_num_ram_values = bdb_shard_num_ram_values

    @property
    def bdb_size(self):
        """Gets the bdb_size of this DbAlertsSettings.  # noqa: E501

        Dataset size has reached the threshold value [% of the memory limit]  # noqa: E501

        :return: The bdb_size of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbSize
        """
        return self._bdb_size

    @bdb_size.setter
    def bdb_size(self, bdb_size):
        """Sets the bdb_size of this DbAlertsSettings.

        Dataset size has reached the threshold value [% of the memory limit]  # noqa: E501

        :param bdb_size: The bdb_size of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbSize
        """

        self._bdb_size = bdb_size

    @property
    def bdb_syncer_connection_error(self):
        """Gets the bdb_syncer_connection_error of this DbAlertsSettings.  # noqa: E501

        (Deprecated) Replica of - sync has connection error while trying to connect replica source  # noqa: E501

        :return: The bdb_syncer_connection_error of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbSyncerConnectionError
        """
        return self._bdb_syncer_connection_error

    @bdb_syncer_connection_error.setter
    def bdb_syncer_connection_error(self, bdb_syncer_connection_error):
        """Sets the bdb_syncer_connection_error of this DbAlertsSettings.

        (Deprecated) Replica of - sync has connection error while trying to connect replica source  # noqa: E501

        :param bdb_syncer_connection_error: The bdb_syncer_connection_error of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbSyncerConnectionError
        """

        self._bdb_syncer_connection_error = bdb_syncer_connection_error

    @property
    def bdb_syncer_general_error(self):
        """Gets the bdb_syncer_general_error of this DbAlertsSettings.  # noqa: E501

        (Deprecated) Replica of - sync encountered in general error  # noqa: E501

        :return: The bdb_syncer_general_error of this DbAlertsSettings.  # noqa: E501
        :rtype: AllOfdbAlertsSettingsBdbSyncerGeneralError
        """
        return self._bdb_syncer_general_error

    @bdb_syncer_general_error.setter
    def bdb_syncer_general_error(self, bdb_syncer_general_error):
        """Sets the bdb_syncer_general_error of this DbAlertsSettings.

        (Deprecated) Replica of - sync encountered in general error  # noqa: E501

        :param bdb_syncer_general_error: The bdb_syncer_general_error of this DbAlertsSettings.  # noqa: E501
        :type: AllOfdbAlertsSettingsBdbSyncerGeneralError
        """

        self._bdb_syncer_general_error = bdb_syncer_general_error

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(DbAlertsSettings, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DbAlertsSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
