# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Crdb(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'guid': 'str',
        'name': 'str',
        'encryption': 'bool',
        'default_db_config': 'Bdb',
        'local_databases': 'list[CrdbLocalDatabases]',
        'instances': 'list[InstanceInfo]',
        'causal_consistency': 'bool',
        'featureset_version': 'int',
        'protocol_version': 'int'
    }

    attribute_map = {
        'guid': 'guid',
        'name': 'name',
        'encryption': 'encryption',
        'default_db_config': 'default_db_config',
        'local_databases': 'local_databases',
        'instances': 'instances',
        'causal_consistency': 'causal_consistency',
        'featureset_version': 'featureset_version',
        'protocol_version': 'protocol_version'
    }

    def __init__(self, guid=None, name=None, encryption=False, default_db_config=None, local_databases=None, instances=None, causal_consistency=False, featureset_version=None, protocol_version=None):  # noqa: E501
        """Crdb - a model defined in Swagger"""  # noqa: E501
        self._guid = None
        self._name = None
        self._encryption = None
        self._default_db_config = None
        self._local_databases = None
        self._instances = None
        self._causal_consistency = None
        self._featureset_version = None
        self._protocol_version = None
        self.discriminator = None
        if guid is not None:
            self.guid = guid
        if name is not None:
            self.name = name
        if encryption is not None:
            self.encryption = encryption
        if default_db_config is not None:
            self.default_db_config = default_db_config
        if local_databases is not None:
            self.local_databases = local_databases
        if instances is not None:
            self.instances = instances
        if causal_consistency is not None:
            self.causal_consistency = causal_consistency
        if featureset_version is not None:
            self.featureset_version = featureset_version
        if protocol_version is not None:
            self.protocol_version = protocol_version

    @property
    def guid(self):
        """Gets the guid of this Crdb.  # noqa: E501

        The GUID of the Active-Active database.  # noqa: E501

        :return: The guid of this Crdb.  # noqa: E501
        :rtype: str
        """
        return self._guid

    @guid.setter
    def guid(self, guid):
        """Sets the guid of this Crdb.

        The GUID of the Active-Active database.  # noqa: E501

        :param guid: The guid of this Crdb.  # noqa: E501
        :type: str
        """

        self._guid = guid

    @property
    def name(self):
        """Gets the name of this Crdb.  # noqa: E501

        Name of Active-Active database.  # noqa: E501

        :return: The name of this Crdb.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Crdb.

        Name of Active-Active database.  # noqa: E501

        :param name: The name of this Crdb.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def encryption(self):
        """Gets the encryption of this Crdb.  # noqa: E501

        Encrypt communication  # noqa: E501

        :return: The encryption of this Crdb.  # noqa: E501
        :rtype: bool
        """
        return self._encryption

    @encryption.setter
    def encryption(self, encryption):
        """Sets the encryption of this Crdb.

        Encrypt communication  # noqa: E501

        :param encryption: The encryption of this Crdb.  # noqa: E501
        :type: bool
        """

        self._encryption = encryption

    @property
    def default_db_config(self):
        """Gets the default_db_config of this Crdb.  # noqa: E501


        :return: The default_db_config of this Crdb.  # noqa: E501
        :rtype: Bdb
        """
        return self._default_db_config

    @default_db_config.setter
    def default_db_config(self, default_db_config):
        """Sets the default_db_config of this Crdb.


        :param default_db_config: The default_db_config of this Crdb.  # noqa: E501
        :type: Bdb
        """

        self._default_db_config = default_db_config

    @property
    def local_databases(self):
        """Gets the local_databases of this Crdb.  # noqa: E501

        Mapping of instance IDs for local databases to local BDB IDs.  # noqa: E501

        :return: The local_databases of this Crdb.  # noqa: E501
        :rtype: list[CrdbLocalDatabases]
        """
        return self._local_databases

    @local_databases.setter
    def local_databases(self, local_databases):
        """Sets the local_databases of this Crdb.

        Mapping of instance IDs for local databases to local BDB IDs.  # noqa: E501

        :param local_databases: The local_databases of this Crdb.  # noqa: E501
        :type: list[CrdbLocalDatabases]
        """

        self._local_databases = local_databases

    @property
    def instances(self):
        """Gets the instances of this Crdb.  # noqa: E501


        :return: The instances of this Crdb.  # noqa: E501
        :rtype: list[InstanceInfo]
        """
        return self._instances

    @instances.setter
    def instances(self, instances):
        """Sets the instances of this Crdb.


        :param instances: The instances of this Crdb.  # noqa: E501
        :type: list[InstanceInfo]
        """

        self._instances = instances

    @property
    def causal_consistency(self):
        """Gets the causal_consistency of this Crdb.  # noqa: E501

        Enables causal consistency across crdt instances  # noqa: E501

        :return: The causal_consistency of this Crdb.  # noqa: E501
        :rtype: bool
        """
        return self._causal_consistency

    @causal_consistency.setter
    def causal_consistency(self, causal_consistency):
        """Sets the causal_consistency of this Crdb.

        Enables causal consistency across crdt instances  # noqa: E501

        :param causal_consistency: The causal_consistency of this Crdb.  # noqa: E501
        :type: bool
        """

        self._causal_consistency = causal_consistency

    @property
    def featureset_version(self):
        """Gets the featureset_version of this Crdb.  # noqa: E501

        Active-Active database active FeatureSet version  # noqa: E501

        :return: The featureset_version of this Crdb.  # noqa: E501
        :rtype: int
        """
        return self._featureset_version

    @featureset_version.setter
    def featureset_version(self, featureset_version):
        """Sets the featureset_version of this Crdb.

        Active-Active database active FeatureSet version  # noqa: E501

        :param featureset_version: The featureset_version of this Crdb.  # noqa: E501
        :type: int
        """

        self._featureset_version = featureset_version

    @property
    def protocol_version(self):
        """Gets the protocol_version of this Crdb.  # noqa: E501

        Active-Active database active protocol version  # noqa: E501

        :return: The protocol_version of this Crdb.  # noqa: E501
        :rtype: int
        """
        return self._protocol_version

    @protocol_version.setter
    def protocol_version(self, protocol_version):
        """Sets the protocol_version of this Crdb.

        Active-Active database active protocol version  # noqa: E501

        :param protocol_version: The protocol_version of this Crdb.  # noqa: E501
        :type: int
        """

        self._protocol_version = protocol_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Crdb, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Crdb):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
