# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ClusterSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'bigstore_migrate_node_threshold': 'int',
        'bigstore_migrate_node_threshold_p': 'int',
        'bigstore_provision_node_threshold': 'int',
        'bigstore_provision_node_threshold_p': 'int',
        'data_internode_encryption': 'bool',
        'default_concurrent_restore_actions': 'int',
        'default_fork_evict_ram': 'bool',
        'default_non_sharded_proxy_policy': 'str',
        'default_provisioned_redis_version': 'str',
        'default_sharded_proxy_policy': 'str',
        'default_shards_placement': 'str',
        'endpoint_rebind_propagation_grace_time': 'int',
        'login_lockout_counter_reset_after': 'int',
        'login_lockout_duration': 'int',
        'login_lockout_threshold': 'int',
        'max_saved_events_per_type': 'int',
        'max_simultaneous_backups': 'int',
        'parallel_shards_upgrade': 'int',
        'rack_aware': 'bool',
        'redis_migrate_node_threshold': 'int',
        'redis_migrate_node_threshold_p': 'int',
        'redis_provision_node_threshold': 'int',
        'redis_provision_node_threshold_p': 'int',
        'redis_upgrade_policy': 'str',
        'shards_overbooking': 'bool',
        'show_internals': 'bool',
        'slave_ha': 'bool',
        'slave_ha_bdb_cooldown_period': 'int',
        'slave_ha_cooldown_period': 'int',
        'slave_ha_grace_period': 'int'
    }

    attribute_map = {
        'bigstore_migrate_node_threshold': 'bigstore_migrate_node_threshold',
        'bigstore_migrate_node_threshold_p': 'bigstore_migrate_node_threshold_p',
        'bigstore_provision_node_threshold': 'bigstore_provision_node_threshold',
        'bigstore_provision_node_threshold_p': 'bigstore_provision_node_threshold_p',
        'data_internode_encryption': 'data_internode_encryption',
        'default_concurrent_restore_actions': 'default_concurrent_restore_actions',
        'default_fork_evict_ram': 'default_fork_evict_ram',
        'default_non_sharded_proxy_policy': 'default_non_sharded_proxy_policy',
        'default_provisioned_redis_version': 'default_provisioned_redis_version',
        'default_sharded_proxy_policy': 'default_sharded_proxy_policy',
        'default_shards_placement': 'default_shards_placement',
        'endpoint_rebind_propagation_grace_time': 'endpoint_rebind_propagation_grace_time',
        'login_lockout_counter_reset_after': 'login_lockout_counter_reset_after',
        'login_lockout_duration': 'login_lockout_duration',
        'login_lockout_threshold': 'login_lockout_threshold',
        'max_saved_events_per_type': 'max_saved_events_per_type',
        'max_simultaneous_backups': 'max_simultaneous_backups',
        'parallel_shards_upgrade': 'parallel_shards_upgrade',
        'rack_aware': 'rack_aware',
        'redis_migrate_node_threshold': 'redis_migrate_node_threshold',
        'redis_migrate_node_threshold_p': 'redis_migrate_node_threshold_p',
        'redis_provision_node_threshold': 'redis_provision_node_threshold',
        'redis_provision_node_threshold_p': 'redis_provision_node_threshold_p',
        'redis_upgrade_policy': 'redis_upgrade_policy',
        'shards_overbooking': 'shards_overbooking',
        'show_internals': 'show_internals',
        'slave_ha': 'slave_ha',
        'slave_ha_bdb_cooldown_period': 'slave_ha_bdb_cooldown_period',
        'slave_ha_cooldown_period': 'slave_ha_cooldown_period',
        'slave_ha_grace_period': 'slave_ha_grace_period'
    }

    def __init__(self, bigstore_migrate_node_threshold=None, bigstore_migrate_node_threshold_p=None, bigstore_provision_node_threshold=None, bigstore_provision_node_threshold_p=None, data_internode_encryption=None, default_concurrent_restore_actions=None, default_fork_evict_ram=None, default_non_sharded_proxy_policy=None, default_provisioned_redis_version=None, default_sharded_proxy_policy=None, default_shards_placement=None, endpoint_rebind_propagation_grace_time=None, login_lockout_counter_reset_after=None, login_lockout_duration=None, login_lockout_threshold=None, max_saved_events_per_type=None, max_simultaneous_backups=None, parallel_shards_upgrade=None, rack_aware=None, redis_migrate_node_threshold=None, redis_migrate_node_threshold_p=None, redis_provision_node_threshold=None, redis_provision_node_threshold_p=None, redis_upgrade_policy=None, shards_overbooking=None, show_internals=None, slave_ha=None, slave_ha_bdb_cooldown_period=None, slave_ha_cooldown_period=None, slave_ha_grace_period=None):  # noqa: E501
        """ClusterSettings - a model defined in Swagger"""  # noqa: E501
        self._bigstore_migrate_node_threshold = None
        self._bigstore_migrate_node_threshold_p = None
        self._bigstore_provision_node_threshold = None
        self._bigstore_provision_node_threshold_p = None
        self._data_internode_encryption = None
        self._default_concurrent_restore_actions = None
        self._default_fork_evict_ram = None
        self._default_non_sharded_proxy_policy = None
        self._default_provisioned_redis_version = None
        self._default_sharded_proxy_policy = None
        self._default_shards_placement = None
        self._endpoint_rebind_propagation_grace_time = None
        self._login_lockout_counter_reset_after = None
        self._login_lockout_duration = None
        self._login_lockout_threshold = None
        self._max_saved_events_per_type = None
        self._max_simultaneous_backups = None
        self._parallel_shards_upgrade = None
        self._rack_aware = None
        self._redis_migrate_node_threshold = None
        self._redis_migrate_node_threshold_p = None
        self._redis_provision_node_threshold = None
        self._redis_provision_node_threshold_p = None
        self._redis_upgrade_policy = None
        self._shards_overbooking = None
        self._show_internals = None
        self._slave_ha = None
        self._slave_ha_bdb_cooldown_period = None
        self._slave_ha_cooldown_period = None
        self._slave_ha_grace_period = None
        self.discriminator = None
        if bigstore_migrate_node_threshold is not None:
            self.bigstore_migrate_node_threshold = bigstore_migrate_node_threshold
        if bigstore_migrate_node_threshold_p is not None:
            self.bigstore_migrate_node_threshold_p = bigstore_migrate_node_threshold_p
        if bigstore_provision_node_threshold is not None:
            self.bigstore_provision_node_threshold = bigstore_provision_node_threshold
        if bigstore_provision_node_threshold_p is not None:
            self.bigstore_provision_node_threshold_p = bigstore_provision_node_threshold_p
        if data_internode_encryption is not None:
            self.data_internode_encryption = data_internode_encryption
        if default_concurrent_restore_actions is not None:
            self.default_concurrent_restore_actions = default_concurrent_restore_actions
        if default_fork_evict_ram is not None:
            self.default_fork_evict_ram = default_fork_evict_ram
        if default_non_sharded_proxy_policy is not None:
            self.default_non_sharded_proxy_policy = default_non_sharded_proxy_policy
        if default_provisioned_redis_version is not None:
            self.default_provisioned_redis_version = default_provisioned_redis_version
        if default_sharded_proxy_policy is not None:
            self.default_sharded_proxy_policy = default_sharded_proxy_policy
        if default_shards_placement is not None:
            self.default_shards_placement = default_shards_placement
        if endpoint_rebind_propagation_grace_time is not None:
            self.endpoint_rebind_propagation_grace_time = endpoint_rebind_propagation_grace_time
        if login_lockout_counter_reset_after is not None:
            self.login_lockout_counter_reset_after = login_lockout_counter_reset_after
        if login_lockout_duration is not None:
            self.login_lockout_duration = login_lockout_duration
        if login_lockout_threshold is not None:
            self.login_lockout_threshold = login_lockout_threshold
        if max_saved_events_per_type is not None:
            self.max_saved_events_per_type = max_saved_events_per_type
        if max_simultaneous_backups is not None:
            self.max_simultaneous_backups = max_simultaneous_backups
        if parallel_shards_upgrade is not None:
            self.parallel_shards_upgrade = parallel_shards_upgrade
        if rack_aware is not None:
            self.rack_aware = rack_aware
        if redis_migrate_node_threshold is not None:
            self.redis_migrate_node_threshold = redis_migrate_node_threshold
        if redis_migrate_node_threshold_p is not None:
            self.redis_migrate_node_threshold_p = redis_migrate_node_threshold_p
        if redis_provision_node_threshold is not None:
            self.redis_provision_node_threshold = redis_provision_node_threshold
        if redis_provision_node_threshold_p is not None:
            self.redis_provision_node_threshold_p = redis_provision_node_threshold_p
        if redis_upgrade_policy is not None:
            self.redis_upgrade_policy = redis_upgrade_policy
        if shards_overbooking is not None:
            self.shards_overbooking = shards_overbooking
        if show_internals is not None:
            self.show_internals = show_internals
        if slave_ha is not None:
            self.slave_ha = slave_ha
        if slave_ha_bdb_cooldown_period is not None:
            self.slave_ha_bdb_cooldown_period = slave_ha_bdb_cooldown_period
        if slave_ha_cooldown_period is not None:
            self.slave_ha_cooldown_period = slave_ha_cooldown_period
        if slave_ha_grace_period is not None:
            self.slave_ha_grace_period = slave_ha_grace_period

    @property
    def bigstore_migrate_node_threshold(self):
        """Gets the bigstore_migrate_node_threshold of this ClusterSettings.  # noqa: E501


        :return: The bigstore_migrate_node_threshold of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._bigstore_migrate_node_threshold

    @bigstore_migrate_node_threshold.setter
    def bigstore_migrate_node_threshold(self, bigstore_migrate_node_threshold):
        """Sets the bigstore_migrate_node_threshold of this ClusterSettings.


        :param bigstore_migrate_node_threshold: The bigstore_migrate_node_threshold of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._bigstore_migrate_node_threshold = bigstore_migrate_node_threshold

    @property
    def bigstore_migrate_node_threshold_p(self):
        """Gets the bigstore_migrate_node_threshold_p of this ClusterSettings.  # noqa: E501


        :return: The bigstore_migrate_node_threshold_p of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._bigstore_migrate_node_threshold_p

    @bigstore_migrate_node_threshold_p.setter
    def bigstore_migrate_node_threshold_p(self, bigstore_migrate_node_threshold_p):
        """Sets the bigstore_migrate_node_threshold_p of this ClusterSettings.


        :param bigstore_migrate_node_threshold_p: The bigstore_migrate_node_threshold_p of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._bigstore_migrate_node_threshold_p = bigstore_migrate_node_threshold_p

    @property
    def bigstore_provision_node_threshold(self):
        """Gets the bigstore_provision_node_threshold of this ClusterSettings.  # noqa: E501


        :return: The bigstore_provision_node_threshold of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._bigstore_provision_node_threshold

    @bigstore_provision_node_threshold.setter
    def bigstore_provision_node_threshold(self, bigstore_provision_node_threshold):
        """Sets the bigstore_provision_node_threshold of this ClusterSettings.


        :param bigstore_provision_node_threshold: The bigstore_provision_node_threshold of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._bigstore_provision_node_threshold = bigstore_provision_node_threshold

    @property
    def bigstore_provision_node_threshold_p(self):
        """Gets the bigstore_provision_node_threshold_p of this ClusterSettings.  # noqa: E501


        :return: The bigstore_provision_node_threshold_p of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._bigstore_provision_node_threshold_p

    @bigstore_provision_node_threshold_p.setter
    def bigstore_provision_node_threshold_p(self, bigstore_provision_node_threshold_p):
        """Sets the bigstore_provision_node_threshold_p of this ClusterSettings.


        :param bigstore_provision_node_threshold_p: The bigstore_provision_node_threshold_p of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._bigstore_provision_node_threshold_p = bigstore_provision_node_threshold_p

    @property
    def data_internode_encryption(self):
        """Gets the data_internode_encryption of this ClusterSettings.  # noqa: E501


        :return: The data_internode_encryption of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._data_internode_encryption

    @data_internode_encryption.setter
    def data_internode_encryption(self, data_internode_encryption):
        """Sets the data_internode_encryption of this ClusterSettings.


        :param data_internode_encryption: The data_internode_encryption of this ClusterSettings.  # noqa: E501
        :type: bool
        """

        self._data_internode_encryption = data_internode_encryption

    @property
    def default_concurrent_restore_actions(self):
        """Gets the default_concurrent_restore_actions of this ClusterSettings.  # noqa: E501


        :return: The default_concurrent_restore_actions of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._default_concurrent_restore_actions

    @default_concurrent_restore_actions.setter
    def default_concurrent_restore_actions(self, default_concurrent_restore_actions):
        """Sets the default_concurrent_restore_actions of this ClusterSettings.


        :param default_concurrent_restore_actions: The default_concurrent_restore_actions of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._default_concurrent_restore_actions = default_concurrent_restore_actions

    @property
    def default_fork_evict_ram(self):
        """Gets the default_fork_evict_ram of this ClusterSettings.  # noqa: E501


        :return: The default_fork_evict_ram of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._default_fork_evict_ram

    @default_fork_evict_ram.setter
    def default_fork_evict_ram(self, default_fork_evict_ram):
        """Sets the default_fork_evict_ram of this ClusterSettings.


        :param default_fork_evict_ram: The default_fork_evict_ram of this ClusterSettings.  # noqa: E501
        :type: bool
        """

        self._default_fork_evict_ram = default_fork_evict_ram

    @property
    def default_non_sharded_proxy_policy(self):
        """Gets the default_non_sharded_proxy_policy of this ClusterSettings.  # noqa: E501


        :return: The default_non_sharded_proxy_policy of this ClusterSettings.  # noqa: E501
        :rtype: str
        """
        return self._default_non_sharded_proxy_policy

    @default_non_sharded_proxy_policy.setter
    def default_non_sharded_proxy_policy(self, default_non_sharded_proxy_policy):
        """Sets the default_non_sharded_proxy_policy of this ClusterSettings.


        :param default_non_sharded_proxy_policy: The default_non_sharded_proxy_policy of this ClusterSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["single", "all-master-shards", "all-nodes"]  # noqa: E501
        if default_non_sharded_proxy_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `default_non_sharded_proxy_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(default_non_sharded_proxy_policy, allowed_values)
            )

        self._default_non_sharded_proxy_policy = default_non_sharded_proxy_policy

    @property
    def default_provisioned_redis_version(self):
        """Gets the default_provisioned_redis_version of this ClusterSettings.  # noqa: E501


        :return: The default_provisioned_redis_version of this ClusterSettings.  # noqa: E501
        :rtype: str
        """
        return self._default_provisioned_redis_version

    @default_provisioned_redis_version.setter
    def default_provisioned_redis_version(self, default_provisioned_redis_version):
        """Sets the default_provisioned_redis_version of this ClusterSettings.


        :param default_provisioned_redis_version: The default_provisioned_redis_version of this ClusterSettings.  # noqa: E501
        :type: str
        """

        self._default_provisioned_redis_version = default_provisioned_redis_version

    @property
    def default_sharded_proxy_policy(self):
        """Gets the default_sharded_proxy_policy of this ClusterSettings.  # noqa: E501


        :return: The default_sharded_proxy_policy of this ClusterSettings.  # noqa: E501
        :rtype: str
        """
        return self._default_sharded_proxy_policy

    @default_sharded_proxy_policy.setter
    def default_sharded_proxy_policy(self, default_sharded_proxy_policy):
        """Sets the default_sharded_proxy_policy of this ClusterSettings.


        :param default_sharded_proxy_policy: The default_sharded_proxy_policy of this ClusterSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["single", "all-master-shards", "all-nodes"]  # noqa: E501
        if default_sharded_proxy_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `default_sharded_proxy_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(default_sharded_proxy_policy, allowed_values)
            )

        self._default_sharded_proxy_policy = default_sharded_proxy_policy

    @property
    def default_shards_placement(self):
        """Gets the default_shards_placement of this ClusterSettings.  # noqa: E501


        :return: The default_shards_placement of this ClusterSettings.  # noqa: E501
        :rtype: str
        """
        return self._default_shards_placement

    @default_shards_placement.setter
    def default_shards_placement(self, default_shards_placement):
        """Sets the default_shards_placement of this ClusterSettings.


        :param default_shards_placement: The default_shards_placement of this ClusterSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["dense", "sparse"]  # noqa: E501
        if default_shards_placement not in allowed_values:
            raise ValueError(
                "Invalid value for `default_shards_placement` ({0}), must be one of {1}"  # noqa: E501
                .format(default_shards_placement, allowed_values)
            )

        self._default_shards_placement = default_shards_placement

    @property
    def endpoint_rebind_propagation_grace_time(self):
        """Gets the endpoint_rebind_propagation_grace_time of this ClusterSettings.  # noqa: E501


        :return: The endpoint_rebind_propagation_grace_time of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._endpoint_rebind_propagation_grace_time

    @endpoint_rebind_propagation_grace_time.setter
    def endpoint_rebind_propagation_grace_time(self, endpoint_rebind_propagation_grace_time):
        """Sets the endpoint_rebind_propagation_grace_time of this ClusterSettings.


        :param endpoint_rebind_propagation_grace_time: The endpoint_rebind_propagation_grace_time of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._endpoint_rebind_propagation_grace_time = endpoint_rebind_propagation_grace_time

    @property
    def login_lockout_counter_reset_after(self):
        """Gets the login_lockout_counter_reset_after of this ClusterSettings.  # noqa: E501


        :return: The login_lockout_counter_reset_after of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._login_lockout_counter_reset_after

    @login_lockout_counter_reset_after.setter
    def login_lockout_counter_reset_after(self, login_lockout_counter_reset_after):
        """Sets the login_lockout_counter_reset_after of this ClusterSettings.


        :param login_lockout_counter_reset_after: The login_lockout_counter_reset_after of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._login_lockout_counter_reset_after = login_lockout_counter_reset_after

    @property
    def login_lockout_duration(self):
        """Gets the login_lockout_duration of this ClusterSettings.  # noqa: E501


        :return: The login_lockout_duration of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._login_lockout_duration

    @login_lockout_duration.setter
    def login_lockout_duration(self, login_lockout_duration):
        """Sets the login_lockout_duration of this ClusterSettings.


        :param login_lockout_duration: The login_lockout_duration of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._login_lockout_duration = login_lockout_duration

    @property
    def login_lockout_threshold(self):
        """Gets the login_lockout_threshold of this ClusterSettings.  # noqa: E501


        :return: The login_lockout_threshold of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._login_lockout_threshold

    @login_lockout_threshold.setter
    def login_lockout_threshold(self, login_lockout_threshold):
        """Sets the login_lockout_threshold of this ClusterSettings.


        :param login_lockout_threshold: The login_lockout_threshold of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._login_lockout_threshold = login_lockout_threshold

    @property
    def max_saved_events_per_type(self):
        """Gets the max_saved_events_per_type of this ClusterSettings.  # noqa: E501


        :return: The max_saved_events_per_type of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._max_saved_events_per_type

    @max_saved_events_per_type.setter
    def max_saved_events_per_type(self, max_saved_events_per_type):
        """Sets the max_saved_events_per_type of this ClusterSettings.


        :param max_saved_events_per_type: The max_saved_events_per_type of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._max_saved_events_per_type = max_saved_events_per_type

    @property
    def max_simultaneous_backups(self):
        """Gets the max_simultaneous_backups of this ClusterSettings.  # noqa: E501


        :return: The max_simultaneous_backups of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._max_simultaneous_backups

    @max_simultaneous_backups.setter
    def max_simultaneous_backups(self, max_simultaneous_backups):
        """Sets the max_simultaneous_backups of this ClusterSettings.


        :param max_simultaneous_backups: The max_simultaneous_backups of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._max_simultaneous_backups = max_simultaneous_backups

    @property
    def parallel_shards_upgrade(self):
        """Gets the parallel_shards_upgrade of this ClusterSettings.  # noqa: E501


        :return: The parallel_shards_upgrade of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._parallel_shards_upgrade

    @parallel_shards_upgrade.setter
    def parallel_shards_upgrade(self, parallel_shards_upgrade):
        """Sets the parallel_shards_upgrade of this ClusterSettings.


        :param parallel_shards_upgrade: The parallel_shards_upgrade of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._parallel_shards_upgrade = parallel_shards_upgrade

    @property
    def rack_aware(self):
        """Gets the rack_aware of this ClusterSettings.  # noqa: E501


        :return: The rack_aware of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._rack_aware

    @rack_aware.setter
    def rack_aware(self, rack_aware):
        """Sets the rack_aware of this ClusterSettings.


        :param rack_aware: The rack_aware of this ClusterSettings.  # noqa: E501
        :type: bool
        """

        self._rack_aware = rack_aware

    @property
    def redis_migrate_node_threshold(self):
        """Gets the redis_migrate_node_threshold of this ClusterSettings.  # noqa: E501


        :return: The redis_migrate_node_threshold of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._redis_migrate_node_threshold

    @redis_migrate_node_threshold.setter
    def redis_migrate_node_threshold(self, redis_migrate_node_threshold):
        """Sets the redis_migrate_node_threshold of this ClusterSettings.


        :param redis_migrate_node_threshold: The redis_migrate_node_threshold of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._redis_migrate_node_threshold = redis_migrate_node_threshold

    @property
    def redis_migrate_node_threshold_p(self):
        """Gets the redis_migrate_node_threshold_p of this ClusterSettings.  # noqa: E501


        :return: The redis_migrate_node_threshold_p of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._redis_migrate_node_threshold_p

    @redis_migrate_node_threshold_p.setter
    def redis_migrate_node_threshold_p(self, redis_migrate_node_threshold_p):
        """Sets the redis_migrate_node_threshold_p of this ClusterSettings.


        :param redis_migrate_node_threshold_p: The redis_migrate_node_threshold_p of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._redis_migrate_node_threshold_p = redis_migrate_node_threshold_p

    @property
    def redis_provision_node_threshold(self):
        """Gets the redis_provision_node_threshold of this ClusterSettings.  # noqa: E501


        :return: The redis_provision_node_threshold of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._redis_provision_node_threshold

    @redis_provision_node_threshold.setter
    def redis_provision_node_threshold(self, redis_provision_node_threshold):
        """Sets the redis_provision_node_threshold of this ClusterSettings.


        :param redis_provision_node_threshold: The redis_provision_node_threshold of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._redis_provision_node_threshold = redis_provision_node_threshold

    @property
    def redis_provision_node_threshold_p(self):
        """Gets the redis_provision_node_threshold_p of this ClusterSettings.  # noqa: E501


        :return: The redis_provision_node_threshold_p of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._redis_provision_node_threshold_p

    @redis_provision_node_threshold_p.setter
    def redis_provision_node_threshold_p(self, redis_provision_node_threshold_p):
        """Sets the redis_provision_node_threshold_p of this ClusterSettings.


        :param redis_provision_node_threshold_p: The redis_provision_node_threshold_p of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._redis_provision_node_threshold_p = redis_provision_node_threshold_p

    @property
    def redis_upgrade_policy(self):
        """Gets the redis_upgrade_policy of this ClusterSettings.  # noqa: E501


        :return: The redis_upgrade_policy of this ClusterSettings.  # noqa: E501
        :rtype: str
        """
        return self._redis_upgrade_policy

    @redis_upgrade_policy.setter
    def redis_upgrade_policy(self, redis_upgrade_policy):
        """Sets the redis_upgrade_policy of this ClusterSettings.


        :param redis_upgrade_policy: The redis_upgrade_policy of this ClusterSettings.  # noqa: E501
        :type: str
        """
        allowed_values = ["major", "latest"]  # noqa: E501
        if redis_upgrade_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `redis_upgrade_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(redis_upgrade_policy, allowed_values)
            )

        self._redis_upgrade_policy = redis_upgrade_policy

    @property
    def shards_overbooking(self):
        """Gets the shards_overbooking of this ClusterSettings.  # noqa: E501


        :return: The shards_overbooking of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._shards_overbooking

    @shards_overbooking.setter
    def shards_overbooking(self, shards_overbooking):
        """Sets the shards_overbooking of this ClusterSettings.


        :param shards_overbooking: The shards_overbooking of this ClusterSettings.  # noqa: E501
        :type: bool
        """

        self._shards_overbooking = shards_overbooking

    @property
    def show_internals(self):
        """Gets the show_internals of this ClusterSettings.  # noqa: E501


        :return: The show_internals of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._show_internals

    @show_internals.setter
    def show_internals(self, show_internals):
        """Sets the show_internals of this ClusterSettings.


        :param show_internals: The show_internals of this ClusterSettings.  # noqa: E501
        :type: bool
        """

        self._show_internals = show_internals

    @property
    def slave_ha(self):
        """Gets the slave_ha of this ClusterSettings.  # noqa: E501


        :return: The slave_ha of this ClusterSettings.  # noqa: E501
        :rtype: bool
        """
        return self._slave_ha

    @slave_ha.setter
    def slave_ha(self, slave_ha):
        """Sets the slave_ha of this ClusterSettings.


        :param slave_ha: The slave_ha of this ClusterSettings.  # noqa: E501
        :type: bool
        """

        self._slave_ha = slave_ha

    @property
    def slave_ha_bdb_cooldown_period(self):
        """Gets the slave_ha_bdb_cooldown_period of this ClusterSettings.  # noqa: E501


        :return: The slave_ha_bdb_cooldown_period of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._slave_ha_bdb_cooldown_period

    @slave_ha_bdb_cooldown_period.setter
    def slave_ha_bdb_cooldown_period(self, slave_ha_bdb_cooldown_period):
        """Sets the slave_ha_bdb_cooldown_period of this ClusterSettings.


        :param slave_ha_bdb_cooldown_period: The slave_ha_bdb_cooldown_period of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._slave_ha_bdb_cooldown_period = slave_ha_bdb_cooldown_period

    @property
    def slave_ha_cooldown_period(self):
        """Gets the slave_ha_cooldown_period of this ClusterSettings.  # noqa: E501


        :return: The slave_ha_cooldown_period of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._slave_ha_cooldown_period

    @slave_ha_cooldown_period.setter
    def slave_ha_cooldown_period(self, slave_ha_cooldown_period):
        """Sets the slave_ha_cooldown_period of this ClusterSettings.


        :param slave_ha_cooldown_period: The slave_ha_cooldown_period of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._slave_ha_cooldown_period = slave_ha_cooldown_period

    @property
    def slave_ha_grace_period(self):
        """Gets the slave_ha_grace_period of this ClusterSettings.  # noqa: E501


        :return: The slave_ha_grace_period of this ClusterSettings.  # noqa: E501
        :rtype: int
        """
        return self._slave_ha_grace_period

    @slave_ha_grace_period.setter
    def slave_ha_grace_period(self, slave_ha_grace_period):
        """Sets the slave_ha_grace_period of this ClusterSettings.


        :param slave_ha_grace_period: The slave_ha_grace_period of this ClusterSettings.  # noqa: E501
        :type: int
        """

        self._slave_ha_grace_period = slave_ha_grace_period

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClusterSettings, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
