# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ClusterAlertSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cluster_certs_about_to_expire': 'AllOfclusterAlertSettingsClusterCertsAboutToExpire',
        'cluster_even_node_count': 'bool',
        'cluster_flash_overcommit': 'bool',
        'cluster_inconsistent_redis_sw': 'bool',
        'cluster_inconsistent_rl_sw': 'bool',
        'cluster_internal_bdb': 'bool',
        'cluster_multiple_nodes_down': 'bool',
        'cluster_node_joined': 'bool',
        'cluster_node_remove_abort_completed': 'bool',
        'cluster_node_remove_abort_failed': 'bool',
        'cluster_node_remove_completed': 'bool',
        'cluster_node_remove_failed': 'bool',
        'cluster_ram_overcommit': 'bool',
        'cluster_too_few_nodes_for_replication': 'bool',
        'node_aof_slow_disk_io': 'bool',
        'node_checks_error': 'bool',
        'node_cpu_utilization': 'AllOfclusterAlertSettingsNodeCpuUtilization',
        'node_ephemeral_storage': 'AllOfclusterAlertSettingsNodeEphemeralStorage',
        'node_failed': 'bool',
        'node_free_flash': 'AllOfclusterAlertSettingsNodeFreeFlash',
        'node_insufficient_disk_aofrw': 'bool',
        'node_internal_certs_about_to_expire': 'AllOfclusterAlertSettingsNodeInternalCertsAboutToExpire',
        'node_memory': 'AllOfclusterAlertSettingsNodeMemory',
        'node_net_throughput': 'AllOfclusterAlertSettingsNodeNetThroughput',
        'node_persistent_storage': 'AllOfclusterAlertSettingsNodePersistentStorage'
    }

    attribute_map = {
        'cluster_certs_about_to_expire': 'cluster_certs_about_to_expire',
        'cluster_even_node_count': 'cluster_even_node_count',
        'cluster_flash_overcommit': 'cluster_flash_overcommit',
        'cluster_inconsistent_redis_sw': 'cluster_inconsistent_redis_sw',
        'cluster_inconsistent_rl_sw': 'cluster_inconsistent_rl_sw',
        'cluster_internal_bdb': 'cluster_internal_bdb',
        'cluster_multiple_nodes_down': 'cluster_multiple_nodes_down',
        'cluster_node_joined': 'cluster_node_joined',
        'cluster_node_remove_abort_completed': 'cluster_node_remove_abort_completed',
        'cluster_node_remove_abort_failed': 'cluster_node_remove_abort_failed',
        'cluster_node_remove_completed': 'cluster_node_remove_completed',
        'cluster_node_remove_failed': 'cluster_node_remove_failed',
        'cluster_ram_overcommit': 'cluster_ram_overcommit',
        'cluster_too_few_nodes_for_replication': 'cluster_too_few_nodes_for_replication',
        'node_aof_slow_disk_io': 'node_aof_slow_disk_io',
        'node_checks_error': 'node_checks_error',
        'node_cpu_utilization': 'node_cpu_utilization',
        'node_ephemeral_storage': 'node_ephemeral_storage',
        'node_failed': 'node_failed',
        'node_free_flash': 'node_free_flash',
        'node_insufficient_disk_aofrw': 'node_insufficient_disk_aofrw',
        'node_internal_certs_about_to_expire': 'node_internal_certs_about_to_expire',
        'node_memory': 'node_memory',
        'node_net_throughput': 'node_net_throughput',
        'node_persistent_storage': 'node_persistent_storage'
    }

    def __init__(self, cluster_certs_about_to_expire=None, cluster_even_node_count=False, cluster_flash_overcommit=False, cluster_inconsistent_redis_sw=False, cluster_inconsistent_rl_sw=False, cluster_internal_bdb=False, cluster_multiple_nodes_down=False, cluster_node_joined=False, cluster_node_remove_abort_completed=False, cluster_node_remove_abort_failed=False, cluster_node_remove_completed=False, cluster_node_remove_failed=False, cluster_ram_overcommit=False, cluster_too_few_nodes_for_replication=False, node_aof_slow_disk_io=False, node_checks_error=False, node_cpu_utilization=None, node_ephemeral_storage=None, node_failed=False, node_free_flash=None, node_insufficient_disk_aofrw=False, node_internal_certs_about_to_expire=None, node_memory=None, node_net_throughput=None, node_persistent_storage=None):  # noqa: E501
        """ClusterAlertSettings - a model defined in Swagger"""  # noqa: E501
        self._cluster_certs_about_to_expire = None
        self._cluster_even_node_count = None
        self._cluster_flash_overcommit = None
        self._cluster_inconsistent_redis_sw = None
        self._cluster_inconsistent_rl_sw = None
        self._cluster_internal_bdb = None
        self._cluster_multiple_nodes_down = None
        self._cluster_node_joined = None
        self._cluster_node_remove_abort_completed = None
        self._cluster_node_remove_abort_failed = None
        self._cluster_node_remove_completed = None
        self._cluster_node_remove_failed = None
        self._cluster_ram_overcommit = None
        self._cluster_too_few_nodes_for_replication = None
        self._node_aof_slow_disk_io = None
        self._node_checks_error = None
        self._node_cpu_utilization = None
        self._node_ephemeral_storage = None
        self._node_failed = None
        self._node_free_flash = None
        self._node_insufficient_disk_aofrw = None
        self._node_internal_certs_about_to_expire = None
        self._node_memory = None
        self._node_net_throughput = None
        self._node_persistent_storage = None
        self.discriminator = None
        if cluster_certs_about_to_expire is not None:
            self.cluster_certs_about_to_expire = cluster_certs_about_to_expire
        if cluster_even_node_count is not None:
            self.cluster_even_node_count = cluster_even_node_count
        if cluster_flash_overcommit is not None:
            self.cluster_flash_overcommit = cluster_flash_overcommit
        if cluster_inconsistent_redis_sw is not None:
            self.cluster_inconsistent_redis_sw = cluster_inconsistent_redis_sw
        if cluster_inconsistent_rl_sw is not None:
            self.cluster_inconsistent_rl_sw = cluster_inconsistent_rl_sw
        if cluster_internal_bdb is not None:
            self.cluster_internal_bdb = cluster_internal_bdb
        if cluster_multiple_nodes_down is not None:
            self.cluster_multiple_nodes_down = cluster_multiple_nodes_down
        if cluster_node_joined is not None:
            self.cluster_node_joined = cluster_node_joined
        if cluster_node_remove_abort_completed is not None:
            self.cluster_node_remove_abort_completed = cluster_node_remove_abort_completed
        if cluster_node_remove_abort_failed is not None:
            self.cluster_node_remove_abort_failed = cluster_node_remove_abort_failed
        if cluster_node_remove_completed is not None:
            self.cluster_node_remove_completed = cluster_node_remove_completed
        if cluster_node_remove_failed is not None:
            self.cluster_node_remove_failed = cluster_node_remove_failed
        if cluster_ram_overcommit is not None:
            self.cluster_ram_overcommit = cluster_ram_overcommit
        if cluster_too_few_nodes_for_replication is not None:
            self.cluster_too_few_nodes_for_replication = cluster_too_few_nodes_for_replication
        if node_aof_slow_disk_io is not None:
            self.node_aof_slow_disk_io = node_aof_slow_disk_io
        if node_checks_error is not None:
            self.node_checks_error = node_checks_error
        if node_cpu_utilization is not None:
            self.node_cpu_utilization = node_cpu_utilization
        if node_ephemeral_storage is not None:
            self.node_ephemeral_storage = node_ephemeral_storage
        if node_failed is not None:
            self.node_failed = node_failed
        if node_free_flash is not None:
            self.node_free_flash = node_free_flash
        if node_insufficient_disk_aofrw is not None:
            self.node_insufficient_disk_aofrw = node_insufficient_disk_aofrw
        if node_internal_certs_about_to_expire is not None:
            self.node_internal_certs_about_to_expire = node_internal_certs_about_to_expire
        if node_memory is not None:
            self.node_memory = node_memory
        if node_net_throughput is not None:
            self.node_net_throughput = node_net_throughput
        if node_persistent_storage is not None:
            self.node_persistent_storage = node_persistent_storage

    @property
    def cluster_certs_about_to_expire(self):
        """Gets the cluster_certs_about_to_expire of this ClusterAlertSettings.  # noqa: E501

        Cluster certificate will expire in [x] days  # noqa: E501

        :return: The cluster_certs_about_to_expire of this ClusterAlertSettings.  # noqa: E501
        :rtype: AllOfclusterAlertSettingsClusterCertsAboutToExpire
        """
        return self._cluster_certs_about_to_expire

    @cluster_certs_about_to_expire.setter
    def cluster_certs_about_to_expire(self, cluster_certs_about_to_expire):
        """Sets the cluster_certs_about_to_expire of this ClusterAlertSettings.

        Cluster certificate will expire in [x] days  # noqa: E501

        :param cluster_certs_about_to_expire: The cluster_certs_about_to_expire of this ClusterAlertSettings.  # noqa: E501
        :type: AllOfclusterAlertSettingsClusterCertsAboutToExpire
        """

        self._cluster_certs_about_to_expire = cluster_certs_about_to_expire

    @property
    def cluster_even_node_count(self):
        """Gets the cluster_even_node_count of this ClusterAlertSettings.  # noqa: E501

        True high availability requires odd number of nodes in cluster  # noqa: E501

        :return: The cluster_even_node_count of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_even_node_count

    @cluster_even_node_count.setter
    def cluster_even_node_count(self, cluster_even_node_count):
        """Sets the cluster_even_node_count of this ClusterAlertSettings.

        True high availability requires odd number of nodes in cluster  # noqa: E501

        :param cluster_even_node_count: The cluster_even_node_count of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_even_node_count = cluster_even_node_count

    @property
    def cluster_flash_overcommit(self):
        """Gets the cluster_flash_overcommit of this ClusterAlertSettings.  # noqa: E501

        Flash committed to databases is larger than cluster total flash  # noqa: E501

        :return: The cluster_flash_overcommit of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_flash_overcommit

    @cluster_flash_overcommit.setter
    def cluster_flash_overcommit(self, cluster_flash_overcommit):
        """Sets the cluster_flash_overcommit of this ClusterAlertSettings.

        Flash committed to databases is larger than cluster total flash  # noqa: E501

        :param cluster_flash_overcommit: The cluster_flash_overcommit of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_flash_overcommit = cluster_flash_overcommit

    @property
    def cluster_inconsistent_redis_sw(self):
        """Gets the cluster_inconsistent_redis_sw of this ClusterAlertSettings.  # noqa: E501

        Not all shards in cluster are running the same Redis software version  # noqa: E501

        :return: The cluster_inconsistent_redis_sw of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_inconsistent_redis_sw

    @cluster_inconsistent_redis_sw.setter
    def cluster_inconsistent_redis_sw(self, cluster_inconsistent_redis_sw):
        """Sets the cluster_inconsistent_redis_sw of this ClusterAlertSettings.

        Not all shards in cluster are running the same Redis software version  # noqa: E501

        :param cluster_inconsistent_redis_sw: The cluster_inconsistent_redis_sw of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_inconsistent_redis_sw = cluster_inconsistent_redis_sw

    @property
    def cluster_inconsistent_rl_sw(self):
        """Gets the cluster_inconsistent_rl_sw of this ClusterAlertSettings.  # noqa: E501

        Not all nodes in cluster are running the same Redis Labs software version  # noqa: E501

        :return: The cluster_inconsistent_rl_sw of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_inconsistent_rl_sw

    @cluster_inconsistent_rl_sw.setter
    def cluster_inconsistent_rl_sw(self, cluster_inconsistent_rl_sw):
        """Sets the cluster_inconsistent_rl_sw of this ClusterAlertSettings.

        Not all nodes in cluster are running the same Redis Labs software version  # noqa: E501

        :param cluster_inconsistent_rl_sw: The cluster_inconsistent_rl_sw of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_inconsistent_rl_sw = cluster_inconsistent_rl_sw

    @property
    def cluster_internal_bdb(self):
        """Gets the cluster_internal_bdb of this ClusterAlertSettings.  # noqa: E501

        Issues with internal cluster databases  # noqa: E501

        :return: The cluster_internal_bdb of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_internal_bdb

    @cluster_internal_bdb.setter
    def cluster_internal_bdb(self, cluster_internal_bdb):
        """Sets the cluster_internal_bdb of this ClusterAlertSettings.

        Issues with internal cluster databases  # noqa: E501

        :param cluster_internal_bdb: The cluster_internal_bdb of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_internal_bdb = cluster_internal_bdb

    @property
    def cluster_multiple_nodes_down(self):
        """Gets the cluster_multiple_nodes_down of this ClusterAlertSettings.  # noqa: E501

        Multiple cluster nodes are down - this might cause a data loss  # noqa: E501

        :return: The cluster_multiple_nodes_down of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_multiple_nodes_down

    @cluster_multiple_nodes_down.setter
    def cluster_multiple_nodes_down(self, cluster_multiple_nodes_down):
        """Sets the cluster_multiple_nodes_down of this ClusterAlertSettings.

        Multiple cluster nodes are down - this might cause a data loss  # noqa: E501

        :param cluster_multiple_nodes_down: The cluster_multiple_nodes_down of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_multiple_nodes_down = cluster_multiple_nodes_down

    @property
    def cluster_node_joined(self):
        """Gets the cluster_node_joined of this ClusterAlertSettings.  # noqa: E501

        New node joined cluster  # noqa: E501

        :return: The cluster_node_joined of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_node_joined

    @cluster_node_joined.setter
    def cluster_node_joined(self, cluster_node_joined):
        """Sets the cluster_node_joined of this ClusterAlertSettings.

        New node joined cluster  # noqa: E501

        :param cluster_node_joined: The cluster_node_joined of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_node_joined = cluster_node_joined

    @property
    def cluster_node_remove_abort_completed(self):
        """Gets the cluster_node_remove_abort_completed of this ClusterAlertSettings.  # noqa: E501

        Abort node remove operation completed  # noqa: E501

        :return: The cluster_node_remove_abort_completed of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_node_remove_abort_completed

    @cluster_node_remove_abort_completed.setter
    def cluster_node_remove_abort_completed(self, cluster_node_remove_abort_completed):
        """Sets the cluster_node_remove_abort_completed of this ClusterAlertSettings.

        Abort node remove operation completed  # noqa: E501

        :param cluster_node_remove_abort_completed: The cluster_node_remove_abort_completed of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_node_remove_abort_completed = cluster_node_remove_abort_completed

    @property
    def cluster_node_remove_abort_failed(self):
        """Gets the cluster_node_remove_abort_failed of this ClusterAlertSettings.  # noqa: E501

        Abort node remove operation failed  # noqa: E501

        :return: The cluster_node_remove_abort_failed of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_node_remove_abort_failed

    @cluster_node_remove_abort_failed.setter
    def cluster_node_remove_abort_failed(self, cluster_node_remove_abort_failed):
        """Sets the cluster_node_remove_abort_failed of this ClusterAlertSettings.

        Abort node remove operation failed  # noqa: E501

        :param cluster_node_remove_abort_failed: The cluster_node_remove_abort_failed of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_node_remove_abort_failed = cluster_node_remove_abort_failed

    @property
    def cluster_node_remove_completed(self):
        """Gets the cluster_node_remove_completed of this ClusterAlertSettings.  # noqa: E501

        Node removed from cluster  # noqa: E501

        :return: The cluster_node_remove_completed of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_node_remove_completed

    @cluster_node_remove_completed.setter
    def cluster_node_remove_completed(self, cluster_node_remove_completed):
        """Sets the cluster_node_remove_completed of this ClusterAlertSettings.

        Node removed from cluster  # noqa: E501

        :param cluster_node_remove_completed: The cluster_node_remove_completed of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_node_remove_completed = cluster_node_remove_completed

    @property
    def cluster_node_remove_failed(self):
        """Gets the cluster_node_remove_failed of this ClusterAlertSettings.  # noqa: E501

        Failure to removed node from cluster  # noqa: E501

        :return: The cluster_node_remove_failed of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_node_remove_failed

    @cluster_node_remove_failed.setter
    def cluster_node_remove_failed(self, cluster_node_remove_failed):
        """Sets the cluster_node_remove_failed of this ClusterAlertSettings.

        Failure to removed node from cluster  # noqa: E501

        :param cluster_node_remove_failed: The cluster_node_remove_failed of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_node_remove_failed = cluster_node_remove_failed

    @property
    def cluster_ram_overcommit(self):
        """Gets the cluster_ram_overcommit of this ClusterAlertSettings.  # noqa: E501

        RAM committed to databases is larger than cluster total RAM  # noqa: E501

        :return: The cluster_ram_overcommit of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_ram_overcommit

    @cluster_ram_overcommit.setter
    def cluster_ram_overcommit(self, cluster_ram_overcommit):
        """Sets the cluster_ram_overcommit of this ClusterAlertSettings.

        RAM committed to databases is larger than cluster total RAM  # noqa: E501

        :param cluster_ram_overcommit: The cluster_ram_overcommit of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_ram_overcommit = cluster_ram_overcommit

    @property
    def cluster_too_few_nodes_for_replication(self):
        """Gets the cluster_too_few_nodes_for_replication of this ClusterAlertSettings.  # noqa: E501

        Replication requires at least 2 nodes in cluster  # noqa: E501

        :return: The cluster_too_few_nodes_for_replication of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._cluster_too_few_nodes_for_replication

    @cluster_too_few_nodes_for_replication.setter
    def cluster_too_few_nodes_for_replication(self, cluster_too_few_nodes_for_replication):
        """Sets the cluster_too_few_nodes_for_replication of this ClusterAlertSettings.

        Replication requires at least 2 nodes in cluster  # noqa: E501

        :param cluster_too_few_nodes_for_replication: The cluster_too_few_nodes_for_replication of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._cluster_too_few_nodes_for_replication = cluster_too_few_nodes_for_replication

    @property
    def node_aof_slow_disk_io(self):
        """Gets the node_aof_slow_disk_io of this ClusterAlertSettings.  # noqa: E501

        AOF reaching disk I/O limits  # noqa: E501

        :return: The node_aof_slow_disk_io of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._node_aof_slow_disk_io

    @node_aof_slow_disk_io.setter
    def node_aof_slow_disk_io(self, node_aof_slow_disk_io):
        """Sets the node_aof_slow_disk_io of this ClusterAlertSettings.

        AOF reaching disk I/O limits  # noqa: E501

        :param node_aof_slow_disk_io: The node_aof_slow_disk_io of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._node_aof_slow_disk_io = node_aof_slow_disk_io

    @property
    def node_checks_error(self):
        """Gets the node_checks_error of this ClusterAlertSettings.  # noqa: E501

        Some node checks have failed  # noqa: E501

        :return: The node_checks_error of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._node_checks_error

    @node_checks_error.setter
    def node_checks_error(self, node_checks_error):
        """Sets the node_checks_error of this ClusterAlertSettings.

        Some node checks have failed  # noqa: E501

        :param node_checks_error: The node_checks_error of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._node_checks_error = node_checks_error

    @property
    def node_cpu_utilization(self):
        """Gets the node_cpu_utilization of this ClusterAlertSettings.  # noqa: E501

        Node cpu utilization has reached the threshold value [% of the utilization limit]  # noqa: E501

        :return: The node_cpu_utilization of this ClusterAlertSettings.  # noqa: E501
        :rtype: AllOfclusterAlertSettingsNodeCpuUtilization
        """
        return self._node_cpu_utilization

    @node_cpu_utilization.setter
    def node_cpu_utilization(self, node_cpu_utilization):
        """Sets the node_cpu_utilization of this ClusterAlertSettings.

        Node cpu utilization has reached the threshold value [% of the utilization limit]  # noqa: E501

        :param node_cpu_utilization: The node_cpu_utilization of this ClusterAlertSettings.  # noqa: E501
        :type: AllOfclusterAlertSettingsNodeCpuUtilization
        """

        self._node_cpu_utilization = node_cpu_utilization

    @property
    def node_ephemeral_storage(self):
        """Gets the node_ephemeral_storage of this ClusterAlertSettings.  # noqa: E501

        Node ephemeral storage has reached the threshold value [% of the storage limit]  # noqa: E501

        :return: The node_ephemeral_storage of this ClusterAlertSettings.  # noqa: E501
        :rtype: AllOfclusterAlertSettingsNodeEphemeralStorage
        """
        return self._node_ephemeral_storage

    @node_ephemeral_storage.setter
    def node_ephemeral_storage(self, node_ephemeral_storage):
        """Sets the node_ephemeral_storage of this ClusterAlertSettings.

        Node ephemeral storage has reached the threshold value [% of the storage limit]  # noqa: E501

        :param node_ephemeral_storage: The node_ephemeral_storage of this ClusterAlertSettings.  # noqa: E501
        :type: AllOfclusterAlertSettingsNodeEphemeralStorage
        """

        self._node_ephemeral_storage = node_ephemeral_storage

    @property
    def node_failed(self):
        """Gets the node_failed of this ClusterAlertSettings.  # noqa: E501

        Node failed  # noqa: E501

        :return: The node_failed of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._node_failed

    @node_failed.setter
    def node_failed(self, node_failed):
        """Sets the node_failed of this ClusterAlertSettings.

        Node failed  # noqa: E501

        :param node_failed: The node_failed of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._node_failed = node_failed

    @property
    def node_free_flash(self):
        """Gets the node_free_flash of this ClusterAlertSettings.  # noqa: E501

        Node flash storage has reached the threshold value [% of the storage limit]  # noqa: E501

        :return: The node_free_flash of this ClusterAlertSettings.  # noqa: E501
        :rtype: AllOfclusterAlertSettingsNodeFreeFlash
        """
        return self._node_free_flash

    @node_free_flash.setter
    def node_free_flash(self, node_free_flash):
        """Sets the node_free_flash of this ClusterAlertSettings.

        Node flash storage has reached the threshold value [% of the storage limit]  # noqa: E501

        :param node_free_flash: The node_free_flash of this ClusterAlertSettings.  # noqa: E501
        :type: AllOfclusterAlertSettingsNodeFreeFlash
        """

        self._node_free_flash = node_free_flash

    @property
    def node_insufficient_disk_aofrw(self):
        """Gets the node_insufficient_disk_aofrw of this ClusterAlertSettings.  # noqa: E501

        Insufficient AOF disk space  # noqa: E501

        :return: The node_insufficient_disk_aofrw of this ClusterAlertSettings.  # noqa: E501
        :rtype: bool
        """
        return self._node_insufficient_disk_aofrw

    @node_insufficient_disk_aofrw.setter
    def node_insufficient_disk_aofrw(self, node_insufficient_disk_aofrw):
        """Sets the node_insufficient_disk_aofrw of this ClusterAlertSettings.

        Insufficient AOF disk space  # noqa: E501

        :param node_insufficient_disk_aofrw: The node_insufficient_disk_aofrw of this ClusterAlertSettings.  # noqa: E501
        :type: bool
        """

        self._node_insufficient_disk_aofrw = node_insufficient_disk_aofrw

    @property
    def node_internal_certs_about_to_expire(self):
        """Gets the node_internal_certs_about_to_expire of this ClusterAlertSettings.  # noqa: E501

        Internal certificate on node will expire in [x] days  # noqa: E501

        :return: The node_internal_certs_about_to_expire of this ClusterAlertSettings.  # noqa: E501
        :rtype: AllOfclusterAlertSettingsNodeInternalCertsAboutToExpire
        """
        return self._node_internal_certs_about_to_expire

    @node_internal_certs_about_to_expire.setter
    def node_internal_certs_about_to_expire(self, node_internal_certs_about_to_expire):
        """Sets the node_internal_certs_about_to_expire of this ClusterAlertSettings.

        Internal certificate on node will expire in [x] days  # noqa: E501

        :param node_internal_certs_about_to_expire: The node_internal_certs_about_to_expire of this ClusterAlertSettings.  # noqa: E501
        :type: AllOfclusterAlertSettingsNodeInternalCertsAboutToExpire
        """

        self._node_internal_certs_about_to_expire = node_internal_certs_about_to_expire

    @property
    def node_memory(self):
        """Gets the node_memory of this ClusterAlertSettings.  # noqa: E501

        Node memory has reached the threshold value [% of the memory limit]  # noqa: E501

        :return: The node_memory of this ClusterAlertSettings.  # noqa: E501
        :rtype: AllOfclusterAlertSettingsNodeMemory
        """
        return self._node_memory

    @node_memory.setter
    def node_memory(self, node_memory):
        """Sets the node_memory of this ClusterAlertSettings.

        Node memory has reached the threshold value [% of the memory limit]  # noqa: E501

        :param node_memory: The node_memory of this ClusterAlertSettings.  # noqa: E501
        :type: AllOfclusterAlertSettingsNodeMemory
        """

        self._node_memory = node_memory

    @property
    def node_net_throughput(self):
        """Gets the node_net_throughput of this ClusterAlertSettings.  # noqa: E501

        Node network throughput has reached the threshold value [bytes/s]  # noqa: E501

        :return: The node_net_throughput of this ClusterAlertSettings.  # noqa: E501
        :rtype: AllOfclusterAlertSettingsNodeNetThroughput
        """
        return self._node_net_throughput

    @node_net_throughput.setter
    def node_net_throughput(self, node_net_throughput):
        """Sets the node_net_throughput of this ClusterAlertSettings.

        Node network throughput has reached the threshold value [bytes/s]  # noqa: E501

        :param node_net_throughput: The node_net_throughput of this ClusterAlertSettings.  # noqa: E501
        :type: AllOfclusterAlertSettingsNodeNetThroughput
        """

        self._node_net_throughput = node_net_throughput

    @property
    def node_persistent_storage(self):
        """Gets the node_persistent_storage of this ClusterAlertSettings.  # noqa: E501

        Node persistent storage has reached the threshold value [% of the storage limit]  # noqa: E501

        :return: The node_persistent_storage of this ClusterAlertSettings.  # noqa: E501
        :rtype: AllOfclusterAlertSettingsNodePersistentStorage
        """
        return self._node_persistent_storage

    @node_persistent_storage.setter
    def node_persistent_storage(self, node_persistent_storage):
        """Sets the node_persistent_storage of this ClusterAlertSettings.

        Node persistent storage has reached the threshold value [% of the storage limit]  # noqa: E501

        :param node_persistent_storage: The node_persistent_storage of this ClusterAlertSettings.  # noqa: E501
        :type: AllOfclusterAlertSettingsNodePersistentStorage
        """

        self._node_persistent_storage = node_persistent_storage

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ClusterAlertSettings, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ClusterAlertSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
