# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ActionsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_v1_bdbs_uid_actions_optimize_shards_placement(self, uid, **kwargs):  # noqa: E501
        """Get optimized shards placement for the given database.  # noqa: E501

        The blueprint returned as the result of this call can be submitted via PUT to the database as the shards_blueprint field. This will cause the shards to be rearranged according to this blueprint. One should use the cluster-state-id feature when trying to optimize the shards placement using the plan returned by this api call. The cluster-state-id returned in the header of this api call, should be passed in the headers of the PUT request on the database, in order to make sure that the optimized shard placement is relevant for the current cluster state. The cluster will reject the update if its state was changed since the optimal shards placement was obtained.  Note that submitting such an optimized blueprint may cause strain on the cluster and its resources, and should therefore be used with caution.  | Required permissions | |--| | view_bdb_info |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v1_bdbs_uid_actions_optimize_shards_placement(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: (required)
        :return: BdbShardsBlueprint
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v1_bdbs_uid_actions_optimize_shards_placement_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v1_bdbs_uid_actions_optimize_shards_placement_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def get_v1_bdbs_uid_actions_optimize_shards_placement_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Get optimized shards placement for the given database.  # noqa: E501

        The blueprint returned as the result of this call can be submitted via PUT to the database as the shards_blueprint field. This will cause the shards to be rearranged according to this blueprint. One should use the cluster-state-id feature when trying to optimize the shards placement using the plan returned by this api call. The cluster-state-id returned in the header of this api call, should be passed in the headers of the PUT request on the database, in order to make sure that the optimized shard placement is relevant for the current cluster state. The cluster will reject the update if its state was changed since the optimal shards placement was obtained.  Note that submitting such an optimized blueprint may cause strain on the cluster and its resources, and should therefore be used with caution.  | Required permissions | |--| | view_bdb_info |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v1_bdbs_uid_actions_optimize_shards_placement_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: (required)
        :return: BdbShardsBlueprint
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v1_bdbs_uid_actions_optimize_shards_placement" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `get_v1_bdbs_uid_actions_optimize_shards_placement`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/actions/optimize_shards_placement', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BdbShardsBlueprint',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_v1_bdbs_uid_actions_recover(self, uid, **kwargs):  # noqa: E501
        """Fetch the recovery plan for a database in recovery mode  # noqa: E501

        Fetch the recovery plan for a database in recovery mode. The recovery plan provides information about the recovery status (if it is possible) and specific detail on which available files to recovery from have been found.  uid – The unique ID of the database for which recovery plan is required. The database must be in recovery mode.  | Required permissions | |---| | view_bdb_recovery_plan |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v1_bdbs_uid_actions_recover(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database to recover. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_v1_bdbs_uid_actions_recover_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_v1_bdbs_uid_actions_recover_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def get_v1_bdbs_uid_actions_recover_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Fetch the recovery plan for a database in recovery mode  # noqa: E501

        Fetch the recovery plan for a database in recovery mode. The recovery plan provides information about the recovery status (if it is possible) and specific detail on which available files to recovery from have been found.  uid – The unique ID of the database for which recovery plan is required. The database must be in recovery mode.  | Required permissions | |---| | view_bdb_recovery_plan |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_v1_bdbs_uid_actions_recover_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database to recover. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_v1_bdbs_uid_actions_recover" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `get_v1_bdbs_uid_actions_recover`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/actions/recover', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v1_bdbs_uid_actions_export(self, uid, **kwargs):  # noqa: E501
        """Initiate a database export.  # noqa: E501

        Initiate a database export.  See [Backup Location](https://redislabs-training.github.io/rs-rest-api-schema-explorer/docs/6.2.4-55/http_rest_api.html#backup-location) for more details on the backup location types.  | Required permissions | |---| | start_bdb_export |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v1_bdbs_uid_actions_export(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database (required)
        :param ActionsExportBody body: The request body should contain a JSON object
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v1_bdbs_uid_actions_export_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v1_bdbs_uid_actions_export_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def post_v1_bdbs_uid_actions_export_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Initiate a database export.  # noqa: E501

        Initiate a database export.  See [Backup Location](https://redislabs-training.github.io/rs-rest-api-schema-explorer/docs/6.2.4-55/http_rest_api.html#backup-location) for more details on the backup location types.  | Required permissions | |---| | start_bdb_export |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v1_bdbs_uid_actions_export_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database (required)
        :param ActionsExportBody body: The request body should contain a JSON object
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v1_bdbs_uid_actions_export" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_v1_bdbs_uid_actions_export`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/actions/export', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v1_bdbs_uid_actions_import(self, uid, **kwargs):  # noqa: E501
        """Initiate a manual import process.  # noqa: E501

        Initiate a manual import process.  The request may contain a subset of the bdb JSON object, which includes the following import-related attributes:  | Attribute | Description | |---|---| | dataset_import_sources | details for the import sources. GET /jsonschema on the bdb object and review the dataset_import_sources field to retrieve the object’s structure. | | email_notification | optional, when true an email on failure/completion will be sent when import is done. |  See [Import Sources](https://redislabs-training.github.io/rs-rest-api-schema-explorer/docs/6.2.4-55/http_rest_api.html#import-sources) for more details on the import location types.   Other attributes are not allowed and will fail the request.  | Required permissions | |---| | start_bdb_import |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v1_bdbs_uid_actions_import(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database (required)
        :param ActionsImportBody body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v1_bdbs_uid_actions_import_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v1_bdbs_uid_actions_import_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def post_v1_bdbs_uid_actions_import_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Initiate a manual import process.  # noqa: E501

        Initiate a manual import process.  The request may contain a subset of the bdb JSON object, which includes the following import-related attributes:  | Attribute | Description | |---|---| | dataset_import_sources | details for the import sources. GET /jsonschema on the bdb object and review the dataset_import_sources field to retrieve the object’s structure. | | email_notification | optional, when true an email on failure/completion will be sent when import is done. |  See [Import Sources](https://redislabs-training.github.io/rs-rest-api-schema-explorer/docs/6.2.4-55/http_rest_api.html#import-sources) for more details on the import location types.   Other attributes are not allowed and will fail the request.  | Required permissions | |---| | start_bdb_import |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v1_bdbs_uid_actions_import_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database (required)
        :param ActionsImportBody body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v1_bdbs_uid_actions_import" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_v1_bdbs_uid_actions_import`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/actions/import', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v1_bdbs_uid_actions_recover(self, uid, **kwargs):  # noqa: E501
        """Initiate recovery for a database in recovery state.  # noqa: E501

        Initiate recovery for a database in recovery state.  The request body may be empty, in which case the database will be recovered automatically:   - Databases with no persistence are recovered with no data.  - Persistent files (aof, rdb) will be loaded from their expected storage locations (i.e. where slave or master shards were last active).  - If persistent files are not found where expected but can be located on other cluster nodes, they will be used. In addition, the request may include a request body with an explicit recovery plan.  | Required permissions | |---| | start_bdb_recovery |  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v1_bdbs_uid_actions_recover(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database to recover. (required)
        :param ActionsRecoverBody body: Optional body -- The request body may be empty, in which case the database will be recovered automatically.

The request may include a request body with an explicit recovery plan.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v1_bdbs_uid_actions_recover_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v1_bdbs_uid_actions_recover_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def post_v1_bdbs_uid_actions_recover_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Initiate recovery for a database in recovery state.  # noqa: E501

        Initiate recovery for a database in recovery state.  The request body may be empty, in which case the database will be recovered automatically:   - Databases with no persistence are recovered with no data.  - Persistent files (aof, rdb) will be loaded from their expected storage locations (i.e. where slave or master shards were last active).  - If persistent files are not found where expected but can be located on other cluster nodes, they will be used. In addition, the request may include a request body with an explicit recovery plan.  | Required permissions | |---| | start_bdb_recovery |  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v1_bdbs_uid_actions_recover_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database to recover. (required)
        :param ActionsRecoverBody body: Optional body -- The request body may be empty, in which case the database will be recovered automatically.

The request may include a request body with an explicit recovery plan.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v1_bdbs_uid_actions_recover" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_v1_bdbs_uid_actions_recover`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/actions/recover', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_v1_bdbs_uid_command(self, uid, **kwargs):  # noqa: E501
        """Execute a redis/memcached command  # noqa: E501

        Execute a redis/memcached command, per the db type.  The request must contain a redis command JSON representation consists of a ‘command’ field. It may also consist of an ‘args’ array.  | Required permissions: |---| | execute_redis_or_memcached_command |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v1_bdbs_uid_command(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int uid: The uid of the db on which the command will be performed. (required)
        :param DbCommand body: The request must contain a redis command JSON representation consists of a ‘command’ field. It may also consist of an ‘args’ array.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_v1_bdbs_uid_command_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.post_v1_bdbs_uid_command_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def post_v1_bdbs_uid_command_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Execute a redis/memcached command  # noqa: E501

        Execute a redis/memcached command, per the db type.  The request must contain a redis command JSON representation consists of a ‘command’ field. It may also consist of an ‘args’ array.  | Required permissions: |---| | execute_redis_or_memcached_command |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_v1_bdbs_uid_command_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int uid: The uid of the db on which the command will be performed. (required)
        :param DbCommand body: The request must contain a redis command JSON representation consists of a ‘command’ field. It may also consist of an ‘args’ array.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_v1_bdbs_uid_command" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `post_v1_bdbs_uid_command`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/command', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_v1_bdbs_uid_action(self, uid, action, **kwargs):  # noqa: E501
        """Update the configuration of an active database.  # noqa: E501

        Update the configuration of an active database.  If passed with the dry_run URL query string, the function will validate the bdb object against the existing bdb, but will not invoke the state machine that will update it.  The above request attempts to modify a database configuration to enable in-memory data replication and Append-Only File data persistence.  Note: Changing the shard hashing policy requires flushing all keys from the database.  When errors are reported, the server may return a JSON object with error_code and message field that provide additional information. The following are possible error_code values:  | Code | Description | |---|---| | rack_awareness_violation | Non rack aware cluster. Not enough nodes in unique racks. | | invalid_certificate | SSL client certificate is missing or malformed. | | certificate_expired | SSL client certificate has expired. | | duplicated_certs | An SSL client certificate appears more than once. | | insufficient_resources | Shards count exceeds shards limit per bdb. | | not_supported_action_on_crdt | reset_admin_pass action is not allowed on CRDT enabled BDB. | | name_violation | CRDT database name can not be changed. | | bad_shards_blueprint | The sharding blueprint is broken or doesn’t fit the BDB. | | replication_violation | CRDT database must use replication. | | eviction_policy_violation | LFU eviction policy is not supported on bdb version<4 | | replication_node_violation | Not enough nodes for replication. | | replication_size_violation | Database limit too small for replication | | invalid_oss_cluster_configuration | BDB configuration does not meet the requirements for oss cluster mode | | missing_backup_interval | BDB backup is enabled but backup interval is missing. | | crdt_sharding_violation | CRDB created without sharding cannot be changed to use sharding | | invalid_proxy_policy | Invalid proxy_policy value. | | invalid_bdb_tags | Tag objects with the same key parameter were passed | | unsupported_module_capabilities | Not all modules configured for the database support the capabilities needed for the database configuration | | redis_acl_unsupported | Redis ACL is not supported for this database |  | Required permissions | |---| | update_bdb_with_action |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v1_bdbs_uid_action(uid, action, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database for which update is requested. (required)
        :param str action: Additional action to perform. Currently the supported actions are: flush, reset_admin_pass. (required)
        :param Bdb body:
        :param str dry_run: Validate the bdb object against the existing bdb, but do not invoke the state machine to update it.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_v1_bdbs_uid_action_with_http_info(uid, action, **kwargs)  # noqa: E501
        else:
            (data) = self.put_v1_bdbs_uid_action_with_http_info(uid, action, **kwargs)  # noqa: E501
            return data

    def put_v1_bdbs_uid_action_with_http_info(self, uid, action, **kwargs):  # noqa: E501
        """Update the configuration of an active database.  # noqa: E501

        Update the configuration of an active database.  If passed with the dry_run URL query string, the function will validate the bdb object against the existing bdb, but will not invoke the state machine that will update it.  The above request attempts to modify a database configuration to enable in-memory data replication and Append-Only File data persistence.  Note: Changing the shard hashing policy requires flushing all keys from the database.  When errors are reported, the server may return a JSON object with error_code and message field that provide additional information. The following are possible error_code values:  | Code | Description | |---|---| | rack_awareness_violation | Non rack aware cluster. Not enough nodes in unique racks. | | invalid_certificate | SSL client certificate is missing or malformed. | | certificate_expired | SSL client certificate has expired. | | duplicated_certs | An SSL client certificate appears more than once. | | insufficient_resources | Shards count exceeds shards limit per bdb. | | not_supported_action_on_crdt | reset_admin_pass action is not allowed on CRDT enabled BDB. | | name_violation | CRDT database name can not be changed. | | bad_shards_blueprint | The sharding blueprint is broken or doesn’t fit the BDB. | | replication_violation | CRDT database must use replication. | | eviction_policy_violation | LFU eviction policy is not supported on bdb version<4 | | replication_node_violation | Not enough nodes for replication. | | replication_size_violation | Database limit too small for replication | | invalid_oss_cluster_configuration | BDB configuration does not meet the requirements for oss cluster mode | | missing_backup_interval | BDB backup is enabled but backup interval is missing. | | crdt_sharding_violation | CRDB created without sharding cannot be changed to use sharding | | invalid_proxy_policy | Invalid proxy_policy value. | | invalid_bdb_tags | Tag objects with the same key parameter were passed | | unsupported_module_capabilities | Not all modules configured for the database support the capabilities needed for the database configuration | | redis_acl_unsupported | Redis ACL is not supported for this database |  | Required permissions | |---| | update_bdb_with_action |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v1_bdbs_uid_action_with_http_info(uid, action, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database for which update is requested. (required)
        :param str action: Additional action to perform. Currently the supported actions are: flush, reset_admin_pass. (required)
        :param Bdb body:
        :param str dry_run: Validate the bdb object against the existing bdb, but do not invoke the state machine to update it.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid', 'action', 'body', 'dry_run']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_v1_bdbs_uid_action" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `put_v1_bdbs_uid_action`")  # noqa: E501
        # verify the required parameter 'action' is set
        if ('action' not in params or
                params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `put_v1_bdbs_uid_action`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501
        if 'action' in params:
            path_params['action'] = params['action']  # noqa: E501

        query_params = []
        if 'dry_run' in params:
            query_params.append(('dry_run', params['dry_run']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/{action}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_v1_bdbs_uid_actions_backup_reset_status(self, uid, **kwargs):  # noqa: E501
        """Reset database current backup status  # noqa: E501

        Reset database current backup status (backup_status) to idle if not in progress. As well clear exiting backup_failure_reason if exits  The above request resets backup_status to idle value and clear failure reason message if exist from backup_failure_reason.  | Required permissions | |---| | reset_bdb_current_backup_status |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v1_bdbs_uid_actions_backup_reset_status(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_v1_bdbs_uid_actions_backup_reset_status_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_v1_bdbs_uid_actions_backup_reset_status_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def put_v1_bdbs_uid_actions_backup_reset_status_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Reset database current backup status  # noqa: E501

        Reset database current backup status (backup_status) to idle if not in progress. As well clear exiting backup_failure_reason if exits  The above request resets backup_status to idle value and clear failure reason message if exist from backup_failure_reason.  | Required permissions | |---| | reset_bdb_current_backup_status |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v1_bdbs_uid_actions_backup_reset_status_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_v1_bdbs_uid_actions_backup_reset_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `put_v1_bdbs_uid_actions_backup_reset_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/actions/backup_reset_status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def put_v1_bdbs_uid_actions_export_reset_status(self, uid, **kwargs):  # noqa: E501
        """Reset database current export status  # noqa: E501

        Reset database current export status (export_status) to idle if not in progress. As well clear exiting export_failure_reason if exits  The above request resets export_status to idle value and clear failure reason message if exist from export_failure_reason.  | Required permissions | |---| | reset_bdb_current_export_status |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v1_bdbs_uid_actions_export_reset_status(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_v1_bdbs_uid_actions_export_reset_status_with_http_info(uid, **kwargs)  # noqa: E501
        else:
            (data) = self.put_v1_bdbs_uid_actions_export_reset_status_with_http_info(uid, **kwargs)  # noqa: E501
            return data

    def put_v1_bdbs_uid_actions_export_reset_status_with_http_info(self, uid, **kwargs):  # noqa: E501
        """Reset database current export status  # noqa: E501

        Reset database current export status (export_status) to idle if not in progress. As well clear exiting export_failure_reason if exits  The above request resets export_status to idle value and clear failure reason message if exist from export_failure_reason.  | Required permissions | |---| | reset_bdb_current_export_status |   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_v1_bdbs_uid_actions_export_reset_status_with_http_info(uid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str uid: The unique ID of the database (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['uid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_v1_bdbs_uid_actions_export_reset_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'uid' is set
        if ('uid' not in params or
                params['uid'] is None):
            raise ValueError("Missing the required parameter `uid` when calling `put_v1_bdbs_uid_actions_export_reset_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'uid' in params:
            path_params['uid'] = params['uid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['YWRtaW5AcmVkaXNsYWJzLmNvbTppbXRoZWFkbWlu']  # noqa: E501

        return self.api_client.call_api(
            '/v1/bdbs/{uid}/actions/export_reset_status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
