/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
import { RestApiBaseProps, SpecRestApi } from "aws-cdk-lib/aws-apigateway";
import { Construct } from "constructs";
import { OpenApiOptions } from "./spec";
/**
 * Configuration for the OpenApiGatewayLambdaApi construct
 */
export interface OpenApiGatewayLambdaApiProps extends RestApiBaseProps, OpenApiOptions {
    /**
     * The parsed OpenAPI specification
     */
    readonly spec: any;
    /**
     * Path to the JSON open api spec
     */
    readonly specPath: string;
}
/**
 * A construct for creating an api gateway api based on the definition in the OpenAPI spec.
 */
export declare class OpenApiGatewayLambdaApi extends Construct {
    readonly api: SpecRestApi;
    constructor(scope: Construct, id: string, props: OpenApiGatewayLambdaApiProps);
}
