# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class ActiveFlowLogRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, flow_log_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # The ID of the flow log.
        self.flow_log_id = flow_log_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the flow log is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ActiveFlowLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ActiveFlowLogResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call is successful.
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ActiveFlowLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ActiveFlowLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ActiveFlowLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ActiveFlowLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ActiveFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTrafficMatchRuleToTrafficMarkingPolicyRequestTrafficMatchRules(TeaModel):
    def __init__(self, dst_cidr=None, dst_port_range=None, match_dscp=None, protocol=None, src_cidr=None,
                 src_port_range=None, traffic_match_rule_description=None, traffic_match_rule_name=None):
        # The destination CIDR block that is used to match packets.
        # 
        # The traffic classification rule matches the packets whose destination IP addresses fall within the specified destination CIDR block. If you do not set this parameter, packets are considered a match regardless of the DSCP value.
        self.dst_cidr = dst_cidr  # type: str
        # The destination port range that is used to match packets. Valid values: **-1** and **1** to **65535**.
        # 
        # The traffic classification rule matches the packets whose destination ports fall within the destination port range. If you do not set this parameter, packets are considered a match regardless of the DSCP value.
        # 
        # You can specify at most two ports. Take note of the following rules:
        # 
        # *   If you enter only one port number such as 1, the system matches the packets whose destination port is port 1.
        # *   If you enter two port numbers such as 1 and 200, the system matches the packets whose destination ports fall between 1 and 200.
        # *   If you enter two port numbers and one of them is -1, the other port number must also be -1. In this case, packets are considered a match regardless of the destination port.
        self.dst_port_range = dst_port_range  # type: list[int]
        # The differentiated services code point (DSCP) value that is used to match packets. Valid values: **0** to **63**.
        # 
        # The traffic classification rule matches the packets that contain the specified DSCP value. If you do not set this parameter, packets are considered a match regardless of the DSCP value.
        # 
        # >  The DSCP value that you specify for this parameter is the DSCP value that packets carry before they are transmitted over the inter-region connection.
        self.match_dscp = match_dscp  # type: int
        # The protocol that is used to match packets.
        # 
        # Valid values: **HTTP**, **HTTPS**, **TCP**, **UDP**, **SSH**, and **Telnet**. For more information, log on to the [Cloud Enterprise Network (CEN) console](https://cen.console.aliyun.com/cen/list).
        self.protocol = protocol  # type: str
        # The source CIDR block that is used to match packets.
        # 
        # The traffic classification rule matches the packets whose source IP addresses fall within the specified source CIDR block. If you do not set this parameter, packets are considered a match regardless of the source IP address.
        self.src_cidr = src_cidr  # type: str
        # The source port range that is used to match packets. Valid values: **-1** and **1** to **65535**.
        # 
        # The traffic classification rule matches the packets whose source ports fall within the source port range. If you do not set this parameter, packets are considered a match regardless of the source port.
        # 
        # You can specify at most two ports. Take note of the following rules:
        # 
        # *   If you enter only one port number such as 1, the system matches the packets whose source port is 1.
        # *   If you enter two port numbers such as 1 and 200, the system matches the packets whose source ports fall between 1 and 200.
        # *   If you enter two port numbers and one of them is -1, the other port number must also be -1. In this case, packets are considered a match regardless of the source port.
        self.src_port_range = src_port_range  # type: list[int]
        # The description of the traffic classification rule.
        # 
        # The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        self.traffic_match_rule_description = traffic_match_rule_description  # type: str
        # The name of the traffic classification rule.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.traffic_match_rule_name = traffic_match_rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTrafficMatchRuleToTrafficMarkingPolicyRequestTrafficMatchRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_cidr is not None:
            result['DstCidr'] = self.dst_cidr
        if self.dst_port_range is not None:
            result['DstPortRange'] = self.dst_port_range
        if self.match_dscp is not None:
            result['MatchDscp'] = self.match_dscp
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.src_cidr is not None:
            result['SrcCidr'] = self.src_cidr
        if self.src_port_range is not None:
            result['SrcPortRange'] = self.src_port_range
        if self.traffic_match_rule_description is not None:
            result['TrafficMatchRuleDescription'] = self.traffic_match_rule_description
        if self.traffic_match_rule_name is not None:
            result['TrafficMatchRuleName'] = self.traffic_match_rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstCidr') is not None:
            self.dst_cidr = m.get('DstCidr')
        if m.get('DstPortRange') is not None:
            self.dst_port_range = m.get('DstPortRange')
        if m.get('MatchDscp') is not None:
            self.match_dscp = m.get('MatchDscp')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('SrcCidr') is not None:
            self.src_cidr = m.get('SrcCidr')
        if m.get('SrcPortRange') is not None:
            self.src_port_range = m.get('SrcPortRange')
        if m.get('TrafficMatchRuleDescription') is not None:
            self.traffic_match_rule_description = m.get('TrafficMatchRuleDescription')
        if m.get('TrafficMatchRuleName') is not None:
            self.traffic_match_rule_name = m.get('TrafficMatchRuleName')
        return self


class AddTrafficMatchRuleToTrafficMarkingPolicyRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, traffic_marking_policy_id=None, traffic_match_rules=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request format, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the traffic marking policy.
        self.traffic_marking_policy_id = traffic_marking_policy_id  # type: str
        # The traffic classification rules.
        # 
        # You can specify at most 50 traffic classification rules.
        self.traffic_match_rules = traffic_match_rules  # type: list[AddTrafficMatchRuleToTrafficMarkingPolicyRequestTrafficMatchRules]

    def validate(self):
        if self.traffic_match_rules:
            for k in self.traffic_match_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddTrafficMatchRuleToTrafficMarkingPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_marking_policy_id is not None:
            result['TrafficMarkingPolicyId'] = self.traffic_marking_policy_id
        result['TrafficMatchRules'] = []
        if self.traffic_match_rules is not None:
            for k in self.traffic_match_rules:
                result['TrafficMatchRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficMarkingPolicyId') is not None:
            self.traffic_marking_policy_id = m.get('TrafficMarkingPolicyId')
        self.traffic_match_rules = []
        if m.get('TrafficMatchRules') is not None:
            for k in m.get('TrafficMatchRules'):
                temp_model = AddTrafficMatchRuleToTrafficMarkingPolicyRequestTrafficMatchRules()
                self.traffic_match_rules.append(temp_model.from_map(k))
        return self


class AddTrafficMatchRuleToTrafficMarkingPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTrafficMatchRuleToTrafficMarkingPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTrafficMatchRuleToTrafficMarkingPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTrafficMatchRuleToTrafficMarkingPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTrafficMatchRuleToTrafficMarkingPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTrafficMatchRuleToTrafficMarkingPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTraficMatchRuleToTrafficMarkingPolicyRequestTrafficMatchRules(TeaModel):
    def __init__(self, dst_cidr=None, dst_port_range=None, match_dscp=None, protocol=None, src_cidr=None,
                 src_port_range=None, traffic_match_rule_description=None, traffic_match_rule_name=None):
        # The destination CIDR block that is used to match packets.
        # 
        # The traffic classification rule matches the packets whose destination IP addresses fall within the specified destination CIDR block. If you do not set this parameter, packets are considered a match regardless of the DSCP value.
        # 
        # You can specify at most 50 traffic classification rules.
        self.dst_cidr = dst_cidr  # type: str
        # The destination port range that is used to match packets. Valid values: **-1** and **1** to **65535**.
        # 
        # The traffic classification rule matches the packets whose destination ports fall within the destination port range. If you do not set this parameter, packets are considered a match regardless of the DSCP value.
        # 
        # You can specify at most two ports. Take note of the following rules:
        # 
        # *   If you enter only one port number such as 1, the system matches the packets whose destination port is port 1.
        # *   If you enter two port numbers such as 1 and 200, the system matches the packets whose destination ports fall between 1 and 200.
        # *   If you enter two port numbers and one of them is -1, the other port number must also be -1. In this case, packets are considered a match regardless of the destination port.
        # 
        # You can specify at most 50 traffic classification rules.
        self.dst_port_range = dst_port_range  # type: list[int]
        # The differentiated services code point (DSCP) value that is used to match packets. Valid values: **0** to **63**.
        # 
        # The traffic classification rule matches the packets that contain the specified DSCP value. If you do not set this parameter, packets are considered a match regardless of the DSCP value.
        # 
        # >  The DSCP value that you specify for this parameter is the DSCP value that packets carry before they are transmitted over the inter-region connection.
        # 
        # You can specify at most 50 traffic classification rules.
        self.match_dscp = match_dscp  # type: int
        # The protocol that is used to match packets.
        # 
        # Valid values: **HTTP**, **HTTPS**, **TCP**, **UDP**, **SSH**, and **Telnet**. For more information, log on to the [Cloud Enterprise Network (CEN) console](https://cen.console.aliyun.com/cen/list).
        # 
        # You can specify at most 50 traffic classification rules.
        self.protocol = protocol  # type: str
        # The source CIDR block that is used to match packets.
        # 
        # The traffic classification rule matches the packets whose source IP addresses fall within the specified source CIDR block. If you do not set this parameter, packets are considered a match regardless of the source IP address.
        # 
        # You can specify at most 50 traffic classification rules.
        self.src_cidr = src_cidr  # type: str
        # The source port range that is used to match packets. Valid values: **-1** and **1** to **65535**.
        # 
        # The traffic classification rule matches the packets whose source ports fall within the source port range. If you do not set this parameter, packets are considered a match regardless of the source port.
        # 
        # You can specify at most two ports. Take note of the following rules:
        # 
        # *   If you enter only one port number such as 1, the system matches the packets whose source port is 1.
        # *   If you enter two port numbers such as 1 and 200, the system matches the packets whose source ports fall between 1 and 200.
        # *   If you enter two port numbers and one of them is -1, the other port number must also be -1. In this case, packets are considered a match regardless of the source port.
        # 
        # You can specify at most 50 traffic classification rules.
        self.src_port_range = src_port_range  # type: list[int]
        # The description of the traffic classification rule.
        # 
        # The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        # 
        # You can specify at most 50 traffic classification rules.
        self.traffic_match_rule_description = traffic_match_rule_description  # type: str
        # The name of the traffic classification rule.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        # 
        # You can specify at most 50 traffic classification rules.
        self.traffic_match_rule_name = traffic_match_rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTraficMatchRuleToTrafficMarkingPolicyRequestTrafficMatchRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_cidr is not None:
            result['DstCidr'] = self.dst_cidr
        if self.dst_port_range is not None:
            result['DstPortRange'] = self.dst_port_range
        if self.match_dscp is not None:
            result['MatchDscp'] = self.match_dscp
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.src_cidr is not None:
            result['SrcCidr'] = self.src_cidr
        if self.src_port_range is not None:
            result['SrcPortRange'] = self.src_port_range
        if self.traffic_match_rule_description is not None:
            result['TrafficMatchRuleDescription'] = self.traffic_match_rule_description
        if self.traffic_match_rule_name is not None:
            result['TrafficMatchRuleName'] = self.traffic_match_rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstCidr') is not None:
            self.dst_cidr = m.get('DstCidr')
        if m.get('DstPortRange') is not None:
            self.dst_port_range = m.get('DstPortRange')
        if m.get('MatchDscp') is not None:
            self.match_dscp = m.get('MatchDscp')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('SrcCidr') is not None:
            self.src_cidr = m.get('SrcCidr')
        if m.get('SrcPortRange') is not None:
            self.src_port_range = m.get('SrcPortRange')
        if m.get('TrafficMatchRuleDescription') is not None:
            self.traffic_match_rule_description = m.get('TrafficMatchRuleDescription')
        if m.get('TrafficMatchRuleName') is not None:
            self.traffic_match_rule_name = m.get('TrafficMatchRuleName')
        return self


class AddTraficMatchRuleToTrafficMarkingPolicyRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, traffic_marking_policy_id=None, traffic_match_rules=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId may be different for each request.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request syntax, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the traffic marking policy.
        self.traffic_marking_policy_id = traffic_marking_policy_id  # type: str
        # The information about the traffic classification rule.
        # 
        # You can specify at most 50 traffic classification rules.
        self.traffic_match_rules = traffic_match_rules  # type: list[AddTraficMatchRuleToTrafficMarkingPolicyRequestTrafficMatchRules]

    def validate(self):
        if self.traffic_match_rules:
            for k in self.traffic_match_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddTraficMatchRuleToTrafficMarkingPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_marking_policy_id is not None:
            result['TrafficMarkingPolicyId'] = self.traffic_marking_policy_id
        result['TrafficMatchRules'] = []
        if self.traffic_match_rules is not None:
            for k in self.traffic_match_rules:
                result['TrafficMatchRules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficMarkingPolicyId') is not None:
            self.traffic_marking_policy_id = m.get('TrafficMarkingPolicyId')
        self.traffic_match_rules = []
        if m.get('TrafficMatchRules') is not None:
            for k in m.get('TrafficMatchRules'):
                temp_model = AddTraficMatchRuleToTrafficMarkingPolicyRequestTrafficMatchRules()
                self.traffic_match_rules.append(temp_model.from_map(k))
        return self


class AddTraficMatchRuleToTrafficMarkingPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddTraficMatchRuleToTrafficMarkingPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTraficMatchRuleToTrafficMarkingPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddTraficMatchRuleToTrafficMarkingPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddTraficMatchRuleToTrafficMarkingPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTraficMatchRuleToTrafficMarkingPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateCenBandwidthPackageRequest(TeaModel):
    def __init__(self, cen_bandwidth_package_id=None, cen_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the bandwidth plan.
        self.cen_bandwidth_package_id = cen_bandwidth_package_id  # type: str
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateCenBandwidthPackageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_bandwidth_package_id is not None:
            result['CenBandwidthPackageId'] = self.cen_bandwidth_package_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenBandwidthPackageId') is not None:
            self.cen_bandwidth_package_id = m.get('CenBandwidthPackageId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AssociateCenBandwidthPackageResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateCenBandwidthPackageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateCenBandwidthPackageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AssociateCenBandwidthPackageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssociateCenBandwidthPackageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateCenBandwidthPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateTransitRouterAttachmentWithRouteTableRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None,
                 transit_router_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # > If you do not specify this parameter, the system automatically uses the value of **RequestId**as the value of **ClientToken**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **false** (default): performs a dry run. If the request passes the dry run, the associated forwarding correlation is created.
        # *   **true**: performs a dry run and sends the request. If you use this value, the system checks whether the required parameters are set, and whether the request syntax is valid. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the route table of the Enterprise Edition transit router.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateTransitRouterAttachmentWithRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        return self


class AssociateTransitRouterAttachmentWithRouteTableResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateTransitRouterAttachmentWithRouteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateTransitRouterAttachmentWithRouteTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AssociateTransitRouterAttachmentWithRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssociateTransitRouterAttachmentWithRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateTransitRouterAttachmentWithRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AssociateTransitRouterMulticastDomainRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None,
                 transit_router_multicast_domain_id=None, v_switch_ids=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        self.client_token = client_token  # type: str
        # Specifies whether only to precheck the API request. Valid values:
        # 
        # *   **true**: prechecks the request but does not associate the vSwitch with the multicast domain. The system checks the required parameters, the request format, and the service limits. If the request fails the check, an error message is returned. If the request passes the check, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. The vSwitch is associated with the multicast domain after the request passes the precheck.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the VPC connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str
        # The vSwitch IDs.
        # 
        # You can specify at most five vSwitch IDs in each call.
        self.v_switch_ids = v_switch_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateTransitRouterMulticastDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class AssociateTransitRouterMulticastDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AssociateTransitRouterMulticastDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AssociateTransitRouterMulticastDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AssociateTransitRouterMulticastDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AssociateTransitRouterMulticastDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AssociateTransitRouterMulticastDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachCenChildInstanceRequest(TeaModel):
    def __init__(self, cen_id=None, child_instance_id=None, child_instance_owner_id=None,
                 child_instance_region_id=None, child_instance_type=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the network instance that you want to attach to the CEN instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the Alibaba Cloud account to which the network instance belongs.
        # 
        # > If the network instance and the CEN instance belong to different Alibaba Cloud accounts, this parameter is required.
        self.child_instance_owner_id = child_instance_owner_id  # type: long
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: virtual private cloud (VPC)
        # *   **VBR**: virtual border router (VBR)
        # *   **CCN**: CCN instance
        self.child_instance_type = child_instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachCenChildInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_owner_id is not None:
            result['ChildInstanceOwnerId'] = self.child_instance_owner_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceOwnerId') is not None:
            self.child_instance_owner_id = m.get('ChildInstanceOwnerId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AttachCenChildInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachCenChildInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AttachCenChildInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachCenChildInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachCenChildInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachCenChildInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckTransitRouterServiceRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate a token, but you must make sure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckTransitRouterServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class CheckTransitRouterServiceResponseBody(TeaModel):
    def __init__(self, enabled=None, request_id=None):
        # Indicates whether the transit router feature is activated.
        # 
        # *   **true**: activated
        # *   If this value is not returned, the system prompts that the current account does not have the transit router feature activated.
        self.enabled = enabled  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CheckTransitRouterServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckTransitRouterServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CheckTransitRouterServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CheckTransitRouterServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckTransitRouterServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCenRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag keys of the resources.
        # 
        # The tag keys cannot be an empty string. The tag keys can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag values of the resources.
        # 
        # The tag values can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key has a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateCenRequest(TeaModel):
    def __init__(self, client_token=None, description=None, name=None, owner_account=None, owner_id=None,
                 protection_level=None, resource_owner_account=None, resource_owner_id=None, tag=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # The description of the CEN instance.
        # 
        # The description must be 2 to 256 characters in length. It must start with a letter and cannot start with `http://` or `https://`.
        self.description = description  # type: str
        # The name of the CEN instance.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter and cannot start with `http://` or `https://`.
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The level of CIDR block overlapping.
        # 
        # Set the value to **REDUCED** (default). This value specifies that CIDR blocks can overlap but cannot be the same.
        self.protection_level = protection_level  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The tags.
        self.tag = tag  # type: list[CreateCenRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.protection_level is not None:
            result['ProtectionLevel'] = self.protection_level
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProtectionLevel') is not None:
            self.protection_level = m.get('ProtectionLevel')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateCenRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateCenResponseBody(TeaModel):
    def __init__(self, cen_id=None, request_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCenBandwidthPackageRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag keys of the resources.
        # 
        # The tag keys cannot be an empty string. The tag keys can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag values of the resources.
        # 
        # The tag values can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key has a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenBandwidthPackageRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateCenBandwidthPackageRequest(TeaModel):
    def __init__(self, auto_pay=None, auto_renew=None, auto_renew_duration=None, bandwidth=None,
                 bandwidth_package_charge_type=None, client_token=None, description=None, geographic_region_aid=None, geographic_region_bid=None,
                 name=None, owner_account=None, owner_id=None, period=None, pricing_cycle=None,
                 resource_owner_account=None, resource_owner_id=None, tag=None):
        # Specifies whether to automatically complete the payment of the bandwidth plan. Valid values:
        # 
        # *   **true**: yes
        # *   **false** (default): no
        # 
        # If you set the parameter to false, go to Billing Management to complete the payment after you call this operation. The instance is created only after you complete the payment.
        self.auto_pay = auto_pay  # type: bool
        self.auto_renew = auto_renew  # type: bool
        self.auto_renew_duration = auto_renew_duration  # type: int
        # The maximum bandwidth value of the bandwidth plan. Unit: Mbit/s. Valid values: **2** to **10000**.
        self.bandwidth = bandwidth  # type: int
        # The billing method of the bandwidth plan. Valid value: **PREPAY**, which indicates that the billing method is pay-as-you-go.
        self.bandwidth_package_charge_type = bandwidth_package_charge_type  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate a token, but you must make sure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # The description of the bandwidth plan.
        self.description = description  # type: str
        # The area where the network instance is deployed. Valid values:
        # 
        # *   **China**: Chinese mainland
        # *   **North-America**: North America
        # *   **Asia-Pacific**: Asia Pacific
        # *   **Europe**: Europe
        # *   **Australia**: Australia
        self.geographic_region_aid = geographic_region_aid  # type: str
        # The area where the other network instance is deployed. Valid values: Valid values:
        # 
        # *   **China**: Chinese mainland
        # *   **North-America**: North America
        # *   **Asia-Pacific**: Asia Pacific
        # *   **Europe**: Europe
        # *   **Australia**: Australia
        self.geographic_region_bid = geographic_region_bid  # type: str
        # The name of the bandwidth plan.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter and cannot start with `http://` or `https://`.
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The subscription duration of the bandwidth plan. Default value: 1.
        # 
        # *   If **PricingCycle** is set to **Month**, set **Period** to a value from **1** to **3** or **6**.
        # *   If **PricingCycle** is set to **Year**, set **Period** to a value from **1** to **3**.
        # 
        # >  This parameter is required when **BandwidthPackageChargeType** is set to **PREPAY**.
        self.period = period  # type: int
        # The billing cycle of the bandwidth plan. Valid values:
        # 
        # *   **Month** (default): billed on a monthly basis.
        # *   **Year**: billed on an annual basis.
        self.pricing_cycle = pricing_cycle  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The tags.
        self.tag = tag  # type: list[CreateCenBandwidthPackageRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCenBandwidthPackageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_pay is not None:
            result['AutoPay'] = self.auto_pay
        if self.auto_renew is not None:
            result['AutoRenew'] = self.auto_renew
        if self.auto_renew_duration is not None:
            result['AutoRenewDuration'] = self.auto_renew_duration
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.bandwidth_package_charge_type is not None:
            result['BandwidthPackageChargeType'] = self.bandwidth_package_charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.geographic_region_aid is not None:
            result['GeographicRegionAId'] = self.geographic_region_aid
        if self.geographic_region_bid is not None:
            result['GeographicRegionBId'] = self.geographic_region_bid
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.period is not None:
            result['Period'] = self.period
        if self.pricing_cycle is not None:
            result['PricingCycle'] = self.pricing_cycle
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPay') is not None:
            self.auto_pay = m.get('AutoPay')
        if m.get('AutoRenew') is not None:
            self.auto_renew = m.get('AutoRenew')
        if m.get('AutoRenewDuration') is not None:
            self.auto_renew_duration = m.get('AutoRenewDuration')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('BandwidthPackageChargeType') is not None:
            self.bandwidth_package_charge_type = m.get('BandwidthPackageChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('GeographicRegionAId') is not None:
            self.geographic_region_aid = m.get('GeographicRegionAId')
        if m.get('GeographicRegionBId') is not None:
            self.geographic_region_bid = m.get('GeographicRegionBId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        if m.get('PricingCycle') is not None:
            self.pricing_cycle = m.get('PricingCycle')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateCenBandwidthPackageRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class CreateCenBandwidthPackageResponseBody(TeaModel):
    def __init__(self, cen_bandwidth_package_id=None, cen_bandwidth_package_order_id=None, request_id=None):
        # The ID of the bandwidth plan.
        self.cen_bandwidth_package_id = cen_bandwidth_package_id  # type: str
        # The ID of the order for the bandwidth plan.
        self.cen_bandwidth_package_order_id = cen_bandwidth_package_order_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenBandwidthPackageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_bandwidth_package_id is not None:
            result['CenBandwidthPackageId'] = self.cen_bandwidth_package_id
        if self.cen_bandwidth_package_order_id is not None:
            result['CenBandwidthPackageOrderId'] = self.cen_bandwidth_package_order_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenBandwidthPackageId') is not None:
            self.cen_bandwidth_package_id = m.get('CenBandwidthPackageId')
        if m.get('CenBandwidthPackageOrderId') is not None:
            self.cen_bandwidth_package_order_id = m.get('CenBandwidthPackageOrderId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCenBandwidthPackageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCenBandwidthPackageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCenBandwidthPackageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCenBandwidthPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCenChildInstanceRouteEntryToAttachmentRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, destination_cidr_block=None, dry_run=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None, route_table_id=None,
                 transit_router_attachment_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that the value is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # The destination CIDR block of the route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # Specifies whether to check the request but not perform the operation. The system checks the permissions and the status of the specified instances. Valid values:
        # 
        # *   **false**: performs a precheck. The route is added to the network instance after the request passes the precheck. This is the default value.
        # *   **true**: performs a precheck. The route is not added to the network instance. If you use this value, the system checks the required parameters and the request syntax. If the request fails to pass the precheck, an error message is returned. If the request passes the check, the `DryRunOperation` error code is returned.
        # 
        # >  This parameter is not in use.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the route table configured on the network instance.
        self.route_table_id = route_table_id  # type: str
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenChildInstanceRouteEntryToAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class CreateCenChildInstanceRouteEntryToAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenChildInstanceRouteEntryToAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCenChildInstanceRouteEntryToAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCenChildInstanceRouteEntryToAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCenChildInstanceRouteEntryToAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCenChildInstanceRouteEntryToAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCenChildInstanceRouteEntryToCenRequest(TeaModel):
    def __init__(self, cen_id=None, child_instance_ali_uid=None, child_instance_id=None,
                 child_instance_region_id=None, child_instance_type=None, destination_cidr_block=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, route_table_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the Alibaba Cloud account to which the network instance belongs.
        # 
        # > If the network instance belongs to another Alibaba Cloud account, this parameter is required.
        self.child_instance_ali_uid = child_instance_ali_uid  # type: long
        # The ID of the network instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: a virtual private cloud (VPC)
        # *   **VBR**: a virtual border router (VBR)
        self.child_instance_type = child_instance_type  # type: str
        # The destination CIDR block of the route.
        # 
        # Specify the value of this parameter in CIDR notation. Example: 192.168.10.0/24.
        self.destination_cidr_block = destination_cidr_block  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the route table configured on the network instance.
        self.route_table_id = route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenChildInstanceRouteEntryToCenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_ali_uid is not None:
            result['ChildInstanceAliUid'] = self.child_instance_ali_uid
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceAliUid') is not None:
            self.child_instance_ali_uid = m.get('ChildInstanceAliUid')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class CreateCenChildInstanceRouteEntryToCenResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenChildInstanceRouteEntryToCenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCenChildInstanceRouteEntryToCenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCenChildInstanceRouteEntryToCenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCenChildInstanceRouteEntryToCenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCenChildInstanceRouteEntryToCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCenInterRegionTrafficQosPolicyRequestTrafficQosQueues(TeaModel):
    def __init__(self, dscps=None, qos_queue_description=None, qos_queue_name=None, remain_bandwidth_percent=None):
        # The differentiated services code point (DSCP) value that matches the current queue.
        # 
        # Each QoS policy supports up to three queues. You can specify at most 60 DSCP values for each queue. Separate DSCP values with commas (,).
        self.dscps = dscps  # type: list[int]
        # The description of the current queue.
        # 
        # Each QoS policy supports up to three queues. You can add a description to each queue.
        # 
        # The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        self.qos_queue_description = qos_queue_description  # type: str
        # The name of the current queue.
        # 
        # Each QoS policy supports up to three queues. You can specify a name for each queue.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.qos_queue_name = qos_queue_name  # type: str
        # The percentage of bandwidth resources that can be allocated to the current queue.
        # 
        # Each QoS policy supports up to three queues. You can specify a percentage of bandwidth resources for each queue.
        # 
        # If you enter **1**, it indicates that the current queue can consume at most 1% of the bandwidth resources.
        # 
        # >  The sum of the percentage values of all the queues in a QoS policy cannot exceed 100%.
        self.remain_bandwidth_percent = remain_bandwidth_percent  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenInterRegionTrafficQosPolicyRequestTrafficQosQueues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dscps is not None:
            result['Dscps'] = self.dscps
        if self.qos_queue_description is not None:
            result['QosQueueDescription'] = self.qos_queue_description
        if self.qos_queue_name is not None:
            result['QosQueueName'] = self.qos_queue_name
        if self.remain_bandwidth_percent is not None:
            result['RemainBandwidthPercent'] = self.remain_bandwidth_percent
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dscps') is not None:
            self.dscps = m.get('Dscps')
        if m.get('QosQueueDescription') is not None:
            self.qos_queue_description = m.get('QosQueueDescription')
        if m.get('QosQueueName') is not None:
            self.qos_queue_name = m.get('QosQueueName')
        if m.get('RemainBandwidthPercent') is not None:
            self.remain_bandwidth_percent = m.get('RemainBandwidthPercent')
        return self


class CreateCenInterRegionTrafficQosPolicyRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, traffic_qos_policy_description=None, traffic_qos_policy_name=None,
                 traffic_qos_queues=None, transit_router_attachment_id=None, transit_router_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters and cannot exceed 64 characters in length.
        self.client_token = client_token  # type: str
        # Specifies whether only to precheck the API request. Valid values:
        # 
        # *   **true**: prechecks the request but does not create the QoS policy. The system checks the required parameters, the request format, and the service limits. If the request fails the check, an error message is returned. If the request passes the check, the `DryRunOperation` error code is returned.
        # *   **false**: sends the API request. If the request passes the precheck, the QoS policy is created. This is the default value.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The description of the QoS policy.
        # 
        # The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        self.traffic_qos_policy_description = traffic_qos_policy_description  # type: str
        # The name of the QoS policy.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.traffic_qos_policy_name = traffic_qos_policy_name  # type: str
        # A list of QoS queues.
        # 
        # Each QoS policy supports up to three queues.
        self.traffic_qos_queues = traffic_qos_queues  # type: list[CreateCenInterRegionTrafficQosPolicyRequestTrafficQosQueues]
        # The ID of the inter-region connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        if self.traffic_qos_queues:
            for k in self.traffic_qos_queues:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateCenInterRegionTrafficQosPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_qos_policy_description is not None:
            result['TrafficQosPolicyDescription'] = self.traffic_qos_policy_description
        if self.traffic_qos_policy_name is not None:
            result['TrafficQosPolicyName'] = self.traffic_qos_policy_name
        result['TrafficQosQueues'] = []
        if self.traffic_qos_queues is not None:
            for k in self.traffic_qos_queues:
                result['TrafficQosQueues'].append(k.to_map() if k else None)
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficQosPolicyDescription') is not None:
            self.traffic_qos_policy_description = m.get('TrafficQosPolicyDescription')
        if m.get('TrafficQosPolicyName') is not None:
            self.traffic_qos_policy_name = m.get('TrafficQosPolicyName')
        self.traffic_qos_queues = []
        if m.get('TrafficQosQueues') is not None:
            for k in m.get('TrafficQosQueues'):
                temp_model = CreateCenInterRegionTrafficQosPolicyRequestTrafficQosQueues()
                self.traffic_qos_queues.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class CreateCenInterRegionTrafficQosPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None, traffic_qos_policy_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the QoS policy.
        self.traffic_qos_policy_id = traffic_qos_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenInterRegionTrafficQosPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.traffic_qos_policy_id is not None:
            result['TrafficQosPolicyId'] = self.traffic_qos_policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TrafficQosPolicyId') is not None:
            self.traffic_qos_policy_id = m.get('TrafficQosPolicyId')
        return self


class CreateCenInterRegionTrafficQosPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCenInterRegionTrafficQosPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCenInterRegionTrafficQosPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCenInterRegionTrafficQosPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCenInterRegionTrafficQosQueueRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, dscps=None, owner_account=None, owner_id=None,
                 qos_queue_description=None, qos_queue_name=None, remain_bandwidth_percent=None, resource_owner_account=None,
                 resource_owner_id=None, traffic_qos_policy_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId may be different for each request.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, the request format, and the service limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        # The differentiated services code point (DSCP) value that matches the current queue.
        # 
        # You can specify at most 20 DSCP values for a queue in each call. Separate DSCP values with commas (,).
        self.dscps = dscps  # type: list[int]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The description of the queue.
        # 
        # The description must be 1 to 256 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.qos_queue_description = qos_queue_description  # type: str
        # The name of the queue.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, hyphens (-), and underscores (\_). It must start with a letter.
        self.qos_queue_name = qos_queue_name  # type: str
        # The maximum bandwidth of the queue,
        # 
        # *   in percentage. For example, a value of 20 specifies that the queue can occupy at most 20% of the bandwidth allocated to the inter-region connection.
        # *   The sum of percentage values specified for all queues that belong to the same inter-region connection cannot exceed 100%.
        self.remain_bandwidth_percent = remain_bandwidth_percent  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the QoS policy.
        self.traffic_qos_policy_id = traffic_qos_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenInterRegionTrafficQosQueueRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.dscps is not None:
            result['Dscps'] = self.dscps
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_queue_description is not None:
            result['QosQueueDescription'] = self.qos_queue_description
        if self.qos_queue_name is not None:
            result['QosQueueName'] = self.qos_queue_name
        if self.remain_bandwidth_percent is not None:
            result['RemainBandwidthPercent'] = self.remain_bandwidth_percent
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_qos_policy_id is not None:
            result['TrafficQosPolicyId'] = self.traffic_qos_policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('Dscps') is not None:
            self.dscps = m.get('Dscps')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosQueueDescription') is not None:
            self.qos_queue_description = m.get('QosQueueDescription')
        if m.get('QosQueueName') is not None:
            self.qos_queue_name = m.get('QosQueueName')
        if m.get('RemainBandwidthPercent') is not None:
            self.remain_bandwidth_percent = m.get('RemainBandwidthPercent')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficQosPolicyId') is not None:
            self.traffic_qos_policy_id = m.get('TrafficQosPolicyId')
        return self


class CreateCenInterRegionTrafficQosQueueResponseBody(TeaModel):
    def __init__(self, qos_queue_id=None, request_id=None):
        # The ID of the queue.
        self.qos_queue_id = qos_queue_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenInterRegionTrafficQosQueueResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.qos_queue_id is not None:
            result['QosQueueId'] = self.qos_queue_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('QosQueueId') is not None:
            self.qos_queue_id = m.get('QosQueueId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCenInterRegionTrafficQosQueueResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCenInterRegionTrafficQosQueueResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCenInterRegionTrafficQosQueueResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCenInterRegionTrafficQosQueueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCenRouteMapRequest(TeaModel):
    def __init__(self, as_path_match_mode=None, cen_id=None, cen_region_id=None, cidr_match_mode=None,
                 community_match_mode=None, community_operate_mode=None, description=None, destination_child_instance_types=None,
                 destination_cidr_blocks=None, destination_instance_ids=None, destination_instance_ids_reverse_match=None,
                 destination_route_table_ids=None, map_result=None, match_address_type=None, match_asns=None, match_community_set=None,
                 next_priority=None, operate_community_set=None, owner_account=None, owner_id=None, preference=None,
                 prepend_as_path=None, priority=None, resource_owner_account=None, resource_owner_id=None, route_types=None,
                 source_child_instance_types=None, source_instance_ids=None, source_instance_ids_reverse_match=None, source_region_ids=None,
                 source_route_table_ids=None, transit_router_route_table_id=None, transmit_direction=None):
        # The match method that is used to match routes against the AS paths. Valid values:
        # 
        # *   **Include**: fuzzy match. A route meets the match condition if the AS path of the route overlaps with the AS paths specified in the match condition.
        # *   **Complete**: exact match. A route is a match only if the AS path of the route is the same as an AS path specified in the match condition.
        self.as_path_match_mode = as_path_match_mode  # type: str
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the region where the routing policy is applied.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.cen_region_id = cen_region_id  # type: str
        # The match method that is used to match routes against the prefix list. Valid values:
        # 
        # *   **Include**: fuzzy match. A route is a match if the route prefix is included in the match conditions.
        # 
        #     For example, if you set the match condition to 10.10.0.0/16 and fuzzy match is enabled, the route whose prefix is 10.10.1.0/24 is a match.
        # 
        # *   **Complete**: exact match. A route is a match only if the route prefix is the same as the prefix specified in the match condition.
        # 
        #     For example, if you set the match condition to 10.10.0.0/16 and exact match is enabled, a route is a match only if the prefix is 10.10.0.0/16.
        self.cidr_match_mode = cidr_match_mode  # type: str
        # The match method that is used to match routes against the community. Valid values:
        # 
        # *   **Include**: fuzzy match. A route meets the match condition if the community of the route overlaps with the community specified in the match condition.
        # *   **Complete**: exact match. A route meets the match condition only if the community of the route is the same as the community specified in the match condition.
        self.community_match_mode = community_match_mode  # type: str
        # The action that is performed on the community. Valid values:
        # 
        # *   **Additive**: adds the community to the route.
        # *   **Replace**: replaces the original community of the route.
        # 
        # This parameter specifies the action to be performed when a route meets the match condition.
        self.community_operate_mode = community_operate_mode  # type: str
        # The description of the routing policy.
        # 
        # The description must be 2 to 256 characters in length, and can contain letters, digits, hyphens (-), periods (.), and underscores (\_). It must start with a letter and cannot start with `http://` or `https://`.
        self.description = description  # type: str
        # The types of destination network instance to which the routes belong. The following types of network instances are supported:
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        # *   **VPN**: IPsec connection
        # 
        #     > This parameter does not take effect if the IPsec-VPN connection or SSL client is associated with a transit router through a VPN gateway and a VPC. This parameter takes effect only if the IPsec connection is directly connected to the transit router.
        # 
        # You can specify one or more network instance types.
        # 
        # >  The destination network instance types are valid only if the routing policy is applied to scenarios where routes are advertised from the gateway in the current region to network instances in the current region.
        self.destination_child_instance_types = destination_child_instance_types  # type: list[str]
        # The prefix list against which routes are matched.
        # 
        # You must specify the IP addresses in CIDR notation. You can enter at most 32 CIDR blocks.
        self.destination_cidr_blocks = destination_cidr_blocks  # type: list[str]
        # The IDs of the destination network instances to which the routes belong. The following network instance types are supported:
        # 
        # *   VPC
        # *   VBR
        # *   CCN instance
        # *   SAG instance
        # *   The ID of the IPsec connection.
        # 
        # You can enter at most 32 IDs.
        # 
        # >  The destination network instance IDs are valid only if the routing policy is applied to scenarios where routes are advertised from the gateway in the current region to network instances in the current region.
        self.destination_instance_ids = destination_instance_ids  # type: list[str]
        # Specifies whether to exclude the destination network instance IDs. Valid values:
        # 
        # *   **false** (default value): A route is a match if its destination network instance ID is in the list specified by **DestinationInstanceIds.N**.
        # *   **true**: A route meets the match condition if its destination network instance ID is not in the list specified by **DestinationInstanceIds.N**.
        self.destination_instance_ids_reverse_match = destination_instance_ids_reverse_match  # type: bool
        # The IDs of the destination route tables to which routes are evaluated. You can enter at most 32 route table IDs.
        # 
        # >  The destination route table IDs are valid only when the routing policy is applied to scenarios where routes are advertised from the gateway in the current region to route tables in the current region.
        self.destination_route_table_ids = destination_route_table_ids  # type: list[str]
        # The action to be performed on a route that meets all match conditions. Valid values:
        # 
        # *   **Permit**: the route is permitted.
        # *   **Deny**: the route is denied.
        self.map_result = map_result  # type: str
        # The type of IP address in the match condition. Valid values:
        # 
        # *   **IPv4**: IPv4 address
        # *   **IPv6**: IPv6 address
        # 
        # This parameter can be empty. If no value is specified, all types of IP address are a match.
        self.match_address_type = match_address_type  # type: str
        # The AS paths against which routes are matched.
        # 
        # You can specify at most 32 AS numbers.
        # 
        # >  Only the AS-SEQUENCE parameter is supported. The AS-SET, AS-CONFED-SEQUENCE, and AS-CONFED-SET parameters are not supported. In other words, only the AS number list is supported. Sets and sub-lists are not supported.
        self.match_asns = match_asns  # type: list[long]
        # The community against which routes are matched.
        # 
        # Specify the community in the format of n:m. Valid values of n and m: **1** to **65535**. Each community must comply with the RFC 1997 standard. The RFC 8092 standard that defines Border Gateway Protocol (BGP) large communities is not supported.
        # 
        # You can specify at most 32 communities.
        # 
        # >  If the configurations of the communities are incorrect, routes may fail to be advertised to your data center.
        self.match_community_set = match_community_set  # type: list[str]
        # The priority of the routing policy that you want to associate with the current one.
        # 
        # *   This parameter takes effect only when the **MapResult** parameter is set to **Permit**. This way, the permitted route is matched against the next routing policy.
        # *   The region and direction of the routing policy to be associated must be the same as those of the current routing policy.
        # *   The priority of the next routing policy must be lower than the priority of the current routing policy.
        self.next_priority = next_priority  # type: int
        # The community set on which actions are performed.
        # 
        # Specify the community in the format of n:m. Valid values of n and m: **1** to **65535**. Each community must comply with RFC 1997. The RFC 8092 standard that defines BGP large communities is not supported.
        # 
        # You can specify at most 32 communities.
        # 
        # >  If the configurations of the communities are incorrect, routes may fail to be advertised to your data center.
        self.operate_community_set = operate_community_set  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The new priority of the route.
        # 
        # Valid values: **1** to **100**. The default priority is **50**. A smaller value indicates a higher priority.
        # 
        # This parameter specifies the action to be performed when a route meets the match condition.
        self.preference = preference  # type: int
        # The AS paths that are prepended by using an action statement when regional gateways receive or advertise routes.
        # 
        # The AS paths vary based on the direction in which the routing policy is applied:
        # 
        # *   If AS paths are prepended to a routing policy that is applied in the inbound direction, you must specify source network instance IDs and the source region in the match condition. In addition, the source region must be the same as the region where the routing policy is applied.
        # *   If AS paths are prepended to a routing policy that is applied in the outbound direction, you must specify destination network instance IDs in the match condition.
        # 
        # This parameter specifies the action to be performed when a route meets the match condition. You can specify at most 32 AS numbers.
        self.prepend_as_path = prepend_as_path  # type: list[long]
        # The priority of the routing policy. Valid values: **1** to **100**. A smaller value indicates a higher priority.
        # 
        # >  You cannot specify the same priority for routing policies that apply in the same region and direction. The system matches routes against the match conditions of routing policies in descending order of priority. A smaller value indicates a higher priority. You must set the priorities to proper values.
        self.priority = priority  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The type of route to be matched against the match condition. The following route types are supported:
        # 
        # *   **System**: system routes that are automatically generated by the system.
        # *   **Custom**: custom routes that are manually added.
        # *   **BGP**: routes that are advertised over BGP.
        # 
        # You can specify multiple route types.
        self.route_types = route_types  # type: list[str]
        # The types of source network instance to which the routes belong. The following types of network instances are supported:
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        # *   **VPN**: VPN gateway or IPsec connection
        #     *   If the IPsec-VPN connection or SSL client is associated with a VPN gateway, the VPC associated with the VPN gateway must be connected to a transit router, and the VPN gateway must use BGP dynamic routing. Otherwise, this parameter cannot take effect.
        #     *   This parameter takes effect if the IPsec connection is directly connected to a transit router.
        # 
        # You can specify one or more network instance types.
        self.source_child_instance_types = source_child_instance_types  # type: list[str]
        # The IDs of the source network instances to which the routes belong. The following network instance types are supported:
        # 
        # *   VPC
        # *   VBR
        # *   CCN instance
        # *   SAG instance
        # *   The ID of the IPsec connection.
        # 
        # You can enter at most 32 IDs.
        self.source_instance_ids = source_instance_ids  # type: list[str]
        # Specifies whether to exclude the source network instance IDs. Valid values:
        # 
        # *   **false** (default value): A route is a match if its source network instance ID is in the list specified by **SourceInstanceIds.N**.
        # *   **true**: A route is a match if its source network instance ID is not in the list specified by **SourceInstanceIds.N**.
        self.source_instance_ids_reverse_match = source_instance_ids_reverse_match  # type: bool
        # The IDs of the source regions from which routes are evaluated. You can enter at most 32 region IDs.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.source_region_ids = source_region_ids  # type: list[str]
        # The IDs of the source route tables from which routes are evaluated. You can enter at most 32 route table IDs.
        self.source_route_table_ids = source_route_table_ids  # type: list[str]
        # The ID of the route table of the transit router.
        # 
        # If you do not specify a route table ID, the routing policy is automatically associated with the default route table of the transit router.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str
        # The direction in which the routing policy is applied. Valid values:
        # 
        # *   **RegionIn**: Routes are advertised to the gateways in the regions that are connected by the CEN instance.
        # 
        #     For example, routes are advertised from network instances deployed in the current region or other regions to the gateway deployed in the current region.
        # 
        # *   **RegionOut**: Routes are advertised from the gateways in the regions that are connected by the CEN instance.
        # 
        #     For example, routes are advertised from the gateway deployed in the current region to network instances deployed in the same region, or to gateways deployed in other regions.
        self.transmit_direction = transmit_direction  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenRouteMapRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_path_match_mode is not None:
            result['AsPathMatchMode'] = self.as_path_match_mode
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_region_id is not None:
            result['CenRegionId'] = self.cen_region_id
        if self.cidr_match_mode is not None:
            result['CidrMatchMode'] = self.cidr_match_mode
        if self.community_match_mode is not None:
            result['CommunityMatchMode'] = self.community_match_mode
        if self.community_operate_mode is not None:
            result['CommunityOperateMode'] = self.community_operate_mode
        if self.description is not None:
            result['Description'] = self.description
        if self.destination_child_instance_types is not None:
            result['DestinationChildInstanceTypes'] = self.destination_child_instance_types
        if self.destination_cidr_blocks is not None:
            result['DestinationCidrBlocks'] = self.destination_cidr_blocks
        if self.destination_instance_ids is not None:
            result['DestinationInstanceIds'] = self.destination_instance_ids
        if self.destination_instance_ids_reverse_match is not None:
            result['DestinationInstanceIdsReverseMatch'] = self.destination_instance_ids_reverse_match
        if self.destination_route_table_ids is not None:
            result['DestinationRouteTableIds'] = self.destination_route_table_ids
        if self.map_result is not None:
            result['MapResult'] = self.map_result
        if self.match_address_type is not None:
            result['MatchAddressType'] = self.match_address_type
        if self.match_asns is not None:
            result['MatchAsns'] = self.match_asns
        if self.match_community_set is not None:
            result['MatchCommunitySet'] = self.match_community_set
        if self.next_priority is not None:
            result['NextPriority'] = self.next_priority
        if self.operate_community_set is not None:
            result['OperateCommunitySet'] = self.operate_community_set
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.preference is not None:
            result['Preference'] = self.preference
        if self.prepend_as_path is not None:
            result['PrependAsPath'] = self.prepend_as_path
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_types is not None:
            result['RouteTypes'] = self.route_types
        if self.source_child_instance_types is not None:
            result['SourceChildInstanceTypes'] = self.source_child_instance_types
        if self.source_instance_ids is not None:
            result['SourceInstanceIds'] = self.source_instance_ids
        if self.source_instance_ids_reverse_match is not None:
            result['SourceInstanceIdsReverseMatch'] = self.source_instance_ids_reverse_match
        if self.source_region_ids is not None:
            result['SourceRegionIds'] = self.source_region_ids
        if self.source_route_table_ids is not None:
            result['SourceRouteTableIds'] = self.source_route_table_ids
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        if self.transmit_direction is not None:
            result['TransmitDirection'] = self.transmit_direction
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsPathMatchMode') is not None:
            self.as_path_match_mode = m.get('AsPathMatchMode')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenRegionId') is not None:
            self.cen_region_id = m.get('CenRegionId')
        if m.get('CidrMatchMode') is not None:
            self.cidr_match_mode = m.get('CidrMatchMode')
        if m.get('CommunityMatchMode') is not None:
            self.community_match_mode = m.get('CommunityMatchMode')
        if m.get('CommunityOperateMode') is not None:
            self.community_operate_mode = m.get('CommunityOperateMode')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestinationChildInstanceTypes') is not None:
            self.destination_child_instance_types = m.get('DestinationChildInstanceTypes')
        if m.get('DestinationCidrBlocks') is not None:
            self.destination_cidr_blocks = m.get('DestinationCidrBlocks')
        if m.get('DestinationInstanceIds') is not None:
            self.destination_instance_ids = m.get('DestinationInstanceIds')
        if m.get('DestinationInstanceIdsReverseMatch') is not None:
            self.destination_instance_ids_reverse_match = m.get('DestinationInstanceIdsReverseMatch')
        if m.get('DestinationRouteTableIds') is not None:
            self.destination_route_table_ids = m.get('DestinationRouteTableIds')
        if m.get('MapResult') is not None:
            self.map_result = m.get('MapResult')
        if m.get('MatchAddressType') is not None:
            self.match_address_type = m.get('MatchAddressType')
        if m.get('MatchAsns') is not None:
            self.match_asns = m.get('MatchAsns')
        if m.get('MatchCommunitySet') is not None:
            self.match_community_set = m.get('MatchCommunitySet')
        if m.get('NextPriority') is not None:
            self.next_priority = m.get('NextPriority')
        if m.get('OperateCommunitySet') is not None:
            self.operate_community_set = m.get('OperateCommunitySet')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Preference') is not None:
            self.preference = m.get('Preference')
        if m.get('PrependAsPath') is not None:
            self.prepend_as_path = m.get('PrependAsPath')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteTypes') is not None:
            self.route_types = m.get('RouteTypes')
        if m.get('SourceChildInstanceTypes') is not None:
            self.source_child_instance_types = m.get('SourceChildInstanceTypes')
        if m.get('SourceInstanceIds') is not None:
            self.source_instance_ids = m.get('SourceInstanceIds')
        if m.get('SourceInstanceIdsReverseMatch') is not None:
            self.source_instance_ids_reverse_match = m.get('SourceInstanceIdsReverseMatch')
        if m.get('SourceRegionIds') is not None:
            self.source_region_ids = m.get('SourceRegionIds')
        if m.get('SourceRouteTableIds') is not None:
            self.source_route_table_ids = m.get('SourceRouteTableIds')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        if m.get('TransmitDirection') is not None:
            self.transmit_direction = m.get('TransmitDirection')
        return self


class CreateCenRouteMapResponseBody(TeaModel):
    def __init__(self, request_id=None, route_map_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the routing policy.
        self.route_map_id = route_map_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateCenRouteMapResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_map_id is not None:
            result['RouteMapId'] = self.route_map_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteMapId') is not None:
            self.route_map_id = m.get('RouteMapId')
        return self


class CreateCenRouteMapResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateCenRouteMapResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateCenRouteMapResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCenRouteMapResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFlowlogRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowlogRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateFlowlogRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, description=None, flow_log_name=None, interval=None,
                 log_store_name=None, owner_account=None, owner_id=None, project_name=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, tag=None, transit_router_attachment_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # The description of the flow log.
        # 
        # The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        self.description = description  # type: str
        # The name of the flow log.
        # 
        # The name must be 2 to 128 characters in length, and can contain digits, periods (.), underscores (\_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.flow_log_name = flow_log_name  # type: str
        # The time window for collecting log data. Unit: seconds. Valid values: **60** and **600**. Default value: **600**.
        self.interval = interval  # type: long
        # The Logstore where the flow log is stored.
        # 
        # *   If a Logstore is already created in the selected region, enter the name of the Logstore.
        # 
        # *   If no Logstores are created in the selected region, enter a name and the system automatically creates a Logstore. The name of the Logstore. The name must meet the following requirements:
        # 
        #     *   The name must be unique in a project.
        #     *   The name can contain only lowercase letters, digits, hyphens (-), and underscores (\_).
        #     *   The name must start and end with a lowercase letter or a digit.
        #     *   The name must be 3 to 63 characters in length.
        self.log_store_name = log_store_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The Log Service project where the flow log is stored.
        # 
        # *   If a project is already created in the selected region, enter the name of the project.
        # 
        # *   If no projects are created in the selected region, enter a name and the system automatically creates a project.
        # 
        #     The project name must be unique in a region. You cannot change the name after you create the project. The naming conventions are:
        # 
        #     *   The name must be globally unique.
        #     *   The name can contain only lowercase letters, digits, and hyphens (-).
        #     *   The name must start and end with a lowercase letter or a digit.
        #     *   The name must be 3 to 63 characters in length.
        self.project_name = project_name  # type: str
        # The ID of the region where the flow log is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[CreateFlowlogRequestTag]
        # The ID of the inter-region connection or the VBR connection.
        # 
        # > This parameter is required.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateFlowlogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.flow_log_name is not None:
            result['FlowLogName'] = self.flow_log_name
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FlowLogName') is not None:
            self.flow_log_name = m.get('FlowLogName')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateFlowlogRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class CreateFlowlogResponseBody(TeaModel):
    def __init__(self, flow_log_id=None, request_id=None, success=None):
        # The ID of the flow log.
        self.flow_log_id = flow_log_id  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call is successful. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateFlowlogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateFlowlogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateFlowlogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateFlowlogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFlowlogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTrafficMarkingPolicyRequestTrafficMatchRules(TeaModel):
    def __init__(self, dst_cidr=None, dst_port_range=None, match_dscp=None, protocol=None, src_cidr=None,
                 src_port_range=None, traffic_match_rule_description=None, traffic_match_rule_name=None):
        # The destination CIDR block that is used to match packets.
        # 
        # The traffic classification rule matches the packets whose destination IP addresses fall within the specified destination CIDR block. If you do not set this parameter, packets with all destination IP addresses are matched.
        # 
        # You can create up to 50 traffic classification rules in each call. You can specify a destination CIDR block for each traffic classification rule.
        self.dst_cidr = dst_cidr  # type: str
        # The destination port range that is used to match packets. Valid values: **-1** and **1** to **65535**.
        # 
        # The traffic classification rule matches the packets whose destination ports fall within the destination port range. If you do not set this parameter, packets with all destination ports are matched.
        # 
        # You can specify at most two ports. Take note of the following rules:
        # 
        # *   If you enter only one port number such as 1, the system matches the packets whose destination port is port 1.
        # *   If you enter two port numbers such as 1 and 200, the system matches the packets whose destination ports fall between 1 and 200.
        # *   If you enter two port numbers and one of them is -1, the other port number must also be -1. In this case, packets with all destination ports are matched.
        # 
        # You can create up to 50 traffic classification rules in each call. You can specify a destination port range for each traffic classification rule.
        self.dst_port_range = dst_port_range  # type: list[int]
        # The DSCP value that is used to match packets. Valid values: **0** to **63**.
        # 
        # The traffic classification rule matches the packets that contain the specified DSCP value. If you do not set this parameter, packets are considered a match regardless of the DSCP value.
        # 
        # >  The DSCP value that you specify for this parameter is the DSCP value that packets carry before they are transmitted over the inter-region connection.
        # 
        # You can create up to 50 traffic classification rules in each call. You can specify a DSCP value for each traffic classification rule.
        self.match_dscp = match_dscp  # type: int
        # The protocol that is used to match packets.
        # 
        # Valid values: **HTTP**, **HTTPS**, **TCP**, **UDP**, **SSH**, and **Telnet**. For more information, log on to the [Cloud Enterprise Network (CEN) console](https://cen.console.aliyun.com/cen/list).
        # 
        # You can create up to 50 traffic classification rules in each call. You can specify a protocol for each traffic classification rule.
        self.protocol = protocol  # type: str
        # The source CIDR block that is used to match packets.
        # 
        # The traffic classification rule matches the packets whose source IP addresses fall within the specified source CIDR block. If you do not set this parameter, packets with all source IP addresses are matched.
        # 
        # You can create up to 50 traffic classification rules in each call. You can specify a source CIDR block for each traffic classification rule.
        self.src_cidr = src_cidr  # type: str
        # The source port range that is used to match packets. Valid values: **-1** and **1** to **65535**.
        # 
        # The traffic classification rule matches the packets whose source ports fall within the source port range. If you do not set this parameter, packets with all source ports are matched.
        # 
        # You can specify at most two ports. Take note of the following rules:
        # 
        # *   If you enter only one port number such as 1, the system matches the packets whose source port is 1.
        # *   If you enter two port numbers such as 1 and 200, the system matches the packets whose source ports fall between 1 and 200.
        # *   If you enter two port numbers and one of them is -1, the other port number must also be -1. In this case, packets with all source ports are matched.
        # 
        # You can create up to 50 traffic classification rules in each call. You can specify a source port range for each traffic classification rule.
        self.src_port_range = src_port_range  # type: list[int]
        # The description of the traffic classification rule.
        # 
        # You can create up to 50 traffic classification rules in each call. You can specify a description for each traffic classification rule.
        # 
        # The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        self.traffic_match_rule_description = traffic_match_rule_description  # type: str
        # The name of the traffic classification rule.
        # 
        # You can create up to 50 traffic classification rules in each call. You can specify a name for each traffic classification rule.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.traffic_match_rule_name = traffic_match_rule_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTrafficMarkingPolicyRequestTrafficMatchRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_cidr is not None:
            result['DstCidr'] = self.dst_cidr
        if self.dst_port_range is not None:
            result['DstPortRange'] = self.dst_port_range
        if self.match_dscp is not None:
            result['MatchDscp'] = self.match_dscp
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.src_cidr is not None:
            result['SrcCidr'] = self.src_cidr
        if self.src_port_range is not None:
            result['SrcPortRange'] = self.src_port_range
        if self.traffic_match_rule_description is not None:
            result['TrafficMatchRuleDescription'] = self.traffic_match_rule_description
        if self.traffic_match_rule_name is not None:
            result['TrafficMatchRuleName'] = self.traffic_match_rule_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstCidr') is not None:
            self.dst_cidr = m.get('DstCidr')
        if m.get('DstPortRange') is not None:
            self.dst_port_range = m.get('DstPortRange')
        if m.get('MatchDscp') is not None:
            self.match_dscp = m.get('MatchDscp')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('SrcCidr') is not None:
            self.src_cidr = m.get('SrcCidr')
        if m.get('SrcPortRange') is not None:
            self.src_port_range = m.get('SrcPortRange')
        if m.get('TrafficMatchRuleDescription') is not None:
            self.traffic_match_rule_description = m.get('TrafficMatchRuleDescription')
        if m.get('TrafficMatchRuleName') is not None:
            self.traffic_match_rule_name = m.get('TrafficMatchRuleName')
        return self


class CreateTrafficMarkingPolicyRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, marking_dscp=None, owner_account=None, owner_id=None,
                 priority=None, resource_owner_account=None, resource_owner_id=None,
                 traffic_marking_policy_description=None, traffic_marking_policy_name=None, traffic_match_rules=None, transit_router_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request format, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        # The differentiated services code point (DSCP) value to be added to packets that match the traffic classification rule. Valid values: **0** to **63**.
        # 
        # The DSCP value of each traffic marking policy on a transit router must be unique.
        self.marking_dscp = marking_dscp  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The priority value of the traffic marking policy. Valid values: **1** to **100**.
        # 
        # The priority value of each traffic marking policy on a transit router must be unique. A smaller value specifies a higher priority.
        self.priority = priority  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The description of the traffic marking policy.
        # 
        # The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        self.traffic_marking_policy_description = traffic_marking_policy_description  # type: str
        # The name of the traffic marking policy.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
        self.traffic_marking_policy_name = traffic_marking_policy_name  # type: str
        # The traffic classification rules in the traffic marking policy.
        # 
        # Packets that match the traffic classification rules are assigned the DSCP value of the traffic marking policy.
        # 
        # You can specify at most 50 traffic classification rules.
        self.traffic_match_rules = traffic_match_rules  # type: list[CreateTrafficMarkingPolicyRequestTrafficMatchRules]
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        if self.traffic_match_rules:
            for k in self.traffic_match_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTrafficMarkingPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.marking_dscp is not None:
            result['MarkingDscp'] = self.marking_dscp
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_marking_policy_description is not None:
            result['TrafficMarkingPolicyDescription'] = self.traffic_marking_policy_description
        if self.traffic_marking_policy_name is not None:
            result['TrafficMarkingPolicyName'] = self.traffic_marking_policy_name
        result['TrafficMatchRules'] = []
        if self.traffic_match_rules is not None:
            for k in self.traffic_match_rules:
                result['TrafficMatchRules'].append(k.to_map() if k else None)
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('MarkingDscp') is not None:
            self.marking_dscp = m.get('MarkingDscp')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficMarkingPolicyDescription') is not None:
            self.traffic_marking_policy_description = m.get('TrafficMarkingPolicyDescription')
        if m.get('TrafficMarkingPolicyName') is not None:
            self.traffic_marking_policy_name = m.get('TrafficMarkingPolicyName')
        self.traffic_match_rules = []
        if m.get('TrafficMatchRules') is not None:
            for k in m.get('TrafficMatchRules'):
                temp_model = CreateTrafficMarkingPolicyRequestTrafficMatchRules()
                self.traffic_match_rules.append(temp_model.from_map(k))
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class CreateTrafficMarkingPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None, traffic_marking_policy_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the traffic marking policy.
        self.traffic_marking_policy_id = traffic_marking_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTrafficMarkingPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.traffic_marking_policy_id is not None:
            result['TrafficMarkingPolicyId'] = self.traffic_marking_policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TrafficMarkingPolicyId') is not None:
            self.traffic_marking_policy_id = m.get('TrafficMarkingPolicyId')
        return self


class CreateTrafficMarkingPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTrafficMarkingPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTrafficMarkingPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTrafficMarkingPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouteTableAggregationRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_route_table_aggregation_cidr=None,
                 transit_route_table_aggregation_description=None, transit_route_table_aggregation_name=None, transit_route_table_aggregation_scop=None,
                 transit_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that the value is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId may different for each request.
        self.client_token = client_token  # type: str
        # Specifies whether to precheck the request. Check items include permissions and the status of the specified cloud resources. Valid values:
        # 
        # *   **false** (default): sends the request. If the request passes the precheck, the aggregate route is added.
        # *   **true**: prechecks the request but does not create the aggregate route. If you use this value, the system checks the required parameters and the request syntax. If the request fails to pass the precheck, an error message is returned. If the request passes the check, the `DryRunOperation` error code is returned.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The destination CIDR block of the aggregate route.
        # 
        # >  The following CIDR blocks are not supported:
        # 
        # *   CIDR blocks that start with 0 or 100.64.
        # *   Multicast CIDR blocks, including 224.0.0.1 to 239.255.255.254.
        self.transit_route_table_aggregation_cidr = transit_route_table_aggregation_cidr  # type: str
        # The description of the aggregate route.
        # 
        # The description must be 2 to 256 characters in length, and can contain letters, digits, and the following special characters: , . ; / @ \_ -. You can also leave the description empty.
        self.transit_route_table_aggregation_description = transit_route_table_aggregation_description  # type: str
        # The name of the aggregate route.
        # 
        # The name must be 0 to 128 characters in length, and can contain letters, digits, and the following special characters: , . ; / @ \_ -.
        self.transit_route_table_aggregation_name = transit_route_table_aggregation_name  # type: str
        # The scope of networks that you want to advertise the aggregate route.
        # 
        # Set the value to **VPC**, which specified that the aggregate route is advertised to VPCs that are in associated forwarding relationship with a route table of the Enterprise Edition transit router and have route synchronization enabled.
        self.transit_route_table_aggregation_scop = transit_route_table_aggregation_scop  # type: str
        # The ID of the route table of the Enterprise Edition transit router.
        self.transit_route_table_id = transit_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouteTableAggregationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_route_table_aggregation_cidr is not None:
            result['TransitRouteTableAggregationCidr'] = self.transit_route_table_aggregation_cidr
        if self.transit_route_table_aggregation_description is not None:
            result['TransitRouteTableAggregationDescription'] = self.transit_route_table_aggregation_description
        if self.transit_route_table_aggregation_name is not None:
            result['TransitRouteTableAggregationName'] = self.transit_route_table_aggregation_name
        if self.transit_route_table_aggregation_scop is not None:
            result['TransitRouteTableAggregationScop'] = self.transit_route_table_aggregation_scop
        if self.transit_route_table_id is not None:
            result['TransitRouteTableId'] = self.transit_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouteTableAggregationCidr') is not None:
            self.transit_route_table_aggregation_cidr = m.get('TransitRouteTableAggregationCidr')
        if m.get('TransitRouteTableAggregationDescription') is not None:
            self.transit_route_table_aggregation_description = m.get('TransitRouteTableAggregationDescription')
        if m.get('TransitRouteTableAggregationName') is not None:
            self.transit_route_table_aggregation_name = m.get('TransitRouteTableAggregationName')
        if m.get('TransitRouteTableAggregationScop') is not None:
            self.transit_route_table_aggregation_scop = m.get('TransitRouteTableAggregationScop')
        if m.get('TransitRouteTableId') is not None:
            self.transit_route_table_id = m.get('TransitRouteTableId')
        return self


class CreateTransitRouteTableAggregationResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouteTableAggregationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateTransitRouteTableAggregationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouteTableAggregationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouteTableAggregationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouteTableAggregationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length, and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTransitRouterRequestTransitRouterCidrList(TeaModel):
    def __init__(self, cidr=None, description=None, name=None, publish_cidr_route=None):
        # The CIDR block of the transit router.
        self.cidr = cidr  # type: str
        # The description of the CIDR block.
        # 
        # The description must be 1 to 256 characters in length.
        self.description = description  # type: str
        # The name of the CIDR block.
        # 
        # The name must be 1 to 128 characters in length.
        self.name = name  # type: str
        # Specifies whether to allow the system to automatically add a route that points to the CIDR block to the route table of the transit router.
        # 
        # *   **true** (default): yes
        # 
        #         A value of true specifies that after you create a private VPN connection and add a route learning correlation for the private VPN connection, the system automatically adds the following route to the route table of the transit router that is in route learning correlation with the private VPN connection:
        # 
        #           A blackhole route whose destination CIDR block is the CIDR block of the transit router. The CIDR block of the transit router refers to the CIDR block from which gateway IP addresses are allocated to IPsec-VPN connections. 
        # 
        #           The blackhole route is advertised only to the route tables of the virtual border routers (VBRs) that are connected to the transit router. 
        # 
        # *   **false**: no
        self.publish_cidr_route = publish_cidr_route  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterRequestTransitRouterCidrList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.publish_cidr_route is not None:
            result['PublishCidrRoute'] = self.publish_cidr_route
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PublishCidrRoute') is not None:
            self.publish_cidr_route = m.get('PublishCidrRoute')
        return self


class CreateTransitRouterRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, support_multicast=None, tag=None,
                 transit_router_cidr_list=None, transit_router_description=None, transit_router_name=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and the request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the Enterprise Edition transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        # 
        # *   **false** (default): disables multicast
        # *   **true**: enables multicast
        # 
        # The multicast feature is supported only in specific regions. You can call the [ListTransitRouterAvailableResource](~~261356~~) operation to query the regions that support multicast.
        self.support_multicast = support_multicast  # type: bool
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[CreateTransitRouterRequestTag]
        # The CIDR blocks of the transit router.
        # 
        # You can add up to five CIDR blocks in each call. For more information about CIDR blocks of transit routers, see [CIDR blocks of transit routers](~~462635~~).
        # 
        # > Only Enterprise Edition transit routers support CIDR blocks.
        self.transit_router_cidr_list = transit_router_cidr_list  # type: list[CreateTransitRouterRequestTransitRouterCidrList]
        # The description of the Enterprise Edition transit router.
        # 
        # The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        self.transit_router_description = transit_router_description  # type: str
        # The name of the Enterprise Edition transit router.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.transit_router_name = transit_router_name  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.transit_router_cidr_list:
            for k in self.transit_router_cidr_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTransitRouterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.support_multicast is not None:
            result['SupportMulticast'] = self.support_multicast
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        result['TransitRouterCidrList'] = []
        if self.transit_router_cidr_list is not None:
            for k in self.transit_router_cidr_list:
                result['TransitRouterCidrList'].append(k.to_map() if k else None)
        if self.transit_router_description is not None:
            result['TransitRouterDescription'] = self.transit_router_description
        if self.transit_router_name is not None:
            result['TransitRouterName'] = self.transit_router_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SupportMulticast') is not None:
            self.support_multicast = m.get('SupportMulticast')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateTransitRouterRequestTag()
                self.tag.append(temp_model.from_map(k))
        self.transit_router_cidr_list = []
        if m.get('TransitRouterCidrList') is not None:
            for k in m.get('TransitRouterCidrList'):
                temp_model = CreateTransitRouterRequestTransitRouterCidrList()
                self.transit_router_cidr_list.append(temp_model.from_map(k))
        if m.get('TransitRouterDescription') is not None:
            self.transit_router_description = m.get('TransitRouterDescription')
        if m.get('TransitRouterName') is not None:
            self.transit_router_name = m.get('TransitRouterName')
        return self


class CreateTransitRouterShrinkRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length, and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterShrinkRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTransitRouterShrinkRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, support_multicast=None, tag=None,
                 transit_router_cidr_list_shrink=None, transit_router_description=None, transit_router_name=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and the request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the Enterprise Edition transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # Specifies whether to enable the multicast feature for the Enterprise Edition transit router. Valid values:
        # 
        # *   **false** (default): disables multicast
        # *   **true**: enables multicast
        # 
        # The multicast feature is supported only in specific regions. You can call the [ListTransitRouterAvailableResource](~~261356~~) operation to query the regions that support multicast.
        self.support_multicast = support_multicast  # type: bool
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[CreateTransitRouterShrinkRequestTag]
        # The CIDR blocks of the transit router.
        # 
        # You can add up to five CIDR blocks in each call. For more information about CIDR blocks of transit routers, see [CIDR blocks of transit routers](~~462635~~).
        # 
        # > Only Enterprise Edition transit routers support CIDR blocks.
        self.transit_router_cidr_list_shrink = transit_router_cidr_list_shrink  # type: str
        # The description of the Enterprise Edition transit router.
        # 
        # The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        self.transit_router_description = transit_router_description  # type: str
        # The name of the Enterprise Edition transit router.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.transit_router_name = transit_router_name  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTransitRouterShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.support_multicast is not None:
            result['SupportMulticast'] = self.support_multicast
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_cidr_list_shrink is not None:
            result['TransitRouterCidrList'] = self.transit_router_cidr_list_shrink
        if self.transit_router_description is not None:
            result['TransitRouterDescription'] = self.transit_router_description
        if self.transit_router_name is not None:
            result['TransitRouterName'] = self.transit_router_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SupportMulticast') is not None:
            self.support_multicast = m.get('SupportMulticast')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateTransitRouterShrinkRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterCidrList') is not None:
            self.transit_router_cidr_list_shrink = m.get('TransitRouterCidrList')
        if m.get('TransitRouterDescription') is not None:
            self.transit_router_description = m.get('TransitRouterDescription')
        if m.get('TransitRouterName') is not None:
            self.transit_router_name = m.get('TransitRouterName')
        return self


class CreateTransitRouterResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the Enterprise Edition transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class CreateTransitRouterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterCidrRequest(TeaModel):
    def __init__(self, cidr=None, client_token=None, description=None, dry_run=None, name=None, owner_account=None,
                 owner_id=None, publish_cidr_route=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, transit_router_id=None):
        # The CIDR block that you want to create for the transit router.
        self.cidr = cidr  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # The description of the CIDR block.
        # 
        # The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        self.description = description  # type: str
        # Specifies whether only to precheck the request. Valid values:
        # 
        # *   **true**: prechecks the request but does not create the CIDR block. The system checks the required parameters, the request format, and the service limits. If the request fails to pass the precheck, an error message is returned. If the request passes the precheck, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. After the request passes the precheck, the CIDR block is created.
        self.dry_run = dry_run  # type: bool
        # The name of the CIDR block.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.name = name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # Specifies whether to allow the system to automatically add a route that points to the CIDR block to the route table of the transit router.
        # 
        # *   **true** (default): yes
        # 
        #     A value of true specifies that after you create a private VPN connection and enable route learning for the connection, the system automatically adds a blackhole route to the route table of the transit router to which the VPN connection is attached. The destination CIDR block of the blackhole route is the CIDR block of the transit router. The CIDR block of the transit router refers to the CIDR block from which gateway IP addresses are allocated to IPsec-VPN connections. The blackhole route is advertised only to the route table of the virtual border router (VBR) that is connected to the transit router.
        # 
        # *   **false**: no
        self.publish_cidr_route = publish_cidr_route  # type: bool
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterCidrRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.name is not None:
            result['Name'] = self.name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.publish_cidr_route is not None:
            result['PublishCidrRoute'] = self.publish_cidr_route
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PublishCidrRoute') is not None:
            self.publish_cidr_route = m.get('PublishCidrRoute')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class CreateTransitRouterCidrResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_cidr_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the transit router CIDR block.
        self.transit_router_cidr_id = transit_router_cidr_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterCidrResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_cidr_id is not None:
            result['TransitRouterCidrId'] = self.transit_router_cidr_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterCidrId') is not None:
            self.transit_router_cidr_id = m.get('TransitRouterCidrId')
        return self


class CreateTransitRouterCidrResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterCidrResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterCidrResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterCidrResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterMulticastDomainRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterMulticastDomainRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTransitRouterMulticastDomainRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, tag=None, transit_router_id=None,
                 transit_router_multicast_domain_description=None, transit_router_multicast_domain_name=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request format, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[CreateTransitRouterMulticastDomainRequestTag]
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The description of the multicast domain.
        # 
        # The description must be 0 to 256 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\_), and hyphens (-).
        self.transit_router_multicast_domain_description = transit_router_multicast_domain_description  # type: str
        # The name of the multicast domain.
        # 
        # The name must be 0 to 128 characters in length, and can contain letters, digits, commas (,), periods (.), semicolons (;), forward slashes (/), at signs (@), underscores (\_), and hyphens (-).
        self.transit_router_multicast_domain_name = transit_router_multicast_domain_name  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTransitRouterMulticastDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.transit_router_multicast_domain_description is not None:
            result['TransitRouterMulticastDomainDescription'] = self.transit_router_multicast_domain_description
        if self.transit_router_multicast_domain_name is not None:
            result['TransitRouterMulticastDomainName'] = self.transit_router_multicast_domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateTransitRouterMulticastDomainRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('TransitRouterMulticastDomainDescription') is not None:
            self.transit_router_multicast_domain_description = m.get('TransitRouterMulticastDomainDescription')
        if m.get('TransitRouterMulticastDomainName') is not None:
            self.transit_router_multicast_domain_name = m.get('TransitRouterMulticastDomainName')
        return self


class CreateTransitRouterMulticastDomainResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_multicast_domain_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterMulticastDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        return self


class CreateTransitRouterMulticastDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterMulticastDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterMulticastDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterMulticastDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterPeerAttachmentRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag keys of the resources. 
        # 
        # The tag keys cannot be an empty string. The tag keys can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.  
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag values of the resources. 
        # 
        # The tag values can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.  
        # 
        # Each tag key has a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterPeerAttachmentRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTransitRouterPeerAttachmentRequest(TeaModel):
    def __init__(self, auto_publish_route_enabled=None, bandwidth=None, bandwidth_type=None,
                 cen_bandwidth_package_id=None, cen_id=None, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 peer_transit_router_id=None, peer_transit_router_region_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, tag=None, transit_router_attachment_description=None, transit_router_attachment_name=None,
                 transit_router_id=None):
        # Specifies whether to enable the local Enterprise Edition transit router to automatically advertise the routes of the inter-region connection to the peer transit router. Valid values:
        # 
        # *   **false** (default): no.
        # *   **true**: yes.
        self.auto_publish_route_enabled = auto_publish_route_enabled  # type: bool
        # The bandwidth value of the inter-region connection. Unit: Mbit/s.
        # 
        # *   If you set **BandwidthType** to **BandwidthPackage**, this parameter specifies the bandwidth that is available for the inter-region connection.
        # 
        # <!---->
        # 
        # *   If you set **BandwidthType** to **DataTransfer**, this parameter specifies the bandwidth limit of the inter-region connection.
        self.bandwidth = bandwidth  # type: int
        # The method that is used to allocate bandwidth to the inter-region connection. Valid values:
        # 
        # **BandwidthPackage**: allocates bandwidth from a bandwidth plan.
        # 
        # **DataTransfer**: uses pay-by-data-transfer bandwidth.
        self.bandwidth_type = bandwidth_type  # type: str
        # The ID of the bandwidth plan that is used to allocate bandwidth to the inter-region connection.
        # 
        # >  If you set **BandwidthType** to **DataTransfer**, you do not need to set this parameter.
        self.cen_bandwidth_package_id = cen_bandwidth_package_id  # type: str
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, the system automatically uses **RequestId** as **ClientToken**. The value of **RequestId** of each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to check the request but not perform the operation. The system checks the permissions and the status of the specified instances. Valid values:
        # 
        # *   **false** (default): checks the request. If the request passes the check, the inter-region connection is created.
        # *   **true**: checks the request but does not perform the operation. The inter-region connection is not created after the request passes the check. If you use this value, the system checks the required parameters and the request syntax. If the request fails to pass the precheck, an error message is returned. If the request passes the check, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the peer transit router.
        self.peer_transit_router_id = peer_transit_router_id  # type: str
        # The ID of the region where the peer transit router is deployed.
        self.peer_transit_router_region_id = peer_transit_router_region_id  # type: str
        # The ID of the region where the local Enterprise Edition transit router is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The tags.
        self.tag = tag  # type: list[CreateTransitRouterPeerAttachmentRequestTag]
        # The description of the inter-region connection.
        # 
        # The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        self.transit_router_attachment_description = transit_router_attachment_description  # type: str
        # The name of the inter-region connection.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
        self.transit_router_attachment_name = transit_router_attachment_name  # type: str
        # The ID of the local Enterprise Edition transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTransitRouterPeerAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_publish_route_enabled is not None:
            result['AutoPublishRouteEnabled'] = self.auto_publish_route_enabled
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.bandwidth_type is not None:
            result['BandwidthType'] = self.bandwidth_type
        if self.cen_bandwidth_package_id is not None:
            result['CenBandwidthPackageId'] = self.cen_bandwidth_package_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.peer_transit_router_id is not None:
            result['PeerTransitRouterId'] = self.peer_transit_router_id
        if self.peer_transit_router_region_id is not None:
            result['PeerTransitRouterRegionId'] = self.peer_transit_router_region_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_attachment_description is not None:
            result['TransitRouterAttachmentDescription'] = self.transit_router_attachment_description
        if self.transit_router_attachment_name is not None:
            result['TransitRouterAttachmentName'] = self.transit_router_attachment_name
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPublishRouteEnabled') is not None:
            self.auto_publish_route_enabled = m.get('AutoPublishRouteEnabled')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('BandwidthType') is not None:
            self.bandwidth_type = m.get('BandwidthType')
        if m.get('CenBandwidthPackageId') is not None:
            self.cen_bandwidth_package_id = m.get('CenBandwidthPackageId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PeerTransitRouterId') is not None:
            self.peer_transit_router_id = m.get('PeerTransitRouterId')
        if m.get('PeerTransitRouterRegionId') is not None:
            self.peer_transit_router_region_id = m.get('PeerTransitRouterRegionId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateTransitRouterPeerAttachmentRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentDescription') is not None:
            self.transit_router_attachment_description = m.get('TransitRouterAttachmentDescription')
        if m.get('TransitRouterAttachmentName') is not None:
            self.transit_router_attachment_name = m.get('TransitRouterAttachmentName')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class CreateTransitRouterPeerAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_attachment_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the inter-region connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterPeerAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class CreateTransitRouterPeerAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterPeerAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterPeerAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterPeerAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterPrefixListAssociationRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, next_hop=None, next_hop_type=None, owner_account=None,
                 owner_id=None, owner_uid=None, prefix_list_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, transit_router_id=None, transit_router_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request syntax, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        # The ID of the next hop.
        # 
        # > If **NextHopType** is set to **BlackHole**, you must set this parameter to **BlackHole**.
        self.next_hop = next_hop  # type: str
        # The type of the next hop. Valid values:
        # 
        # *   **BlackHole**: specifies that all the CIDR blocks in the prefix list are blackhole routes. Packets destined for the CIDR blocks are dropped.
        # *   **VPC**: specifies that the next hop of the CIDR blocks in the prefix list is a virtual private cloud (VPC) connection.
        # *   **VBR**: specifies that the next hop of the CIDR blocks in the prefix list is a virtual border router (VBR) connection.
        # *   **TR**: specifies that the next hop of the CIDR blocks in the prefix list is an inter-region connection.
        self.next_hop_type = next_hop_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the Alibaba Cloud account to which the prefix list belongs.
        self.owner_uid = owner_uid  # type: long
        # The ID of the prefix list.
        self.prefix_list_id = prefix_list_id  # type: str
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The ID of the route table of the transit router.
        self.transit_router_table_id = transit_router_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterPrefixListAssociationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.owner_uid is not None:
            result['OwnerUid'] = self.owner_uid
        if self.prefix_list_id is not None:
            result['PrefixListId'] = self.prefix_list_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.transit_router_table_id is not None:
            result['TransitRouterTableId'] = self.transit_router_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('OwnerUid') is not None:
            self.owner_uid = m.get('OwnerUid')
        if m.get('PrefixListId') is not None:
            self.prefix_list_id = m.get('PrefixListId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('TransitRouterTableId') is not None:
            self.transit_router_table_id = m.get('TransitRouterTableId')
        return self


class CreateTransitRouterPrefixListAssociationResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterPrefixListAssociationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateTransitRouterPrefixListAssociationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterPrefixListAssociationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterPrefixListAssociationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterPrefixListAssociationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterRouteEntryRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_route_entry_description=None,
                 transit_router_route_entry_destination_cidr_block=None, transit_router_route_entry_name=None, transit_router_route_entry_next_hop_id=None,
                 transit_router_route_entry_next_hop_type=None, transit_router_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Default values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The description of the route.
        # 
        # The description must be 2 to 256 characters in length, and can contain letters, digits, and the following special characters: , . ; / @ \_ -. You can also leave the description empty.
        self.transit_router_route_entry_description = transit_router_route_entry_description  # type: str
        # The destination CIDR block of the route.
        self.transit_router_route_entry_destination_cidr_block = transit_router_route_entry_destination_cidr_block  # type: str
        # The name of the route.
        # 
        # The name must be 0 to 128 characters in length, and can contain letters, digits, and the following special characters: , . ; / @ \_ -.
        self.transit_router_route_entry_name = transit_router_route_entry_name  # type: str
        # The ID of the network instance connection that you want to specify as the next hop.
        self.transit_router_route_entry_next_hop_id = transit_router_route_entry_next_hop_id  # type: str
        # The type of the next hop. Valid values:
        # 
        # *   **BlackHole**: routes network traffic to a black hole. All packets that match this route are dropped. If you select this option, you do not need to specify the next hop information.
        # *   **Attachment**: routes network traffic to a network instance connection. If you select this option, you must specify the ID of the network instance connection. All packets that match this route are routed to the specified network instance connection.
        self.transit_router_route_entry_next_hop_type = transit_router_route_entry_next_hop_type  # type: str
        # The route table IDs of the Enterprise Edition transit router.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterRouteEntryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_route_entry_description is not None:
            result['TransitRouterRouteEntryDescription'] = self.transit_router_route_entry_description
        if self.transit_router_route_entry_destination_cidr_block is not None:
            result['TransitRouterRouteEntryDestinationCidrBlock'] = self.transit_router_route_entry_destination_cidr_block
        if self.transit_router_route_entry_name is not None:
            result['TransitRouterRouteEntryName'] = self.transit_router_route_entry_name
        if self.transit_router_route_entry_next_hop_id is not None:
            result['TransitRouterRouteEntryNextHopId'] = self.transit_router_route_entry_next_hop_id
        if self.transit_router_route_entry_next_hop_type is not None:
            result['TransitRouterRouteEntryNextHopType'] = self.transit_router_route_entry_next_hop_type
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterRouteEntryDescription') is not None:
            self.transit_router_route_entry_description = m.get('TransitRouterRouteEntryDescription')
        if m.get('TransitRouterRouteEntryDestinationCidrBlock') is not None:
            self.transit_router_route_entry_destination_cidr_block = m.get('TransitRouterRouteEntryDestinationCidrBlock')
        if m.get('TransitRouterRouteEntryName') is not None:
            self.transit_router_route_entry_name = m.get('TransitRouterRouteEntryName')
        if m.get('TransitRouterRouteEntryNextHopId') is not None:
            self.transit_router_route_entry_next_hop_id = m.get('TransitRouterRouteEntryNextHopId')
        if m.get('TransitRouterRouteEntryNextHopType') is not None:
            self.transit_router_route_entry_next_hop_type = m.get('TransitRouterRouteEntryNextHopType')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        return self


class CreateTransitRouterRouteEntryResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_route_entry_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the route.
        self.transit_router_route_entry_id = transit_router_route_entry_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterRouteEntryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_route_entry_id is not None:
            result['TransitRouterRouteEntryId'] = self.transit_router_route_entry_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterRouteEntryId') is not None:
            self.transit_router_route_entry_id = m.get('TransitRouterRouteEntryId')
        return self


class CreateTransitRouterRouteEntryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterRouteEntryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterRouteEntryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterRouteTableRequestRouteTableOptions(TeaModel):
    def __init__(self, multi_region_ecmp=None):
        self.multi_region_ecmp = multi_region_ecmp  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterRouteTableRequestRouteTableOptions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.multi_region_ecmp is not None:
            result['MultiRegionECMP'] = self.multi_region_ecmp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MultiRegionECMP') is not None:
            self.multi_region_ecmp = m.get('MultiRegionECMP')
        return self


class CreateTransitRouterRouteTableRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterRouteTableRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTransitRouterRouteTableRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, route_table_options=None, tag=None, transit_router_id=None,
                 transit_router_route_table_description=None, transit_router_route_table_name=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and the request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.route_table_options = route_table_options  # type: CreateTransitRouterRouteTableRequestRouteTableOptions
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[CreateTransitRouterRouteTableRequestTag]
        # The ID of the Enterprise Edition transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The description of the custom route table.
        # 
        # The description must be 2 to 256 characters in length, and can contain letters, digits, and the following special characters: , . ; / @ \_ -. You can also leave the description empty.
        self.transit_router_route_table_description = transit_router_route_table_description  # type: str
        # The name of the custom route table.
        # 
        # The name must be 0 to 128 characters in length, and can contain letters, digits, and the following special characters: , . ; / @ \_ -.
        self.transit_router_route_table_name = transit_router_route_table_name  # type: str

    def validate(self):
        if self.route_table_options:
            self.route_table_options.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTransitRouterRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_table_options is not None:
            result['RouteTableOptions'] = self.route_table_options.to_map()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.transit_router_route_table_description is not None:
            result['TransitRouterRouteTableDescription'] = self.transit_router_route_table_description
        if self.transit_router_route_table_name is not None:
            result['TransitRouterRouteTableName'] = self.transit_router_route_table_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteTableOptions') is not None:
            temp_model = CreateTransitRouterRouteTableRequestRouteTableOptions()
            self.route_table_options = temp_model.from_map(m['RouteTableOptions'])
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateTransitRouterRouteTableRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('TransitRouterRouteTableDescription') is not None:
            self.transit_router_route_table_description = m.get('TransitRouterRouteTableDescription')
        if m.get('TransitRouterRouteTableName') is not None:
            self.transit_router_route_table_name = m.get('TransitRouterRouteTableName')
        return self


class CreateTransitRouterRouteTableResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_route_table_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the custom route table.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterRouteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        return self


class CreateTransitRouterRouteTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterVbrAttachmentRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterVbrAttachmentRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTransitRouterVbrAttachmentRequest(TeaModel):
    def __init__(self, auto_publish_route_enabled=None, cen_id=None, client_token=None, dry_run=None,
                 owner_account=None, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, tag=None,
                 transit_router_attachment_description=None, transit_router_attachment_name=None, transit_router_id=None, vbr_id=None, vbr_owner_id=None):
        # Specifies whether to enable the Enterprise Edition transit router to automatically advertise routes to the VBR. Valid values:
        # 
        # *   **false** (default): no
        # *   **true**: yes
        self.auto_publish_route_enabled = auto_publish_route_enabled  # type: bool
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Default values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The region ID of the VBR.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to obtain the region ID.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[CreateTransitRouterVbrAttachmentRequestTag]
        # The description of the VBR connection.
        # 
        # The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        self.transit_router_attachment_description = transit_router_attachment_description  # type: str
        # The name of the VBR connection.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.transit_router_attachment_name = transit_router_attachment_name  # type: str
        # The ID of the Enterprise Edition transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The ID of the VBR.
        self.vbr_id = vbr_id  # type: str
        # The ID of the Alibaba Cloud account to which the VBR belongs. The default value is the ID of the current Alibaba Cloud account.
        # 
        # > If the network instance and the CEN instance belong to different Alibaba Cloud accounts, this parameter is required.
        self.vbr_owner_id = vbr_owner_id  # type: long

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTransitRouterVbrAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_publish_route_enabled is not None:
            result['AutoPublishRouteEnabled'] = self.auto_publish_route_enabled
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_attachment_description is not None:
            result['TransitRouterAttachmentDescription'] = self.transit_router_attachment_description
        if self.transit_router_attachment_name is not None:
            result['TransitRouterAttachmentName'] = self.transit_router_attachment_name
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.vbr_id is not None:
            result['VbrId'] = self.vbr_id
        if self.vbr_owner_id is not None:
            result['VbrOwnerId'] = self.vbr_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPublishRouteEnabled') is not None:
            self.auto_publish_route_enabled = m.get('AutoPublishRouteEnabled')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateTransitRouterVbrAttachmentRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentDescription') is not None:
            self.transit_router_attachment_description = m.get('TransitRouterAttachmentDescription')
        if m.get('TransitRouterAttachmentName') is not None:
            self.transit_router_attachment_name = m.get('TransitRouterAttachmentName')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('VbrId') is not None:
            self.vbr_id = m.get('VbrId')
        if m.get('VbrOwnerId') is not None:
            self.vbr_owner_id = m.get('VbrOwnerId')
        return self


class CreateTransitRouterVbrAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_attachment_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the VBR connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterVbrAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class CreateTransitRouterVbrAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterVbrAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterVbrAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterVbrAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterVpcAttachmentRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterVpcAttachmentRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTransitRouterVpcAttachmentRequestZoneMappings(TeaModel):
    def __init__(self, v_switch_id=None, zone_id=None):
        # A vSwitch that is deployed in the zone that supports Enterprise Edition transit routers.
        # 
        # You can specify vSwitches for at most 10 zones in each call.
        self.v_switch_id = v_switch_id  # type: str
        # The ID of the zone that supports Enterprise Edition transit routers.
        # 
        # You can call the [DescribeZones](~~36064~~) operation to query the most recent zone list.
        # 
        # You can specify at most 10 zones in each call.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterVpcAttachmentRequestZoneMappings, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateTransitRouterVpcAttachmentRequest(TeaModel):
    def __init__(self, cen_id=None, charge_type=None, client_token=None, dry_run=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, tag=None,
                 transit_router_attachment_description=None, transit_router_attachment_name=None, transit_router_id=None, vpc_id=None, vpc_owner_id=None,
                 zone_mappings=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The billing method. The default value is **POSTPAY**, which specifies the pay-as-you-go billing method.
        self.charge_type = charge_type  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Default values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the VPC is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[CreateTransitRouterVpcAttachmentRequestTag]
        # The description of the VPC connection.
        # 
        # The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        self.transit_router_attachment_description = transit_router_attachment_description  # type: str
        # The name of the VPC connection.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.transit_router_attachment_name = transit_router_attachment_name  # type: str
        # The ID of the Enterprise Edition transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The ID of the VPC.
        self.vpc_id = vpc_id  # type: str
        # The ID of the Alibaba Cloud account to which the VPC belongs. The default value is the ID of the current Alibaba Cloud account.
        # 
        # > If the network instance and CEN instance belong to different Alibaba Cloud accounts, this parameter is required.
        self.vpc_owner_id = vpc_owner_id  # type: long
        # A zone that supports Enterprise Edition transit routers.
        # 
        # You can specify at most 10 zones.
        self.zone_mappings = zone_mappings  # type: list[CreateTransitRouterVpcAttachmentRequestZoneMappings]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.zone_mappings:
            for k in self.zone_mappings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTransitRouterVpcAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_attachment_description is not None:
            result['TransitRouterAttachmentDescription'] = self.transit_router_attachment_description
        if self.transit_router_attachment_name is not None:
            result['TransitRouterAttachmentName'] = self.transit_router_attachment_name
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_owner_id is not None:
            result['VpcOwnerId'] = self.vpc_owner_id
        result['ZoneMappings'] = []
        if self.zone_mappings is not None:
            for k in self.zone_mappings:
                result['ZoneMappings'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateTransitRouterVpcAttachmentRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentDescription') is not None:
            self.transit_router_attachment_description = m.get('TransitRouterAttachmentDescription')
        if m.get('TransitRouterAttachmentName') is not None:
            self.transit_router_attachment_name = m.get('TransitRouterAttachmentName')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcOwnerId') is not None:
            self.vpc_owner_id = m.get('VpcOwnerId')
        self.zone_mappings = []
        if m.get('ZoneMappings') is not None:
            for k in m.get('ZoneMappings'):
                temp_model = CreateTransitRouterVpcAttachmentRequestZoneMappings()
                self.zone_mappings.append(temp_model.from_map(k))
        return self


class CreateTransitRouterVpcAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_attachment_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the VPC connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterVpcAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class CreateTransitRouterVpcAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterVpcAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterVpcAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterVpcAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTransitRouterVpnAttachmentRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length, and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterVpnAttachmentRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class CreateTransitRouterVpnAttachmentRequestZone(TeaModel):
    def __init__(self, zone_id=None):
        # The ID of the zone.
        # 
        # You can call the [ListTransitRouterAvailableResource](~~261356~~) operation to query the most recent zone list.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterVpnAttachmentRequestZone, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class CreateTransitRouterVpnAttachmentRequest(TeaModel):
    def __init__(self, auto_publish_route_enabled=None, cen_id=None, charge_type=None, client_token=None,
                 dry_run=None, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, tag=None, transit_router_attachment_description=None, transit_router_attachment_name=None,
                 transit_router_id=None, vpn_id=None, vpn_owner_id=None, zone=None):
        # Specifies whether to allow the transit router to automatically advertise routes to the IPsec-VPN connection. Valid values:
        # 
        # *   **true** (default): yes
        # *   **false**: no
        self.auto_publish_route_enabled = auto_publish_route_enabled  # type: bool
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The billing method.
        # 
        # Set the value to **POSTPAY**, which is the default value and specifies the pay-as-you-go billing method.
        self.charge_type = charge_type  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The ClientToken value contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request syntax, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[CreateTransitRouterVpnAttachmentRequestTag]
        # The description of the VPN attachment.
        # 
        # The description must be 2 to 256 characters in length. The description must start with a letter but cannot start with `http://` or `https://`.
        self.transit_router_attachment_description = transit_router_attachment_description  # type: str
        # The name of the VPN attachment.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.transit_router_attachment_name = transit_router_attachment_name  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The ID of the IPsec-VPN connection.
        self.vpn_id = vpn_id  # type: str
        # The ID of the Alibaba Cloud account to which the IPsec-VPN connection belongs.
        # 
        # *   If you do not set this parameter, the ID of the current Alibaba Cloud account is used.
        # *   You must set VpnOwnerId if you want to connect the transit router to an IPsec-VPN connection that belongs to another Alibaba Cloud account.
        self.vpn_owner_id = vpn_owner_id  # type: long
        # The ID of the zone in the current region.
        # 
        # Resources are deployed in the specified zone.
        self.zone = zone  # type: list[CreateTransitRouterVpnAttachmentRequestZone]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()
        if self.zone:
            for k in self.zone:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(CreateTransitRouterVpnAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_publish_route_enabled is not None:
            result['AutoPublishRouteEnabled'] = self.auto_publish_route_enabled
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.charge_type is not None:
            result['ChargeType'] = self.charge_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_attachment_description is not None:
            result['TransitRouterAttachmentDescription'] = self.transit_router_attachment_description
        if self.transit_router_attachment_name is not None:
            result['TransitRouterAttachmentName'] = self.transit_router_attachment_name
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.vpn_id is not None:
            result['VpnId'] = self.vpn_id
        if self.vpn_owner_id is not None:
            result['VpnOwnerId'] = self.vpn_owner_id
        result['Zone'] = []
        if self.zone is not None:
            for k in self.zone:
                result['Zone'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPublishRouteEnabled') is not None:
            self.auto_publish_route_enabled = m.get('AutoPublishRouteEnabled')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChargeType') is not None:
            self.charge_type = m.get('ChargeType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = CreateTransitRouterVpnAttachmentRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentDescription') is not None:
            self.transit_router_attachment_description = m.get('TransitRouterAttachmentDescription')
        if m.get('TransitRouterAttachmentName') is not None:
            self.transit_router_attachment_name = m.get('TransitRouterAttachmentName')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('VpnId') is not None:
            self.vpn_id = m.get('VpnId')
        if m.get('VpnOwnerId') is not None:
            self.vpn_owner_id = m.get('VpnOwnerId')
        self.zone = []
        if m.get('Zone') is not None:
            for k in m.get('Zone'):
                temp_model = CreateTransitRouterVpnAttachmentRequestZone()
                self.zone.append(temp_model.from_map(k))
        return self


class CreateTransitRouterVpnAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None, transit_router_attachment_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The ID of the VPN attachment.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTransitRouterVpnAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class CreateTransitRouterVpnAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTransitRouterVpnAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTransitRouterVpnAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTransitRouterVpnAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeactiveFlowLogRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, flow_log_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # The ID of the flow log.
        self.flow_log_id = flow_log_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the flow log is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeactiveFlowLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeactiveFlowLogResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call is successful. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeactiveFlowLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeactiveFlowLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeactiveFlowLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeactiveFlowLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeactiveFlowLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCenRequest(TeaModel):
    def __init__(self, cen_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCenResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCenBandwidthPackageRequest(TeaModel):
    def __init__(self, cen_bandwidth_package_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the bandwidth plan that you want to delete.
        self.cen_bandwidth_package_id = cen_bandwidth_package_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenBandwidthPackageRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_bandwidth_package_id is not None:
            result['CenBandwidthPackageId'] = self.cen_bandwidth_package_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenBandwidthPackageId') is not None:
            self.cen_bandwidth_package_id = m.get('CenBandwidthPackageId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCenBandwidthPackageResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenBandwidthPackageResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCenBandwidthPackageResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCenBandwidthPackageResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCenBandwidthPackageResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCenBandwidthPackageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCenChildInstanceRouteEntryToAttachmentRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, destination_cidr_block=None, dry_run=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None, route_table_id=None,
                 transit_router_attachment_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** may be different for each API request.
        self.client_token = client_token  # type: str
        # The destination CIDR block of the route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # Specifies whether to perform a precheck to check information such as the permissions and instance status. Valid values:
        # 
        # *   **false**: performs a precheck. The route is deleted after the request passes the precheck. This is the default value.
        # *   **true**: performs a precheck. The route is not deleted. If you use this value, the system checks the required parameters and the request syntax. If the request fails to pass the precheck, an error message is returned. If the request passes the check, the system returns the ID of the request.
        # 
        # >  This parameter is not in use.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the route table configured on the network instance.
        self.route_table_id = route_table_id  # type: str
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenChildInstanceRouteEntryToAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class DeleteCenChildInstanceRouteEntryToAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenChildInstanceRouteEntryToAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCenChildInstanceRouteEntryToAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCenChildInstanceRouteEntryToAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCenChildInstanceRouteEntryToAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCenChildInstanceRouteEntryToAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCenChildInstanceRouteEntryToCenRequest(TeaModel):
    def __init__(self, cen_id=None, child_instance_ali_uid=None, child_instance_id=None,
                 child_instance_region_id=None, child_instance_type=None, destination_cidr_block=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, route_table_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The ID of the Alibaba Cloud account to which the network instance belongs.
        # 
        # > If the network instance belongs to another Alibaba Cloud account, this parameter is required.
        self.child_instance_ali_uid = child_instance_ali_uid  # type: long
        # The ID of the network instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: a virtual private cloud (VPC)
        # *   **VBR**: a virtual border router (VBR)
        self.child_instance_type = child_instance_type  # type: str
        # The destination CIDR block of the route entry.
        # 
        # Specify the value of this parameter in CIDR notation. Example: 192.168.10.0/24.
        self.destination_cidr_block = destination_cidr_block  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the route table configured on the network instance.
        self.route_table_id = route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenChildInstanceRouteEntryToCenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_ali_uid is not None:
            result['ChildInstanceAliUid'] = self.child_instance_ali_uid
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceAliUid') is not None:
            self.child_instance_ali_uid = m.get('ChildInstanceAliUid')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        return self


class DeleteCenChildInstanceRouteEntryToCenResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenChildInstanceRouteEntryToCenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCenChildInstanceRouteEntryToCenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCenChildInstanceRouteEntryToCenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCenChildInstanceRouteEntryToCenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCenChildInstanceRouteEntryToCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCenInterRegionTrafficQosPolicyRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, traffic_qos_policy_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Default value: false. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request syntax, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the QoS policy.
        self.traffic_qos_policy_id = traffic_qos_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenInterRegionTrafficQosPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_qos_policy_id is not None:
            result['TrafficQosPolicyId'] = self.traffic_qos_policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficQosPolicyId') is not None:
            self.traffic_qos_policy_id = m.get('TrafficQosPolicyId')
        return self


class DeleteCenInterRegionTrafficQosPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenInterRegionTrafficQosPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCenInterRegionTrafficQosPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCenInterRegionTrafficQosPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCenInterRegionTrafficQosPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCenInterRegionTrafficQosPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCenInterRegionTrafficQosQueueRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None, qos_queue_id=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request syntax, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): performs a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the queue.
        self.qos_queue_id = qos_queue_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenInterRegionTrafficQosQueueRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.qos_queue_id is not None:
            result['QosQueueId'] = self.qos_queue_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('QosQueueId') is not None:
            self.qos_queue_id = m.get('QosQueueId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCenInterRegionTrafficQosQueueResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenInterRegionTrafficQosQueueResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCenInterRegionTrafficQosQueueResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCenInterRegionTrafficQosQueueResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCenInterRegionTrafficQosQueueResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCenInterRegionTrafficQosQueueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCenRouteMapRequest(TeaModel):
    def __init__(self, cen_id=None, cen_region_id=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, route_map_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The ID of the region in which the routing policy is applied.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.cen_region_id = cen_region_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the routing policy.
        self.route_map_id = route_map_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenRouteMapRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_region_id is not None:
            result['CenRegionId'] = self.cen_region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_map_id is not None:
            result['RouteMapId'] = self.route_map_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenRegionId') is not None:
            self.cen_region_id = m.get('CenRegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteMapId') is not None:
            self.route_map_id = m.get('RouteMapId')
        return self


class DeleteCenRouteMapResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteCenRouteMapResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCenRouteMapResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteCenRouteMapResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteCenRouteMapResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCenRouteMapResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteFlowlogRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, flow_log_id=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can only contain ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # The ID of the flow log.
        self.flow_log_id = flow_log_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the flow log is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowlogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteFlowlogResponseBody(TeaModel):
    def __init__(self, request_id=None, success=None):
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call is successful.
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteFlowlogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteFlowlogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteFlowlogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteFlowlogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteFlowlogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteRouteServiceInCenRequest(TeaModel):
    def __init__(self, access_region_id=None, cen_id=None, host=None, host_region_id=None, host_vpc_id=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the region in which the network instance of the cloud service that you want to access is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.access_region_id = access_region_id  # type: str
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The IP addresses or CIDR blocks of the cloud service.
        self.host = host  # type: str
        # The ID of the region in which the cloud service is deployed.
        self.host_region_id = host_region_id  # type: str
        # The ID of the virtual private cloud (VPC) that is associated with the cloud service.
        self.host_vpc_id = host_vpc_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRouteServiceInCenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_region_id is not None:
            result['AccessRegionId'] = self.access_region_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.host is not None:
            result['Host'] = self.host
        if self.host_region_id is not None:
            result['HostRegionId'] = self.host_region_id
        if self.host_vpc_id is not None:
            result['HostVpcId'] = self.host_vpc_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessRegionId') is not None:
            self.access_region_id = m.get('AccessRegionId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('HostRegionId') is not None:
            self.host_region_id = m.get('HostRegionId')
        if m.get('HostVpcId') is not None:
            self.host_vpc_id = m.get('HostVpcId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteRouteServiceInCenResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteRouteServiceInCenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteRouteServiceInCenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteRouteServiceInCenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteRouteServiceInCenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteRouteServiceInCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTrafficMarkingPolicyRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, traffic_marking_policy_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # > If you do not specify this parameter, the system automatically uses the value of **RequestId** as the value of **ClientToken**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request syntax, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the DryRunOperation error code is returned.
        # *   **false** (default): performs a dry run and sends the request. If the request passes the dry run, a 2xx HTTP status code is returned and the operation is performed.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the traffic marking policy.
        self.traffic_marking_policy_id = traffic_marking_policy_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTrafficMarkingPolicyRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_marking_policy_id is not None:
            result['TrafficMarkingPolicyId'] = self.traffic_marking_policy_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficMarkingPolicyId') is not None:
            self.traffic_marking_policy_id = m.get('TrafficMarkingPolicyId')
        return self


class DeleteTrafficMarkingPolicyResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTrafficMarkingPolicyResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTrafficMarkingPolicyResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTrafficMarkingPolicyResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTrafficMarkingPolicyResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTrafficMarkingPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouteTableAggregationRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_route_table_aggregation_cidr=None,
                 transit_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that the value is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId may be different for each request.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and the request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The destination CIDR block of the aggregate route.
        self.transit_route_table_aggregation_cidr = transit_route_table_aggregation_cidr  # type: str
        # The ID of the route table of the Enterprise Edition transit router.
        self.transit_route_table_id = transit_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouteTableAggregationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_route_table_aggregation_cidr is not None:
            result['TransitRouteTableAggregationCidr'] = self.transit_route_table_aggregation_cidr
        if self.transit_route_table_id is not None:
            result['TransitRouteTableId'] = self.transit_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouteTableAggregationCidr') is not None:
            self.transit_route_table_aggregation_cidr = m.get('TransitRouteTableAggregationCidr')
        if m.get('TransitRouteTableId') is not None:
            self.transit_route_table_id = m.get('TransitRouteTableId')
        return self


class DeleteTransitRouteTableAggregationResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouteTableAggregationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouteTableAggregationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouteTableAggregationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouteTableAggregationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouteTableAggregationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that the value is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and the request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class DeleteTransitRouterResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterCidrRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_cidr_id=None, transit_router_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether only to precheck the request. Valid values:
        # 
        # *   **true**: prechecks the request but does not delete the CIDR block. The system checks the required parameters, the request format, and the service limits. If the request fails to pass the precheck, an error message is returned. If the request passes the precheck, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. If the request passes the precheck, the CIDR block is deleted.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the transit router CIDR block.
        # 
        # You can call [ListTransitRouterCidr](~~462772~~) to query the ID of a transit router CIDR block.
        self.transit_router_cidr_id = transit_router_cidr_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterCidrRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_cidr_id is not None:
            result['TransitRouterCidrId'] = self.transit_router_cidr_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterCidrId') is not None:
            self.transit_router_cidr_id = m.get('TransitRouterCidrId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class DeleteTransitRouterCidrResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterCidrResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterCidrResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterCidrResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterCidrResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterCidrResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterMulticastDomainRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_multicast_domain_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can only contain ASCII characters.
        self.client_token = client_token  # type: str
        # Specifies whether only to precheck the API request. Valid values:
        # 
        # *   **true**: prechecks the request but does not delete the multicast domain. The system checks the required parameters, the request format, and the service limits. If the request fails the check, an error message is returned. If the request passes the check, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. After the request passes the precheck, the multicast domain is deleted.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterMulticastDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        return self


class DeleteTransitRouterMulticastDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterMulticastDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterMulticastDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterMulticastDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterMulticastDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterMulticastDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterPeerAttachmentRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, force=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that the value is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run to check information such as the permissions and instance status. Valid values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and the request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.force = force  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the inter-region connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterPeerAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.force is not None:
            result['Force'] = self.force
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class DeleteTransitRouterPeerAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterPeerAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterPeerAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterPeerAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterPeerAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterPeerAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterPrefixListAssociationRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, next_hop=None, next_hop_type=None, owner_account=None,
                 owner_id=None, prefix_list_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None,
                 transit_router_id=None, transit_router_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** of each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether only to check the request. Valid values:
        # 
        # *   **true**: prechecks the request but does not disassociate the route table from the prefix list. The system checks the required parameters, the request format, and the service limits. If the request fails to pass the precheck, an error message is returned. If the request passes the precheck, the `DryRunOperation` error code is returned.
        # *   **false** (default): prechecks the request. If the request passes the check, the route table is disassociated from the prefix list.
        self.dry_run = dry_run  # type: bool
        # The ID of the next hop connection.
        # 
        # >  If **NextHopType** is set to **BlackHole**, set this parameter to **BlackHole**.
        self.next_hop = next_hop  # type: str
        # The type of the next hop. Valid values:
        # 
        # *   **BlackHole**: specifies that all the CIDR blocks in the prefix list are blackhole routes. Packets destined for the CIDR blocks are dropped.
        # *   **VPC**: specifies that the next hop of the CIDR blocks in the prefix list is a virtual private cloud (VPC) connection.
        # *   **VBR**: specifies that the next hop of the CIDR blocks in the prefix list is a virtual border router (VBR) connection.
        # *   **TR**: specifies that the next hop of the CIDR blocks in the prefix list is an inter-region connection.
        self.next_hop_type = next_hop_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the prefix list.
        self.prefix_list_id = prefix_list_id  # type: str
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The ID of the route table of the transit router.
        self.transit_router_table_id = transit_router_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterPrefixListAssociationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.next_hop is not None:
            result['NextHop'] = self.next_hop
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prefix_list_id is not None:
            result['PrefixListId'] = self.prefix_list_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.transit_router_table_id is not None:
            result['TransitRouterTableId'] = self.transit_router_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('NextHop') is not None:
            self.next_hop = m.get('NextHop')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PrefixListId') is not None:
            self.prefix_list_id = m.get('PrefixListId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('TransitRouterTableId') is not None:
            self.transit_router_table_id = m.get('TransitRouterTableId')
        return self


class DeleteTransitRouterPrefixListAssociationResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterPrefixListAssociationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterPrefixListAssociationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterPrefixListAssociationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterPrefixListAssociationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterPrefixListAssociationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterRouteEntryRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_route_entry_destination_cidr_block=None,
                 transit_router_route_entry_id=None, transit_router_route_entry_next_hop_id=None,
                 transit_router_route_entry_next_hop_type=None, transit_router_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # > If you do not specify this parameter, the system automatically uses the value of **RequestId** as the value of **ClientToken**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to check the request but not perform the operation. The system checks the permissions and the status of the specified instances. Valid values:
        # 
        # *   **false** (default): sends the request. If the request passes the precheck, the route is deleted.
        # *   **true**: sends a precheck request. The route is not deleted after the request passes the precheck. If you use this value, the system checks the required parameters and the request syntax. If the check fails, the corresponding error message is returned. If the request passes the check, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The destination CIDR block.
        self.transit_router_route_entry_destination_cidr_block = transit_router_route_entry_destination_cidr_block  # type: str
        # The ID of the route entry.
        self.transit_router_route_entry_id = transit_router_route_entry_id  # type: str
        # The ID of the network instance connection that you want to specify as the next hop.
        self.transit_router_route_entry_next_hop_id = transit_router_route_entry_next_hop_id  # type: str
        # The type of the next hop. Valid values:
        # 
        # *   **BlackHole**: a blackhole route. You do not need to specify a next hop.
        # *   **Attachment**: a network instance connection. You must specify a network instance connection as the next hop.
        self.transit_router_route_entry_next_hop_type = transit_router_route_entry_next_hop_type  # type: str
        # The ID of the route table of the Enterprise Edition transit router.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterRouteEntryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_route_entry_destination_cidr_block is not None:
            result['TransitRouterRouteEntryDestinationCidrBlock'] = self.transit_router_route_entry_destination_cidr_block
        if self.transit_router_route_entry_id is not None:
            result['TransitRouterRouteEntryId'] = self.transit_router_route_entry_id
        if self.transit_router_route_entry_next_hop_id is not None:
            result['TransitRouterRouteEntryNextHopId'] = self.transit_router_route_entry_next_hop_id
        if self.transit_router_route_entry_next_hop_type is not None:
            result['TransitRouterRouteEntryNextHopType'] = self.transit_router_route_entry_next_hop_type
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterRouteEntryDestinationCidrBlock') is not None:
            self.transit_router_route_entry_destination_cidr_block = m.get('TransitRouterRouteEntryDestinationCidrBlock')
        if m.get('TransitRouterRouteEntryId') is not None:
            self.transit_router_route_entry_id = m.get('TransitRouterRouteEntryId')
        if m.get('TransitRouterRouteEntryNextHopId') is not None:
            self.transit_router_route_entry_next_hop_id = m.get('TransitRouterRouteEntryNextHopId')
        if m.get('TransitRouterRouteEntryNextHopType') is not None:
            self.transit_router_route_entry_next_hop_type = m.get('TransitRouterRouteEntryNextHopType')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        return self


class DeleteTransitRouterRouteEntryResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterRouteEntryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterRouteEntryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterRouteEntryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterRouteEntryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterRouteEntryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterRouteTableRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not specify this parameter, the system automatically uses the value of **RequestId** as the value of **ClientToken**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **false** (default): performs a dry run and sends the request. If the request passes the dry run, the custom route table is deleted.
        # *   **true**: performs a dry run. The system checks whether the required parameters are set, and whether the request syntax is valid. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the custom route table.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        return self


class DeleteTransitRouterRouteTableResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterRouteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterRouteTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterVbrAttachmentRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, force=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Default values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and the request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        # Specifies whether to forcibly delete the VBR connection. Valid values:
        # 
        # *   **false** (default): checks for resources related to the VBR connection, such as associated forwarding and route learning policies. If such resources exist, the VBR connection is not deleted and an error message is returned.
        # *   **true**: deletes the VBR connection and related resources.
        self.force = force  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the VBR connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterVbrAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.force is not None:
            result['Force'] = self.force
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class DeleteTransitRouterVbrAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterVbrAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterVbrAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterVbrAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterVbrAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterVbrAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterVpcAttachmentRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, force=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Default values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        # Specifies whether to forcefully delete the VPC connection. Valid values:
        # 
        # *   **false** (default): checks resources such as associated forwarding correlations and route learning policies that are related to the VPC connection before it is deleted. If such a resource exists, the VPC connection is not deleted and an error message is returned.
        # *   **true**: deletes the VPC connection and all resources that are related to the VPC connection.
        self.force = force  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the VPC connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterVpcAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.force is not None:
            result['Force'] = self.force
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class DeleteTransitRouterVpcAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterVpcAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterVpcAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterVpcAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterVpcAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterVpcAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTransitRouterVpnAttachmentRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, force=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** may be different for each API request.
        self.client_token = client_token  # type: str
        # Specifies whether only to precheck the request. Valid values:
        # 
        # *   **true**: prechecks the request but does not delete the VPN connection. The system checks the required parameters, request syntax, and limits. If the request fails the precheck, an error message is returned. If the request passes the precheck, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. After the request passes the precheck, the VPN connection is deleted.
        self.dry_run = dry_run  # type: bool
        # Specifies whether to force to delete the a VPN connection for the Enterprise Edition transit router.
        self.force = force  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the VPN connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterVpnAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.force is not None:
            result['Force'] = self.force
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('Force') is not None:
            self.force = m.get('Force')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class DeleteTransitRouterVpnAttachmentResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteTransitRouterVpnAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTransitRouterVpnAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteTransitRouterVpnAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteTransitRouterVpnAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTransitRouterVpnAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeregisterTransitRouterMulticastGroupMembersRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, group_ip_address=None, network_interface_ids=None,
                 owner_account=None, owner_id=None, peer_transit_router_multicast_domains=None, resource_owner_account=None,
                 resource_owner_id=None, transit_router_multicast_domain_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can contain only ASCII characters.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run. Valid values:
        # 
        # *   **true**: performs a dry run. The system checks the required parameters, request syntax, and limits. If the request fails the dry run, an error message is returned. If the request passes the dry run, the `DryRunOperation` error code is returned.
        # *   **false** (default): preforms a dry run and sends the request.
        self.dry_run = dry_run  # type: bool
        # The IP address of the multicast group to which the multicast members belong.
        self.group_ip_address = group_ip_address  # type: str
        # The IDs of elastic network interfaces (ENIs).
        self.network_interface_ids = network_interface_ids  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the multicast domain that is in a different region.
        self.peer_transit_router_multicast_domains = peer_transit_router_multicast_domains  # type: list[str]
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the multicast domain to which the multicast members belong.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeregisterTransitRouterMulticastGroupMembersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.group_ip_address is not None:
            result['GroupIpAddress'] = self.group_ip_address
        if self.network_interface_ids is not None:
            result['NetworkInterfaceIds'] = self.network_interface_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.peer_transit_router_multicast_domains is not None:
            result['PeerTransitRouterMulticastDomains'] = self.peer_transit_router_multicast_domains
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('GroupIpAddress') is not None:
            self.group_ip_address = m.get('GroupIpAddress')
        if m.get('NetworkInterfaceIds') is not None:
            self.network_interface_ids = m.get('NetworkInterfaceIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PeerTransitRouterMulticastDomains') is not None:
            self.peer_transit_router_multicast_domains = m.get('PeerTransitRouterMulticastDomains')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        return self


class DeregisterTransitRouterMulticastGroupMembersResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeregisterTransitRouterMulticastGroupMembersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeregisterTransitRouterMulticastGroupMembersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeregisterTransitRouterMulticastGroupMembersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeregisterTransitRouterMulticastGroupMembersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeregisterTransitRouterMulticastGroupMembersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeregisterTransitRouterMulticastGroupSourcesRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, group_ip_address=None, network_interface_ids=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 transit_router_multicast_domain_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        self.client_token = client_token  # type: str
        # Specifies whether only to check the request. Valid values:
        # 
        # *   **true**: only prechecks the API request. The multicast source is not deleted. The system checks the required parameters, the request format, and the service limits. If the request fails to pass the precheck, an error message is returned. If the request passes the precheck, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. After the request passes the precheck, the multicast source is deleted.
        self.dry_run = dry_run  # type: bool
        # The IP address of the multicast group to which the multicast source belongs.
        self.group_ip_address = group_ip_address  # type: str
        # The IDs of the multicast sources. You can create only one multicast source in a multicast group.
        # 
        # >  This parameter is required.
        self.network_interface_ids = network_interface_ids  # type: list[str]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the multicast group to which the multicast source belongs.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeregisterTransitRouterMulticastGroupSourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.group_ip_address is not None:
            result['GroupIpAddress'] = self.group_ip_address
        if self.network_interface_ids is not None:
            result['NetworkInterfaceIds'] = self.network_interface_ids
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('GroupIpAddress') is not None:
            self.group_ip_address = m.get('GroupIpAddress')
        if m.get('NetworkInterfaceIds') is not None:
            self.network_interface_ids = m.get('NetworkInterfaceIds')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        return self


class DeregisterTransitRouterMulticastGroupSourcesResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeregisterTransitRouterMulticastGroupSourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeregisterTransitRouterMulticastGroupSourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeregisterTransitRouterMulticastGroupSourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeregisterTransitRouterMulticastGroupSourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeregisterTransitRouterMulticastGroupSourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenAttachedChildInstanceAttributeRequest(TeaModel):
    def __init__(self, cen_id=None, child_instance_id=None, child_instance_region_id=None,
                 child_instance_type=None, owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the network instance that is attached to the CEN instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        self.child_instance_type = child_instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenAttachedChildInstanceAttributeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCenAttachedChildInstanceAttributeResponseBody(TeaModel):
    def __init__(self, cen_id=None, child_instance_attach_time=None, child_instance_id=None,
                 child_instance_name=None, child_instance_owner_id=None, child_instance_region_id=None, child_instance_type=None,
                 request_id=None, status=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The time when the network instance was attached to the CEN instance.
        # 
        # The time follows the ISO8601 standard in the YYYY-MM-DDThh:mmZ format. The time is displayed in UTC.
        self.child_instance_attach_time = child_instance_attach_time  # type: str
        # The ID of the network instance.
        self.child_instance_id = child_instance_id  # type: str
        # The name of the network instance.
        self.child_instance_name = child_instance_name  # type: str
        # The ID of the Alibaba Cloud account to which the network instance belongs.
        self.child_instance_owner_id = child_instance_owner_id  # type: long
        # The ID of the region where the network instance is deployed.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        self.child_instance_type = child_instance_type  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the network instance is attached to the CEN instance. Valid values:
        # 
        # *   **Attaching**: being attached to the CEN instance.
        # *   **Attached**: attached to the CEN instance.
        # *   **Detaching**: being detached from the CEN instance.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenAttachedChildInstanceAttributeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_attach_time is not None:
            result['ChildInstanceAttachTime'] = self.child_instance_attach_time
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_name is not None:
            result['ChildInstanceName'] = self.child_instance_name
        if self.child_instance_owner_id is not None:
            result['ChildInstanceOwnerId'] = self.child_instance_owner_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceAttachTime') is not None:
            self.child_instance_attach_time = m.get('ChildInstanceAttachTime')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceName') is not None:
            self.child_instance_name = m.get('ChildInstanceName')
        if m.get('ChildInstanceOwnerId') is not None:
            self.child_instance_owner_id = m.get('ChildInstanceOwnerId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCenAttachedChildInstanceAttributeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenAttachedChildInstanceAttributeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenAttachedChildInstanceAttributeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenAttachedChildInstanceAttributeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenAttachedChildInstancesRequest(TeaModel):
    def __init__(self, cen_id=None, child_instance_region_id=None, child_instance_type=None, owner_account=None,
                 owner_id=None, page_number=None, page_size=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: virtual private cloud (VPC)
        # *   **VBR**: virtual border router (VBR)
        # *   **CCN**: Cloud Connect Network (CCN) instance
        self.child_instance_type = child_instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenAttachedChildInstancesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCenAttachedChildInstancesResponseBodyChildInstancesChildInstance(TeaModel):
    def __init__(self, cen_id=None, child_instance_attach_time=None, child_instance_id=None,
                 child_instance_owner_id=None, child_instance_region_id=None, child_instance_type=None, status=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The time when the network instance was attached to the CEN instance.
        # 
        # The time follows the ISO8601 standard in the YYYY-MM-DDThh:mmZ format. The time is displayed in UTC.
        self.child_instance_attach_time = child_instance_attach_time  # type: str
        # The ID of the network instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the Alibaba Cloud account to which the network instance belongs.
        self.child_instance_owner_id = child_instance_owner_id  # type: long
        # The ID of the region where the network instance is deployed.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        self.child_instance_type = child_instance_type  # type: str
        # The status of the network instance. Valid values:
        # 
        # *   **Attaching**: The network instance is being created on the transit router.
        # *   **Attached**: The network instance has been created on the transit router.
        # *   **Detaching**: The network instance is being deleted from the transit router.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenAttachedChildInstancesResponseBodyChildInstancesChildInstance, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_attach_time is not None:
            result['ChildInstanceAttachTime'] = self.child_instance_attach_time
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_owner_id is not None:
            result['ChildInstanceOwnerId'] = self.child_instance_owner_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceAttachTime') is not None:
            self.child_instance_attach_time = m.get('ChildInstanceAttachTime')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceOwnerId') is not None:
            self.child_instance_owner_id = m.get('ChildInstanceOwnerId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCenAttachedChildInstancesResponseBodyChildInstances(TeaModel):
    def __init__(self, child_instance=None):
        self.child_instance = child_instance  # type: list[DescribeCenAttachedChildInstancesResponseBodyChildInstancesChildInstance]

    def validate(self):
        if self.child_instance:
            for k in self.child_instance:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenAttachedChildInstancesResponseBodyChildInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ChildInstance'] = []
        if self.child_instance is not None:
            for k in self.child_instance:
                result['ChildInstance'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.child_instance = []
        if m.get('ChildInstance') is not None:
            for k in m.get('ChildInstance'):
                temp_model = DescribeCenAttachedChildInstancesResponseBodyChildInstancesChildInstance()
                self.child_instance.append(temp_model.from_map(k))
        return self


class DescribeCenAttachedChildInstancesResponseBody(TeaModel):
    def __init__(self, child_instances=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The information about the network instances.
        self.child_instances = child_instances  # type: DescribeCenAttachedChildInstancesResponseBodyChildInstances
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.child_instances:
            self.child_instances.validate()

    def to_map(self):
        _map = super(DescribeCenAttachedChildInstancesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_instances is not None:
            result['ChildInstances'] = self.child_instances.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChildInstances') is not None:
            temp_model = DescribeCenAttachedChildInstancesResponseBodyChildInstances()
            self.child_instances = temp_model.from_map(m['ChildInstances'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCenAttachedChildInstancesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenAttachedChildInstancesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenAttachedChildInstancesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenAttachedChildInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenBandwidthPackagesRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        # The filter condition.
        # 
        # You can use filter conditions to filter the bandwidth plans that you want to query. The following filter conditions are supported:
        # 
        # *   **CenId**: CEN instance ID
        # 
        # *   **Status**: bandwidth plan status. Valid values:
        # 
        #     *   **Idle**: not associated with a CEN instance.
        #     *   **InUse**: associated with a CEN instance.
        # 
        # *   **CenBandwidthPackageId**: bandwidth plan ID
        # 
        # *   **Name**: bandwidth plan name
        # 
        #     You can specify one or more filter conditions. The maximum value of **N** is **5**.
        self.key = key  # type: str
        # The values of condition.
        self.value = value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesRequestFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCenBandwidthPackagesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCenBandwidthPackagesRequest(TeaModel):
    def __init__(self, filter=None, include_reservation_data=None, is_or_key=None, owner_account=None,
                 owner_id=None, page_number=None, page_size=None, resource_group_id=None, resource_owner_account=None,
                 resource_owner_id=None, tag=None):
        # The filter conditions.
        self.filter = filter  # type: list[DescribeCenBandwidthPackagesRequestFilter]
        # Specifies whether to include renewal data. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.include_reservation_data = include_reservation_data  # type: bool
        # The logical operator between the filter conditions. Valid values:
        # 
        # *   **false** (default): **AND** Bandwidth plans that meet all filter conditions are returned.
        # *   **true**: **OR** Bandwidth plans that meet one of the filter conditions are returned.
        self.is_or_key = is_or_key  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Maximum value: **50**. Default value: **10**.
        self.page_size = page_size  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.tag = tag  # type: list[DescribeCenBandwidthPackagesRequestTag]

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        if self.include_reservation_data is not None:
            result['IncludeReservationData'] = self.include_reservation_data
        if self.is_or_key is not None:
            result['IsOrKey'] = self.is_or_key
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeCenBandwidthPackagesRequestFilter()
                self.filter.append(temp_model.from_map(k))
        if m.get('IncludeReservationData') is not None:
            self.include_reservation_data = m.get('IncludeReservationData')
        if m.get('IsOrKey') is not None:
            self.is_or_key = m.get('IsOrKey')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCenBandwidthPackagesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageCenIds(TeaModel):
    def __init__(self, cen_id=None):
        self.cen_id = cen_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageCenIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        return self


class DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageOrginInterRegionBandwidthLimitsOrginInterRegionBandwidthLimit(TeaModel):
    def __init__(self, bandwidth_limit=None, geographic_span_id=None, local_region_id=None,
                 opposite_region_id=None):
        # The maximum bandwidth value for the inter-region connection.
        self.bandwidth_limit = bandwidth_limit  # type: str
        # The connected regions.
        self.geographic_span_id = geographic_span_id  # type: str
        # The ID of the source region.
        self.local_region_id = local_region_id  # type: str
        # The ID of the peer region.
        self.opposite_region_id = opposite_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageOrginInterRegionBandwidthLimitsOrginInterRegionBandwidthLimit, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_limit is not None:
            result['BandwidthLimit'] = self.bandwidth_limit
        if self.geographic_span_id is not None:
            result['GeographicSpanId'] = self.geographic_span_id
        if self.local_region_id is not None:
            result['LocalRegionId'] = self.local_region_id
        if self.opposite_region_id is not None:
            result['OppositeRegionId'] = self.opposite_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BandwidthLimit') is not None:
            self.bandwidth_limit = m.get('BandwidthLimit')
        if m.get('GeographicSpanId') is not None:
            self.geographic_span_id = m.get('GeographicSpanId')
        if m.get('LocalRegionId') is not None:
            self.local_region_id = m.get('LocalRegionId')
        if m.get('OppositeRegionId') is not None:
            self.opposite_region_id = m.get('OppositeRegionId')
        return self


class DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageOrginInterRegionBandwidthLimits(TeaModel):
    def __init__(self, orgin_inter_region_bandwidth_limit=None):
        self.orgin_inter_region_bandwidth_limit = orgin_inter_region_bandwidth_limit  # type: list[DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageOrginInterRegionBandwidthLimitsOrginInterRegionBandwidthLimit]

    def validate(self):
        if self.orgin_inter_region_bandwidth_limit:
            for k in self.orgin_inter_region_bandwidth_limit:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageOrginInterRegionBandwidthLimits, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OrginInterRegionBandwidthLimit'] = []
        if self.orgin_inter_region_bandwidth_limit is not None:
            for k in self.orgin_inter_region_bandwidth_limit:
                result['OrginInterRegionBandwidthLimit'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.orgin_inter_region_bandwidth_limit = []
        if m.get('OrginInterRegionBandwidthLimit') is not None:
            for k in m.get('OrginInterRegionBandwidthLimit'):
                temp_model = DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageOrginInterRegionBandwidthLimitsOrginInterRegionBandwidthLimit()
                self.orgin_inter_region_bandwidth_limit.append(temp_model.from_map(k))
        return self


class DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageTagsTag(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackage(TeaModel):
    def __init__(self, bandwidth=None, bandwidth_package_charge_type=None, business_status=None,
                 cen_bandwidth_package_id=None, cen_ids=None, creation_time=None, description=None, expired_time=None,
                 geographic_region_aid=None, geographic_region_bid=None, geographic_span_id=None, has_reservation_data=None,
                 is_cross_border=None, name=None, orgin_inter_region_bandwidth_limits=None, reservation_active_time=None,
                 reservation_bandwidth=None, reservation_internet_charge_type=None, reservation_order_type=None, resource_group_id=None,
                 status=None, tags=None):
        # The maximum bandwidth of the bandwidth plan.
        self.bandwidth = bandwidth  # type: long
        # The billing method of the bandwidth plan.
        self.bandwidth_package_charge_type = bandwidth_package_charge_type  # type: str
        # The status of the bandwidth plan. Valid values:
        # 
        # *   **Normal**: normal
        # *   **FinancialLocked**: locked due to overdue payments
        # *   **SecurityLocked**: locked due to security reasons
        self.business_status = business_status  # type: str
        # The ID of the bandwidth plan.
        self.cen_bandwidth_package_id = cen_bandwidth_package_id  # type: str
        # A list of CEN instances that are associated with the bandwidth plan.
        self.cen_ids = cen_ids  # type: DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageCenIds
        # The time when the bandwidth plan was created. The time is displayed in the ISO8601 standard in the YYYY-MM-DDThh:mmZ format.
        self.creation_time = creation_time  # type: str
        # The description of the bandwidth plan.
        self.description = description  # type: str
        # The timeout period of the bandwidth plan.
        self.expired_time = expired_time  # type: str
        # The ID of the area that you want to query. Valid values:
        # 
        # *   **china**: Chinese mainland.
        # *   **asia-pacific**: Asia Pacific
        # *   **europe**: Europe
        # *   **australia**: Australia
        # *   **north-america**: North America
        self.geographic_region_aid = geographic_region_aid  # type: str
        # The ID of the other connected area of the bandwidth plan. Valid values:
        # 
        # *   **china**: Chinese mainland.
        # *   **asia-pacific**: Asia Pacific
        # *   **europe**: Europe
        # *   **australia**: Australia
        # *   **north-america**: North America
        self.geographic_region_bid = geographic_region_bid  # type: str
        # The ID of the connected area.
        self.geographic_span_id = geographic_span_id  # type: str
        # Indicates whether renewal data is included.
        # 
        # *   **true**: yes
        # *   **false**: no
        # 
        # >  This parameter returns **true** only when the **IncludeReservationData** parameter is set to **true** and an order has not taken effect.
        self.has_reservation_data = has_reservation_data  # type: str
        # Indicates whether the bandwidth plan is a cross-border bandwidth plan.
        # 
        # *   **false**: no
        # *   **true**: yes
        self.is_cross_border = is_cross_border  # type: bool
        # The name of the bandwidth plan.
        self.name = name  # type: str
        # The details about the connected regions.
        self.orgin_inter_region_bandwidth_limits = orgin_inter_region_bandwidth_limits  # type: DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageOrginInterRegionBandwidthLimits
        # The expiration time of the temporary upgrade.
        self.reservation_active_time = reservation_active_time  # type: str
        # The bandwidth value to which the bandwidth plan is rolled back when the temporary upgrade ends.
        self.reservation_bandwidth = reservation_bandwidth  # type: str
        # The new billing method.
        self.reservation_internet_charge_type = reservation_internet_charge_type  # type: str
        # The renewal method.
        # 
        # *   **TEMP_UPGRADE**: temporary upgrade
        # *   **UPGRADE**: upgrade
        self.reservation_order_type = reservation_order_type  # type: str
        self.resource_group_id = resource_group_id  # type: str
        # Indicates whether the bandwidth plan is associated with a CEN instance.
        # 
        # *   **Idle**: no
        # *   **InUse**: yes
        self.status = status  # type: str
        self.tags = tags  # type: DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageTags

    def validate(self):
        if self.cen_ids:
            self.cen_ids.validate()
        if self.orgin_inter_region_bandwidth_limits:
            self.orgin_inter_region_bandwidth_limits.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackage, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.bandwidth_package_charge_type is not None:
            result['BandwidthPackageChargeType'] = self.bandwidth_package_charge_type
        if self.business_status is not None:
            result['BusinessStatus'] = self.business_status
        if self.cen_bandwidth_package_id is not None:
            result['CenBandwidthPackageId'] = self.cen_bandwidth_package_id
        if self.cen_ids is not None:
            result['CenIds'] = self.cen_ids.to_map()
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.expired_time is not None:
            result['ExpiredTime'] = self.expired_time
        if self.geographic_region_aid is not None:
            result['GeographicRegionAId'] = self.geographic_region_aid
        if self.geographic_region_bid is not None:
            result['GeographicRegionBId'] = self.geographic_region_bid
        if self.geographic_span_id is not None:
            result['GeographicSpanId'] = self.geographic_span_id
        if self.has_reservation_data is not None:
            result['HasReservationData'] = self.has_reservation_data
        if self.is_cross_border is not None:
            result['IsCrossBorder'] = self.is_cross_border
        if self.name is not None:
            result['Name'] = self.name
        if self.orgin_inter_region_bandwidth_limits is not None:
            result['OrginInterRegionBandwidthLimits'] = self.orgin_inter_region_bandwidth_limits.to_map()
        if self.reservation_active_time is not None:
            result['ReservationActiveTime'] = self.reservation_active_time
        if self.reservation_bandwidth is not None:
            result['ReservationBandwidth'] = self.reservation_bandwidth
        if self.reservation_internet_charge_type is not None:
            result['ReservationInternetChargeType'] = self.reservation_internet_charge_type
        if self.reservation_order_type is not None:
            result['ReservationOrderType'] = self.reservation_order_type
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('BandwidthPackageChargeType') is not None:
            self.bandwidth_package_charge_type = m.get('BandwidthPackageChargeType')
        if m.get('BusinessStatus') is not None:
            self.business_status = m.get('BusinessStatus')
        if m.get('CenBandwidthPackageId') is not None:
            self.cen_bandwidth_package_id = m.get('CenBandwidthPackageId')
        if m.get('CenIds') is not None:
            temp_model = DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageCenIds()
            self.cen_ids = temp_model.from_map(m['CenIds'])
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExpiredTime') is not None:
            self.expired_time = m.get('ExpiredTime')
        if m.get('GeographicRegionAId') is not None:
            self.geographic_region_aid = m.get('GeographicRegionAId')
        if m.get('GeographicRegionBId') is not None:
            self.geographic_region_bid = m.get('GeographicRegionBId')
        if m.get('GeographicSpanId') is not None:
            self.geographic_span_id = m.get('GeographicSpanId')
        if m.get('HasReservationData') is not None:
            self.has_reservation_data = m.get('HasReservationData')
        if m.get('IsCrossBorder') is not None:
            self.is_cross_border = m.get('IsCrossBorder')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('OrginInterRegionBandwidthLimits') is not None:
            temp_model = DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageOrginInterRegionBandwidthLimits()
            self.orgin_inter_region_bandwidth_limits = temp_model.from_map(m['OrginInterRegionBandwidthLimits'])
        if m.get('ReservationActiveTime') is not None:
            self.reservation_active_time = m.get('ReservationActiveTime')
        if m.get('ReservationBandwidth') is not None:
            self.reservation_bandwidth = m.get('ReservationBandwidth')
        if m.get('ReservationInternetChargeType') is not None:
            self.reservation_internet_charge_type = m.get('ReservationInternetChargeType')
        if m.get('ReservationOrderType') is not None:
            self.reservation_order_type = m.get('ReservationOrderType')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackageTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackages(TeaModel):
    def __init__(self, cen_bandwidth_package=None):
        self.cen_bandwidth_package = cen_bandwidth_package  # type: list[DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackage]

    def validate(self):
        if self.cen_bandwidth_package:
            for k in self.cen_bandwidth_package:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackages, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CenBandwidthPackage'] = []
        if self.cen_bandwidth_package is not None:
            for k in self.cen_bandwidth_package:
                result['CenBandwidthPackage'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cen_bandwidth_package = []
        if m.get('CenBandwidthPackage') is not None:
            for k in m.get('CenBandwidthPackage'):
                temp_model = DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackagesCenBandwidthPackage()
                self.cen_bandwidth_package.append(temp_model.from_map(k))
        return self


class DescribeCenBandwidthPackagesResponseBody(TeaModel):
    def __init__(self, cen_bandwidth_packages=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        # The details about the bandwidth plan.
        self.cen_bandwidth_packages = cen_bandwidth_packages  # type: DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackages
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.cen_bandwidth_packages:
            self.cen_bandwidth_packages.validate()

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_bandwidth_packages is not None:
            result['CenBandwidthPackages'] = self.cen_bandwidth_packages.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenBandwidthPackages') is not None:
            temp_model = DescribeCenBandwidthPackagesResponseBodyCenBandwidthPackages()
            self.cen_bandwidth_packages = temp_model.from_map(m['CenBandwidthPackages'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCenBandwidthPackagesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenBandwidthPackagesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenBandwidthPackagesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenBandwidthPackagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenChildInstanceRouteEntriesRequest(TeaModel):
    def __init__(self, cen_id=None, child_instance_id=None, child_instance_region_id=None,
                 child_instance_route_table_id=None, child_instance_type=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, resource_owner_account=None, resource_owner_id=None, status=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the network instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        self.child_instance_route_table_id = child_instance_route_table_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**\
        # *   **VBR**\
        # *   **CCN**\
        self.child_instance_type = child_instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The status of the routes that you want to query. Valid values:
        # 
        # *   **Active**: active routes
        # *   **Candidate**: standby routes
        # *   **Rejected**: rejected routes
        # *   **Prohibited**: prohibited routes
        # *   **All** (default value): all routes
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_route_table_id is not None:
            result['ChildInstanceRouteTableId'] = self.child_instance_route_table_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceRouteTableId') is not None:
            self.child_instance_route_table_id = m.get('ChildInstanceRouteTableId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryAsPaths(TeaModel):
    def __init__(self, as_path=None):
        self.as_path = as_path  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryAsPaths, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_path is not None:
            result['AsPath'] = self.as_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsPath') is not None:
            self.as_path = m.get('AsPath')
        return self


class DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecordsCenRouteMapRecord(TeaModel):
    def __init__(self, region_id=None, route_map_id=None):
        # The ID of the region where the route map is applied.
        self.region_id = region_id  # type: str
        # The ID of the route map.
        self.route_map_id = route_map_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecordsCenRouteMapRecord, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_map_id is not None:
            result['RouteMapId'] = self.route_map_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteMapId') is not None:
            self.route_map_id = m.get('RouteMapId')
        return self


class DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecords(TeaModel):
    def __init__(self, cen_route_map_record=None):
        self.cen_route_map_record = cen_route_map_record  # type: list[DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecordsCenRouteMapRecord]

    def validate(self):
        if self.cen_route_map_record:
            for k in self.cen_route_map_record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CenRouteMapRecord'] = []
        if self.cen_route_map_record is not None:
            for k in self.cen_route_map_record:
                result['CenRouteMapRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cen_route_map_record = []
        if m.get('CenRouteMapRecord') is not None:
            for k in m.get('CenRouteMapRecord'):
                temp_model = DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecordsCenRouteMapRecord()
                self.cen_route_map_record.append(temp_model.from_map(k))
        return self


class DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCommunities(TeaModel):
    def __init__(self, community=None):
        self.community = community  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCommunities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.community is not None:
            result['Community'] = self.community
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Community') is not None:
            self.community = m.get('Community')
        return self


class DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryConflictsConflict(TeaModel):
    def __init__(self, destination_cidr_block=None, instance_id=None, instance_type=None, region_id=None,
                 status=None):
        # The destination CIDR block of the conflicting route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # The ID of the peer network instance on which conflicting routes are found.
        self.instance_id = instance_id  # type: str
        # The type of the peer network instance on which conflicting routes are found. 
        # 
        # - **VPC**\
        # - **VBR**\
        # - **CCN**\
        self.instance_type = instance_type  # type: str
        # The ID of the region where the peer network instance on which conflicting routes are found is deployed.
        self.region_id = region_id  # type: str
        # The cause of the route error. Valid values: 
        # 
        # - **conflict**: Two routes have the same destination CIDR block.
        # - **overflow**: The number of routes in the route table configured on another network instance reached the upper limit.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryConflictsConflict, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryConflicts(TeaModel):
    def __init__(self, conflict=None):
        self.conflict = conflict  # type: list[DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryConflictsConflict]

    def validate(self):
        if self.conflict:
            for k in self.conflict:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryConflicts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Conflict'] = []
        if self.conflict is not None:
            for k in self.conflict:
                result['Conflict'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.conflict = []
        if m.get('Conflict') is not None:
            for k in m.get('Conflict'):
                temp_model = DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryConflictsConflict()
                self.conflict.append(temp_model.from_map(k))
        return self


class DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntry(TeaModel):
    def __init__(self, as_paths=None, cen_route_map_records=None, communities=None, conflicts=None,
                 destination_cidr_block=None, next_hop_instance_id=None, next_hop_region_id=None, next_hop_type=None,
                 operational_mode=None, publish_status=None, route_table_id=None, status=None, type=None):
        # The AS paths of the routes.
        self.as_paths = as_paths  # type: DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryAsPaths
        # The route maps that the routes match.
        self.cen_route_map_records = cen_route_map_records  # type: DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecords
        # The community attributes of the routes.
        self.communities = communities  # type: DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCommunities
        # The array of conflicting routes.
        self.conflicts = conflicts  # type: DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryConflicts
        # The destination CIDR block of the route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # The ID of the instance specified as the next hop in the route.
        self.next_hop_instance_id = next_hop_instance_id  # type: str
        # The ID of the region where the instance specified as the next hop in the route belongs.
        self.next_hop_region_id = next_hop_region_id  # type: str
        # The type of the instance specified as the next hop in the route. 
        # 
        # - **Instance**: ECS instance
        # - **HaVip**: HAVIP
        # - **RouterInterface**: router interface
        # - **NetworkInterface**: ENI
        # - **VpnGateway**: VPN gateway
        # - **IPv6Gateway**: IPv6 gateway
        # - **NatGateway**: NAT gateway
        # - **Attachment**: network instance connection
        # - **service**: cloud service
        # - **VBR**: virtual border router
        # - **CCN**: CCN instance
        # - **VPC**: virtual private cloud
        # - **local**: system route. No next hop is specified.
        # - **TR**: transit router
        # - **BlackHole**: blackhole route. No next hop is specified.
        # - **EcRouterInterface**: router interface for Express Connect
        # - **HealthCheck**: health check
        # - **AS**: access gateway for CCN
        # - **classic**: classic network-type instance
        # - **GatewayEndpoint**: gateway endpoint
        # - **CPE**: data center connected by VBRs
        self.next_hop_type = next_hop_type  # type: str
        # Indicates whether the route is allowed to be advertised to or withdrawn from the CEN instance. Valid values:  
        # 
        # - **true**: The route is allowed to be advertised to or withdrawn from the CEN instance.
        # - **false**: The route is not allowed to be advertised to or withdrawn from the CEN instance.
        self.operational_mode = operational_mode  # type: bool
        # Indicates whether the route is advertised to the CEN instance. Valid values: 
        # 
        # - **Published**: The route is advertised to the CEN instance.
        # - **NonPublished**: The route is not advertised to the CEN instance.
        self.publish_status = publish_status  # type: str
        # The ID of the route table.
        self.route_table_id = route_table_id  # type: str
        # The status of the route. Valid values: 
        # 
        # - **Active**: The route is active.
        # - **Candidate**: The route is a standby route.
        # - **Rejected**: The route is rejected.
        # - **Prohibited**: The route is prohibited.
        self.status = status  # type: str
        # The type of the route. Valid values: 
        # 
        # - **CEN**: route that is advertised through CEN
        # - **System**: system route
        # - **Custom**: custom route
        self.type = type  # type: str

    def validate(self):
        if self.as_paths:
            self.as_paths.validate()
        if self.cen_route_map_records:
            self.cen_route_map_records.validate()
        if self.communities:
            self.communities.validate()
        if self.conflicts:
            self.conflicts.validate()

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_paths is not None:
            result['AsPaths'] = self.as_paths.to_map()
        if self.cen_route_map_records is not None:
            result['CenRouteMapRecords'] = self.cen_route_map_records.to_map()
        if self.communities is not None:
            result['Communities'] = self.communities.to_map()
        if self.conflicts is not None:
            result['Conflicts'] = self.conflicts.to_map()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_instance_id is not None:
            result['NextHopInstanceId'] = self.next_hop_instance_id
        if self.next_hop_region_id is not None:
            result['NextHopRegionId'] = self.next_hop_region_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.operational_mode is not None:
            result['OperationalMode'] = self.operational_mode
        if self.publish_status is not None:
            result['PublishStatus'] = self.publish_status
        if self.route_table_id is not None:
            result['RouteTableId'] = self.route_table_id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsPaths') is not None:
            temp_model = DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryAsPaths()
            self.as_paths = temp_model.from_map(m['AsPaths'])
        if m.get('CenRouteMapRecords') is not None:
            temp_model = DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecords()
            self.cen_route_map_records = temp_model.from_map(m['CenRouteMapRecords'])
        if m.get('Communities') is not None:
            temp_model = DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCommunities()
            self.communities = temp_model.from_map(m['Communities'])
        if m.get('Conflicts') is not None:
            temp_model = DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryConflicts()
            self.conflicts = temp_model.from_map(m['Conflicts'])
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopInstanceId') is not None:
            self.next_hop_instance_id = m.get('NextHopInstanceId')
        if m.get('NextHopRegionId') is not None:
            self.next_hop_region_id = m.get('NextHopRegionId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('OperationalMode') is not None:
            self.operational_mode = m.get('OperationalMode')
        if m.get('PublishStatus') is not None:
            self.publish_status = m.get('PublishStatus')
        if m.get('RouteTableId') is not None:
            self.route_table_id = m.get('RouteTableId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntries(TeaModel):
    def __init__(self, cen_route_entry=None):
        self.cen_route_entry = cen_route_entry  # type: list[DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntry]

    def validate(self):
        if self.cen_route_entry:
            for k in self.cen_route_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CenRouteEntry'] = []
        if self.cen_route_entry is not None:
            for k in self.cen_route_entry:
                result['CenRouteEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cen_route_entry = []
        if m.get('CenRouteEntry') is not None:
            for k in m.get('CenRouteEntry'):
                temp_model = DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntriesCenRouteEntry()
                self.cen_route_entry.append(temp_model.from_map(k))
        return self


class DescribeCenChildInstanceRouteEntriesResponseBody(TeaModel):
    def __init__(self, cen_route_entries=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The array of routes.
        self.cen_route_entries = cen_route_entries  # type: DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntries
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.cen_route_entries:
            self.cen_route_entries.validate()

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_route_entries is not None:
            result['CenRouteEntries'] = self.cen_route_entries.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenRouteEntries') is not None:
            temp_model = DescribeCenChildInstanceRouteEntriesResponseBodyCenRouteEntries()
            self.cen_route_entries = temp_model.from_map(m['CenRouteEntries'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCenChildInstanceRouteEntriesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenChildInstanceRouteEntriesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenChildInstanceRouteEntriesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenChildInstanceRouteEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenGeographicSpanRemainingBandwidthRequest(TeaModel):
    def __init__(self, cen_id=None, geographic_region_aid=None, geographic_region_bid=None, owner_account=None,
                 owner_id=None, page_number=None, page_size=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance to which the bandwidth plan is associated.
        self.cen_id = cen_id  # type: str
        # The ID of one of the areas connected by the bandwidth plan. Valid values:
        # 
        # *   **China**: Chinese mainland
        # *   **North-America**: North America
        # *   **Asia-Pacific**: Asia Pacific
        # *   **Europe**: Europe
        # *   **Australia**: Australia
        self.geographic_region_aid = geographic_region_aid  # type: str
        # The ID of the other area connected by the bandwidth plan. Valid values:
        # 
        # *   **China**: Chinese mainland
        # *   **North-America**: North America
        # *   **Asia-Pacific**: Asia Pacific
        # *   **Europe**: Europe
        # *   **Australia**: Australia
        self.geographic_region_bid = geographic_region_bid  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenGeographicSpanRemainingBandwidthRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.geographic_region_aid is not None:
            result['GeographicRegionAId'] = self.geographic_region_aid
        if self.geographic_region_bid is not None:
            result['GeographicRegionBId'] = self.geographic_region_bid
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('GeographicRegionAId') is not None:
            self.geographic_region_aid = m.get('GeographicRegionAId')
        if m.get('GeographicRegionBId') is not None:
            self.geographic_region_bid = m.get('GeographicRegionBId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCenGeographicSpanRemainingBandwidthResponseBody(TeaModel):
    def __init__(self, remaining_bandwidth=None, request_id=None):
        # The remaining bandwidth of the bandwidth plan. Unit: Mbit/s.
        self.remaining_bandwidth = remaining_bandwidth  # type: long
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenGeographicSpanRemainingBandwidthResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remaining_bandwidth is not None:
            result['RemainingBandwidth'] = self.remaining_bandwidth
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RemainingBandwidth') is not None:
            self.remaining_bandwidth = m.get('RemainingBandwidth')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCenGeographicSpanRemainingBandwidthResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenGeographicSpanRemainingBandwidthResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenGeographicSpanRemainingBandwidthResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenGeographicSpanRemainingBandwidthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenGeographicSpansRequest(TeaModel):
    def __init__(self, geographic_span_id=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the areas that are connected by the CEN instance.
        # 
        # > If you do not set this parameter, the system queries the information about all areas supported by CEN.
        self.geographic_span_id = geographic_span_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenGeographicSpansRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.geographic_span_id is not None:
            result['GeographicSpanId'] = self.geographic_span_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GeographicSpanId') is not None:
            self.geographic_span_id = m.get('GeographicSpanId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCenGeographicSpansResponseBodyGeographicSpanModelsGeographicSpanModel(TeaModel):
    def __init__(self, geographic_span_id=None, local_geo_region_id=None, opposite_geo_region_id=None):
        # The ID of the pair of connected areas.
        self.geographic_span_id = geographic_span_id  # type: str
        # The ID of the local area.
        self.local_geo_region_id = local_geo_region_id  # type: str
        # The ID of the peer area.
        self.opposite_geo_region_id = opposite_geo_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenGeographicSpansResponseBodyGeographicSpanModelsGeographicSpanModel, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.geographic_span_id is not None:
            result['GeographicSpanId'] = self.geographic_span_id
        if self.local_geo_region_id is not None:
            result['LocalGeoRegionId'] = self.local_geo_region_id
        if self.opposite_geo_region_id is not None:
            result['OppositeGeoRegionId'] = self.opposite_geo_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GeographicSpanId') is not None:
            self.geographic_span_id = m.get('GeographicSpanId')
        if m.get('LocalGeoRegionId') is not None:
            self.local_geo_region_id = m.get('LocalGeoRegionId')
        if m.get('OppositeGeoRegionId') is not None:
            self.opposite_geo_region_id = m.get('OppositeGeoRegionId')
        return self


class DescribeCenGeographicSpansResponseBodyGeographicSpanModels(TeaModel):
    def __init__(self, geographic_span_model=None):
        self.geographic_span_model = geographic_span_model  # type: list[DescribeCenGeographicSpansResponseBodyGeographicSpanModelsGeographicSpanModel]

    def validate(self):
        if self.geographic_span_model:
            for k in self.geographic_span_model:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenGeographicSpansResponseBodyGeographicSpanModels, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GeographicSpanModel'] = []
        if self.geographic_span_model is not None:
            for k in self.geographic_span_model:
                result['GeographicSpanModel'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.geographic_span_model = []
        if m.get('GeographicSpanModel') is not None:
            for k in m.get('GeographicSpanModel'):
                temp_model = DescribeCenGeographicSpansResponseBodyGeographicSpanModelsGeographicSpanModel()
                self.geographic_span_model.append(temp_model.from_map(k))
        return self


class DescribeCenGeographicSpansResponseBody(TeaModel):
    def __init__(self, geographic_span_models=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        # A list of areas.
        self.geographic_span_models = geographic_span_models  # type: DescribeCenGeographicSpansResponseBodyGeographicSpanModels
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.geographic_span_models:
            self.geographic_span_models.validate()

    def to_map(self):
        _map = super(DescribeCenGeographicSpansResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.geographic_span_models is not None:
            result['GeographicSpanModels'] = self.geographic_span_models.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GeographicSpanModels') is not None:
            temp_model = DescribeCenGeographicSpansResponseBodyGeographicSpanModels()
            self.geographic_span_models = temp_model.from_map(m['GeographicSpanModels'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCenGeographicSpansResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenGeographicSpansResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenGeographicSpansResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenGeographicSpansResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenInterRegionBandwidthLimitsRequest(TeaModel):
    def __init__(self, cen_id=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return per page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenInterRegionBandwidthLimitsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCenInterRegionBandwidthLimitsResponseBodyCenInterRegionBandwidthLimitsCenInterRegionBandwidthLimit(TeaModel):
    def __init__(self, bandwidth_limit=None, bandwidth_package_id=None, cen_id=None, geographic_span_id=None,
                 local_region_id=None, opposite_region_id=None, status=None):
        # The bandwidth limit of the cross-region connection. Unit: Mbit/s.
        self.bandwidth_limit = bandwidth_limit  # type: long
        # The ID of the bandwidth plan.
        self.bandwidth_package_id = bandwidth_package_id  # type: str
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The connected areas.
        self.geographic_span_id = geographic_span_id  # type: str
        # The ID of the local region.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.local_region_id = local_region_id  # type: str
        # The ID of the peer region.
        self.opposite_region_id = opposite_region_id  # type: str
        # The status of the bandwidth of the cross-region connection. Valid values:
        # 
        # *   **Active**: The bandwidth limit of the cross-region connection is effective.
        # *   **Modifying**: The bandwidth limit of the cross-region connection is being changed.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenInterRegionBandwidthLimitsResponseBodyCenInterRegionBandwidthLimitsCenInterRegionBandwidthLimit, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bandwidth_limit is not None:
            result['BandwidthLimit'] = self.bandwidth_limit
        if self.bandwidth_package_id is not None:
            result['BandwidthPackageId'] = self.bandwidth_package_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.geographic_span_id is not None:
            result['GeographicSpanId'] = self.geographic_span_id
        if self.local_region_id is not None:
            result['LocalRegionId'] = self.local_region_id
        if self.opposite_region_id is not None:
            result['OppositeRegionId'] = self.opposite_region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BandwidthLimit') is not None:
            self.bandwidth_limit = m.get('BandwidthLimit')
        if m.get('BandwidthPackageId') is not None:
            self.bandwidth_package_id = m.get('BandwidthPackageId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('GeographicSpanId') is not None:
            self.geographic_span_id = m.get('GeographicSpanId')
        if m.get('LocalRegionId') is not None:
            self.local_region_id = m.get('LocalRegionId')
        if m.get('OppositeRegionId') is not None:
            self.opposite_region_id = m.get('OppositeRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCenInterRegionBandwidthLimitsResponseBodyCenInterRegionBandwidthLimits(TeaModel):
    def __init__(self, cen_inter_region_bandwidth_limit=None):
        self.cen_inter_region_bandwidth_limit = cen_inter_region_bandwidth_limit  # type: list[DescribeCenInterRegionBandwidthLimitsResponseBodyCenInterRegionBandwidthLimitsCenInterRegionBandwidthLimit]

    def validate(self):
        if self.cen_inter_region_bandwidth_limit:
            for k in self.cen_inter_region_bandwidth_limit:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenInterRegionBandwidthLimitsResponseBodyCenInterRegionBandwidthLimits, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CenInterRegionBandwidthLimit'] = []
        if self.cen_inter_region_bandwidth_limit is not None:
            for k in self.cen_inter_region_bandwidth_limit:
                result['CenInterRegionBandwidthLimit'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cen_inter_region_bandwidth_limit = []
        if m.get('CenInterRegionBandwidthLimit') is not None:
            for k in m.get('CenInterRegionBandwidthLimit'):
                temp_model = DescribeCenInterRegionBandwidthLimitsResponseBodyCenInterRegionBandwidthLimitsCenInterRegionBandwidthLimit()
                self.cen_inter_region_bandwidth_limit.append(temp_model.from_map(k))
        return self


class DescribeCenInterRegionBandwidthLimitsResponseBody(TeaModel):
    def __init__(self, cen_inter_region_bandwidth_limits=None, page_number=None, page_size=None, request_id=None,
                 total_count=None):
        # The list of cross-region connections.
        self.cen_inter_region_bandwidth_limits = cen_inter_region_bandwidth_limits  # type: DescribeCenInterRegionBandwidthLimitsResponseBodyCenInterRegionBandwidthLimits
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.cen_inter_region_bandwidth_limits:
            self.cen_inter_region_bandwidth_limits.validate()

    def to_map(self):
        _map = super(DescribeCenInterRegionBandwidthLimitsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_inter_region_bandwidth_limits is not None:
            result['CenInterRegionBandwidthLimits'] = self.cen_inter_region_bandwidth_limits.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenInterRegionBandwidthLimits') is not None:
            temp_model = DescribeCenInterRegionBandwidthLimitsResponseBodyCenInterRegionBandwidthLimits()
            self.cen_inter_region_bandwidth_limits = temp_model.from_map(m['CenInterRegionBandwidthLimits'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCenInterRegionBandwidthLimitsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenInterRegionBandwidthLimitsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenInterRegionBandwidthLimitsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenInterRegionBandwidthLimitsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenPrivateZoneRoutesRequest(TeaModel):
    def __init__(self, access_region_id=None, cen_id=None, host_region_id=None, page_number=None, page_size=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the region where PrivateZone is accessed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.access_region_id = access_region_id  # type: str
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The ID of the region where PrivateZone is deployed.
        self.host_region_id = host_region_id  # type: str
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenPrivateZoneRoutesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_region_id is not None:
            result['AccessRegionId'] = self.access_region_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.host_region_id is not None:
            result['HostRegionId'] = self.host_region_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessRegionId') is not None:
            self.access_region_id = m.get('AccessRegionId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('HostRegionId') is not None:
            self.host_region_id = m.get('HostRegionId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeCenPrivateZoneRoutesResponseBodyPrivateZoneInfosPrivateZoneInfo(TeaModel):
    def __init__(self, access_region_id=None, host_region_id=None, host_vpc_id=None, status=None):
        # The ID of the region where PrivateZone is accessed.
        self.access_region_id = access_region_id  # type: str
        # The ID of the region where PrivateZone is deployed.
        self.host_region_id = host_region_id  # type: str
        # The ID of the virtual private cloud (VPC) that is associated with PrivateZone.
        self.host_vpc_id = host_vpc_id  # type: str
        # The status of PrivateZone. Valid values:
        # 
        # *   **Creating**: being created
        # *   **Active**: available
        # *   **Deleting**: being deleted
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenPrivateZoneRoutesResponseBodyPrivateZoneInfosPrivateZoneInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_region_id is not None:
            result['AccessRegionId'] = self.access_region_id
        if self.host_region_id is not None:
            result['HostRegionId'] = self.host_region_id
        if self.host_vpc_id is not None:
            result['HostVpcId'] = self.host_vpc_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessRegionId') is not None:
            self.access_region_id = m.get('AccessRegionId')
        if m.get('HostRegionId') is not None:
            self.host_region_id = m.get('HostRegionId')
        if m.get('HostVpcId') is not None:
            self.host_vpc_id = m.get('HostVpcId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCenPrivateZoneRoutesResponseBodyPrivateZoneInfos(TeaModel):
    def __init__(self, private_zone_info=None):
        self.private_zone_info = private_zone_info  # type: list[DescribeCenPrivateZoneRoutesResponseBodyPrivateZoneInfosPrivateZoneInfo]

    def validate(self):
        if self.private_zone_info:
            for k in self.private_zone_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenPrivateZoneRoutesResponseBodyPrivateZoneInfos, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PrivateZoneInfo'] = []
        if self.private_zone_info is not None:
            for k in self.private_zone_info:
                result['PrivateZoneInfo'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.private_zone_info = []
        if m.get('PrivateZoneInfo') is not None:
            for k in m.get('PrivateZoneInfo'):
                temp_model = DescribeCenPrivateZoneRoutesResponseBodyPrivateZoneInfosPrivateZoneInfo()
                self.private_zone_info.append(temp_model.from_map(k))
        return self


class DescribeCenPrivateZoneRoutesResponseBody(TeaModel):
    def __init__(self, cen_id=None, page_number=None, page_size=None, private_zone_dns_servers=None,
                 private_zone_infos=None, request_id=None, total_count=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The IP address of the DNS server used by PrivateZone.
        self.private_zone_dns_servers = private_zone_dns_servers  # type: str
        # The configuration details of PrivateZone.
        self.private_zone_infos = private_zone_infos  # type: DescribeCenPrivateZoneRoutesResponseBodyPrivateZoneInfos
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.private_zone_infos:
            self.private_zone_infos.validate()

    def to_map(self):
        _map = super(DescribeCenPrivateZoneRoutesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.private_zone_dns_servers is not None:
            result['PrivateZoneDnsServers'] = self.private_zone_dns_servers
        if self.private_zone_infos is not None:
            result['PrivateZoneInfos'] = self.private_zone_infos.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PrivateZoneDnsServers') is not None:
            self.private_zone_dns_servers = m.get('PrivateZoneDnsServers')
        if m.get('PrivateZoneInfos') is not None:
            temp_model = DescribeCenPrivateZoneRoutesResponseBodyPrivateZoneInfos()
            self.private_zone_infos = temp_model.from_map(m['PrivateZoneInfos'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCenPrivateZoneRoutesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenPrivateZoneRoutesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenPrivateZoneRoutesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenPrivateZoneRoutesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenRegionDomainRouteEntriesRequest(TeaModel):
    def __init__(self, cen_id=None, cen_region_id=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, resource_owner_account=None, resource_owner_id=None, status=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the region that you want to query.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.cen_region_id = cen_region_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The status of the routes that you want to query. Valid values:
        # 
        # *   **Active** (default value): active routes
        # *   **Candidate**: standby routes
        # *   **Rejected**: rejected routes
        # *   **Prohibited**: prohibited routes
        # *   **All**: all routes
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_region_id is not None:
            result['CenRegionId'] = self.cen_region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenRegionId') is not None:
            self.cen_region_id = m.get('CenRegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryAsPaths(TeaModel):
    def __init__(self, as_path=None):
        self.as_path = as_path  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryAsPaths, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_path is not None:
            result['AsPath'] = self.as_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsPath') is not None:
            self.as_path = m.get('AsPath')
        return self


class DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenOutRouteMapRecordsCenOutRouteMapRecord(TeaModel):
    def __init__(self, region_id=None, route_map_id=None):
        # The ID of the region where the route map is applied.
        self.region_id = region_id  # type: str
        # The ID of the route map.
        self.route_map_id = route_map_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenOutRouteMapRecordsCenOutRouteMapRecord, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_map_id is not None:
            result['RouteMapId'] = self.route_map_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteMapId') is not None:
            self.route_map_id = m.get('RouteMapId')
        return self


class DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenOutRouteMapRecords(TeaModel):
    def __init__(self, cen_out_route_map_record=None):
        self.cen_out_route_map_record = cen_out_route_map_record  # type: list[DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenOutRouteMapRecordsCenOutRouteMapRecord]

    def validate(self):
        if self.cen_out_route_map_record:
            for k in self.cen_out_route_map_record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenOutRouteMapRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CenOutRouteMapRecord'] = []
        if self.cen_out_route_map_record is not None:
            for k in self.cen_out_route_map_record:
                result['CenOutRouteMapRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cen_out_route_map_record = []
        if m.get('CenOutRouteMapRecord') is not None:
            for k in m.get('CenOutRouteMapRecord'):
                temp_model = DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenOutRouteMapRecordsCenOutRouteMapRecord()
                self.cen_out_route_map_record.append(temp_model.from_map(k))
        return self


class DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecordsCenRouteMapRecord(TeaModel):
    def __init__(self, region_id=None, route_map_id=None):
        # The ID of the region where the route map is applied.
        self.region_id = region_id  # type: str
        # The ID of the route map.
        self.route_map_id = route_map_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecordsCenRouteMapRecord, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.route_map_id is not None:
            result['RouteMapId'] = self.route_map_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RouteMapId') is not None:
            self.route_map_id = m.get('RouteMapId')
        return self


class DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecords(TeaModel):
    def __init__(self, cen_route_map_record=None):
        self.cen_route_map_record = cen_route_map_record  # type: list[DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecordsCenRouteMapRecord]

    def validate(self):
        if self.cen_route_map_record:
            for k in self.cen_route_map_record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecords, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CenRouteMapRecord'] = []
        if self.cen_route_map_record is not None:
            for k in self.cen_route_map_record:
                result['CenRouteMapRecord'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cen_route_map_record = []
        if m.get('CenRouteMapRecord') is not None:
            for k in m.get('CenRouteMapRecord'):
                temp_model = DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecordsCenRouteMapRecord()
                self.cen_route_map_record.append(temp_model.from_map(k))
        return self


class DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCommunities(TeaModel):
    def __init__(self, community=None):
        self.community = community  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCommunities, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.community is not None:
            result['Community'] = self.community
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Community') is not None:
            self.community = m.get('Community')
        return self


class DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntry(TeaModel):
    def __init__(self, as_paths=None, cen_out_route_map_records=None, cen_route_map_records=None, communities=None,
                 destination_cidr_block=None, next_hop_instance_id=None, next_hop_region_id=None, next_hop_type=None, preference=None,
                 status=None, to_other_region_status=None, type=None):
        # The AS paths of the routes.
        self.as_paths = as_paths  # type: DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryAsPaths
        # The route maps that the routes match in the outbound direction.
        self.cen_out_route_map_records = cen_out_route_map_records  # type: DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenOutRouteMapRecords
        # The route maps that the routes match in the inbound direction.
        self.cen_route_map_records = cen_route_map_records  # type: DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecords
        # The community attributes of the routes.
        self.communities = communities  # type: DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCommunities
        # The destination CIDR block of the route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # The ID of the instance specified as the next hop in the route.
        self.next_hop_instance_id = next_hop_instance_id  # type: str
        # The ID of the region where the network instance specified as the next hop in the route belongs.
        self.next_hop_region_id = next_hop_region_id  # type: str
        # The type of the network instance specified as the next hop in the route. 
        # 
        # - **VPC**\
        # - **VBR**\
        # - **CCN**\
        # - **local_service**: system route. No next hop is specified.
        self.next_hop_type = next_hop_type  # type: str
        # The priority of the route. 
        # 
        # > A smaller value indicates a higher priority.
        self.preference = preference  # type: int
        # The status of the route. Valid values: 
        # 
        # - **Active**: The route is active.
        # - **Candidate**: The route is a standby route.
        # - **Rejected**: The route is rejected.
        # - **Prohibited**: The route is prohibited.
        self.status = status  # type: str
        # Whether the route can be advertised to other regions. Valid values: 
        # 
        # - **Active**: The route can be advertised to other regions.
        # - **Prohibited**: The route cannot be advertised to other regions.
        self.to_other_region_status = to_other_region_status  # type: str
        # The type of the route. Valid values: 
        # 
        # - **CEN**: route that is advertised through CEN
        # - **Custom**: custom route
        # - **System**: system route
        self.type = type  # type: str

    def validate(self):
        if self.as_paths:
            self.as_paths.validate()
        if self.cen_out_route_map_records:
            self.cen_out_route_map_records.validate()
        if self.cen_route_map_records:
            self.cen_route_map_records.validate()
        if self.communities:
            self.communities.validate()

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_paths is not None:
            result['AsPaths'] = self.as_paths.to_map()
        if self.cen_out_route_map_records is not None:
            result['CenOutRouteMapRecords'] = self.cen_out_route_map_records.to_map()
        if self.cen_route_map_records is not None:
            result['CenRouteMapRecords'] = self.cen_route_map_records.to_map()
        if self.communities is not None:
            result['Communities'] = self.communities.to_map()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_instance_id is not None:
            result['NextHopInstanceId'] = self.next_hop_instance_id
        if self.next_hop_region_id is not None:
            result['NextHopRegionId'] = self.next_hop_region_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.preference is not None:
            result['Preference'] = self.preference
        if self.status is not None:
            result['Status'] = self.status
        if self.to_other_region_status is not None:
            result['ToOtherRegionStatus'] = self.to_other_region_status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsPaths') is not None:
            temp_model = DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryAsPaths()
            self.as_paths = temp_model.from_map(m['AsPaths'])
        if m.get('CenOutRouteMapRecords') is not None:
            temp_model = DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenOutRouteMapRecords()
            self.cen_out_route_map_records = temp_model.from_map(m['CenOutRouteMapRecords'])
        if m.get('CenRouteMapRecords') is not None:
            temp_model = DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCenRouteMapRecords()
            self.cen_route_map_records = temp_model.from_map(m['CenRouteMapRecords'])
        if m.get('Communities') is not None:
            temp_model = DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntryCommunities()
            self.communities = temp_model.from_map(m['Communities'])
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopInstanceId') is not None:
            self.next_hop_instance_id = m.get('NextHopInstanceId')
        if m.get('NextHopRegionId') is not None:
            self.next_hop_region_id = m.get('NextHopRegionId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('Preference') is not None:
            self.preference = m.get('Preference')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('ToOtherRegionStatus') is not None:
            self.to_other_region_status = m.get('ToOtherRegionStatus')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntries(TeaModel):
    def __init__(self, cen_route_entry=None):
        self.cen_route_entry = cen_route_entry  # type: list[DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntry]

    def validate(self):
        if self.cen_route_entry:
            for k in self.cen_route_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CenRouteEntry'] = []
        if self.cen_route_entry is not None:
            for k in self.cen_route_entry:
                result['CenRouteEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cen_route_entry = []
        if m.get('CenRouteEntry') is not None:
            for k in m.get('CenRouteEntry'):
                temp_model = DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntriesCenRouteEntry()
                self.cen_route_entry.append(temp_model.from_map(k))
        return self


class DescribeCenRegionDomainRouteEntriesResponseBody(TeaModel):
    def __init__(self, cen_route_entries=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The array of routes.
        self.cen_route_entries = cen_route_entries  # type: DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntries
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.cen_route_entries:
            self.cen_route_entries.validate()

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_route_entries is not None:
            result['CenRouteEntries'] = self.cen_route_entries.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenRouteEntries') is not None:
            temp_model = DescribeCenRegionDomainRouteEntriesResponseBodyCenRouteEntries()
            self.cen_route_entries = temp_model.from_map(m['CenRouteEntries'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCenRegionDomainRouteEntriesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenRegionDomainRouteEntriesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenRegionDomainRouteEntriesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenRegionDomainRouteEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenRouteMapsRequest(TeaModel):
    def __init__(self, cen_id=None, cen_region_id=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, resource_owner_account=None, resource_owner_id=None, route_map_id=None,
                 transit_router_route_table_id=None, transmit_direction=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the region where the routing policy is applied.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.cen_region_id = cen_region_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the routing policy.
        self.route_map_id = route_map_id  # type: str
        # The route table ID of the transit router with which the routing policy is associated.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str
        # The direction in which the routing policy is applied. Valid values:
        # 
        # *   **RegionIn**: Routes are advertised to the gateways in the regions that are connected by the CEN instance.
        # 
        #     For example, routes are advertised from network instances deployed in the current region or other regions to the gateway deployed in the current region.
        # 
        # *   **RegionOut**: Routes are advertised from the gateways in the regions that are connected by the CEN instance.
        # 
        #     For example, routes are advertised from the gateway deployed in the current region to network instances deployed in the current region, or to gateways deployed in other regions.
        self.transmit_direction = transmit_direction  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_region_id is not None:
            result['CenRegionId'] = self.cen_region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.route_map_id is not None:
            result['RouteMapId'] = self.route_map_id
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        if self.transmit_direction is not None:
            result['TransmitDirection'] = self.transmit_direction
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenRegionId') is not None:
            self.cen_region_id = m.get('CenRegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RouteMapId') is not None:
            self.route_map_id = m.get('RouteMapId')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        if m.get('TransmitDirection') is not None:
            self.transmit_direction = m.get('TransmitDirection')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationChildInstanceTypes(TeaModel):
    def __init__(self, destination_child_instance_type=None):
        self.destination_child_instance_type = destination_child_instance_type  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationChildInstanceTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_child_instance_type is not None:
            result['DestinationChildInstanceType'] = self.destination_child_instance_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationChildInstanceType') is not None:
            self.destination_child_instance_type = m.get('DestinationChildInstanceType')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationCidrBlocks(TeaModel):
    def __init__(self, destination_cidr_block=None):
        self.destination_cidr_block = destination_cidr_block  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationCidrBlocks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationInstanceIds(TeaModel):
    def __init__(self, destination_instance_id=None):
        self.destination_instance_id = destination_instance_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationInstanceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_instance_id is not None:
            result['DestinationInstanceId'] = self.destination_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationInstanceId') is not None:
            self.destination_instance_id = m.get('DestinationInstanceId')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationRouteTableIds(TeaModel):
    def __init__(self, destination_route_table_id=None):
        self.destination_route_table_id = destination_route_table_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationRouteTableIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_route_table_id is not None:
            result['DestinationRouteTableId'] = self.destination_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationRouteTableId') is not None:
            self.destination_route_table_id = m.get('DestinationRouteTableId')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapMatchAsns(TeaModel):
    def __init__(self, match_asn=None):
        self.match_asn = match_asn  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapMatchAsns, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_asn is not None:
            result['MatchAsn'] = self.match_asn
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MatchAsn') is not None:
            self.match_asn = m.get('MatchAsn')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapMatchCommunitySet(TeaModel):
    def __init__(self, match_community=None):
        self.match_community = match_community  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapMatchCommunitySet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.match_community is not None:
            result['MatchCommunity'] = self.match_community
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MatchCommunity') is not None:
            self.match_community = m.get('MatchCommunity')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapOperateCommunitySet(TeaModel):
    def __init__(self, operate_community=None):
        self.operate_community = operate_community  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapOperateCommunitySet, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operate_community is not None:
            result['OperateCommunity'] = self.operate_community
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OperateCommunity') is not None:
            self.operate_community = m.get('OperateCommunity')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapPrependAsPath(TeaModel):
    def __init__(self, as_path=None):
        self.as_path = as_path  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapPrependAsPath, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_path is not None:
            result['AsPath'] = self.as_path
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsPath') is not None:
            self.as_path = m.get('AsPath')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapRouteTypes(TeaModel):
    def __init__(self, route_type=None):
        self.route_type = route_type  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapRouteTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.route_type is not None:
            result['RouteType'] = self.route_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RouteType') is not None:
            self.route_type = m.get('RouteType')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceChildInstanceTypes(TeaModel):
    def __init__(self, source_child_instance_type=None):
        self.source_child_instance_type = source_child_instance_type  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceChildInstanceTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_child_instance_type is not None:
            result['SourceChildInstanceType'] = self.source_child_instance_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceChildInstanceType') is not None:
            self.source_child_instance_type = m.get('SourceChildInstanceType')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceInstanceIds(TeaModel):
    def __init__(self, source_instance_id=None):
        self.source_instance_id = source_instance_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceInstanceIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_instance_id is not None:
            result['SourceInstanceId'] = self.source_instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceInstanceId') is not None:
            self.source_instance_id = m.get('SourceInstanceId')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceRegionIds(TeaModel):
    def __init__(self, source_region_id=None):
        self.source_region_id = source_region_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceRegionIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_region_id is not None:
            result['SourceRegionId'] = self.source_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceRegionId') is not None:
            self.source_region_id = m.get('SourceRegionId')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceRouteTableIds(TeaModel):
    def __init__(self, source_route_table_id=None):
        self.source_route_table_id = source_route_table_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceRouteTableIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_route_table_id is not None:
            result['SourceRouteTableId'] = self.source_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SourceRouteTableId') is not None:
            self.source_route_table_id = m.get('SourceRouteTableId')
        return self


class DescribeCenRouteMapsResponseBodyRouteMapsRouteMap(TeaModel):
    def __init__(self, as_path_match_mode=None, cen_id=None, cen_region_id=None, cidr_match_mode=None,
                 community_match_mode=None, community_operate_mode=None, description=None, destination_child_instance_types=None,
                 destination_cidr_blocks=None, destination_instance_ids=None, destination_instance_ids_reverse_match=None,
                 destination_route_table_ids=None, map_result=None, match_address_type=None, match_asns=None, match_community_set=None,
                 next_priority=None, operate_community_set=None, preference=None, prepend_as_path=None, priority=None,
                 route_map_id=None, route_types=None, source_child_instance_types=None, source_instance_ids=None,
                 source_instance_ids_reverse_match=None, source_region_ids=None, source_route_table_ids=None, status=None,
                 transit_router_route_table_id=None, transmit_direction=None):
        # The match method that is used to match routes based on the AS path.
        # 
        # *   **Include**: fuzzy match. A route is a match if the AS path of the route overlaps with the AS path specified in the match condition.
        # *   **Complete**: exact match. A route is a match only if the AS path of the route is the same as the AS path specified in the match condition.
        self.as_path_match_mode = as_path_match_mode  # type: str
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the region where the routing policy is applied.
        self.cen_region_id = cen_region_id  # type: str
        # The match method that is used to match routes based on the prefix. Valid values:
        # 
        # *   **Include**: fuzzy match. A route is a match if the route prefix is included in the match conditions.
        # 
        #     For example, if you set the match condition to 10.10.0.0/16 and fuzzy match is enabled, the route whose prefix is 10.10.1.0/24 is a match.
        # 
        # *   **Complete**: exact match. A route is a match only if the route prefix is the same as the prefix specified in the match condition.
        # 
        #     For example, if you set the match condition to 10.10.0.0/16 and exact match is enabled, a route is a match only if the prefix is 10.10.0.0/16.
        self.cidr_match_mode = cidr_match_mode  # type: str
        # The match method that is used to match routes based on the community.
        # 
        # *   **Include**: fuzzy match. A route is a match if the community of the route overlaps with the community specified in the match condition.
        # *   **Complete**: exact match. A route is a match only if the community of the route is the same as the community specified in the match condition.
        self.community_match_mode = community_match_mode  # type: str
        # The action that is performed on the community of the route.
        # 
        # *   **Additive**: adds the community to the route.
        # *   **Replace**: replaces the original community of the route.
        # 
        # This parameter indicates the action to be performed when a route meets the match condition.
        self.community_operate_mode = community_operate_mode  # type: str
        # The description of the routing policy.
        self.description = description  # type: str
        # The types of destination network instance to which the routes belong.
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        # *   **VPN**: IPsec-VPN connection
        # 
        # >  The destination network instance types are valid only when the routing policy is applied to scenarios where routes are advertised from the gateway in the current region to network instances in the current region.
        self.destination_child_instance_types = destination_child_instance_types  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationChildInstanceTypes
        # The prefixes of the routes.
        self.destination_cidr_blocks = destination_cidr_blocks  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationCidrBlocks
        # The IDs of the destination network instances to which the routes belong.
        # 
        # >  The destination network instance IDs are valid only when the routing policy is applied to scenarios where routes are advertised from the gateway in the current region to network instances in the current region.
        self.destination_instance_ids = destination_instance_ids  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationInstanceIds
        # Indicates whether the destination network instance IDs are excluded.
        # 
        # *   **false** (default): A route is a match if its destination network instance ID is in the list specified by **DestinationInstanceIds.N**.
        # *   **true**: A route is a match if its destination network instance ID is not in the list specified by **DestinationInstanceIds.N**.
        self.destination_instance_ids_reverse_match = destination_instance_ids_reverse_match  # type: bool
        # The IDs of the destination route tables to which the routes belong. You can enter at most 32 route table IDs.
        # 
        # >  The destination route table IDs are valid only when the routing policy is applied to scenarios where routes are advertised from the gateway in the current region to route tables in the current region.
        self.destination_route_table_ids = destination_route_table_ids  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationRouteTableIds
        # The action performed on a route that meets the match conditions.
        # 
        # *   **Permit**: the route is permitted.
        # *   **Deny**: the route is denied.
        self.map_result = map_result  # type: str
        # The type of IP address to be matched against the match condition. Valid values:
        # 
        # *   **IPv4**: IPv4 addresses
        # *   **IPv6**: IPv6 addresses
        # *   If no value is returned, both IPv4 and IPv6 addresses are matched against the match condition.
        self.match_address_type = match_address_type  # type: str
        # The AS paths based on which the routes are compared.
        self.match_asns = match_asns  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapMatchAsns
        # The community set based on which the routes are compared.
        self.match_community_set = match_community_set  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapMatchCommunitySet
        # The priority of the routing policy that you want to associate with the current one.
        self.next_priority = next_priority  # type: int
        # The community set on which actions are performed.
        self.operate_community_set = operate_community_set  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapOperateCommunitySet
        # The new priority of the route.
        # 
        # A smaller value indicates a higher priority.
        # 
        # This parameter indicates the action to be performed when a route meets the match condition.
        self.preference = preference  # type: int
        # The AS paths that are prepended by using an action statement when regional gateways receive or advertise routes.
        # 
        # This parameter indicates the action to be performed when a route meets the match condition.
        self.prepend_as_path = prepend_as_path  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapPrependAsPath
        # The priority of the routing policy. A smaller value indicates a higher priority.
        self.priority = priority  # type: int
        # The ID of the routing policy.
        self.route_map_id = route_map_id  # type: str
        # The types of routes that is compared. Valid values:
        # 
        # *   **System**: system routes that are automatically generated by the system.
        # *   **Custom**: custom routes that are manually added.
        # *   **BGP**: routes that are advertised over Border Gateway Protocol (BGP).
        self.route_types = route_types  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapRouteTypes
        # The types of source network instance to which the routes belong.
        # 
        # *   **VPC**: virtual private cloud (VPC)
        # *   **VBR**: virtual border router (VBR)
        # *   **CCN**: Cloud Connect Network (CCN) instance
        # *   **VPN**: IPsec-VPN connection
        self.source_child_instance_types = source_child_instance_types  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceChildInstanceTypes
        # The IDs of the source network instances to which the routes belong.
        self.source_instance_ids = source_instance_ids  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceInstanceIds
        # Indicates whether the source network instance IDs are excluded.
        # 
        # *   **false** (default): A route is a match if its source network instance ID is in the list specified by **SourceInstanceIds.N**.
        # *   **true**: A route is match if its source network instance ID is not in the list specified by **SourceInstanceIds.N**.
        self.source_instance_ids_reverse_match = source_instance_ids_reverse_match  # type: bool
        # The IDs of the source regions to which the routes belong.
        self.source_region_ids = source_region_ids  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceRegionIds
        # The IDs of the source route tables to which the routes belong.
        self.source_route_table_ids = source_route_table_ids  # type: DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceRouteTableIds
        # The status of the routing policy. Valid values:
        # 
        # *   **Creating**: The routing policy is being created.
        # *   **Active**: The routing policy is available.
        # *   **Deleting**: The routing policy is being deleted.
        self.status = status  # type: str
        # The route table ID of the transit router with which the routing policy is associated.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str
        # The direction in which the routing policy is applied.
        self.transmit_direction = transmit_direction  # type: str

    def validate(self):
        if self.destination_child_instance_types:
            self.destination_child_instance_types.validate()
        if self.destination_cidr_blocks:
            self.destination_cidr_blocks.validate()
        if self.destination_instance_ids:
            self.destination_instance_ids.validate()
        if self.destination_route_table_ids:
            self.destination_route_table_ids.validate()
        if self.match_asns:
            self.match_asns.validate()
        if self.match_community_set:
            self.match_community_set.validate()
        if self.operate_community_set:
            self.operate_community_set.validate()
        if self.prepend_as_path:
            self.prepend_as_path.validate()
        if self.route_types:
            self.route_types.validate()
        if self.source_child_instance_types:
            self.source_child_instance_types.validate()
        if self.source_instance_ids:
            self.source_instance_ids.validate()
        if self.source_region_ids:
            self.source_region_ids.validate()
        if self.source_route_table_ids:
            self.source_route_table_ids.validate()

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMapsRouteMap, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.as_path_match_mode is not None:
            result['AsPathMatchMode'] = self.as_path_match_mode
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_region_id is not None:
            result['CenRegionId'] = self.cen_region_id
        if self.cidr_match_mode is not None:
            result['CidrMatchMode'] = self.cidr_match_mode
        if self.community_match_mode is not None:
            result['CommunityMatchMode'] = self.community_match_mode
        if self.community_operate_mode is not None:
            result['CommunityOperateMode'] = self.community_operate_mode
        if self.description is not None:
            result['Description'] = self.description
        if self.destination_child_instance_types is not None:
            result['DestinationChildInstanceTypes'] = self.destination_child_instance_types.to_map()
        if self.destination_cidr_blocks is not None:
            result['DestinationCidrBlocks'] = self.destination_cidr_blocks.to_map()
        if self.destination_instance_ids is not None:
            result['DestinationInstanceIds'] = self.destination_instance_ids.to_map()
        if self.destination_instance_ids_reverse_match is not None:
            result['DestinationInstanceIdsReverseMatch'] = self.destination_instance_ids_reverse_match
        if self.destination_route_table_ids is not None:
            result['DestinationRouteTableIds'] = self.destination_route_table_ids.to_map()
        if self.map_result is not None:
            result['MapResult'] = self.map_result
        if self.match_address_type is not None:
            result['MatchAddressType'] = self.match_address_type
        if self.match_asns is not None:
            result['MatchAsns'] = self.match_asns.to_map()
        if self.match_community_set is not None:
            result['MatchCommunitySet'] = self.match_community_set.to_map()
        if self.next_priority is not None:
            result['NextPriority'] = self.next_priority
        if self.operate_community_set is not None:
            result['OperateCommunitySet'] = self.operate_community_set.to_map()
        if self.preference is not None:
            result['Preference'] = self.preference
        if self.prepend_as_path is not None:
            result['PrependAsPath'] = self.prepend_as_path.to_map()
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.route_map_id is not None:
            result['RouteMapId'] = self.route_map_id
        if self.route_types is not None:
            result['RouteTypes'] = self.route_types.to_map()
        if self.source_child_instance_types is not None:
            result['SourceChildInstanceTypes'] = self.source_child_instance_types.to_map()
        if self.source_instance_ids is not None:
            result['SourceInstanceIds'] = self.source_instance_ids.to_map()
        if self.source_instance_ids_reverse_match is not None:
            result['SourceInstanceIdsReverseMatch'] = self.source_instance_ids_reverse_match
        if self.source_region_ids is not None:
            result['SourceRegionIds'] = self.source_region_ids.to_map()
        if self.source_route_table_ids is not None:
            result['SourceRouteTableIds'] = self.source_route_table_ids.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        if self.transmit_direction is not None:
            result['TransmitDirection'] = self.transmit_direction
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AsPathMatchMode') is not None:
            self.as_path_match_mode = m.get('AsPathMatchMode')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenRegionId') is not None:
            self.cen_region_id = m.get('CenRegionId')
        if m.get('CidrMatchMode') is not None:
            self.cidr_match_mode = m.get('CidrMatchMode')
        if m.get('CommunityMatchMode') is not None:
            self.community_match_mode = m.get('CommunityMatchMode')
        if m.get('CommunityOperateMode') is not None:
            self.community_operate_mode = m.get('CommunityOperateMode')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DestinationChildInstanceTypes') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationChildInstanceTypes()
            self.destination_child_instance_types = temp_model.from_map(m['DestinationChildInstanceTypes'])
        if m.get('DestinationCidrBlocks') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationCidrBlocks()
            self.destination_cidr_blocks = temp_model.from_map(m['DestinationCidrBlocks'])
        if m.get('DestinationInstanceIds') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationInstanceIds()
            self.destination_instance_ids = temp_model.from_map(m['DestinationInstanceIds'])
        if m.get('DestinationInstanceIdsReverseMatch') is not None:
            self.destination_instance_ids_reverse_match = m.get('DestinationInstanceIdsReverseMatch')
        if m.get('DestinationRouteTableIds') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapDestinationRouteTableIds()
            self.destination_route_table_ids = temp_model.from_map(m['DestinationRouteTableIds'])
        if m.get('MapResult') is not None:
            self.map_result = m.get('MapResult')
        if m.get('MatchAddressType') is not None:
            self.match_address_type = m.get('MatchAddressType')
        if m.get('MatchAsns') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapMatchAsns()
            self.match_asns = temp_model.from_map(m['MatchAsns'])
        if m.get('MatchCommunitySet') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapMatchCommunitySet()
            self.match_community_set = temp_model.from_map(m['MatchCommunitySet'])
        if m.get('NextPriority') is not None:
            self.next_priority = m.get('NextPriority')
        if m.get('OperateCommunitySet') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapOperateCommunitySet()
            self.operate_community_set = temp_model.from_map(m['OperateCommunitySet'])
        if m.get('Preference') is not None:
            self.preference = m.get('Preference')
        if m.get('PrependAsPath') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapPrependAsPath()
            self.prepend_as_path = temp_model.from_map(m['PrependAsPath'])
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RouteMapId') is not None:
            self.route_map_id = m.get('RouteMapId')
        if m.get('RouteTypes') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapRouteTypes()
            self.route_types = temp_model.from_map(m['RouteTypes'])
        if m.get('SourceChildInstanceTypes') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceChildInstanceTypes()
            self.source_child_instance_types = temp_model.from_map(m['SourceChildInstanceTypes'])
        if m.get('SourceInstanceIds') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceInstanceIds()
            self.source_instance_ids = temp_model.from_map(m['SourceInstanceIds'])
        if m.get('SourceInstanceIdsReverseMatch') is not None:
            self.source_instance_ids_reverse_match = m.get('SourceInstanceIdsReverseMatch')
        if m.get('SourceRegionIds') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceRegionIds()
            self.source_region_ids = temp_model.from_map(m['SourceRegionIds'])
        if m.get('SourceRouteTableIds') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMapSourceRouteTableIds()
            self.source_route_table_ids = temp_model.from_map(m['SourceRouteTableIds'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        if m.get('TransmitDirection') is not None:
            self.transmit_direction = m.get('TransmitDirection')
        return self


class DescribeCenRouteMapsResponseBodyRouteMaps(TeaModel):
    def __init__(self, route_map=None):
        self.route_map = route_map  # type: list[DescribeCenRouteMapsResponseBodyRouteMapsRouteMap]

    def validate(self):
        if self.route_map:
            for k in self.route_map:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBodyRouteMaps, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RouteMap'] = []
        if self.route_map is not None:
            for k in self.route_map:
                result['RouteMap'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.route_map = []
        if m.get('RouteMap') is not None:
            for k in m.get('RouteMap'):
                temp_model = DescribeCenRouteMapsResponseBodyRouteMapsRouteMap()
                self.route_map.append(temp_model.from_map(k))
        return self


class DescribeCenRouteMapsResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, route_maps=None, total_count=None):
        # The number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the routing policy.
        self.route_maps = route_maps  # type: DescribeCenRouteMapsResponseBodyRouteMaps
        # The number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.route_maps:
            self.route_maps.validate()

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_maps is not None:
            result['RouteMaps'] = self.route_maps.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteMaps') is not None:
            temp_model = DescribeCenRouteMapsResponseBodyRouteMaps()
            self.route_maps = temp_model.from_map(m['RouteMaps'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCenRouteMapsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenRouteMapsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenRouteMapsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenRouteMapsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCenVbrHealthCheckRequest(TeaModel):
    def __init__(self, cen_id=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 resource_owner_account=None, resource_owner_id=None, vbr_instance_id=None, vbr_instance_owner_id=None,
                 vbr_instance_region_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values: **1** to **50**. Default value: **10**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the VBR.
        self.vbr_instance_id = vbr_instance_id  # type: str
        # The ID of the Alibaba Cloud account that owns the VBR.
        # 
        # >  The parameter is required if the VBR and the CEN instance belong to different Alibaba Cloud accounts.
        self.vbr_instance_owner_id = vbr_instance_owner_id  # type: long
        # The ID of the region where the VBR is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.vbr_instance_region_id = vbr_instance_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenVbrHealthCheckRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vbr_instance_id is not None:
            result['VbrInstanceId'] = self.vbr_instance_id
        if self.vbr_instance_owner_id is not None:
            result['VbrInstanceOwnerId'] = self.vbr_instance_owner_id
        if self.vbr_instance_region_id is not None:
            result['VbrInstanceRegionId'] = self.vbr_instance_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VbrInstanceId') is not None:
            self.vbr_instance_id = m.get('VbrInstanceId')
        if m.get('VbrInstanceOwnerId') is not None:
            self.vbr_instance_owner_id = m.get('VbrInstanceOwnerId')
        if m.get('VbrInstanceRegionId') is not None:
            self.vbr_instance_region_id = m.get('VbrInstanceRegionId')
        return self


class DescribeCenVbrHealthCheckResponseBodyVbrHealthChecksVbrHealthCheck(TeaModel):
    def __init__(self, cen_id=None, health_check_interval=None, health_check_only=None,
                 health_check_source_ip=None, health_check_target_ip=None, healthy_threshold=None, vbr_instance_id=None,
                 vbr_instance_region_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The time interval at which probe packets are sent during the health check. Unit: seconds.
        self.health_check_interval = health_check_interval  # type: int
        # Indicates whether probing is enabled. Valid values:
        # 
        # *   **true**: yes
        # 
        #     If probing is enabled, the system does not switch to another route when the detected route is not reachable.
        # 
        # *   **false**: no
        # 
        #     If probing is disabled and a redundant route is specified, the system switches to the redundant route when the detected route is not reachable.
        self.health_check_only = health_check_only  # type: bool
        # The source IP address of the health check.
        self.health_check_source_ip = health_check_source_ip  # type: str
        # The destination IP address of the health check.
        self.health_check_target_ip = health_check_target_ip  # type: str
        # The number of probe packets that are sent during the health check.
        self.healthy_threshold = healthy_threshold  # type: int
        # The ID of the VBR.
        self.vbr_instance_id = vbr_instance_id  # type: str
        # The ID of the region where the VBR is deployed.
        self.vbr_instance_region_id = vbr_instance_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCenVbrHealthCheckResponseBodyVbrHealthChecksVbrHealthCheck, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.health_check_only is not None:
            result['HealthCheckOnly'] = self.health_check_only
        if self.health_check_source_ip is not None:
            result['HealthCheckSourceIp'] = self.health_check_source_ip
        if self.health_check_target_ip is not None:
            result['HealthCheckTargetIp'] = self.health_check_target_ip
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.vbr_instance_id is not None:
            result['VbrInstanceId'] = self.vbr_instance_id
        if self.vbr_instance_region_id is not None:
            result['VbrInstanceRegionId'] = self.vbr_instance_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthCheckOnly') is not None:
            self.health_check_only = m.get('HealthCheckOnly')
        if m.get('HealthCheckSourceIp') is not None:
            self.health_check_source_ip = m.get('HealthCheckSourceIp')
        if m.get('HealthCheckTargetIp') is not None:
            self.health_check_target_ip = m.get('HealthCheckTargetIp')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('VbrInstanceId') is not None:
            self.vbr_instance_id = m.get('VbrInstanceId')
        if m.get('VbrInstanceRegionId') is not None:
            self.vbr_instance_region_id = m.get('VbrInstanceRegionId')
        return self


class DescribeCenVbrHealthCheckResponseBodyVbrHealthChecks(TeaModel):
    def __init__(self, vbr_health_check=None):
        self.vbr_health_check = vbr_health_check  # type: list[DescribeCenVbrHealthCheckResponseBodyVbrHealthChecksVbrHealthCheck]

    def validate(self):
        if self.vbr_health_check:
            for k in self.vbr_health_check:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCenVbrHealthCheckResponseBodyVbrHealthChecks, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['VbrHealthCheck'] = []
        if self.vbr_health_check is not None:
            for k in self.vbr_health_check:
                result['VbrHealthCheck'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.vbr_health_check = []
        if m.get('VbrHealthCheck') is not None:
            for k in m.get('VbrHealthCheck'):
                temp_model = DescribeCenVbrHealthCheckResponseBodyVbrHealthChecksVbrHealthCheck()
                self.vbr_health_check.append(temp_model.from_map(k))
        return self


class DescribeCenVbrHealthCheckResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, total_count=None, vbr_health_checks=None):
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int
        # The health check configuration of the VBR.
        self.vbr_health_checks = vbr_health_checks  # type: DescribeCenVbrHealthCheckResponseBodyVbrHealthChecks

    def validate(self):
        if self.vbr_health_checks:
            self.vbr_health_checks.validate()

    def to_map(self):
        _map = super(DescribeCenVbrHealthCheckResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.vbr_health_checks is not None:
            result['VbrHealthChecks'] = self.vbr_health_checks.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('VbrHealthChecks') is not None:
            temp_model = DescribeCenVbrHealthCheckResponseBodyVbrHealthChecks()
            self.vbr_health_checks = temp_model.from_map(m['VbrHealthChecks'])
        return self


class DescribeCenVbrHealthCheckResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCenVbrHealthCheckResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCenVbrHealthCheckResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCenVbrHealthCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCensRequestFilter(TeaModel):
    def __init__(self, key=None, value=None):
        # The filter condition. Valid values:
        # 
        # *   **CenId**: the ID of a CEN instance.
        # *   **Name**: the name of a CEN instance.
        # 
        # By default, the logical operator among filter conditions is **AND**. Information about a CEN instance is returned only if the CEN instance matches all filter conditions.
        # 
        # You can specify at most five filter conditions in each call.
        self.key = key  # type: str
        # The values of the filter condition.
        self.value = value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCensRequestFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCensRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag keys of the resources.
        # 
        # The tag keys cannot be an empty string. The tag keys can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag values of the resources.
        # 
        # The tag values can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key has a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCensRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCensRequest(TeaModel):
    def __init__(self, filter=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 resource_group_id=None, resource_owner_account=None, resource_owner_id=None, tag=None):
        # The list of the filter conditions.
        self.filter = filter  # type: list[DescribeCensRequestFilter]
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values: **1** to **50**. Default value: **10**.
        self.page_size = page_size  # type: int
        self.resource_group_id = resource_group_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The tags.
        self.tag = tag  # type: list[DescribeCensRequestTag]

    def validate(self):
        if self.filter:
            for k in self.filter:
                if k:
                    k.validate()
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCensRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Filter'] = []
        if self.filter is not None:
            for k in self.filter:
                result['Filter'].append(k.to_map() if k else None)
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.filter = []
        if m.get('Filter') is not None:
            for k in m.get('Filter'):
                temp_model = DescribeCensRequestFilter()
                self.filter.append(temp_model.from_map(k))
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCensRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCensResponseBodyCensCenCenBandwidthPackageIds(TeaModel):
    def __init__(self, cen_bandwidth_package_id=None):
        self.cen_bandwidth_package_id = cen_bandwidth_package_id  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCensResponseBodyCensCenCenBandwidthPackageIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_bandwidth_package_id is not None:
            result['CenBandwidthPackageId'] = self.cen_bandwidth_package_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenBandwidthPackageId') is not None:
            self.cen_bandwidth_package_id = m.get('CenBandwidthPackageId')
        return self


class DescribeCensResponseBodyCensCenTagsTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of the tag.
        self.key = key  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeCensResponseBodyCensCenTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCensResponseBodyCensCenTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeCensResponseBodyCensCenTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCensResponseBodyCensCenTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeCensResponseBodyCensCenTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeCensResponseBodyCensCen(TeaModel):
    def __init__(self, cen_bandwidth_package_ids=None, cen_id=None, creation_time=None, description=None,
                 ipv_6level=None, name=None, protection_level=None, resource_group_id=None, status=None, tags=None):
        # The IDs of the bandwidth plans that are associated with the CEN instance.
        self.cen_bandwidth_package_ids = cen_bandwidth_package_ids  # type: DescribeCensResponseBodyCensCenCenBandwidthPackageIds
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The time when the CEN instance was created.
        # 
        # The time follows the ISO8601 standard in the `YYYY-MM-DDThh:mmZ` format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the CEN instance.
        self.description = description  # type: str
        # Indicates whether IPv6 is enabled for the CEN instance.
        # 
        # *   **ENABLE**: enabled
        # *   **DISABLED**: disabled
        self.ipv_6level = ipv_6level  # type: str
        # The name of the CEN instance.
        self.name = name  # type: str
        # The level of CIDR block overlapping.
        # 
        # **REDUCED**: Overlapped CIDR blocks are allowed. This value specifies that CIDR blocks can overlap but CIDR blocks cannot be duplicates.
        self.protection_level = protection_level  # type: str
        # The ID of the resource group to which the CEN instance belongs.
        self.resource_group_id = resource_group_id  # type: str
        # The status of the CEN instance.
        # 
        # *   **Creating**: The CEN instance is being created.
        # *   **Active**: The CEN instance is running.
        # *   **Deleting**: The instance is being deleted.
        self.status = status  # type: str
        # The IDs of the tags that are added to the CEN instance.
        self.tags = tags  # type: DescribeCensResponseBodyCensCenTags

    def validate(self):
        if self.cen_bandwidth_package_ids:
            self.cen_bandwidth_package_ids.validate()
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeCensResponseBodyCensCen, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_bandwidth_package_ids is not None:
            result['CenBandwidthPackageIds'] = self.cen_bandwidth_package_ids.to_map()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.ipv_6level is not None:
            result['Ipv6Level'] = self.ipv_6level
        if self.name is not None:
            result['Name'] = self.name
        if self.protection_level is not None:
            result['ProtectionLevel'] = self.protection_level
        if self.resource_group_id is not None:
            result['ResourceGroupId'] = self.resource_group_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenBandwidthPackageIds') is not None:
            temp_model = DescribeCensResponseBodyCensCenCenBandwidthPackageIds()
            self.cen_bandwidth_package_ids = temp_model.from_map(m['CenBandwidthPackageIds'])
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Ipv6Level') is not None:
            self.ipv_6level = m.get('Ipv6Level')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ProtectionLevel') is not None:
            self.protection_level = m.get('ProtectionLevel')
        if m.get('ResourceGroupId') is not None:
            self.resource_group_id = m.get('ResourceGroupId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeCensResponseBodyCensCenTags()
            self.tags = temp_model.from_map(m['Tags'])
        return self


class DescribeCensResponseBodyCens(TeaModel):
    def __init__(self, cen=None):
        self.cen = cen  # type: list[DescribeCensResponseBodyCensCen]

    def validate(self):
        if self.cen:
            for k in self.cen:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeCensResponseBodyCens, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Cen'] = []
        if self.cen is not None:
            for k in self.cen:
                result['Cen'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cen = []
        if m.get('Cen') is not None:
            for k in m.get('Cen'):
                temp_model = DescribeCensResponseBodyCensCen()
                self.cen.append(temp_model.from_map(k))
        return self


class DescribeCensResponseBody(TeaModel):
    def __init__(self, cens=None, page_number=None, page_size=None, request_id=None, total_count=None):
        # The information about the CEN instance.
        self.cens = cens  # type: DescribeCensResponseBodyCens
        # The number of the page returned.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.cens:
            self.cens.validate()

    def to_map(self):
        _map = super(DescribeCensResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cens is not None:
            result['Cens'] = self.cens.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cens') is not None:
            temp_model = DescribeCensResponseBodyCens()
            self.cens = temp_model.from_map(m['Cens'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCensResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeCensResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeCensResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCensResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeChildInstanceRegionsRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, product_type=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: virtual private cloud (VPC)
        # *   **VBR**: virtual border router (VBR)
        # *   **CCN**: Cloud Connect Network (CCN) instance
        self.product_type = product_type  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeChildInstanceRegionsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeChildInstanceRegionsResponseBodyRegionsRegion(TeaModel):
    def __init__(self, local_name=None, region_id=None):
        # The name of the region.
        self.local_name = local_name  # type: str
        # The ID of the region.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeChildInstanceRegionsResponseBodyRegionsRegion, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.local_name is not None:
            result['LocalName'] = self.local_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('LocalName') is not None:
            self.local_name = m.get('LocalName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeChildInstanceRegionsResponseBodyRegions(TeaModel):
    def __init__(self, region=None):
        self.region = region  # type: list[DescribeChildInstanceRegionsResponseBodyRegionsRegion]

    def validate(self):
        if self.region:
            for k in self.region:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeChildInstanceRegionsResponseBodyRegions, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Region'] = []
        if self.region is not None:
            for k in self.region:
                result['Region'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.region = []
        if m.get('Region') is not None:
            for k in m.get('Region'):
                temp_model = DescribeChildInstanceRegionsResponseBodyRegionsRegion()
                self.region.append(temp_model.from_map(k))
        return self


class DescribeChildInstanceRegionsResponseBody(TeaModel):
    def __init__(self, regions=None, request_id=None):
        # A list of regions.
        self.regions = regions  # type: DescribeChildInstanceRegionsResponseBodyRegions
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.regions:
            self.regions.validate()

    def to_map(self):
        _map = super(DescribeChildInstanceRegionsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.regions is not None:
            result['Regions'] = self.regions.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Regions') is not None:
            temp_model = DescribeChildInstanceRegionsResponseBodyRegions()
            self.regions = temp_model.from_map(m['Regions'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeChildInstanceRegionsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeChildInstanceRegionsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeChildInstanceRegionsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeChildInstanceRegionsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFlowlogsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot be an empty string. The tag key can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # Each tag key must have a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowlogsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeFlowlogsRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, description=None, flow_log_id=None, flow_log_name=None,
                 log_store_name=None, owner_account=None, owner_id=None, page_number=None, page_size=None, project_name=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, status=None, tag=None,
                 transit_router_attachment_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # The description of the flow log.
        # 
        # The description must be 2 to 256 characters in length. It must start with a letter but cannot start with `http://` or `https://`.
        self.description = description  # type: str
        # The ID of the flow log.
        self.flow_log_id = flow_log_id  # type: str
        # The name of the flow log.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, periods (.), underscores (\_), and hyphens (-). The name must start with a letter but cannot start with `http://` or `https://`.
        self.flow_log_name = flow_log_name  # type: str
        # The name of the Logstore where the flow log is stored.
        # 
        # The name must be 3 to 63 characters in length, and can contain lowercase letters, digits, underscores (\_), and hyphens (-). It must start or end with a lowercase letter or a digit.
        self.log_store_name = log_store_name  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Minimum value: **1**. Default value: **20**.
        self.page_size = page_size  # type: int
        # The name of the project where the flow log is stored.
        # 
        # The name must be 3 to 63 characters in length, and can contain lowercase letters, digits, and hyphens (-). It must start or end with a lowercase letter or a digit.
        self.project_name = project_name  # type: str
        # The ID of the region where the flow log is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The status of the flow log. Valid values:
        # 
        # *   **Active**: The flow log is enabled.
        # *   **Inactive**: The flow log is disabled.
        self.status = status  # type: str
        # The information about the tags.
        # 
        # You can specify at most 20 tags in each call.
        self.tag = tag  # type: list[DescribeFlowlogsRequestTag]
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowlogsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.description is not None:
            result['Description'] = self.description
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.flow_log_name is not None:
            result['FlowLogName'] = self.flow_log_name
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('FlowLogName') is not None:
            self.flow_log_name = m.get('FlowLogName')
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeFlowlogsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class DescribeFlowlogsResponseBodyFlowLogsFlowLogTagsTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        self.key = key  # type: str
        # The tag value.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeFlowlogsResponseBodyFlowLogsFlowLogTagsTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeFlowlogsResponseBodyFlowLogsFlowLogTags(TeaModel):
    def __init__(self, tag=None):
        self.tag = tag  # type: list[DescribeFlowlogsResponseBodyFlowLogsFlowLogTagsTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowlogsResponseBodyFlowLogsFlowLogTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = DescribeFlowlogsResponseBodyFlowLogsFlowLogTagsTag()
                self.tag.append(temp_model.from_map(k))
        return self


class DescribeFlowlogsResponseBodyFlowLogsFlowLog(TeaModel):
    def __init__(self, cen_id=None, creation_time=None, description=None, flow_log_id=None, flow_log_name=None,
                 interval=None, log_store_name=None, project_name=None, region_id=None, status=None, tags=None,
                 transit_router_attachment_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The time when the flow log was created.
        # 
        # The time follows the ISO 8601 standard in the YYYY-MM-DDThh:mm:ssZ format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The description of the flow log.
        self.description = description  # type: str
        # The ID of the flow log.
        self.flow_log_id = flow_log_id  # type: str
        # The name of the flow log.
        self.flow_log_name = flow_log_name  # type: str
        # The time window for collecting log data. Unit: seconds. Valid values: **60** and **600**. Default value: **600**.
        self.interval = interval  # type: long
        # The name of the Logstore where the flow log is stored.
        self.log_store_name = log_store_name  # type: str
        # The name of the project where the flow log is stored.
        self.project_name = project_name  # type: str
        # The ID of the region where the flow log is deployed.
        self.region_id = region_id  # type: str
        # The status of the flow log. Valid values:
        # 
        # *   **Active**: The flow log is enabled.
        # *   **Inactive**: The flow log is disabled.
        self.status = status  # type: str
        # A list of tags.
        self.tags = tags  # type: DescribeFlowlogsResponseBodyFlowLogsFlowLogTags
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        if self.tags:
            self.tags.validate()

    def to_map(self):
        _map = super(DescribeFlowlogsResponseBodyFlowLogsFlowLog, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.description is not None:
            result['Description'] = self.description
        if self.flow_log_id is not None:
            result['FlowLogId'] = self.flow_log_id
        if self.flow_log_name is not None:
            result['FlowLogName'] = self.flow_log_name
        if self.interval is not None:
            result['Interval'] = self.interval
        if self.log_store_name is not None:
            result['LogStoreName'] = self.log_store_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tags is not None:
            result['Tags'] = self.tags.to_map()
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FlowLogId') is not None:
            self.flow_log_id = m.get('FlowLogId')
        if m.get('FlowLogName') is not None:
            self.flow_log_name = m.get('FlowLogName')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        if m.get('LogStoreName') is not None:
            self.log_store_name = m.get('LogStoreName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tags') is not None:
            temp_model = DescribeFlowlogsResponseBodyFlowLogsFlowLogTags()
            self.tags = temp_model.from_map(m['Tags'])
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class DescribeFlowlogsResponseBodyFlowLogs(TeaModel):
    def __init__(self, flow_log=None):
        self.flow_log = flow_log  # type: list[DescribeFlowlogsResponseBodyFlowLogsFlowLog]

    def validate(self):
        if self.flow_log:
            for k in self.flow_log:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeFlowlogsResponseBodyFlowLogs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FlowLog'] = []
        if self.flow_log is not None:
            for k in self.flow_log:
                result['FlowLog'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.flow_log = []
        if m.get('FlowLog') is not None:
            for k in m.get('FlowLog'):
                temp_model = DescribeFlowlogsResponseBodyFlowLogsFlowLog()
                self.flow_log.append(temp_model.from_map(k))
        return self


class DescribeFlowlogsResponseBody(TeaModel):
    def __init__(self, flow_logs=None, page_number=None, page_size=None, request_id=None, success=None,
                 total_count=None):
        # A list of flow logs.
        self.flow_logs = flow_logs  # type: DescribeFlowlogsResponseBodyFlowLogs
        # The page number of the returned page.
        self.page_number = page_number  # type: str
        # The number of entries returned per page.
        self.page_size = page_size  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # Indicates whether the call is successful. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: str

    def validate(self):
        if self.flow_logs:
            self.flow_logs.validate()

    def to_map(self):
        _map = super(DescribeFlowlogsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flow_logs is not None:
            result['FlowLogs'] = self.flow_logs.to_map()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('FlowLogs') is not None:
            temp_model = DescribeFlowlogsResponseBodyFlowLogs()
            self.flow_logs = temp_model.from_map(m['FlowLogs'])
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeFlowlogsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeFlowlogsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeFlowlogsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFlowlogsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGeographicRegionMembershipRequest(TeaModel):
    def __init__(self, geographic_region_id=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the area that you want to query. Valid values:
        # 
        # *   **china**: the Chinese mainland
        # *   **asia-pacific**: Asia Pacific
        # *   **europe**: Europe
        # *   **australia**: Australia
        # *   **north-america**: North America
        self.geographic_region_id = geographic_region_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return per page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGeographicRegionMembershipRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.geographic_region_id is not None:
            result['GeographicRegionId'] = self.geographic_region_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GeographicRegionId') is not None:
            self.geographic_region_id = m.get('GeographicRegionId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeGeographicRegionMembershipResponseBodyRegionIdsRegionId(TeaModel):
    def __init__(self, region_id=None):
        # The ID of the region.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGeographicRegionMembershipResponseBodyRegionIdsRegionId, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeGeographicRegionMembershipResponseBodyRegionIds(TeaModel):
    def __init__(self, region_id=None):
        self.region_id = region_id  # type: list[DescribeGeographicRegionMembershipResponseBodyRegionIdsRegionId]

    def validate(self):
        if self.region_id:
            for k in self.region_id:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGeographicRegionMembershipResponseBodyRegionIds, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RegionId'] = []
        if self.region_id is not None:
            for k in self.region_id:
                result['RegionId'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.region_id = []
        if m.get('RegionId') is not None:
            for k in m.get('RegionId'):
                temp_model = DescribeGeographicRegionMembershipResponseBodyRegionIdsRegionId()
                self.region_id.append(temp_model.from_map(k))
        return self


class DescribeGeographicRegionMembershipResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, region_ids=None, request_id=None, total_count=None):
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The list of regions.
        self.region_ids = region_ids  # type: DescribeGeographicRegionMembershipResponseBodyRegionIds
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.region_ids:
            self.region_ids.validate()

    def to_map(self):
        _map = super(DescribeGeographicRegionMembershipResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionIds') is not None:
            temp_model = DescribeGeographicRegionMembershipResponseBodyRegionIds()
            self.region_ids = temp_model.from_map(m['RegionIds'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGeographicRegionMembershipResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGeographicRegionMembershipResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGeographicRegionMembershipResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGeographicRegionMembershipResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGrantRulesToCenRequest(TeaModel):
    def __init__(self, cen_id=None, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 product_type=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The number of entries to return on each page. Valid values: **1** to **100**.  
        # 
        # - If you do not set **MaxResults**, it indicates that you do not need to query results in batches. The value of **MaxResults** in the response indicates the total number of entries.
        # - If a value is specified for **MaxResults**, it indicates that you need to query results in batches. The value of **MaxResults** in the response indicates the number of entries in the current batch. We recommend that you set **MaxResults** to **20**.
        self.max_results = max_results  # type: long
        # The token that determines the start point of the query. Valid values:
        # 
        # - If this is your first query or no subsequent query is to be sent, ignore this parameter.
        # - If a subsequent query is to be sent, set the value to the value of **NextToken** that was returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The type of the network instance. Valid values:
        # 
        # - **VPC**: virtual private cloud (VPC)
        # - **VBR**: virtual border router (VBR)
        # - **CCN**: Cloud Connect Network (CCN) instance
        # - **VPN**: IPsec-VPN connection
        self.product_type = product_type  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGrantRulesToCenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeGrantRulesToCenResponseBodyGrantRulesGrantRule(TeaModel):
    def __init__(self, cen_id=None, cen_owner_id=None, child_instance_id=None, child_instance_owner_id=None,
                 child_instance_region_id=None, child_instance_type=None, order_type=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the Alibaba Cloud account to which the CEN instance belongs.
        self.cen_owner_id = cen_owner_id  # type: long
        # The ID of the network instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the Alibaba Cloud account to which the network instance belongs.
        self.child_instance_owner_id = child_instance_owner_id  # type: long
        # The ID of the region where the network instance is deployed.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        # *   **VPN**: IPsec-VPN connection
        self.child_instance_type = child_instance_type  # type: str
        # The entity that pays the fees of the network instance. Valid values:
        # 
        # *   **PayByCenOwner**: the Alibaba Cloud account that owns the CEN instance.
        # *   **PayByResourceOwner**: the Alibaba Cloud account that owns the network instance.
        self.order_type = order_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGrantRulesToCenResponseBodyGrantRulesGrantRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_owner_id is not None:
            result['ChildInstanceOwnerId'] = self.child_instance_owner_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceOwnerId') is not None:
            self.child_instance_owner_id = m.get('ChildInstanceOwnerId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DescribeGrantRulesToCenResponseBodyGrantRules(TeaModel):
    def __init__(self, grant_rule=None):
        self.grant_rule = grant_rule  # type: list[DescribeGrantRulesToCenResponseBodyGrantRulesGrantRule]

    def validate(self):
        if self.grant_rule:
            for k in self.grant_rule:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGrantRulesToCenResponseBodyGrantRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GrantRule'] = []
        if self.grant_rule is not None:
            for k in self.grant_rule:
                result['GrantRule'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.grant_rule = []
        if m.get('GrantRule') is not None:
            for k in m.get('GrantRule'):
                temp_model = DescribeGrantRulesToCenResponseBodyGrantRulesGrantRule()
                self.grant_rule.append(temp_model.from_map(k))
        return self


class DescribeGrantRulesToCenResponseBody(TeaModel):
    def __init__(self, grant_rules=None, max_results=None, next_token=None, request_id=None, total_count=None):
        # The permissions that are granted to the CEN instance.
        self.grant_rules = grant_rules  # type: DescribeGrantRulesToCenResponseBodyGrantRules
        # The number of entries returned on each page.
        self.max_results = max_results  # type: long
        # The token that determines the start point of the query. Valid values:
        # 
        # - If **NextToken** was not returned, it indicates that no additional results exist.
        # - If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The number of entries returned.
        self.total_count = total_count  # type: long

    def validate(self):
        if self.grant_rules:
            self.grant_rules.validate()

    def to_map(self):
        _map = super(DescribeGrantRulesToCenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grant_rules is not None:
            result['GrantRules'] = self.grant_rules.to_map()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GrantRules') is not None:
            temp_model = DescribeGrantRulesToCenResponseBodyGrantRules()
            self.grant_rules = temp_model.from_map(m['GrantRules'])
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGrantRulesToCenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGrantRulesToCenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGrantRulesToCenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGrantRulesToCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGrantRulesToResourceRequest(TeaModel):
    def __init__(self, max_results=None, next_token=None, owner_account=None, owner_id=None, product_type=None,
                 region_id=None, resource_id=None, resource_owner_account=None, resource_owner_id=None):
        # *   If you do not set **MaxResults**, it indicates that you do not need to query results in batches. The value of **MaxResults** indicates the total number of entries.
        # *   If you specify a value for **MaxResults**, it indicates that you need to query results in batches. The value of **MaxResults** indicates the number of entries to return in each batch. Valid values: **1** to **100**. The value of **MaxResults** in the response indicates the number of entries in the current batch. We recommend that you set **MaxResults** to **20**.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If this is your first query or no next query is to be sent, ignore this parameter.
        # *   If a subsequent query is to be sent, set the value to the value of **NextToken** that was returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: virtual private cloud (VPC)
        # *   **ExpressConnect**: virtual border router (VBR)
        # *   **VPN**: IPsec-VPN connection
        self.product_type = product_type  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        # The ID of the network instance.
        self.resource_id = resource_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGrantRulesToResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.product_type is not None:
            result['ProductType'] = self.product_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProductType') is not None:
            self.product_type = m.get('ProductType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeGrantRulesToResourceResponseBodyGrantRules(TeaModel):
    def __init__(self, cen_id=None, cen_owner_id=None, order_type=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the Alibaba Cloud account to which the CEN instance belongs.
        self.cen_owner_id = cen_owner_id  # type: long
        # The entity that pays the fees of the network instance. Valid values:
        # 
        # *   **PayByCenOwner**: The fees of the connections and data forwarding on the transit router are paid by the Alibaba Cloud account to which the CEN instance belongs.
        # *   **PayByResourceOwner**: The fees of the connections and data forwarding on the transit router are paid by the Alibaba Cloud account to which the network instance belongs.
        self.order_type = order_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeGrantRulesToResourceResponseBodyGrantRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        return self


class DescribeGrantRulesToResourceResponseBody(TeaModel):
    def __init__(self, grant_rules=None, max_results=None, next_token=None, request_id=None, total_count=None):
        # The permissions that are granted to the CEN instance.
        self.grant_rules = grant_rules  # type: list[DescribeGrantRulesToResourceResponseBodyGrantRules]
        # *   If no value is specified for **MaxResults**, query results are returned in one batch. The value of **MaxResults** indicates the total number of entries.
        # *   If a value is specified for **MaxResults**, it indicates that you need to query results in batches. The value of **MaxResults** in the response indicates the number of entries in the current batch.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If **NextToken** was not returned in the previous query, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.grant_rules:
            for k in self.grant_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeGrantRulesToResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GrantRules'] = []
        if self.grant_rules is not None:
            for k in self.grant_rules:
                result['GrantRules'].append(k.to_map() if k else None)
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.grant_rules = []
        if m.get('GrantRules') is not None:
            for k in m.get('GrantRules'):
                temp_model = DescribeGrantRulesToResourceResponseBodyGrantRules()
                self.grant_rules.append(temp_model.from_map(k))
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGrantRulesToResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeGrantRulesToResourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeGrantRulesToResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGrantRulesToResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePublishedRouteEntriesRequest(TeaModel):
    def __init__(self, cen_id=None, child_instance_id=None, child_instance_region_id=None,
                 child_instance_route_table_id=None, child_instance_type=None, destination_cidr_block=None, page_number=None, page_size=None,
                 resource_owner_account=None, resource_owner_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the network instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The ID of the route table of the network instance.
        self.child_instance_route_table_id = child_instance_route_table_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: Cloud Connect Network (CCN) instance
        self.child_instance_type = child_instance_type  # type: str
        # The destination CIDR block of the route that you want to query.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePublishedRouteEntriesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_route_table_id is not None:
            result['ChildInstanceRouteTableId'] = self.child_instance_route_table_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceRouteTableId') is not None:
            self.child_instance_route_table_id = m.get('ChildInstanceRouteTableId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntryConflictsConflict(TeaModel):
    def __init__(self, destination_cidr_block=None, instance_id=None, instance_type=None, region_id=None,
                 status=None):
        # The destination CIDR block of the conflicting route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # The ID of the peer network instance on which conflicting routes are found.
        self.instance_id = instance_id  # type: str
        # The type of the peer network instance on which the conflicting routes are found. Valid values:
        # 
        # *   **VPC**: VPC
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        self.instance_type = instance_type  # type: str
        # The ID of the region where the peer network instance on which the conflicting routes are found is deployed.
        self.region_id = region_id  # type: str
        # The cause of the route confliction. Valid values:
        # 
        # *   **conflict**: The routes have the same destination CIDR block.
        # *   **overflow**: The number of routes in the route table configured on another network instance has reached the upper limit.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntryConflictsConflict, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntryConflicts(TeaModel):
    def __init__(self, conflict=None):
        self.conflict = conflict  # type: list[DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntryConflictsConflict]

    def validate(self):
        if self.conflict:
            for k in self.conflict:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntryConflicts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Conflict'] = []
        if self.conflict is not None:
            for k in self.conflict:
                result['Conflict'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.conflict = []
        if m.get('Conflict') is not None:
            for k in m.get('Conflict'):
                temp_model = DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntryConflictsConflict()
                self.conflict.append(temp_model.from_map(k))
        return self


class DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntry(TeaModel):
    def __init__(self, child_instance_route_table_id=None, conflicts=None, destination_cidr_block=None,
                 next_hop_id=None, next_hop_type=None, operational_mode=None, publish_status=None, route_type=None):
        # The ID of the route table configured on the network instance.
        self.child_instance_route_table_id = child_instance_route_table_id  # type: str
        # A list of conflicting routes.
        self.conflicts = conflicts  # type: DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntryConflicts
        # The destination CIDR block of the route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # The ID of the instance specified as the next hop in the route.
        self.next_hop_id = next_hop_id  # type: str
        # The type of the instance specified as the next hop in the route.
        # 
        # *   **Instance**: ECS instance
        # *   **HaVip**: high-availability virtual IP address (HAVIP).
        # *   **RouterInterface**: router interface.
        # *   **NetworkInterface**: elastic network interface (ENI).
        # *   **VpnGateway**: VPN gateway.
        # *   **IPv6Gateway**: IPv6 gateway.
        # *   **NatGateway**: NAT gateway.
        # *   **Attachment**: network instance connection
        # *   **service**: cloud service
        # *   **VBR**: VBR
        # *   **CCN**: CCN instance
        # *   **VPC**: VPC
        # *   **local**: system route. No next hop is specified.
        # *   **TR**: transit router
        # *   \*\*BlackHole\*\*: blackhole route. No next hop is specified.
        # *   \*\*EcRouterInterface\*\*: router interface for Express Connect
        # *   **HealthCheck**: health check
        # *   **AS**: access gateway for CCN
        # *   **classicLink**: classic network-type instance
        # *   **GatewayEndpoint**: gateway endpoint
        # *   **CPE**: data center connected to the VBR
        self.next_hop_type = next_hop_type  # type: str
        # Indicates whether the route is allowed to be advertised to or withdrawn from the CEN instance. Valid values:
        # 
        # *   **true**: The route is allowed to be advertised to or withdrawn from the CEN instance.
        # *   **false**: The route is not allowed to be advertised to or withdrawn from the CEN instance.
        self.operational_mode = operational_mode  # type: bool
        # Indicates whether the route is advertised to the CEN instance. Valid values:
        # 
        # *   **Published**: The route is advertised to the CEN instance.
        # *   **NonPublished**: The route is not advertised to the CEN instance.
        self.publish_status = publish_status  # type: str
        # The type of the route. Valid values:
        # 
        # *   **CEN**: route that is advertised through CEN
        # *   **System**: system route
        # *   **Custom**: custom route
        self.route_type = route_type  # type: str

    def validate(self):
        if self.conflicts:
            self.conflicts.validate()

    def to_map(self):
        _map = super(DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_instance_route_table_id is not None:
            result['ChildInstanceRouteTableId'] = self.child_instance_route_table_id
        if self.conflicts is not None:
            result['Conflicts'] = self.conflicts.to_map()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.next_hop_id is not None:
            result['NextHopId'] = self.next_hop_id
        if self.next_hop_type is not None:
            result['NextHopType'] = self.next_hop_type
        if self.operational_mode is not None:
            result['OperationalMode'] = self.operational_mode
        if self.publish_status is not None:
            result['PublishStatus'] = self.publish_status
        if self.route_type is not None:
            result['RouteType'] = self.route_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChildInstanceRouteTableId') is not None:
            self.child_instance_route_table_id = m.get('ChildInstanceRouteTableId')
        if m.get('Conflicts') is not None:
            temp_model = DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntryConflicts()
            self.conflicts = temp_model.from_map(m['Conflicts'])
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('NextHopId') is not None:
            self.next_hop_id = m.get('NextHopId')
        if m.get('NextHopType') is not None:
            self.next_hop_type = m.get('NextHopType')
        if m.get('OperationalMode') is not None:
            self.operational_mode = m.get('OperationalMode')
        if m.get('PublishStatus') is not None:
            self.publish_status = m.get('PublishStatus')
        if m.get('RouteType') is not None:
            self.route_type = m.get('RouteType')
        return self


class DescribePublishedRouteEntriesResponseBodyPublishedRouteEntries(TeaModel):
    def __init__(self, published_route_entry=None):
        self.published_route_entry = published_route_entry  # type: list[DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntry]

    def validate(self):
        if self.published_route_entry:
            for k in self.published_route_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribePublishedRouteEntriesResponseBodyPublishedRouteEntries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PublishedRouteEntry'] = []
        if self.published_route_entry is not None:
            for k in self.published_route_entry:
                result['PublishedRouteEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.published_route_entry = []
        if m.get('PublishedRouteEntry') is not None:
            for k in m.get('PublishedRouteEntry'):
                temp_model = DescribePublishedRouteEntriesResponseBodyPublishedRouteEntriesPublishedRouteEntry()
                self.published_route_entry.append(temp_model.from_map(k))
        return self


class DescribePublishedRouteEntriesResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, published_route_entries=None, request_id=None,
                 total_count=None):
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # A list of routes.
        self.published_route_entries = published_route_entries  # type: DescribePublishedRouteEntriesResponseBodyPublishedRouteEntries
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.published_route_entries:
            self.published_route_entries.validate()

    def to_map(self):
        _map = super(DescribePublishedRouteEntriesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.published_route_entries is not None:
            result['PublishedRouteEntries'] = self.published_route_entries.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PublishedRouteEntries') is not None:
            temp_model = DescribePublishedRouteEntriesResponseBodyPublishedRouteEntries()
            self.published_route_entries = temp_model.from_map(m['PublishedRouteEntries'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribePublishedRouteEntriesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribePublishedRouteEntriesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribePublishedRouteEntriesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribePublishedRouteEntriesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRouteConflictRequest(TeaModel):
    def __init__(self, child_instance_id=None, child_instance_region_id=None, child_instance_route_table_id=None,
                 child_instance_type=None, destination_cidr_block=None, owner_account=None, owner_id=None, page_number=None,
                 page_size=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the network instance that you want to query.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The ID of the route table that is configured on the network instance.
        self.child_instance_route_table_id = child_instance_route_table_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**\
        # *   **VBR**\
        # *   **CCN**\
        self.child_instance_type = child_instance_type  # type: str
        # The destination CIDR block of the conflicting route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRouteConflictRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_route_table_id is not None:
            result['ChildInstanceRouteTableId'] = self.child_instance_route_table_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceRouteTableId') is not None:
            self.child_instance_route_table_id = m.get('ChildInstanceRouteTableId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeRouteConflictResponseBodyRouteConflictsRouteConflict(TeaModel):
    def __init__(self, destination_cidr_block=None, instance_id=None, instance_type=None, region_id=None,
                 status=None):
        # The destination CIDR block of the conflicting route.
        self.destination_cidr_block = destination_cidr_block  # type: str
        # The ID of the peer network instance on which conflicting routes are found.
        self.instance_id = instance_id  # type: str
        # The type of the peer network instance on which conflicting routes are found.
        # 
        # *   **VPC**\
        # *   **VBR**\
        # *   **CCN**\
        self.instance_type = instance_type  # type: str
        # The region ID of the peer network instance on which conflicting routes are found is deployed.
        self.region_id = region_id  # type: str
        # The cause of the route error. Valid values:
        # 
        # *   **conflict**: Routes have the same destination CIDR block.
        # *   **overflow**: The number of routes in the route table configured on another network instance has reached the upper limit.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRouteConflictResponseBodyRouteConflictsRouteConflict, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeRouteConflictResponseBodyRouteConflicts(TeaModel):
    def __init__(self, route_conflict=None):
        self.route_conflict = route_conflict  # type: list[DescribeRouteConflictResponseBodyRouteConflictsRouteConflict]

    def validate(self):
        if self.route_conflict:
            for k in self.route_conflict:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRouteConflictResponseBodyRouteConflicts, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RouteConflict'] = []
        if self.route_conflict is not None:
            for k in self.route_conflict:
                result['RouteConflict'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.route_conflict = []
        if m.get('RouteConflict') is not None:
            for k in m.get('RouteConflict'):
                temp_model = DescribeRouteConflictResponseBodyRouteConflictsRouteConflict()
                self.route_conflict.append(temp_model.from_map(k))
        return self


class DescribeRouteConflictResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, route_conflicts=None, total_count=None):
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The array of conflicting routes.
        self.route_conflicts = route_conflicts  # type: DescribeRouteConflictResponseBodyRouteConflicts
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.route_conflicts:
            self.route_conflicts.validate()

    def to_map(self):
        _map = super(DescribeRouteConflictResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_conflicts is not None:
            result['RouteConflicts'] = self.route_conflicts.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteConflicts') is not None:
            temp_model = DescribeRouteConflictResponseBodyRouteConflicts()
            self.route_conflicts = temp_model.from_map(m['RouteConflicts'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRouteConflictResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeRouteConflictResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRouteConflictResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRouteConflictResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRouteServicesInCenRequest(TeaModel):
    def __init__(self, access_region_id=None, cen_id=None, host=None, host_region_id=None, host_vpc_id=None,
                 owner_account=None, owner_id=None, page_number=None, page_size=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the region where the cloud service is accessed.
        self.access_region_id = access_region_id  # type: str
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The service address of the cloud service.
        # 
        # You can enter a domain name, an IP address, or a CIDR block.
        self.host = host  # type: str
        # The ID of the region where the cloud service is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.host_region_id = host_region_id  # type: str
        # The ID of the virtual private cloud (VPC) that is associated with the cloud service.
        self.host_vpc_id = host_vpc_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return per page. Default value: **10**. Valid values: **1** to **50**.
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRouteServicesInCenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_region_id is not None:
            result['AccessRegionId'] = self.access_region_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.host is not None:
            result['Host'] = self.host
        if self.host_region_id is not None:
            result['HostRegionId'] = self.host_region_id
        if self.host_vpc_id is not None:
            result['HostVpcId'] = self.host_vpc_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessRegionId') is not None:
            self.access_region_id = m.get('AccessRegionId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('HostRegionId') is not None:
            self.host_region_id = m.get('HostRegionId')
        if m.get('HostVpcId') is not None:
            self.host_vpc_id = m.get('HostVpcId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DescribeRouteServicesInCenResponseBodyRouteServiceEntriesRouteServiceEntryCidrs(TeaModel):
    def __init__(self, cidr=None):
        self.cidr = cidr  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRouteServicesInCenResponseBodyRouteServiceEntriesRouteServiceEntryCidrs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        return self


class DescribeRouteServicesInCenResponseBodyRouteServiceEntriesRouteServiceEntry(TeaModel):
    def __init__(self, access_region_id=None, cen_id=None, cidrs=None, description=None, host=None,
                 host_region_id=None, host_vpc_id=None, status=None):
        # The ID of the region where the cloud service is accessed.
        self.access_region_id = access_region_id  # type: str
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The service addresses of the cloud service.
        self.cidrs = cidrs  # type: DescribeRouteServicesInCenResponseBodyRouteServiceEntriesRouteServiceEntryCidrs
        # The description of the cloud service.
        self.description = description  # type: str
        # The service address of the cloud service.
        self.host = host  # type: str
        # The ID of the region where the cloud service is deployed.
        self.host_region_id = host_region_id  # type: str
        # The ID of the VPC that is associated with the cloud service.
        self.host_vpc_id = host_vpc_id  # type: str
        # The status of the cloud service. Valid values:
        # 
        # *   **Creating**: The cloud service is being created.
        # *   **Active**: The cloud service is available.
        # *   **Deleting**: The cloud service is being deleted.
        self.status = status  # type: str

    def validate(self):
        if self.cidrs:
            self.cidrs.validate()

    def to_map(self):
        _map = super(DescribeRouteServicesInCenResponseBodyRouteServiceEntriesRouteServiceEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_region_id is not None:
            result['AccessRegionId'] = self.access_region_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cidrs is not None:
            result['Cidrs'] = self.cidrs.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.host is not None:
            result['Host'] = self.host
        if self.host_region_id is not None:
            result['HostRegionId'] = self.host_region_id
        if self.host_vpc_id is not None:
            result['HostVpcId'] = self.host_vpc_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccessRegionId') is not None:
            self.access_region_id = m.get('AccessRegionId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('Cidrs') is not None:
            temp_model = DescribeRouteServicesInCenResponseBodyRouteServiceEntriesRouteServiceEntryCidrs()
            self.cidrs = temp_model.from_map(m['Cidrs'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('HostRegionId') is not None:
            self.host_region_id = m.get('HostRegionId')
        if m.get('HostVpcId') is not None:
            self.host_vpc_id = m.get('HostVpcId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeRouteServicesInCenResponseBodyRouteServiceEntries(TeaModel):
    def __init__(self, route_service_entry=None):
        self.route_service_entry = route_service_entry  # type: list[DescribeRouteServicesInCenResponseBodyRouteServiceEntriesRouteServiceEntry]

    def validate(self):
        if self.route_service_entry:
            for k in self.route_service_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeRouteServicesInCenResponseBodyRouteServiceEntries, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['RouteServiceEntry'] = []
        if self.route_service_entry is not None:
            for k in self.route_service_entry:
                result['RouteServiceEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.route_service_entry = []
        if m.get('RouteServiceEntry') is not None:
            for k in m.get('RouteServiceEntry'):
                temp_model = DescribeRouteServicesInCenResponseBodyRouteServiceEntriesRouteServiceEntry()
                self.route_service_entry.append(temp_model.from_map(k))
        return self


class DescribeRouteServicesInCenResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, route_service_entries=None,
                 total_count=None):
        # The number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The information about the cloud services.
        self.route_service_entries = route_service_entries  # type: DescribeRouteServicesInCenResponseBodyRouteServiceEntries
        # The total number of entries returned.
        self.total_count = total_count  # type: int

    def validate(self):
        if self.route_service_entries:
            self.route_service_entries.validate()

    def to_map(self):
        _map = super(DescribeRouteServicesInCenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.route_service_entries is not None:
            result['RouteServiceEntries'] = self.route_service_entries.to_map()
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RouteServiceEntries') is not None:
            temp_model = DescribeRouteServicesInCenResponseBodyRouteServiceEntries()
            self.route_service_entries = temp_model.from_map(m['RouteServiceEntries'])
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeRouteServicesInCenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeRouteServicesInCenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRouteServicesInCenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRouteServicesInCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTransitRouteTableAggregationRequest(TeaModel):
    def __init__(self, client_token=None, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_route_table_aggregation_cidr=None,
                 transit_route_table_id=None):
        self.client_token = client_token  # type: str
        self.max_results = max_results  # type: long
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.transit_route_table_aggregation_cidr = transit_route_table_aggregation_cidr  # type: str
        self.transit_route_table_id = transit_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTransitRouteTableAggregationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_route_table_aggregation_cidr is not None:
            result['TransitRouteTableAggregationCidr'] = self.transit_route_table_aggregation_cidr
        if self.transit_route_table_id is not None:
            result['TransitRouteTableId'] = self.transit_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouteTableAggregationCidr') is not None:
            self.transit_route_table_aggregation_cidr = m.get('TransitRouteTableAggregationCidr')
        if m.get('TransitRouteTableId') is not None:
            self.transit_route_table_id = m.get('TransitRouteTableId')
        return self


class DescribeTransitRouteTableAggregationResponseBodyData(TeaModel):
    def __init__(self, description=None, name=None, route_type=None, scop=None, status=None, tr_route_table_id=None,
                 transit_route_table_aggregation_cidr=None):
        self.description = description  # type: str
        self.name = name  # type: str
        self.route_type = route_type  # type: str
        self.scop = scop  # type: str
        self.status = status  # type: str
        self.tr_route_table_id = tr_route_table_id  # type: str
        self.transit_route_table_aggregation_cidr = transit_route_table_aggregation_cidr  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTransitRouteTableAggregationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.route_type is not None:
            result['RouteType'] = self.route_type
        if self.scop is not None:
            result['Scop'] = self.scop
        if self.status is not None:
            result['Status'] = self.status
        if self.tr_route_table_id is not None:
            result['TrRouteTableId'] = self.tr_route_table_id
        if self.transit_route_table_aggregation_cidr is not None:
            result['TransitRouteTableAggregationCidr'] = self.transit_route_table_aggregation_cidr
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RouteType') is not None:
            self.route_type = m.get('RouteType')
        if m.get('Scop') is not None:
            self.scop = m.get('Scop')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TrRouteTableId') is not None:
            self.tr_route_table_id = m.get('TrRouteTableId')
        if m.get('TransitRouteTableAggregationCidr') is not None:
            self.transit_route_table_aggregation_cidr = m.get('TransitRouteTableAggregationCidr')
        return self


class DescribeTransitRouteTableAggregationResponseBody(TeaModel):
    def __init__(self, count=None, data=None, next_token=None, request_id=None, total=None):
        self.count = count  # type: int
        self.data = data  # type: list[DescribeTransitRouteTableAggregationResponseBodyData]
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.total = total  # type: int

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeTransitRouteTableAggregationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeTransitRouteTableAggregationResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeTransitRouteTableAggregationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeTransitRouteTableAggregationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeTransitRouteTableAggregationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTransitRouteTableAggregationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeTransitRouteTableAggregationDetailRequest(TeaModel):
    def __init__(self, client_token=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, transit_route_table_aggregation_cidr=None, transit_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that the value is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId may be different for each request.
        self.client_token = client_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The destination CIDR block of the aggregate route.
        self.transit_route_table_aggregation_cidr = transit_route_table_aggregation_cidr  # type: str
        # The ID of the route table of the Enterprise Edition transit router.
        self.transit_route_table_id = transit_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTransitRouteTableAggregationDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_route_table_aggregation_cidr is not None:
            result['TransitRouteTableAggregationCidr'] = self.transit_route_table_aggregation_cidr
        if self.transit_route_table_id is not None:
            result['TransitRouteTableId'] = self.transit_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouteTableAggregationCidr') is not None:
            self.transit_route_table_aggregation_cidr = m.get('TransitRouteTableAggregationCidr')
        if m.get('TransitRouteTableId') is not None:
            self.transit_route_table_id = m.get('TransitRouteTableId')
        return self


class DescribeTransitRouteTableAggregationDetailResponseBodyData(TeaModel):
    def __init__(self, description=None, instance_id=None, status=None):
        # The error message returned if the configuration of the aggregate route fails.
        self.description = description  # type: str
        # The ID of the virtual private cloud (VPC) for which the aggregate route is configured.
        self.instance_id = instance_id  # type: str
        # The status of the aggregate route. Valid values:
        # 
        # *   **Configured**: The aggregate route is advertised to the VPC.
        # *   **Configuring**: The aggregate route is being advertised.
        # *   **ConfigFailed**: The aggregate route failed to be advertised.
        # *   **PartialConfigured**: Some content of the aggregate route failed to be advertised.
        # *   **Deleting**: The aggregate route is being deleted.
        self.status = status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeTransitRouteTableAggregationDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeTransitRouteTableAggregationDetailResponseBody(TeaModel):
    def __init__(self, count=None, data=None, request_id=None, total=None):
        # The number of entries returned on each page.
        self.count = count  # type: int
        # The configuration of the aggregate route.
        self.data = data  # type: list[DescribeTransitRouteTableAggregationDetailResponseBodyData]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total = total  # type: int

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(DescribeTransitRouteTableAggregationDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeTransitRouteTableAggregationDetailResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeTransitRouteTableAggregationDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeTransitRouteTableAggregationDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeTransitRouteTableAggregationDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeTransitRouteTableAggregationDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DetachCenChildInstanceRequest(TeaModel):
    def __init__(self, cen_id=None, cen_owner_id=None, child_instance_id=None, child_instance_owner_id=None,
                 child_instance_region_id=None, child_instance_type=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The ID of the Alibaba Cloud account to which the CEN instance belongs.
        self.cen_owner_id = cen_owner_id  # type: long
        # The ID of the network instance that you want to detach from the CEN instance.
        self.child_instance_id = child_instance_id  # type: str
        # The ID of the Alibaba Cloud account to which the network instance belongs.
        self.child_instance_owner_id = child_instance_owner_id  # type: long
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.child_instance_region_id = child_instance_region_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: virtual private cloud (VPC)
        # *   **VBR**: virtual border router (VBR)
        # *   **CCN**: Cloud Connect Network (CCN) instance
        self.child_instance_type = child_instance_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachCenChildInstanceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.child_instance_id is not None:
            result['ChildInstanceId'] = self.child_instance_id
        if self.child_instance_owner_id is not None:
            result['ChildInstanceOwnerId'] = self.child_instance_owner_id
        if self.child_instance_region_id is not None:
            result['ChildInstanceRegionId'] = self.child_instance_region_id
        if self.child_instance_type is not None:
            result['ChildInstanceType'] = self.child_instance_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('ChildInstanceId') is not None:
            self.child_instance_id = m.get('ChildInstanceId')
        if m.get('ChildInstanceOwnerId') is not None:
            self.child_instance_owner_id = m.get('ChildInstanceOwnerId')
        if m.get('ChildInstanceRegionId') is not None:
            self.child_instance_region_id = m.get('ChildInstanceRegionId')
        if m.get('ChildInstanceType') is not None:
            self.child_instance_type = m.get('ChildInstanceType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DetachCenChildInstanceResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DetachCenChildInstanceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DetachCenChildInstanceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DetachCenChildInstanceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DetachCenChildInstanceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DetachCenChildInstanceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableCenVbrHealthCheckRequest(TeaModel):
    def __init__(self, cen_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, vbr_instance_id=None, vbr_instance_owner_id=None, vbr_instance_region_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the VBR.
        self.vbr_instance_id = vbr_instance_id  # type: str
        # The ID of the Alibaba Cloud account to which the VBR belongs.
        # 
        # > This parameter is required if the VBR and the CEN instance belong to different Alibaba Cloud accounts.
        self.vbr_instance_owner_id = vbr_instance_owner_id  # type: long
        # The ID of the region where the VBR is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.vbr_instance_region_id = vbr_instance_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableCenVbrHealthCheckRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vbr_instance_id is not None:
            result['VbrInstanceId'] = self.vbr_instance_id
        if self.vbr_instance_owner_id is not None:
            result['VbrInstanceOwnerId'] = self.vbr_instance_owner_id
        if self.vbr_instance_region_id is not None:
            result['VbrInstanceRegionId'] = self.vbr_instance_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VbrInstanceId') is not None:
            self.vbr_instance_id = m.get('VbrInstanceId')
        if m.get('VbrInstanceOwnerId') is not None:
            self.vbr_instance_owner_id = m.get('VbrInstanceOwnerId')
        if m.get('VbrInstanceRegionId') is not None:
            self.vbr_instance_region_id = m.get('VbrInstanceRegionId')
        return self


class DisableCenVbrHealthCheckResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableCenVbrHealthCheckResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableCenVbrHealthCheckResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DisableCenVbrHealthCheckResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableCenVbrHealthCheckResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableCenVbrHealthCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisableTransitRouterRouteTablePropagationRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None,
                 transit_router_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to perform a dry run to check information such as the permissions and the instance status. Default values:
        # 
        # *   **false** (default): performs a dry run and sends the request.
        # *   **true**: performs a dry run. The system checks the required parameters and the request syntax. If the request fails the dry run, an error message is returned. If the request passes the dry run, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the route table of the Enterprise Edition transit router.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableTransitRouterRouteTablePropagationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        return self


class DisableTransitRouterRouteTablePropagationResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisableTransitRouterRouteTablePropagationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisableTransitRouterRouteTablePropagationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DisableTransitRouterRouteTablePropagationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisableTransitRouterRouteTablePropagationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisableTransitRouterRouteTablePropagationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DisassociateTransitRouterMulticastDomainRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None,
                 transit_router_multicast_domain_id=None, v_switch_ids=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The client token can contain only ASCII characters.
        self.client_token = client_token  # type: str
        # Specifies whether only to precheck the API request. Valid values:
        # 
        # *   **true**: prechecks the request but does not disassociate the vSwitch from the multicast domain. The system checks the required parameters, the request format, and the service limits. If the request fails the check, an error message is returned. If the request passes the check, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. The vSwitch is disassociated from the multicast domain after the request passes the precheck.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the virtual private cloud (VPC) connection.
        # 
        # A connection ID is generated after a VPC to which the vSwitch belongs is connected to a transit router.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str
        # A list of vSwitch IDs.
        self.v_switch_ids = v_switch_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisassociateTransitRouterMulticastDomainRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class DisassociateTransitRouterMulticastDomainResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DisassociateTransitRouterMulticastDomainResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DisassociateTransitRouterMulticastDomainResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DisassociateTransitRouterMulticastDomainResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DisassociateTransitRouterMulticastDomainResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DisassociateTransitRouterMulticastDomainResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DissociateTransitRouterAttachmentFromRouteTableRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None,
                 transit_router_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to check the request but not perform the operation. The system checks the permissions and the status of the specified instances. Valid values:
        # 
        # *   **false** (default): sends the request. If the request passes the precheck, the associated forwarding correlation is deleted.
        # *   **true**: sends a request for precheck only. The associated forwarding correlation is not deleted after the request passes the precheck. If you use this value, the system checks the required parameters and the request syntax. If the check fails, the corresponding error message is returned. If the request passes the check, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the route table of the Enterprise Edition transit router.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DissociateTransitRouterAttachmentFromRouteTableRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        return self


class DissociateTransitRouterAttachmentFromRouteTableResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DissociateTransitRouterAttachmentFromRouteTableResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DissociateTransitRouterAttachmentFromRouteTableResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DissociateTransitRouterAttachmentFromRouteTableResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DissociateTransitRouterAttachmentFromRouteTableResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DissociateTransitRouterAttachmentFromRouteTableResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableCenVbrHealthCheckRequest(TeaModel):
    def __init__(self, cen_id=None, health_check_interval=None, health_check_only=None,
                 health_check_source_ip=None, health_check_target_ip=None, healthy_threshold=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, vbr_instance_id=None, vbr_instance_owner_id=None,
                 vbr_instance_region_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The time interval at which probe packets are sent during a health check. Unit: seconds. Default value: **2**. Valid values: **2 to 3**.
        self.health_check_interval = health_check_interval  # type: int
        # Specifies whether to enable probing during the health check. Valid values:
        # 
        # *   **true**: yes
        # 
        #         If you enable probing, the system does not switch to another route if the detected route is not reachable. 
        # 
        #           Make sure that a redundant route is available. Otherwise, network disconnections may occur. 
        # 
        # *   **false** (default): no
        # 
        #         Probing is disabled by default. If a redundant route is specified, the system switches to the redundant route if the detected route is not reachable.
        self.health_check_only = health_check_only  # type: bool
        # The source IP address for the health check. You can set the source IP address in the following ways:
        # 
        # *   **Automatic IP Address** (recommended): The system automatically assigns an IP address from the 100.96.0.0/16 CIDR block.
        # *   **Custom IP Address**: You must specify an idle IP address from the 10.0.0.0/8, 192.168.0.0/16, or 172.16.0.0/12 CIDR block. The specified IP address cannot be the IP address of the VBR on the Alibaba Cloud side, the IP address of the VBR on the customer side, or other IP addresses with which the VBR communicates through the CEN instance.
        self.health_check_source_ip = health_check_source_ip  # type: str
        # The destination IP address for the health check.
        # 
        # Set the destination IP address to the IP address of the VBR on the customer side.
        self.health_check_target_ip = health_check_target_ip  # type: str
        # The number of probe packets that are sent during a health check. Unit: packets. Valid values: **3 to 8**. Default value: **8**.
        self.healthy_threshold = healthy_threshold  # type: int
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the VBR.
        self.vbr_instance_id = vbr_instance_id  # type: str
        # The ID of the Alibaba Cloud account to which the VBR belongs.
        # 
        # > This parameter is required if the VBR and the CEN instance belong to different Alibaba Cloud accounts.
        self.vbr_instance_owner_id = vbr_instance_owner_id  # type: long
        # The ID of the region where the VBR is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.vbr_instance_region_id = vbr_instance_region_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableCenVbrHealthCheckRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.health_check_interval is not None:
            result['HealthCheckInterval'] = self.health_check_interval
        if self.health_check_only is not None:
            result['HealthCheckOnly'] = self.health_check_only
        if self.health_check_source_ip is not None:
            result['HealthCheckSourceIp'] = self.health_check_source_ip
        if self.health_check_target_ip is not None:
            result['HealthCheckTargetIp'] = self.health_check_target_ip
        if self.healthy_threshold is not None:
            result['HealthyThreshold'] = self.healthy_threshold
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vbr_instance_id is not None:
            result['VbrInstanceId'] = self.vbr_instance_id
        if self.vbr_instance_owner_id is not None:
            result['VbrInstanceOwnerId'] = self.vbr_instance_owner_id
        if self.vbr_instance_region_id is not None:
            result['VbrInstanceRegionId'] = self.vbr_instance_region_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('HealthCheckInterval') is not None:
            self.health_check_interval = m.get('HealthCheckInterval')
        if m.get('HealthCheckOnly') is not None:
            self.health_check_only = m.get('HealthCheckOnly')
        if m.get('HealthCheckSourceIp') is not None:
            self.health_check_source_ip = m.get('HealthCheckSourceIp')
        if m.get('HealthCheckTargetIp') is not None:
            self.health_check_target_ip = m.get('HealthCheckTargetIp')
        if m.get('HealthyThreshold') is not None:
            self.healthy_threshold = m.get('HealthyThreshold')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VbrInstanceId') is not None:
            self.vbr_instance_id = m.get('VbrInstanceId')
        if m.get('VbrInstanceOwnerId') is not None:
            self.vbr_instance_owner_id = m.get('VbrInstanceOwnerId')
        if m.get('VbrInstanceRegionId') is not None:
            self.vbr_instance_region_id = m.get('VbrInstanceRegionId')
        return self


class EnableCenVbrHealthCheckResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableCenVbrHealthCheckResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableCenVbrHealthCheckResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EnableCenVbrHealthCheckResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableCenVbrHealthCheckResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableCenVbrHealthCheckResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EnableTransitRouterRouteTablePropagationRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_attachment_id=None,
                 transit_router_route_table_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The client token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, **ClientToken** is set to the value of **RequestId**. The value of **RequestId** for each API request may be different.
        self.client_token = client_token  # type: str
        # Specifies whether to check the request but not perform the operation. The system checks the permissions and the status of the specified instances. Valid values:
        # 
        # *   **false** (default): sends the request. If the request passes the precheck, the route learning correlation is created.
        # *   **true**: sends a request for precheck only. No route learning correlation is created after the request passes the precheck. If you use this value, the system checks whether the required parameters are set, and whether the request syntax is valid. If the request fails to pass the precheck, an error message is returned. If the request passes the precheck, the system returns the ID of the request.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the route table of the Enterprise Edition transit router.
        self.transit_router_route_table_id = transit_router_route_table_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableTransitRouterRouteTablePropagationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_route_table_id is not None:
            result['TransitRouterRouteTableId'] = self.transit_router_route_table_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterRouteTableId') is not None:
            self.transit_router_route_table_id = m.get('TransitRouterRouteTableId')
        return self


class EnableTransitRouterRouteTablePropagationResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EnableTransitRouterRouteTablePropagationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class EnableTransitRouterRouteTablePropagationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EnableTransitRouterRouteTablePropagationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EnableTransitRouterRouteTablePropagationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EnableTransitRouterRouteTablePropagationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GrantInstanceToTransitRouterRequest(TeaModel):
    def __init__(self, cen_id=None, cen_owner_id=None, instance_id=None, instance_type=None, order_type=None,
                 owner_account=None, owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance to which the transit router belongs.
        self.cen_id = cen_id  # type: str
        # The ID of the Alibaba Cloud account to which the CEN instance belongs.
        self.cen_owner_id = cen_owner_id  # type: long
        # The ID of the network instance.
        self.instance_id = instance_id  # type: str
        # The type of the network instance. Valid values:
        # 
        # *   **VPC**: VPC
        # *   **ExpressConnect**: VBR
        # *   **VPN**: IPsec-VPN connection
        self.instance_type = instance_type  # type: str
        # The entity that pays the fees of the network instance. Valid values:
        # 
        # *   **PayByCenOwner**: the Alibaba Cloud account that owns the CEN instance.
        # *   **PayByResourceOwner**: the Alibaba Cloud account that owns the network instance.
        self.order_type = order_type  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the network instance is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GrantInstanceToTransitRouterRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.cen_owner_id is not None:
            result['CenOwnerId'] = self.cen_owner_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.order_type is not None:
            result['OrderType'] = self.order_type
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CenOwnerId') is not None:
            self.cen_owner_id = m.get('CenOwnerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('OrderType') is not None:
            self.order_type = m.get('OrderType')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GrantInstanceToTransitRouterResponseBody(TeaModel):
    def __init__(self, request_id=None):
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GrantInstanceToTransitRouterResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class GrantInstanceToTransitRouterResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GrantInstanceToTransitRouterResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GrantInstanceToTransitRouterResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GrantInstanceToTransitRouterResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCenChildInstanceRouteEntriesToAttachmentRequestRouteFilter(TeaModel):
    def __init__(self, key=None, value=None):
        self.key = key  # type: str
        self.value = value  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCenChildInstanceRouteEntriesToAttachmentRequestRouteFilter, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListCenChildInstanceRouteEntriesToAttachmentRequest(TeaModel):
    def __init__(self, cen_id=None, child_instance_route_table_id=None, max_results=None, next_token=None,
                 owner_account=None, owner_id=None, resource_owner_account=None, resource_owner_id=None, route_filter=None,
                 service_type=None, transit_router_attachment_id=None):
        self.cen_id = cen_id  # type: str
        self.child_instance_route_table_id = child_instance_route_table_id  # type: str
        self.max_results = max_results  # type: int
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.route_filter = route_filter  # type: list[ListCenChildInstanceRouteEntriesToAttachmentRequestRouteFilter]
        self.service_type = service_type  # type: str
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        if self.route_filter:
            for k in self.route_filter:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCenChildInstanceRouteEntriesToAttachmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_route_table_id is not None:
            result['ChildInstanceRouteTableId'] = self.child_instance_route_table_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['RouteFilter'] = []
        if self.route_filter is not None:
            for k in self.route_filter:
                result['RouteFilter'].append(k.to_map() if k else None)
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceRouteTableId') is not None:
            self.child_instance_route_table_id = m.get('ChildInstanceRouteTableId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.route_filter = []
        if m.get('RouteFilter') is not None:
            for k in m.get('RouteFilter'):
                temp_model = ListCenChildInstanceRouteEntriesToAttachmentRequestRouteFilter()
                self.route_filter.append(temp_model.from_map(k))
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class ListCenChildInstanceRouteEntriesToAttachmentResponseBodyRouteEntry(TeaModel):
    def __init__(self, cen_id=None, child_instance_route_table_id=None, destination_cidr_block=None,
                 service_type=None, status=None, transit_router_attachment_id=None):
        self.cen_id = cen_id  # type: str
        self.child_instance_route_table_id = child_instance_route_table_id  # type: str
        self.destination_cidr_block = destination_cidr_block  # type: str
        self.service_type = service_type  # type: str
        self.status = status  # type: str
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCenChildInstanceRouteEntriesToAttachmentResponseBodyRouteEntry, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.child_instance_route_table_id is not None:
            result['ChildInstanceRouteTableId'] = self.child_instance_route_table_id
        if self.destination_cidr_block is not None:
            result['DestinationCidrBlock'] = self.destination_cidr_block
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        if self.status is not None:
            result['Status'] = self.status
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ChildInstanceRouteTableId') is not None:
            self.child_instance_route_table_id = m.get('ChildInstanceRouteTableId')
        if m.get('DestinationCidrBlock') is not None:
            self.destination_cidr_block = m.get('DestinationCidrBlock')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        return self


class ListCenChildInstanceRouteEntriesToAttachmentResponseBody(TeaModel):
    def __init__(self, next_token=None, request_id=None, route_entry=None):
        self.next_token = next_token  # type: str
        self.request_id = request_id  # type: str
        self.route_entry = route_entry  # type: list[ListCenChildInstanceRouteEntriesToAttachmentResponseBodyRouteEntry]

    def validate(self):
        if self.route_entry:
            for k in self.route_entry:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCenChildInstanceRouteEntriesToAttachmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['RouteEntry'] = []
        if self.route_entry is not None:
            for k in self.route_entry:
                result['RouteEntry'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.route_entry = []
        if m.get('RouteEntry') is not None:
            for k in m.get('RouteEntry'):
                temp_model = ListCenChildInstanceRouteEntriesToAttachmentResponseBodyRouteEntry()
                self.route_entry.append(temp_model.from_map(k))
        return self


class ListCenChildInstanceRouteEntriesToAttachmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCenChildInstanceRouteEntriesToAttachmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCenChildInstanceRouteEntriesToAttachmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCenChildInstanceRouteEntriesToAttachmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCenInterRegionTrafficQosPoliciesRequest(TeaModel):
    def __init__(self, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, traffic_qos_policy_description=None, traffic_qos_policy_id=None,
                 traffic_qos_policy_name=None, transit_router_attachment_id=None, transit_router_id=None):
        # The number of entries to return on each page. Valid values: **1** to **100**. Default value: **20**.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If this is your first query or no subsequent query is to be sent, ignore this parameter.
        # *   If a next query is to be sent, set the value to the value of **NextToken** that is returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The description of the QoS policy.
        # 
        # The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        self.traffic_qos_policy_description = traffic_qos_policy_description  # type: str
        # The ID of the QoS policy.
        self.traffic_qos_policy_id = traffic_qos_policy_id  # type: str
        # The name of the QoS policy.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). It must start with a letter.
        self.traffic_qos_policy_name = traffic_qos_policy_name  # type: str
        # The ID of the inter-region connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_qos_policy_description is not None:
            result['TrafficQosPolicyDescription'] = self.traffic_qos_policy_description
        if self.traffic_qos_policy_id is not None:
            result['TrafficQosPolicyId'] = self.traffic_qos_policy_id
        if self.traffic_qos_policy_name is not None:
            result['TrafficQosPolicyName'] = self.traffic_qos_policy_name
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficQosPolicyDescription') is not None:
            self.traffic_qos_policy_description = m.get('TrafficQosPolicyDescription')
        if m.get('TrafficQosPolicyId') is not None:
            self.traffic_qos_policy_id = m.get('TrafficQosPolicyId')
        if m.get('TrafficQosPolicyName') is not None:
            self.traffic_qos_policy_name = m.get('TrafficQosPolicyName')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListCenInterRegionTrafficQosPoliciesResponseBodyTrafficQosPoliciesTrafficQosQueues(TeaModel):
    def __init__(self, dscps=None, qos_queue_description=None, qos_queue_id=None, qos_queue_name=None,
                 remain_bandwidth_percent=None):
        # The differentiated services code point (DSCP) value used to match packets in the queue.
        self.dscps = dscps  # type: list[int]
        # The description of the queue.
        self.qos_queue_description = qos_queue_description  # type: str
        # The ID of the queue.
        self.qos_queue_id = qos_queue_id  # type: str
        # The name of the queue.
        self.qos_queue_name = qos_queue_name  # type: str
        # The percentage of the inter-region bandwidth that can be used by the queue.
        self.remain_bandwidth_percent = remain_bandwidth_percent  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosPoliciesResponseBodyTrafficQosPoliciesTrafficQosQueues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dscps is not None:
            result['Dscps'] = self.dscps
        if self.qos_queue_description is not None:
            result['QosQueueDescription'] = self.qos_queue_description
        if self.qos_queue_id is not None:
            result['QosQueueId'] = self.qos_queue_id
        if self.qos_queue_name is not None:
            result['QosQueueName'] = self.qos_queue_name
        if self.remain_bandwidth_percent is not None:
            result['RemainBandwidthPercent'] = self.remain_bandwidth_percent
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dscps') is not None:
            self.dscps = m.get('Dscps')
        if m.get('QosQueueDescription') is not None:
            self.qos_queue_description = m.get('QosQueueDescription')
        if m.get('QosQueueId') is not None:
            self.qos_queue_id = m.get('QosQueueId')
        if m.get('QosQueueName') is not None:
            self.qos_queue_name = m.get('QosQueueName')
        if m.get('RemainBandwidthPercent') is not None:
            self.remain_bandwidth_percent = m.get('RemainBandwidthPercent')
        return self


class ListCenInterRegionTrafficQosPoliciesResponseBodyTrafficQosPolicies(TeaModel):
    def __init__(self, traffic_qos_policy_description=None, traffic_qos_policy_id=None,
                 traffic_qos_policy_name=None, traffic_qos_policy_status=None, traffic_qos_queues=None, transit_router_attachment_id=None,
                 transit_router_id=None):
        # The description of the QoS policy.
        self.traffic_qos_policy_description = traffic_qos_policy_description  # type: str
        # The ID of the QoS policy.
        self.traffic_qos_policy_id = traffic_qos_policy_id  # type: str
        # The name of the QoS policy.
        self.traffic_qos_policy_name = traffic_qos_policy_name  # type: str
        # The status of the QoS policy. Valid values:
        # 
        # *   **Creating**: The QoS policy is being created.
        # *   **Active**: The QoS policy is available.
        # *   **Modifying**: The QoS policy is being modified
        # *   **Deleting**: The QoS policy is being deleted.
        # *   **Deleted**: The QoS policy is deleted.
        self.traffic_qos_policy_status = traffic_qos_policy_status  # type: str
        # A list of queues.
        self.traffic_qos_queues = traffic_qos_queues  # type: list[ListCenInterRegionTrafficQosPoliciesResponseBodyTrafficQosPoliciesTrafficQosQueues]
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        if self.traffic_qos_queues:
            for k in self.traffic_qos_queues:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosPoliciesResponseBodyTrafficQosPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.traffic_qos_policy_description is not None:
            result['TrafficQosPolicyDescription'] = self.traffic_qos_policy_description
        if self.traffic_qos_policy_id is not None:
            result['TrafficQosPolicyId'] = self.traffic_qos_policy_id
        if self.traffic_qos_policy_name is not None:
            result['TrafficQosPolicyName'] = self.traffic_qos_policy_name
        if self.traffic_qos_policy_status is not None:
            result['TrafficQosPolicyStatus'] = self.traffic_qos_policy_status
        result['TrafficQosQueues'] = []
        if self.traffic_qos_queues is not None:
            for k in self.traffic_qos_queues:
                result['TrafficQosQueues'].append(k.to_map() if k else None)
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('TrafficQosPolicyDescription') is not None:
            self.traffic_qos_policy_description = m.get('TrafficQosPolicyDescription')
        if m.get('TrafficQosPolicyId') is not None:
            self.traffic_qos_policy_id = m.get('TrafficQosPolicyId')
        if m.get('TrafficQosPolicyName') is not None:
            self.traffic_qos_policy_name = m.get('TrafficQosPolicyName')
        if m.get('TrafficQosPolicyStatus') is not None:
            self.traffic_qos_policy_status = m.get('TrafficQosPolicyStatus')
        self.traffic_qos_queues = []
        if m.get('TrafficQosQueues') is not None:
            for k in m.get('TrafficQosQueues'):
                temp_model = ListCenInterRegionTrafficQosPoliciesResponseBodyTrafficQosPoliciesTrafficQosQueues()
                self.traffic_qos_queues.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListCenInterRegionTrafficQosPoliciesResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, request_id=None, total_count=None,
                 traffic_qos_policies=None):
        # The number of entries returned per page.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query.
        # 
        # *   If **NextToken** was not returned in the previous query, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int
        # A list of QoS policies.
        self.traffic_qos_policies = traffic_qos_policies  # type: list[ListCenInterRegionTrafficQosPoliciesResponseBodyTrafficQosPolicies]

    def validate(self):
        if self.traffic_qos_policies:
            for k in self.traffic_qos_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TrafficQosPolicies'] = []
        if self.traffic_qos_policies is not None:
            for k in self.traffic_qos_policies:
                result['TrafficQosPolicies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.traffic_qos_policies = []
        if m.get('TrafficQosPolicies') is not None:
            for k in m.get('TrafficQosPolicies'):
                temp_model = ListCenInterRegionTrafficQosPoliciesResponseBodyTrafficQosPolicies()
                self.traffic_qos_policies.append(temp_model.from_map(k))
        return self


class ListCenInterRegionTrafficQosPoliciesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCenInterRegionTrafficQosPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCenInterRegionTrafficQosPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListCenInterRegionTrafficQosQueuesRequest(TeaModel):
    def __init__(self, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, traffic_qos_policy_id=None, traffic_qos_queue_description=None,
                 traffic_qos_queue_id=None, traffic_qos_queue_name=None, transit_router_attachment_id=None, transit_router_id=None):
        # The number of entries to return on each page. Valid values: 1 to 100. Default value: 20.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query.
        # 
        # *   If **NextToken** was not returned in the previous query, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the QoS policy.
        self.traffic_qos_policy_id = traffic_qos_policy_id  # type: str
        # The description of the queue.
        self.traffic_qos_queue_description = traffic_qos_queue_description  # type: str
        # The ID of the queue.
        self.traffic_qos_queue_id = traffic_qos_queue_id  # type: str
        # The name of the queue.
        self.traffic_qos_queue_name = traffic_qos_queue_name  # type: str
        # The ID of the inter-region connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosQueuesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_qos_policy_id is not None:
            result['TrafficQosPolicyId'] = self.traffic_qos_policy_id
        if self.traffic_qos_queue_description is not None:
            result['TrafficQosQueueDescription'] = self.traffic_qos_queue_description
        if self.traffic_qos_queue_id is not None:
            result['TrafficQosQueueId'] = self.traffic_qos_queue_id
        if self.traffic_qos_queue_name is not None:
            result['TrafficQosQueueName'] = self.traffic_qos_queue_name
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficQosPolicyId') is not None:
            self.traffic_qos_policy_id = m.get('TrafficQosPolicyId')
        if m.get('TrafficQosQueueDescription') is not None:
            self.traffic_qos_queue_description = m.get('TrafficQosQueueDescription')
        if m.get('TrafficQosQueueId') is not None:
            self.traffic_qos_queue_id = m.get('TrafficQosQueueId')
        if m.get('TrafficQosQueueName') is not None:
            self.traffic_qos_queue_name = m.get('TrafficQosQueueName')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListCenInterRegionTrafficQosQueuesResponseBodyTrafficQosQueues(TeaModel):
    def __init__(self, dscps=None, remain_bandwidth_percent=None, status=None, traffic_qos_policy_id=None,
                 traffic_qos_queue_description=None, traffic_qos_queue_id=None, traffic_qos_queue_name=None, transit_router_attachment_id=None,
                 transit_router_id=None):
        # The differentiated services code point (DSCP) value that matches the current queue.
        self.dscps = dscps  # type: list[int]
        # The percentage of bandwidth resources that can be allocated to the current queue.
        # 
        # Each QoS policy supports up to three queues. You can specify a percentage of bandwidth resources for each queue.
        # 
        # For example, a value of **1** indicates that 1 percent of bandwidth resources can be allocated to the queue.
        self.remain_bandwidth_percent = remain_bandwidth_percent  # type: int
        # The status of the queue. Valid values:
        # 
        # **Creating**: The queue is being created. **Active**: The queue is available. **Deleting**: The queue is being deleted.
        self.status = status  # type: str
        # The ID of the QoS policy.
        self.traffic_qos_policy_id = traffic_qos_policy_id  # type: str
        # The description of the queue.
        self.traffic_qos_queue_description = traffic_qos_queue_description  # type: str
        # The ID of the queue.
        self.traffic_qos_queue_id = traffic_qos_queue_id  # type: str
        # The name of the queue.
        self.traffic_qos_queue_name = traffic_qos_queue_name  # type: str
        # The ID of the inter-region connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosQueuesResponseBodyTrafficQosQueues, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dscps is not None:
            result['Dscps'] = self.dscps
        if self.remain_bandwidth_percent is not None:
            result['RemainBandwidthPercent'] = self.remain_bandwidth_percent
        if self.status is not None:
            result['Status'] = self.status
        if self.traffic_qos_policy_id is not None:
            result['TrafficQosPolicyId'] = self.traffic_qos_policy_id
        if self.traffic_qos_queue_description is not None:
            result['TrafficQosQueueDescription'] = self.traffic_qos_queue_description
        if self.traffic_qos_queue_id is not None:
            result['TrafficQosQueueId'] = self.traffic_qos_queue_id
        if self.traffic_qos_queue_name is not None:
            result['TrafficQosQueueName'] = self.traffic_qos_queue_name
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Dscps') is not None:
            self.dscps = m.get('Dscps')
        if m.get('RemainBandwidthPercent') is not None:
            self.remain_bandwidth_percent = m.get('RemainBandwidthPercent')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TrafficQosPolicyId') is not None:
            self.traffic_qos_policy_id = m.get('TrafficQosPolicyId')
        if m.get('TrafficQosQueueDescription') is not None:
            self.traffic_qos_queue_description = m.get('TrafficQosQueueDescription')
        if m.get('TrafficQosQueueId') is not None:
            self.traffic_qos_queue_id = m.get('TrafficQosQueueId')
        if m.get('TrafficQosQueueName') is not None:
            self.traffic_qos_queue_name = m.get('TrafficQosQueueName')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListCenInterRegionTrafficQosQueuesResponseBody(TeaModel):
    def __init__(self, next_token=None, request_id=None, traffic_qos_queues=None):
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If **NextToken** was not returned, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # A list of queues.
        self.traffic_qos_queues = traffic_qos_queues  # type: list[ListCenInterRegionTrafficQosQueuesResponseBodyTrafficQosQueues]

    def validate(self):
        if self.traffic_qos_queues:
            for k in self.traffic_qos_queues:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosQueuesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TrafficQosQueues'] = []
        if self.traffic_qos_queues is not None:
            for k in self.traffic_qos_queues:
                result['TrafficQosQueues'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.traffic_qos_queues = []
        if m.get('TrafficQosQueues') is not None:
            for k in m.get('TrafficQosQueues'):
                temp_model = ListCenInterRegionTrafficQosQueuesResponseBodyTrafficQosQueues()
                self.traffic_qos_queues.append(temp_model.from_map(k))
        return self


class ListCenInterRegionTrafficQosQueuesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListCenInterRegionTrafficQosQueuesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListCenInterRegionTrafficQosQueuesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListCenInterRegionTrafficQosQueuesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGrantVSwitchEnisRequest(TeaModel):
    def __init__(self, cen_id=None, owner_account=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None, v_switch_id=None, vpc_id=None):
        # The ID of the CEN instance to which the VPC is attached.
        self.cen_id = cen_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of a vSwitch in the VPC.
        # 
        # You can specify only one vSwitch in each call.
        self.v_switch_id = v_switch_id  # type: str
        # The ID of the VPC.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListGrantVSwitchEnisRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class ListGrantVSwitchEnisResponseBodyGrantVSwitchEnis(TeaModel):
    def __init__(self, description=None, network_interface_id=None, transit_router_flag=None, v_switch_id=None,
                 vpc_id=None):
        # The description of the ENI.
        self.description = description  # type: str
        # The ID of the ENI.
        self.network_interface_id = network_interface_id  # type: str
        # Indicates whether the ENI is created by a transit router. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        # 
        # ENIs that are created by transit routers cannot be used as multicast sources or members.
        self.transit_router_flag = transit_router_flag  # type: bool
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id  # type: str
        # The ID of the VPC.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListGrantVSwitchEnisResponseBodyGrantVSwitchEnis, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.transit_router_flag is not None:
            result['TransitRouterFlag'] = self.transit_router_flag
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('TransitRouterFlag') is not None:
            self.transit_router_flag = m.get('TransitRouterFlag')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class ListGrantVSwitchEnisResponseBody(TeaModel):
    def __init__(self, grant_vswitch_enis=None, request_id=None, total_count=None):
        # The list of ENIs.
        self.grant_vswitch_enis = grant_vswitch_enis  # type: list[ListGrantVSwitchEnisResponseBodyGrantVSwitchEnis]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The number of entries returned.
        self.total_count = total_count  # type: str

    def validate(self):
        if self.grant_vswitch_enis:
            for k in self.grant_vswitch_enis:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListGrantVSwitchEnisResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GrantVSwitchEnis'] = []
        if self.grant_vswitch_enis is not None:
            for k in self.grant_vswitch_enis:
                result['GrantVSwitchEnis'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.grant_vswitch_enis = []
        if m.get('GrantVSwitchEnis') is not None:
            for k in m.get('GrantVSwitchEnis'):
                temp_model = ListGrantVSwitchEnisResponseBodyGrantVSwitchEnis()
                self.grant_vswitch_enis.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListGrantVSwitchEnisResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListGrantVSwitchEnisResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListGrantVSwitchEnisResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGrantVSwitchEnisResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListGrantVSwitchesToCenRequest(TeaModel):
    def __init__(self, cen_id=None, owner_account=None, owner_id=None, page_number=None, page_size=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, vpc_id=None, zone_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of the page to return. Default value: **1**.
        self.page_number = page_number  # type: int
        # The number of entries to return on each page. Valid values: **1** to **50**. Default value: **10**.
        self.page_size = page_size  # type: int
        # The ID of the region where the VPC is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the VPC.
        self.vpc_id = vpc_id  # type: str
        # The ID of the zone where the instance resides.
        # 
        # *   If you specify a zone ID, the system queries the information about the vSwitches in the specified zone.
        # *   If you do not specify a zone ID, the system queries the information about the vSwitches in all zones.
        # 
        # You can call the [DescribeZones](~~36064~~) operation to query the most recent zone list.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListGrantVSwitchesToCenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class ListGrantVSwitchesToCenResponseBodyVSwitches(TeaModel):
    def __init__(self, v_switch_id=None, v_switch_name=None, vpc_id=None, zone_id=None):
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id  # type: str
        self.v_switch_name = v_switch_name  # type: str
        # The ID of the VPC to which the vSwitch belongs.
        self.vpc_id = vpc_id  # type: str
        # The ID of the zone where the vSwitch is deployed.
        self.zone_id = zone_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListGrantVSwitchesToCenResponseBodyVSwitches, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.zone_id is not None:
            result['ZoneId'] = self.zone_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('ZoneId') is not None:
            self.zone_id = m.get('ZoneId')
        return self


class ListGrantVSwitchesToCenResponseBody(TeaModel):
    def __init__(self, page_number=None, page_size=None, request_id=None, total_count=None, v_switches=None):
        # The page number of the returned page.
        self.page_number = page_number  # type: int
        # The number of entries returned per page.
        self.page_size = page_size  # type: int
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int
        # A list of vSwitches.
        self.v_switches = v_switches  # type: list[ListGrantVSwitchesToCenResponseBodyVSwitches]

    def validate(self):
        if self.v_switches:
            for k in self.v_switches:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListGrantVSwitchesToCenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['VSwitches'] = []
        if self.v_switches is not None:
            for k in self.v_switches:
                result['VSwitches'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.v_switches = []
        if m.get('VSwitches') is not None:
            for k in m.get('VSwitches'):
                temp_model = ListGrantVSwitchesToCenResponseBodyVSwitches()
                self.v_switches.append(temp_model.from_map(k))
        return self


class ListGrantVSwitchesToCenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListGrantVSwitchesToCenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListGrantVSwitchesToCenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListGrantVSwitchesToCenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTagResourcesRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key.
        # 
        # The tag key cannot exceed 64 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag value.
        # 
        # The tag value cannot exceed 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.
        # 
        # You can specify at most 20 tag values.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagResourcesRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTagResourcesRequest(TeaModel):
    def __init__(self, next_token=None, owner_account=None, owner_id=None, page_size=None, region_id=None,
                 resource_id=None, resource_owner_account=None, resource_owner_id=None, resource_type=None, tag=None):
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If this is your first query and no next queries are to be sent, ignore this parameter.
        # *   If a subsequent query is to be sent, set the parameter to the value of NextToken that is returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The number of entries to return on each page. Valid values: **1** to **50**. Default value: **10**.
        self.page_size = page_size  # type: int
        # The ID of the region where the resource is deployed.
        # 
        # You can ignore this parameter if ResourceType is set to Cen or BandwidthPackage.
        self.region_id = region_id  # type: str
        # The IDs of the CEN instances.
        # 
        # You can specify at most 20 IDs in each call.
        self.resource_id = resource_id  # type: list[str]
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The type of the resource to which you want to add the tag. Valid values:
        # 
        # **Cen**: CEN instance
        # 
        # **BandwidthPackage**: bandwidth plan
        # 
        # **TransitRouter**: transit router
        # 
        # **TransitRouterVpcAttachment**: virtual private cloud (VPC) connection
        # 
        # **TransitRouterVbrAttachment**: virtual border router (VBR) connection
        # 
        # **TransitRouterPeerAttachment**: inter-region connection
        # 
        # **TransitRouterVpnAttachment**: VPN connection
        # 
        # **TransitRouterRouteTable**: route table
        # 
        # **Flowlog**: flow log
        # 
        # **TransitRouterMulticastDomain**: multicast domain
        self.resource_type = resource_type  # type: str
        # The information about the tags that are added to the CEN instance.
        # 
        # You can query at most 20 tags in each call.
        self.tag = tag  # type: list[ListTagResourcesRequestTag]

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTagResourcesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListTagResourcesRequestTag()
                self.tag.append(temp_model.from_map(k))
        return self


class ListTagResourcesResponseBodyTagResourcesTagResource(TeaModel):
    def __init__(self, resource_id=None, resource_type=None, tag_key=None, tag_value=None):
        # The ID of the CEN instance.
        self.resource_id = resource_id  # type: str
        # The type of the resource. Valid values:
        # 
        # **Cen**: CEN instance
        # 
        # **BandwidthPackage**: bandwidth plan
        # 
        # **TransitRouter**: transit router
        # 
        # **TransitRouterVpcAttachment**: virtual private cloud (VPC) connection
        # 
        # **TransitRouterVbrAttachment**: virtual border router (VBR) connection
        # 
        # **TransitRouterPeerAttachment**: inter-region connection
        # 
        # **TransitRouterVpnAttachment**: VPN connection
        # 
        # **TransitRouterRouteTable**: route table
        # 
        # **Flowlog**: flow log
        # 
        # **TransitRouterMulticastDomain**: multicast domain
        self.resource_type = resource_type  # type: str
        # The tag key.
        self.tag_key = tag_key  # type: str
        # The tag value.
        self.tag_value = tag_value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTagResourcesResponseBodyTagResourcesTagResource, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.tag_key is not None:
            result['TagKey'] = self.tag_key
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TagKey') is not None:
            self.tag_key = m.get('TagKey')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class ListTagResourcesResponseBodyTagResources(TeaModel):
    def __init__(self, tag_resource=None):
        self.tag_resource = tag_resource  # type: list[ListTagResourcesResponseBodyTagResourcesTagResource]

    def validate(self):
        if self.tag_resource:
            for k in self.tag_resource:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTagResourcesResponseBodyTagResources, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['TagResource'] = []
        if self.tag_resource is not None:
            for k in self.tag_resource:
                result['TagResource'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.tag_resource = []
        if m.get('TagResource') is not None:
            for k in m.get('TagResource'):
                temp_model = ListTagResourcesResponseBodyTagResourcesTagResource()
                self.tag_resource.append(temp_model.from_map(k))
        return self


class ListTagResourcesResponseBody(TeaModel):
    def __init__(self, next_token=None, request_id=None, tag_resources=None):
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If **NextToken** was not returned, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # A list of resources and tags.
        self.tag_resources = tag_resources  # type: ListTagResourcesResponseBodyTagResources

    def validate(self):
        if self.tag_resources:
            self.tag_resources.validate()

    def to_map(self):
        _map = super(ListTagResourcesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.tag_resources is not None:
            result['TagResources'] = self.tag_resources.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TagResources') is not None:
            temp_model = ListTagResourcesResponseBodyTagResources()
            self.tag_resources = temp_model.from_map(m['TagResources'])
        return self


class ListTagResourcesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTagResourcesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTagResourcesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTagResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTrafficMarkingPoliciesRequest(TeaModel):
    def __init__(self, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, traffic_marking_policy_description=None,
                 traffic_marking_policy_id=None, traffic_marking_policy_name=None, transit_router_id=None):
        # The number of entries to return on each page. Valid values: **1** to **100**. Default value: **20**.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If this is your first query or no subsequent query is to be sent, ignore this parameter.
        # *   If a next query is to be sent, set the value to the value of **NextToken** that is returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The description of the traffic marking policy.
        # 
        # The description must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The description must start with a letter.
        self.traffic_marking_policy_description = traffic_marking_policy_description  # type: str
        # The ID of the traffic marking policy.
        self.traffic_marking_policy_id = traffic_marking_policy_id  # type: str
        # The name of the traffic marking policy.
        # 
        # The name must be 2 to 128 characters in length, and can contain letters, digits, underscores (\_), and hyphens (-). The name must start with a letter.
        self.traffic_marking_policy_name = traffic_marking_policy_name  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTrafficMarkingPoliciesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.traffic_marking_policy_description is not None:
            result['TrafficMarkingPolicyDescription'] = self.traffic_marking_policy_description
        if self.traffic_marking_policy_id is not None:
            result['TrafficMarkingPolicyId'] = self.traffic_marking_policy_id
        if self.traffic_marking_policy_name is not None:
            result['TrafficMarkingPolicyName'] = self.traffic_marking_policy_name
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TrafficMarkingPolicyDescription') is not None:
            self.traffic_marking_policy_description = m.get('TrafficMarkingPolicyDescription')
        if m.get('TrafficMarkingPolicyId') is not None:
            self.traffic_marking_policy_id = m.get('TrafficMarkingPolicyId')
        if m.get('TrafficMarkingPolicyName') is not None:
            self.traffic_marking_policy_name = m.get('TrafficMarkingPolicyName')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListTrafficMarkingPoliciesResponseBodyTrafficMarkingPoliciesTrafficMatchRules(TeaModel):
    def __init__(self, dst_cidr=None, dst_port_range=None, match_dscp=None, protocol=None, src_cidr=None,
                 src_port_range=None, traffic_match_rule_description=None, traffic_match_rule_id=None,
                 traffic_match_rule_name=None, traffic_match_rule_status=None):
        # The destination CIDR block used to match data packets.
        self.dst_cidr = dst_cidr  # type: str
        # The destination port range used to match data packets.
        self.dst_port_range = dst_port_range  # type: list[int]
        # The DSCP value used to match data packets.
        self.match_dscp = match_dscp  # type: int
        # The protocol used to match data packets.
        # 
        # > Traffic marking policies support multiple protocols. For more information, see the documentation of CEN.
        self.protocol = protocol  # type: str
        # The source CIDR block used to match data packets.
        self.src_cidr = src_cidr  # type: str
        # The source port range used to match data packets.
        self.src_port_range = src_port_range  # type: list[int]
        # The description of the traffic classification rule.
        self.traffic_match_rule_description = traffic_match_rule_description  # type: str
        # The ID of the traffic classification rule.
        self.traffic_match_rule_id = traffic_match_rule_id  # type: str
        # The name of the traffic classification rule.
        self.traffic_match_rule_name = traffic_match_rule_name  # type: str
        # The status of the traffic classification rule. Valid values:
        # 
        # *   **Creating**: The rule is being created.
        # *   **Active**: The rule is available.
        # *   **Deleting**: The rule is being deleted.
        # *   **Deleted**: The rule is deleted.
        self.traffic_match_rule_status = traffic_match_rule_status  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTrafficMarkingPoliciesResponseBodyTrafficMarkingPoliciesTrafficMatchRules, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_cidr is not None:
            result['DstCidr'] = self.dst_cidr
        if self.dst_port_range is not None:
            result['DstPortRange'] = self.dst_port_range
        if self.match_dscp is not None:
            result['MatchDscp'] = self.match_dscp
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.src_cidr is not None:
            result['SrcCidr'] = self.src_cidr
        if self.src_port_range is not None:
            result['SrcPortRange'] = self.src_port_range
        if self.traffic_match_rule_description is not None:
            result['TrafficMatchRuleDescription'] = self.traffic_match_rule_description
        if self.traffic_match_rule_id is not None:
            result['TrafficMatchRuleId'] = self.traffic_match_rule_id
        if self.traffic_match_rule_name is not None:
            result['TrafficMatchRuleName'] = self.traffic_match_rule_name
        if self.traffic_match_rule_status is not None:
            result['TrafficMatchRuleStatus'] = self.traffic_match_rule_status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DstCidr') is not None:
            self.dst_cidr = m.get('DstCidr')
        if m.get('DstPortRange') is not None:
            self.dst_port_range = m.get('DstPortRange')
        if m.get('MatchDscp') is not None:
            self.match_dscp = m.get('MatchDscp')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('SrcCidr') is not None:
            self.src_cidr = m.get('SrcCidr')
        if m.get('SrcPortRange') is not None:
            self.src_port_range = m.get('SrcPortRange')
        if m.get('TrafficMatchRuleDescription') is not None:
            self.traffic_match_rule_description = m.get('TrafficMatchRuleDescription')
        if m.get('TrafficMatchRuleId') is not None:
            self.traffic_match_rule_id = m.get('TrafficMatchRuleId')
        if m.get('TrafficMatchRuleName') is not None:
            self.traffic_match_rule_name = m.get('TrafficMatchRuleName')
        if m.get('TrafficMatchRuleStatus') is not None:
            self.traffic_match_rule_status = m.get('TrafficMatchRuleStatus')
        return self


class ListTrafficMarkingPoliciesResponseBodyTrafficMarkingPolicies(TeaModel):
    def __init__(self, marking_dscp=None, priority=None, traffic_marking_policy_description=None,
                 traffic_marking_policy_id=None, traffic_marking_policy_name=None, traffic_marking_policy_status=None,
                 traffic_match_rules=None, transit_router_id=None):
        # The differentiated services code point (DSCP) value of the traffic marking policy.
        self.marking_dscp = marking_dscp  # type: int
        # The priority of the traffic marking policy.
        # 
        # A smaller value indicates a higher priority.
        self.priority = priority  # type: int
        # The description of the traffic marking policy.
        self.traffic_marking_policy_description = traffic_marking_policy_description  # type: str
        # The ID of the traffic marking policy.
        self.traffic_marking_policy_id = traffic_marking_policy_id  # type: str
        # The name of the traffic marking policy.
        self.traffic_marking_policy_name = traffic_marking_policy_name  # type: str
        # The status of the traffic marking policy. Valid values:
        # 
        # *   **Creating**: The policy is being created.
        # *   **Active**: The policy is available.
        # *   **Modifying**: The policy is being modified
        # *   **Deleting**: The policy is being deleted.
        # *   **Deleted**: The policy is deleted.
        self.traffic_marking_policy_status = traffic_marking_policy_status  # type: str
        # The list of traffic classification rules.
        self.traffic_match_rules = traffic_match_rules  # type: list[ListTrafficMarkingPoliciesResponseBodyTrafficMarkingPoliciesTrafficMatchRules]
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        if self.traffic_match_rules:
            for k in self.traffic_match_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTrafficMarkingPoliciesResponseBodyTrafficMarkingPolicies, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.marking_dscp is not None:
            result['MarkingDscp'] = self.marking_dscp
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.traffic_marking_policy_description is not None:
            result['TrafficMarkingPolicyDescription'] = self.traffic_marking_policy_description
        if self.traffic_marking_policy_id is not None:
            result['TrafficMarkingPolicyId'] = self.traffic_marking_policy_id
        if self.traffic_marking_policy_name is not None:
            result['TrafficMarkingPolicyName'] = self.traffic_marking_policy_name
        if self.traffic_marking_policy_status is not None:
            result['TrafficMarkingPolicyStatus'] = self.traffic_marking_policy_status
        result['TrafficMatchRules'] = []
        if self.traffic_match_rules is not None:
            for k in self.traffic_match_rules:
                result['TrafficMatchRules'].append(k.to_map() if k else None)
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MarkingDscp') is not None:
            self.marking_dscp = m.get('MarkingDscp')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('TrafficMarkingPolicyDescription') is not None:
            self.traffic_marking_policy_description = m.get('TrafficMarkingPolicyDescription')
        if m.get('TrafficMarkingPolicyId') is not None:
            self.traffic_marking_policy_id = m.get('TrafficMarkingPolicyId')
        if m.get('TrafficMarkingPolicyName') is not None:
            self.traffic_marking_policy_name = m.get('TrafficMarkingPolicyName')
        if m.get('TrafficMarkingPolicyStatus') is not None:
            self.traffic_marking_policy_status = m.get('TrafficMarkingPolicyStatus')
        self.traffic_match_rules = []
        if m.get('TrafficMatchRules') is not None:
            for k in m.get('TrafficMatchRules'):
                temp_model = ListTrafficMarkingPoliciesResponseBodyTrafficMarkingPoliciesTrafficMatchRules()
                self.traffic_match_rules.append(temp_model.from_map(k))
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListTrafficMarkingPoliciesResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, request_id=None, total_count=None,
                 traffic_marking_policies=None):
        # The number of entries returned on each page.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query.
        # 
        # *   If **NextToken** was not returned in the previous query, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The number of entries returned.
        self.total_count = total_count  # type: int
        # The list of traffic marking policies.
        self.traffic_marking_policies = traffic_marking_policies  # type: list[ListTrafficMarkingPoliciesResponseBodyTrafficMarkingPolicies]

    def validate(self):
        if self.traffic_marking_policies:
            for k in self.traffic_marking_policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTrafficMarkingPoliciesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TrafficMarkingPolicies'] = []
        if self.traffic_marking_policies is not None:
            for k in self.traffic_marking_policies:
                result['TrafficMarkingPolicies'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.traffic_marking_policies = []
        if m.get('TrafficMarkingPolicies') is not None:
            for k in m.get('TrafficMarkingPolicies'):
                temp_model = ListTrafficMarkingPoliciesResponseBodyTrafficMarkingPolicies()
                self.traffic_marking_policies.append(temp_model.from_map(k))
        return self


class ListTrafficMarkingPoliciesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTrafficMarkingPoliciesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTrafficMarkingPoliciesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTrafficMarkingPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTransitRouterAvailableResourceRequest(TeaModel):
    def __init__(self, owner_account=None, owner_id=None, region_id=None, resource_owner_account=None,
                 resource_owner_id=None, support_multicast=None):
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the Enterprise Edition transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # Specifies whether to query only the zones in which the multicast feature is supported. Valid values:
        # 
        # *   **true**: yes
        # 
        #     After you call **ListTransitRouterAvailableResource**, if no zone is returned, it indicates that the Enterprise Edition transit router does not support the multicast feature.
        # 
        # *   **false** (default): no
        self.support_multicast = support_multicast  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterAvailableResourceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.support_multicast is not None:
            result['SupportMulticast'] = self.support_multicast
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SupportMulticast') is not None:
            self.support_multicast = m.get('SupportMulticast')
        return self


class ListTransitRouterAvailableResourceResponseBody(TeaModel):
    def __init__(self, available_zones=None, master_zones=None, request_id=None, slave_zones=None,
                 support_multicast=None):
        # A list of zones.
        self.available_zones = available_zones  # type: list[str]
        # A list of primary zones.
        self.master_zones = master_zones  # type: list[str]
        # The ID of the request.
        self.request_id = request_id  # type: str
        # A list of zone IDs.
        # 
        # You can call [DescribeZones](~~36064~~) to query zones by ID.
        self.slave_zones = slave_zones  # type: list[str]
        self.support_multicast = support_multicast  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterAvailableResourceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.available_zones is not None:
            result['AvailableZones'] = self.available_zones
        if self.master_zones is not None:
            result['MasterZones'] = self.master_zones
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.slave_zones is not None:
            result['SlaveZones'] = self.slave_zones
        if self.support_multicast is not None:
            result['SupportMulticast'] = self.support_multicast
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AvailableZones') is not None:
            self.available_zones = m.get('AvailableZones')
        if m.get('MasterZones') is not None:
            self.master_zones = m.get('MasterZones')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SlaveZones') is not None:
            self.slave_zones = m.get('SlaveZones')
        if m.get('SupportMulticast') is not None:
            self.support_multicast = m.get('SupportMulticast')
        return self


class ListTransitRouterAvailableResourceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTransitRouterAvailableResourceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTransitRouterAvailableResourceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTransitRouterAvailableResourceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTransitRouterCidrRequest(TeaModel):
    def __init__(self, client_token=None, dry_run=None, owner_account=None, owner_id=None, region_id=None,
                 resource_owner_account=None, resource_owner_id=None, transit_router_cidr_id=None, transit_router_id=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. The token can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId may be different for each request.
        self.client_token = client_token  # type: str
        # Specifies whether only to precheck the API request. Valid values:
        # 
        # *   **true**: prechecks the request but does not query the CIDR block. The system checks the required parameters, the request format, and the service limits. If the request fails the check, an error message is returned. If the request passes the check, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. After the request passes the check, the operation is performed.
        self.dry_run = dry_run  # type: bool
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the CIDR block.
        self.transit_router_cidr_id = transit_router_cidr_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterCidrRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_cidr_id is not None:
            result['TransitRouterCidrId'] = self.transit_router_cidr_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterCidrId') is not None:
            self.transit_router_cidr_id = m.get('TransitRouterCidrId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListTransitRouterCidrResponseBodyCidrLists(TeaModel):
    def __init__(self, cidr=None, description=None, family=None, name=None, publish_cidr_route=None,
                 transit_router_cidr_id=None, transit_router_id=None):
        # The CIDR block of the transit router.
        self.cidr = cidr  # type: str
        # The description of the CIDR block.
        self.description = description  # type: str
        # The type of the CIDR block.
        # 
        # The value is set to **IPv4**, which indicates that the CIDR block is of the IPv4 type.
        self.family = family  # type: str
        # The name of the CIDR block.
        self.name = name  # type: str
        # Indicates whether the system is allowed to automatically add a route to the route table of the transit router.
        # 
        # *   **true**: yes.
        # 
        #         A value of true indicates that if you create a private VPN connection and add a route learning policy for the VPC connection, the system automatically adds the following route to the route table of the transit router that is in route learning relationship with the VPN connection:
        #           A blackhole route whose destination CIDR block is the CIDR block of the transit router. The CIDR block of the transit router refers to the CIDR block from which gateway IP addresses are allocated to IPsec-VPN connections. 
        #           The blackhole route is advertised only to the route tables of VBRs that are connected to the transit router. 
        # 
        # *   **false**: no.
        self.publish_cidr_route = publish_cidr_route  # type: bool
        # The ID of the CIDR block.
        self.transit_router_cidr_id = transit_router_cidr_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterCidrResponseBodyCidrLists, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        if self.description is not None:
            result['Description'] = self.description
        if self.family is not None:
            result['Family'] = self.family
        if self.name is not None:
            result['Name'] = self.name
        if self.publish_cidr_route is not None:
            result['PublishCidrRoute'] = self.publish_cidr_route
        if self.transit_router_cidr_id is not None:
            result['TransitRouterCidrId'] = self.transit_router_cidr_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Family') is not None:
            self.family = m.get('Family')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PublishCidrRoute') is not None:
            self.publish_cidr_route = m.get('PublishCidrRoute')
        if m.get('TransitRouterCidrId') is not None:
            self.transit_router_cidr_id = m.get('TransitRouterCidrId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListTransitRouterCidrResponseBody(TeaModel):
    def __init__(self, cidr_lists=None, request_id=None):
        # The CIDR blocks of the transit router.
        self.cidr_lists = cidr_lists  # type: list[ListTransitRouterCidrResponseBodyCidrLists]
        # The ID of the request.
        self.request_id = request_id  # type: str

    def validate(self):
        if self.cidr_lists:
            for k in self.cidr_lists:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterCidrResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CidrLists'] = []
        if self.cidr_lists is not None:
            for k in self.cidr_lists:
                result['CidrLists'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.cidr_lists = []
        if m.get('CidrLists') is not None:
            for k in m.get('CidrLists'):
                temp_model = ListTransitRouterCidrResponseBodyCidrLists()
                self.cidr_lists.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListTransitRouterCidrResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTransitRouterCidrResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTransitRouterCidrResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTransitRouterCidrResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTransitRouterCidrAllocationRequest(TeaModel):
    def __init__(self, attachment_id=None, attachment_name=None, cidr=None, cidr_block=None, client_token=None,
                 dedicated_owner_id=None, dry_run=None, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, transit_router_cidr_id=None,
                 transit_router_id=None):
        # The ID of the network instance connection.
        self.attachment_id = attachment_id  # type: str
        # The name of the network instance connection.
        self.attachment_name = attachment_name  # type: str
        # The CIDR block of the transit router.
        self.cidr = cidr  # type: str
        # The CIDR block that has been allocated to network instances.
        self.cidr_block = cidr_block  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        # 
        # >  If you do not set this parameter, ClientToken is set to the value of RequestId. The value of RequestId for each API request may be different.
        self.client_token = client_token  # type: str
        # The CIDR block that is for exclusive use.
        # 
        # Set the value to **VPN**, which specifies the CIDR block that is reserved for VPN connections.
        self.dedicated_owner_id = dedicated_owner_id  # type: str
        # Specifies whether only to precheck the request. Valid values:
        # 
        # *   **true**: prechecks the request but does not query how IP addresses within the CIDR block of a transit router are allocated. The system checks the required parameters, the request format, and the service limits. If the request fails to pass the precheck, an error message is returned. If the request passes the precheck, the `DryRunOperation` error code is returned.
        # *   **false** (default): sends the request. After the request passes the precheck, allocated IP addresses are queried.
        self.dry_run = dry_run  # type: bool
        # The number of entries returned on each page.
        # 
        # *   If you do not set **MaxResults**, it indicates that you do not need to query results in batches. The value of **MaxResults** indicates the total number of entries.
        # 
        # *   If a value is specified for **MaxResults**, it indicates that you need to query results in batches. Valid values: **1** to **100**. We recommend that you set **MaxResults** to **20**.
        # 
        #     The value of **MaxResults** in the response indicates the number of entries in the current batch.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If this is your first query or no subsequent query is to be sent, ignore this parameter.
        # *   If a subsequent query is to be sent, set the value to the value of **NextToken** that was returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The ID of the CIDR block.
        # 
        # You can call [ListTransitRouterCidr](~~462772~~) to query the ID of a CIDR block.
        self.transit_router_cidr_id = transit_router_cidr_id  # type: str
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterCidrAllocationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.attachment_id is not None:
            result['AttachmentId'] = self.attachment_id
        if self.attachment_name is not None:
            result['AttachmentName'] = self.attachment_name
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        if self.cidr_block is not None:
            result['CidrBlock'] = self.cidr_block
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.dedicated_owner_id is not None:
            result['DedicatedOwnerId'] = self.dedicated_owner_id
        if self.dry_run is not None:
            result['DryRun'] = self.dry_run
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.transit_router_cidr_id is not None:
            result['TransitRouterCidrId'] = self.transit_router_cidr_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AttachmentId') is not None:
            self.attachment_id = m.get('AttachmentId')
        if m.get('AttachmentName') is not None:
            self.attachment_name = m.get('AttachmentName')
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        if m.get('CidrBlock') is not None:
            self.cidr_block = m.get('CidrBlock')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DedicatedOwnerId') is not None:
            self.dedicated_owner_id = m.get('DedicatedOwnerId')
        if m.get('DryRun') is not None:
            self.dry_run = m.get('DryRun')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TransitRouterCidrId') is not None:
            self.transit_router_cidr_id = m.get('TransitRouterCidrId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListTransitRouterCidrAllocationResponseBodyTransitRouterCidrAllocations(TeaModel):
    def __init__(self, allocated_cidr_block=None, attachment_id=None, attachment_name=None, cidr=None,
                 transit_router_cidr_id=None):
        # The CIDR blocks that have been allocated to network instances.
        self.allocated_cidr_block = allocated_cidr_block  # type: str
        # The ID of the network instance connection.
        self.attachment_id = attachment_id  # type: str
        # The name of the network instance connection.
        self.attachment_name = attachment_name  # type: str
        # The ID of the transit router CIDR block.
        self.cidr = cidr  # type: str
        # The ID of the transit router CIDR block.
        self.transit_router_cidr_id = transit_router_cidr_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterCidrAllocationResponseBodyTransitRouterCidrAllocations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allocated_cidr_block is not None:
            result['AllocatedCidrBlock'] = self.allocated_cidr_block
        if self.attachment_id is not None:
            result['AttachmentId'] = self.attachment_id
        if self.attachment_name is not None:
            result['AttachmentName'] = self.attachment_name
        if self.cidr is not None:
            result['Cidr'] = self.cidr
        if self.transit_router_cidr_id is not None:
            result['TransitRouterCidrId'] = self.transit_router_cidr_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AllocatedCidrBlock') is not None:
            self.allocated_cidr_block = m.get('AllocatedCidrBlock')
        if m.get('AttachmentId') is not None:
            self.attachment_id = m.get('AttachmentId')
        if m.get('AttachmentName') is not None:
            self.attachment_name = m.get('AttachmentName')
        if m.get('Cidr') is not None:
            self.cidr = m.get('Cidr')
        if m.get('TransitRouterCidrId') is not None:
            self.transit_router_cidr_id = m.get('TransitRouterCidrId')
        return self


class ListTransitRouterCidrAllocationResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, request_id=None, total_count=None,
                 transit_router_cidr_allocations=None):
        # The number of entries returned on each page.
        # 
        # *   If no value is specified for **MaxResults**, query results are returned in one batch. The value of **MaxResults** indicates the total number of entries.
        # *   If a value is specified for **MaxResults**, query results are returned in batches. The value of **MaxResults** in the response indicates the number of entries in the current batch.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If **NextToken** was not returned, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int
        # The information about the allocated CIDR blocks.
        self.transit_router_cidr_allocations = transit_router_cidr_allocations  # type: list[ListTransitRouterCidrAllocationResponseBodyTransitRouterCidrAllocations]

    def validate(self):
        if self.transit_router_cidr_allocations:
            for k in self.transit_router_cidr_allocations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterCidrAllocationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TransitRouterCidrAllocations'] = []
        if self.transit_router_cidr_allocations is not None:
            for k in self.transit_router_cidr_allocations:
                result['TransitRouterCidrAllocations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.transit_router_cidr_allocations = []
        if m.get('TransitRouterCidrAllocations') is not None:
            for k in m.get('TransitRouterCidrAllocations'):
                temp_model = ListTransitRouterCidrAllocationResponseBodyTransitRouterCidrAllocations()
                self.transit_router_cidr_allocations.append(temp_model.from_map(k))
        return self


class ListTransitRouterCidrAllocationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTransitRouterCidrAllocationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTransitRouterCidrAllocationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTransitRouterCidrAllocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTransitRouterMulticastDomainAssociationsRequest(TeaModel):
    def __init__(self, client_token=None, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 resource_id=None, resource_owner_account=None, resource_owner_id=None, resource_type=None,
                 transit_router_attachment_id=None, transit_router_multicast_domain_id=None, v_switch_ids=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can only contain ASCII characters.
        self.client_token = client_token  # type: str
        # The number of entries to return on each page. Default value: **20**.
        self.max_results = max_results  # type: long
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If this is your first query and no next queries are to be sent, ignore this parameter.
        # *   If a subsequent query is to be sent, set the parameter to the value of NextToken that is returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the resource associated with the multicast domain.
        self.resource_id = resource_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The type of resource associated with the multicast domain.
        # 
        # Valid value: **VPC**.
        self.resource_type = resource_type  # type: str
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str
        # The vSwitch IDs.
        # 
        # You can specify at most 20 IDs.
        self.v_switch_ids = v_switch_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainAssociationsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class ListTransitRouterMulticastDomainAssociationsResponseBodyTransitRouterMulticastAssociations(TeaModel):
    def __init__(self, resource_id=None, resource_owner_id=None, resource_type=None, status=None,
                 transit_router_attachment_id=None, transit_router_multicast_domain_id=None, v_switch_id=None):
        # The ID of the resource associated with the multicast domain.
        self.resource_id = resource_id  # type: str
        # The ID of the Alibaba Cloud account to which the resource associated with the multicast domain belongs.
        self.resource_owner_id = resource_owner_id  # type: long
        # The type of resource associated with the multicast domain.
        # 
        # Valid value: **VPC**.
        self.resource_type = resource_type  # type: str
        # The association status. Valid values:
        # 
        # *   **Associated**: The resource is associated with the multicast domain.
        # *   **Associating**: The resource is being associated with the multicast domain.
        # *   **Dissociating**: The resource is being disassociated from the multicast domain.
        self.status = status  # type: str
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainAssociationsResponseBodyTransitRouterMulticastAssociations, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.status is not None:
            result['Status'] = self.status
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class ListTransitRouterMulticastDomainAssociationsResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, request_id=None, total_count=None,
                 transit_router_multicast_associations=None):
        # The number of entries returned on each page.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If **NextToken** is empty, it indicates that no subsequent query is to be sent.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int
        # The information about the resource associated with the multicast domain.
        self.transit_router_multicast_associations = transit_router_multicast_associations  # type: list[ListTransitRouterMulticastDomainAssociationsResponseBodyTransitRouterMulticastAssociations]

    def validate(self):
        if self.transit_router_multicast_associations:
            for k in self.transit_router_multicast_associations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainAssociationsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TransitRouterMulticastAssociations'] = []
        if self.transit_router_multicast_associations is not None:
            for k in self.transit_router_multicast_associations:
                result['TransitRouterMulticastAssociations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.transit_router_multicast_associations = []
        if m.get('TransitRouterMulticastAssociations') is not None:
            for k in m.get('TransitRouterMulticastAssociations'):
                temp_model = ListTransitRouterMulticastDomainAssociationsResponseBodyTransitRouterMulticastAssociations()
                self.transit_router_multicast_associations.append(temp_model.from_map(k))
        return self


class ListTransitRouterMulticastDomainAssociationsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTransitRouterMulticastDomainAssociationsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainAssociationsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTransitRouterMulticastDomainAssociationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTransitRouterMulticastDomainVSwitchesRequest(TeaModel):
    def __init__(self, cen_id=None, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, v_switch_ids=None, vpc_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The number of entries to return on each page. Minimum value: **0**. Default value: **20**.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If this is your first query or no subsequent query is to be sent, ignore this parameter.
        # *   If a next query is to be sent, set the value to the value of **NextToken** that is returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The vSwitch IDs.
        self.v_switch_ids = v_switch_ids  # type: list[str]
        # The ID of the VPC.
        self.vpc_id = vpc_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainVSwitchesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class ListTransitRouterMulticastDomainVSwitchesResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, request_id=None, total_count=None, v_switch_ids=None):
        # The number of entries returned on each page.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If **NextToken** was not returned, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int
        # The vSwitch IDs.
        self.v_switch_ids = v_switch_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainVSwitchesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class ListTransitRouterMulticastDomainVSwitchesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTransitRouterMulticastDomainVSwitchesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainVSwitchesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTransitRouterMulticastDomainVSwitchesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTransitRouterMulticastDomainsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag keys of the resources. 
        # 
        # The tag keys cannot be an empty string. The tag keys can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.  
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag values of the resources. 
        # 
        # The tag values can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.  
        # 
        # Each tag key has a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTransitRouterMulticastDomainsRequest(TeaModel):
    def __init__(self, cen_id=None, client_token=None, max_results=None, next_token=None, owner_account=None,
                 owner_id=None, region_id=None, resource_owner_account=None, resource_owner_id=None, tag=None,
                 transit_router_id=None, transit_router_multicast_domain_id=None):
        # The ID of the Cloud Enterprise Network (CEN) instance.
        self.cen_id = cen_id  # type: str
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among different requests. ClientToken can contain only ASCII characters.
        self.client_token = client_token  # type: str
        # The number of entries to return on each page. Default value: **20**.
        self.max_results = max_results  # type: long
        # The token that is used for the next query. Valid values:
        # 
        # *   If this is your first query or no next query is to be sent, ignore this parameter.
        # *   If a next query is to be sent, set the parameter to the value of NextToken that is returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the transit router is deployed.
        # 
        # You can call the [DescribeChildInstanceRegions](~~132080~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The tags of the resources.
        self.tag = tag  # type: list[ListTransitRouterMulticastDomainsRequestTag]
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListTransitRouterMulticastDomainsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        return self


class ListTransitRouterMulticastDomainsResponseBodyTransitRouterMulticastDomainsTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag key of the multicast domain.
        self.key = key  # type: str
        # The tag value of the multicast domain.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainsResponseBodyTransitRouterMulticastDomainsTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTransitRouterMulticastDomainsResponseBodyTransitRouterMulticastDomains(TeaModel):
    def __init__(self, status=None, tags=None, transit_router_id=None,
                 transit_router_multicast_domain_description=None, transit_router_multicast_domain_id=None, transit_router_multicast_domain_name=None):
        # The status of the multicast domain.
        # 
        # Valid value: **Active**, which indicates that the multicast domain is available.
        self.status = status  # type: str
        # The tags of the multicast domain.
        self.tags = tags  # type: list[ListTransitRouterMulticastDomainsResponseBodyTransitRouterMulticastDomainsTags]
        # The ID of the transit router.
        self.transit_router_id = transit_router_id  # type: str
        # The description of the multicast domain.
        self.transit_router_multicast_domain_description = transit_router_multicast_domain_description  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str
        # The name of the multicast domain.
        self.transit_router_multicast_domain_name = transit_router_multicast_domain_name  # type: str

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainsResponseBodyTransitRouterMulticastDomains, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        if self.transit_router_multicast_domain_description is not None:
            result['TransitRouterMulticastDomainDescription'] = self.transit_router_multicast_domain_description
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        if self.transit_router_multicast_domain_name is not None:
            result['TransitRouterMulticastDomainName'] = self.transit_router_multicast_domain_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = ListTransitRouterMulticastDomainsResponseBodyTransitRouterMulticastDomainsTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        if m.get('TransitRouterMulticastDomainDescription') is not None:
            self.transit_router_multicast_domain_description = m.get('TransitRouterMulticastDomainDescription')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        if m.get('TransitRouterMulticastDomainName') is not None:
            self.transit_router_multicast_domain_name = m.get('TransitRouterMulticastDomainName')
        return self


class ListTransitRouterMulticastDomainsResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, request_id=None, total_count=None,
                 transit_router_multicast_domains=None):
        # The number of entries returned per page.
        self.max_results = max_results  # type: int
        # The token that is used for the next query. Valid values:
        # 
        # *   If **NextToken** is empty, it indicates that no next query is to be sent.
        # *   If **NextToken** is not empty, the value indicates the token that is used for the next query.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The number of entries returned.
        self.total_count = total_count  # type: int
        # The information about the multicast domain.
        self.transit_router_multicast_domains = transit_router_multicast_domains  # type: list[ListTransitRouterMulticastDomainsResponseBodyTransitRouterMulticastDomains]

    def validate(self):
        if self.transit_router_multicast_domains:
            for k in self.transit_router_multicast_domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TransitRouterMulticastDomains'] = []
        if self.transit_router_multicast_domains is not None:
            for k in self.transit_router_multicast_domains:
                result['TransitRouterMulticastDomains'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.transit_router_multicast_domains = []
        if m.get('TransitRouterMulticastDomains') is not None:
            for k in m.get('TransitRouterMulticastDomains'):
                temp_model = ListTransitRouterMulticastDomainsResponseBodyTransitRouterMulticastDomains()
                self.transit_router_multicast_domains.append(temp_model.from_map(k))
        return self


class ListTransitRouterMulticastDomainsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTransitRouterMulticastDomainsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastDomainsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTransitRouterMulticastDomainsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTransitRouterMulticastGroupsRequest(TeaModel):
    def __init__(self, client_token=None, group_ip_address=None, is_group_member=None, is_group_source=None,
                 max_results=None, network_interface_ids=None, next_token=None, owner_account=None, owner_id=None,
                 peer_transit_router_multicast_domains=None, resource_id=None, resource_owner_account=None, resource_owner_id=None, resource_type=None,
                 transit_router_attachment_id=None, transit_router_multicast_domain_id=None, v_switch_ids=None):
        # The client token that is used to ensure the idempotence of the request.
        # 
        # You can use the client to generate the value, but you must make sure that it is unique among all requests. The token can contain only ASCII characters.
        self.client_token = client_token  # type: str
        # The IP address of the multicast group.
        # 
        # Each multicast group is identified by its IP address.
        self.group_ip_address = group_ip_address  # type: str
        # Specified whether to query the multicast members. Valid values:
        # 
        # *   **false**: no
        # *   **true**: yes
        # 
        # > This parameter can be set together with the IsGroupMember parameter.
        # 
        # *   If you do not set IsGroupMember or IsGroupSource, both the multicast sources and members are queried.
        # 
        # *   If you set only one of them or both of them, the specified values prevail.
        self.is_group_member = is_group_member  # type: bool
        # Specifies whether to query the multicast sources. Valid values:
        # 
        # *   **false**: no
        # *   **true**: yes
        # 
        # > This parameter can be set together with the IsGroupMember parameter.
        # 
        # *   If you do not set IsGroupSource or IsGroupMember, both the multicast sources and members are queried.
        # 
        # *   If you set only one of them or both of them, the specified values prevail.
        self.is_group_source = is_group_source  # type: bool
        # The number of entries to return on each page. Default value: **20**.
        self.max_results = max_results  # type: long
        # The IDs of ENIs.
        self.network_interface_ids = network_interface_ids  # type: list[str]
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If this is your first query and no next queries are to be sent, ignore this parameter.
        # *   If a subsequent query is to be sent, set the parameter to the value of NextToken that is returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the inter-region multicast domain.
        self.peer_transit_router_multicast_domains = peer_transit_router_multicast_domains  # type: list[str]
        # The ID of the resource associated with the multicast resource.
        self.resource_id = resource_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The type of the multicast resource. Valid values:
        # 
        # *   **VPC**: queries multicast resources by VPC.
        # *   **TR**: queries multicast resources that are also deployed in a different region.
        self.resource_type = resource_type  # type: str
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str
        # The vSwitch IDs.
        self.v_switch_ids = v_switch_ids  # type: list[str]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterMulticastGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.group_ip_address is not None:
            result['GroupIpAddress'] = self.group_ip_address
        if self.is_group_member is not None:
            result['IsGroupMember'] = self.is_group_member
        if self.is_group_source is not None:
            result['IsGroupSource'] = self.is_group_source
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.network_interface_ids is not None:
            result['NetworkInterfaceIds'] = self.network_interface_ids
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.peer_transit_router_multicast_domains is not None:
            result['PeerTransitRouterMulticastDomains'] = self.peer_transit_router_multicast_domains
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('GroupIpAddress') is not None:
            self.group_ip_address = m.get('GroupIpAddress')
        if m.get('IsGroupMember') is not None:
            self.is_group_member = m.get('IsGroupMember')
        if m.get('IsGroupSource') is not None:
            self.is_group_source = m.get('IsGroupSource')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NetworkInterfaceIds') is not None:
            self.network_interface_ids = m.get('NetworkInterfaceIds')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PeerTransitRouterMulticastDomains') is not None:
            self.peer_transit_router_multicast_domains = m.get('PeerTransitRouterMulticastDomains')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class ListTransitRouterMulticastGroupsResponseBodyTransitRouterMulticastGroups(TeaModel):
    def __init__(self, group_ip_address=None, group_member=None, group_source=None, member_type=None,
                 network_interface_id=None, peer_transit_router_multicast_domain_id=None, resource_id=None, resource_owner_id=None,
                 resource_type=None, source_type=None, status=None, transit_router_attachment_id=None,
                 transit_router_multicast_domain_id=None, v_switch_id=None):
        # The IP address of the multicast group to which the multicast resource belongs.
        self.group_ip_address = group_ip_address  # type: str
        # Indicates whether the multicast resource is a multicast member. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.group_member = group_member  # type: bool
        # Indicates whether the multicast resource is a multicast source. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.group_source = group_source  # type: bool
        # The type of the multicast source.
        # 
        # If the value is **Static**, the multicast source is manually specified.
        self.member_type = member_type  # type: str
        # The ID of the ENI, which is a multicast resource.
        self.network_interface_id = network_interface_id  # type: str
        # The ID of the multicast domain associated with the multicast resource that is deployed across regions.
        self.peer_transit_router_multicast_domain_id = peer_transit_router_multicast_domain_id  # type: str
        # The ID of the resource associated with the multicast resource.
        self.resource_id = resource_id  # type: str
        # The ID of the Alibaba Cloud account to which the multicast resource belongs.
        self.resource_owner_id = resource_owner_id  # type: long
        # The type of the multicast resource. Valid values:
        # 
        # *   **VPC**: The multicast resource is in a VPC.
        # *   **TR**: The multicast resource is deployed across regions.
        self.resource_type = resource_type  # type: str
        # The type of the multicast member.
        # 
        # If the value is **Static**, the multicast member is manually specified.
        self.source_type = source_type  # type: str
        # The status of the multicast resource. Valid values:
        # 
        # *   **Registering**: being created
        # *   **Registered**: available
        # *   **Deregistering**: being deleted
        self.status = status  # type: str
        # The ID of the network instance connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the multicast domain.
        self.transit_router_multicast_domain_id = transit_router_multicast_domain_id  # type: str
        # The ID of the vSwitch to which the multicast resource belongs.
        self.v_switch_id = v_switch_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterMulticastGroupsResponseBodyTransitRouterMulticastGroups, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_ip_address is not None:
            result['GroupIpAddress'] = self.group_ip_address
        if self.group_member is not None:
            result['GroupMember'] = self.group_member
        if self.group_source is not None:
            result['GroupSource'] = self.group_source
        if self.member_type is not None:
            result['MemberType'] = self.member_type
        if self.network_interface_id is not None:
            result['NetworkInterfaceId'] = self.network_interface_id
        if self.peer_transit_router_multicast_domain_id is not None:
            result['PeerTransitRouterMulticastDomainId'] = self.peer_transit_router_multicast_domain_id
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.status is not None:
            result['Status'] = self.status
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_multicast_domain_id is not None:
            result['TransitRouterMulticastDomainId'] = self.transit_router_multicast_domain_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupIpAddress') is not None:
            self.group_ip_address = m.get('GroupIpAddress')
        if m.get('GroupMember') is not None:
            self.group_member = m.get('GroupMember')
        if m.get('GroupSource') is not None:
            self.group_source = m.get('GroupSource')
        if m.get('MemberType') is not None:
            self.member_type = m.get('MemberType')
        if m.get('NetworkInterfaceId') is not None:
            self.network_interface_id = m.get('NetworkInterfaceId')
        if m.get('PeerTransitRouterMulticastDomainId') is not None:
            self.peer_transit_router_multicast_domain_id = m.get('PeerTransitRouterMulticastDomainId')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterMulticastDomainId') is not None:
            self.transit_router_multicast_domain_id = m.get('TransitRouterMulticastDomainId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class ListTransitRouterMulticastGroupsResponseBody(TeaModel):
    def __init__(self, max_results=None, next_token=None, request_id=None, total_count=None,
                 transit_router_multicast_groups=None):
        # The number of entries returned per page.
        self.max_results = max_results  # type: int
        # The token that determines the start point of the query. Valid values:
        # 
        # *   If **NextToken** was not returned, it indicates that no additional results exist.
        # *   If **NextToken** was returned in the previous query, specify the value to obtain the next set of results.
        self.next_token = next_token  # type: str
        # The ID of the request.
        self.request_id = request_id  # type: str
        # The total number of entries returned.
        self.total_count = total_count  # type: int
        # A list of multicast groups.
        self.transit_router_multicast_groups = transit_router_multicast_groups  # type: list[ListTransitRouterMulticastGroupsResponseBodyTransitRouterMulticastGroups]

    def validate(self):
        if self.transit_router_multicast_groups:
            for k in self.transit_router_multicast_groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['TransitRouterMulticastGroups'] = []
        if self.transit_router_multicast_groups is not None:
            for k in self.transit_router_multicast_groups:
                result['TransitRouterMulticastGroups'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.transit_router_multicast_groups = []
        if m.get('TransitRouterMulticastGroups') is not None:
            for k in m.get('TransitRouterMulticastGroups'):
                temp_model = ListTransitRouterMulticastGroupsResponseBodyTransitRouterMulticastGroups()
                self.transit_router_multicast_groups.append(temp_model.from_map(k))
        return self


class ListTransitRouterMulticastGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTransitRouterMulticastGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTransitRouterMulticastGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTransitRouterMulticastGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTransitRouterPeerAttachmentsRequestTag(TeaModel):
    def __init__(self, key=None, value=None):
        # The tag keys of the resources. 
        # 
        # The tag keys cannot be an empty string. The tag keys can be up to 64 characters in length and cannot start with `acs:` or `aliyun`. It cannot contain `http://` or `https://`.  
        # 
        # You can specify at most 20 tag keys.
        self.key = key  # type: str
        # The tag values of the resources. 
        # 
        # The tag values can be 0 to 128 characters in length, and cannot start with `aliyun` or `acs:`. It cannot contain `http://` or `https://`.  
        # 
        # Each tag key has a unique tag value. You can specify at most 20 tag values in each call.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterPeerAttachmentsRequestTag, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTransitRouterPeerAttachmentsRequest(TeaModel):
    def __init__(self, cen_id=None, max_results=None, next_token=None, owner_account=None, owner_id=None,
                 region_id=None, resource_owner_account=None, resource_owner_id=None, tag=None,
                 transit_router_attachment_id=None, transit_router_id=None):
        # The ID of the CEN instance.
        self.cen_id = cen_id  # type: str
        # The number of entries to return per page. The default value is **20**. The maximum value is **100**.
        self.max_results = max_results  # type: int
        # The token that is used for the next query. Valid values:
        # 
        # *   If this is your first query or no next query is to be sent, ignore this parameter.
        # *   If a next query is to be sent, set the value to the value of **NextToken** that is returned from the last call.
        self.next_token = next_token  # type: str
        self.owner_account = owner_account  # type: str
        self.owner_id = owner_id  # type: long
        # The ID of the region where the Enterprise Edition transit router is deployed.
        # 
        # You can call the [DescribeRegions](~~36063~~) operation to query the most recent region list.
        self.region_id = region_id  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        # The tags.
        self.tag = tag  # type: list[ListTransitRouterPeerAttachmentsRequestTag]
        # The ID of the cross-region connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The ID of the Enterprise Edition transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        if self.tag:
            for k in self.tag:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterPeerAttachmentsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.max_results is not None:
            result['MaxResults'] = self.max_results
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        if self.owner_account is not None:
            result['OwnerAccount'] = self.owner_account
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        result['Tag'] = []
        if self.tag is not None:
            for k in self.tag:
                result['Tag'].append(k.to_map() if k else None)
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('MaxResults') is not None:
            self.max_results = m.get('MaxResults')
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        if m.get('OwnerAccount') is not None:
            self.owner_account = m.get('OwnerAccount')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        self.tag = []
        if m.get('Tag') is not None:
            for k in m.get('Tag'):
                temp_model = ListTransitRouterPeerAttachmentsRequestTag()
                self.tag.append(temp_model.from_map(k))
        if m.get('TransitRouterAttachmentId') is not None:
            self.transit_router_attachment_id = m.get('TransitRouterAttachmentId')
        if m.get('TransitRouterId') is not None:
            self.transit_router_id = m.get('TransitRouterId')
        return self


class ListTransitRouterPeerAttachmentsResponseBodyTransitRouterAttachmentsTags(TeaModel):
    def __init__(self, key=None, value=None):
        # The key of tag.
        self.key = key  # type: str
        # The value of the tag.
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTransitRouterPeerAttachmentsResponseBodyTransitRouterAttachmentsTags, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class ListTransitRouterPeerAttachmentsResponseBodyTransitRouterAttachments(TeaModel):
    def __init__(self, auto_publish_route_enabled=None, bandwidth=None, bandwidth_type=None,
                 cen_bandwidth_package_id=None, cen_id=None, creation_time=None, geographic_span_id=None, peer_transit_router_id=None,
                 peer_transit_router_owner_id=None, peer_transit_router_region_id=None, region_id=None, resource_type=None, status=None,
                 tags=None, transit_router_attachment_description=None, transit_router_attachment_id=None,
                 transit_router_attachment_name=None, transit_router_id=None):
        # Indicates whether the local Enterprise Edition transit router automatically advertises routes of the cross-region connection to the peer transit router. Valid values:
        # 
        # *   **false** (default): no
        # *   **true**: yes
        self.auto_publish_route_enabled = auto_publish_route_enabled  # type: bool
        # The bandwidth value of the cross-region connection. Unit: Mbit/s.
        # 
        # *   If **BandwidthType** is set to **BandwidthPackage**, this parameter indicates the bandwidth that is available for the cross-region connection.
        # *   If **BandwidthType** is set to **DataTransfer**, this parameter indicates the bandwidth limit of the cross-region connection.
        self.bandwidth = bandwidth  # type: int
        # The bandwidth allocation method. Valid values:
        # 
        # **BandwidthPackage**: allocates bandwidth from a bandwidth plan.
        # 
        # **DataTransfer**: uses pay-by-data-transfer bandwidth.
        self.bandwidth_type = bandwidth_type  # type: str
        # The ID of the bandwidth plan that is used to allocate bandwidth to the cross-region connection.
        self.cen_bandwidth_package_id = cen_bandwidth_package_id  # type: str
        self.cen_id = cen_id  # type: str
        # The time when the cross-region connection was created.
        # 
        # The time follows the ISO8601 standard in the `YYYY-MM-ddTHH:mmZ` format. The time is displayed in UTC.
        self.creation_time = creation_time  # type: str
        # The areas that are connected by the bandwidth plan.
        self.geographic_span_id = geographic_span_id  # type: str
        # The ID of the peer transit router.
        self.peer_transit_router_id = peer_transit_router_id  # type: str
        # The ID of the Alibaba Cloud account to which the peer transit router belongs.
        self.peer_transit_router_owner_id = peer_transit_router_owner_id  # type: long
        # The ID of the region where the peer transit router is deployed.
        self.peer_transit_router_region_id = peer_transit_router_region_id  # type: str
        # The ID of the region where the Enterprise Edition transit router is deployed.
        self.region_id = region_id  # type: str
        # The type of the resource to which the transit router is connected. Valid values:
        # 
        # *   **VPC**: virtual private cloud (VPC)
        # *   **CCN**: Cloud Connect Network (CCN) instance
        # *   **VBR**: virtual border router (VBR)
        # *   **TR**: transit router
        self.resource_type = resource_type  # type: str
        # The status of the cross-region connection. Valid values:
        # 
        # *   **Attached**: The local transit router is connected to the peer transit router.
        # *   **Attaching**: The local transit router is connecting to the peer transit router.
        # *   **Detaching**: The local transit router is disconnecting from the peer transit router.
        # *   **Detached**: The local transit router is disconnected from the peer transit router.
        self.status = status  # type: str
        # The list of tags.
        self.tags = tags  # type: list[ListTransitRouterPeerAttachmentsResponseBodyTransitRouterAttachmentsTags]
        # The description of the cross-region connection.
        self.transit_router_attachment_description = transit_router_attachment_description  # type: str
        # The ID of the cross-region connection.
        self.transit_router_attachment_id = transit_router_attachment_id  # type: str
        # The name of the cross-region connection.
        self.transit_router_attachment_name = transit_router_attachment_name  # type: str
        # The ID of the Enterprise Edition transit router.
        self.transit_router_id = transit_router_id  # type: str

    def validate(self):
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTransitRouterPeerAttachmentsResponseBodyTransitRouterAttachments, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auto_publish_route_enabled is not None:
            result['AutoPublishRouteEnabled'] = self.auto_publish_route_enabled
        if self.bandwidth is not None:
            result['Bandwidth'] = self.bandwidth
        if self.bandwidth_type is not None:
            result['BandwidthType'] = self.bandwidth_type
        if self.cen_bandwidth_package_id is not None:
            result['CenBandwidthPackageId'] = self.cen_bandwidth_package_id
        if self.cen_id is not None:
            result['CenId'] = self.cen_id
        if self.creation_time is not None:
            result['CreationTime'] = self.creation_time
        if self.geographic_span_id is not None:
            result['GeographicSpanId'] = self.geographic_span_id
        if self.peer_transit_router_id is not None:
            result['PeerTransitRouterId'] = self.peer_transit_router_id
        if self.peer_transit_router_owner_id is not None:
            result['PeerTransitRouterOwnerId'] = self.peer_transit_router_owner_id
        if self.peer_transit_router_region_id is not None:
            result['PeerTransitRouterRegionId'] = self.peer_transit_router_region_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.status is not None:
            result['Status'] = self.status
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.transit_router_attachment_description is not None:
            result['TransitRouterAttachmentDescription'] = self.transit_router_attachment_description
        if self.transit_router_attachment_id is not None:
            result['TransitRouterAttachmentId'] = self.transit_router_attachment_id
        if self.transit_router_attachment_name is not None:
            result['TransitRouterAttachmentName'] = self.transit_router_attachment_name
        if self.transit_router_id is not None:
            result['TransitRouterId'] = self.transit_router_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AutoPublishRouteEnabled') is not None:
            self.auto_publish_route_enabled = m.get('AutoPublishRouteEnabled')
        if m.get('Bandwidth') is not None:
            self.bandwidth = m.get('Bandwidth')
        if m.get('BandwidthType') is not None:
            self.bandwidth_type = m.get('BandwidthType')
        if m.get('CenBandwidthPackageId') is not None:
            self.cen_bandwidth_package_id = m.get('CenBandwidthPackageId')
        if m.get('CenId') is not None:
            self.cen_id = m.get('CenId')
        if m.get('CreationTime') is not None:
            self.creation_time = m.get('CreationTime')
        if m.get('GeographicSpanId') is not None:
            self.geogra