"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyApiGatewayPythonProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const open_api_gateway_python_project_1 = require("./open-api-gateway-python-project");
const setup_smithy_build_1 = require("./smithy/setup-smithy-build");
/**
 * Synthesizes a Python Project with a Smithy model, generated clients, a CDK construct for deploying the API
 * with API Gateway, and generated lambda handler wrappers for type-safe handling of requests.
 *
 * @pjid smithy-api-gateway-py
 */
class SmithyApiGatewayPythonProject extends open_api_gateway_python_project_1.OpenApiGatewayPythonProject {
    constructor(options) {
        super(options);
    }
    preConstruct(options) {
        const { generatedSpecFilePath } = setup_smithy_build_1.setupSmithyBuild(this, 
        // Options are the same as those in the constructor, so it is safe to cast to SmithyApiGatewayProjectOptions
        options);
        return {
            ...options,
            specFile: generatedSpecFilePath,
        };
    }
}
exports.SmithyApiGatewayPythonProject = SmithyApiGatewayPythonProject;
_a = JSII_RTTI_SYMBOL_1;
SmithyApiGatewayPythonProject[_a] = { fqn: "@aws-prototyping-sdk/open-api-gateway.SmithyApiGatewayPythonProject", version: "0.14.9" };
//# sourceMappingURL=data:application/json;base64,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