/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.CapacitySize;
import software.amazon.awssdk.services.sagemaker.model.TrafficRoutingConfigType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficRoutingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficRoutingConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(TrafficRoutingConfig.getter(TrafficRoutingConfig::typeAsString)).setter(TrafficRoutingConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<Integer> WAIT_INTERVAL_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WaitIntervalInSeconds").getter(TrafficRoutingConfig.getter(TrafficRoutingConfig::waitIntervalInSeconds)).setter(TrafficRoutingConfig.setter(Builder::waitIntervalInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WaitIntervalInSeconds").build()}).build();
    private static final SdkField<CapacitySize> CANARY_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CanarySize").getter(TrafficRoutingConfig.getter(TrafficRoutingConfig::canarySize)).setter(TrafficRoutingConfig.setter(Builder::canarySize)).constructor(CapacitySize::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CanarySize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, WAIT_INTERVAL_IN_SECONDS_FIELD, CANARY_SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Integer waitIntervalInSeconds;
    private final CapacitySize canarySize;

    private TrafficRoutingConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.waitIntervalInSeconds = builder.waitIntervalInSeconds;
        this.canarySize = builder.canarySize;
    }

    public final TrafficRoutingConfigType type() {
        return TrafficRoutingConfigType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Integer waitIntervalInSeconds() {
        return this.waitIntervalInSeconds;
    }

    public final CapacitySize canarySize() {
        return this.canarySize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.waitIntervalInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.canarySize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficRoutingConfig)) {
            return false;
        }
        TrafficRoutingConfig other = (TrafficRoutingConfig)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.waitIntervalInSeconds(), other.waitIntervalInSeconds()) && Objects.equals(this.canarySize(), other.canarySize());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficRoutingConfig").add("Type", (Object)this.typeAsString()).add("WaitIntervalInSeconds", (Object)this.waitIntervalInSeconds()).add("CanarySize", (Object)this.canarySize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "WaitIntervalInSeconds": {
                return Optional.ofNullable(clazz.cast(this.waitIntervalInSeconds()));
            }
            case "CanarySize": {
                return Optional.ofNullable(clazz.cast(this.canarySize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrafficRoutingConfig, T> g) {
        return obj -> g.apply((TrafficRoutingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Integer waitIntervalInSeconds;
        private CapacitySize canarySize;

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficRoutingConfig model) {
            this.type(model.type);
            this.waitIntervalInSeconds(model.waitIntervalInSeconds);
            this.canarySize(model.canarySize);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(TrafficRoutingConfigType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getWaitIntervalInSeconds() {
            return this.waitIntervalInSeconds;
        }

        public final void setWaitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
        }

        @Override
        @Transient
        public final Builder waitIntervalInSeconds(Integer waitIntervalInSeconds) {
            this.waitIntervalInSeconds = waitIntervalInSeconds;
            return this;
        }

        public final CapacitySize.Builder getCanarySize() {
            return this.canarySize != null ? this.canarySize.toBuilder() : null;
        }

        public final void setCanarySize(CapacitySize.BuilderImpl canarySize) {
            this.canarySize = canarySize != null ? canarySize.build() : null;
        }

        @Override
        @Transient
        public final Builder canarySize(CapacitySize canarySize) {
            this.canarySize = canarySize;
            return this;
        }

        public TrafficRoutingConfig build() {
            return new TrafficRoutingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficRoutingConfig> {
        public Builder type(String var1);

        public Builder type(TrafficRoutingConfigType var1);

        public Builder waitIntervalInSeconds(Integer var1);

        public Builder canarySize(CapacitySize var1);

        default public Builder canarySize(Consumer<CapacitySize.Builder> canarySize) {
            return this.canarySize((CapacitySize)((CapacitySize.Builder)CapacitySize.builder().applyMutation(canarySize)).build());
        }
    }
}

