/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SecondaryStatus {
    STARTING("Starting"),
    LAUNCHING_ML_INSTANCES("LaunchingMLInstances"),
    PREPARING_TRAINING_STACK("PreparingTrainingStack"),
    DOWNLOADING("Downloading"),
    DOWNLOADING_TRAINING_IMAGE("DownloadingTrainingImage"),
    TRAINING("Training"),
    UPLOADING("Uploading"),
    STOPPING("Stopping"),
    STOPPED("Stopped"),
    MAX_RUNTIME_EXCEEDED("MaxRuntimeExceeded"),
    COMPLETED("Completed"),
    FAILED("Failed"),
    INTERRUPTED("Interrupted"),
    MAX_WAIT_TIME_EXCEEDED("MaxWaitTimeExceeded"),
    UPDATING("Updating"),
    RESTARTING("Restarting"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SecondaryStatus> VALUE_MAP;
    private final String value;

    private SecondaryStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SecondaryStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SecondaryStatus> knownValues() {
        EnumSet<SecondaryStatus> knownValues = EnumSet.allOf(SecondaryStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SecondaryStatus.class, SecondaryStatus::toString);
    }
}

