import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from ..core.Object3D import Object3D

from ..materials.Material import Material
from ..core.BaseGeometry_autogen import BaseGeometry
from ..core.BaseBufferGeometry_autogen import BaseBufferGeometry

@register
class Mesh(Object3D):
    """Mesh

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/objects/Mesh
    """

    def __init__(self, geometry=None, material=[], **kwargs):
        kwargs['geometry'] = geometry
        kwargs['material'] = material
        super(Mesh, self).__init__(**kwargs)

    _model_name = Unicode('MeshModel').tag(sync=True)

    material = Union([Instance(Material), Tuple()]).tag(sync=True, **widget_serialization)

    geometry = Union([
        Instance(BaseGeometry, allow_none=False),
        Instance(BaseBufferGeometry, allow_none=False)
    ]).tag(sync=True, **widget_serialization)

    drawMode = Enum(DrawModes, "TrianglesDrawMode", allow_none=False).tag(sync=True)

    morphTargetInfluences = List().tag(sync=True)

    type = Unicode("Mesh", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    Mesh.__signature__ = inspect.signature(Mesh.__init__)
