import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget


@register
class TextureLoader(ThreeWidget):
    """TextureLoader

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/loaders/TextureLoader
    """

    def __init__(self, **kwargs):
        super(TextureLoader, self).__init__(**kwargs)

    _model_name = Unicode('TextureLoaderModel').tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    TextureLoader.__signature__ = inspect.signature(TextureLoader.__init__)
