import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .Light_autogen import Light


@register
class AmbientLight(Light):
    """AmbientLight

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/lights/AmbientLight
    """

    def __init__(self, color="#ffffff", intensity=1, **kwargs):
        kwargs['color'] = color
        kwargs['intensity'] = intensity
        super(AmbientLight, self).__init__(**kwargs)

    _model_name = Unicode('AmbientLightModel').tag(sync=True)

    type = Unicode("AmbientLight", allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    AmbientLight.__signature__ = inspect.signature(AmbientLight.__init__)
