import six
from ipywidgets import (
    Widget, DOMWidget, widget_serialization, register
)
from ipywidgets.widgets.trait_types import TypedTuple
from traitlets import (
    Unicode, Int, CInt, Instance, ForwardDeclaredInstance, This, Enum,
    Tuple, List, Dict, Float, CFloat, Bool, Union, Any,
)

from .._base.Three import ThreeWidget
from .._base.uniforms import uniforms_serialization
from ..enums import *
from ..traits import *

from .._base.Three import ThreeWidget

from .InterleavedBuffer_autogen import InterleavedBuffer

@register
class InterleavedBufferAttribute(ThreeWidget):
    """InterleavedBufferAttribute

    Autogenerated by generate-wrappers.js
    See https://threejs.org/docs/#api/core/InterleavedBufferAttribute
    """

    def __init__(self, data=None, itemSize=0, offset=0, normalized=False, **kwargs):
        kwargs['data'] = data
        kwargs['itemSize'] = itemSize
        kwargs['offset'] = offset
        kwargs['normalized'] = normalized
        super(InterleavedBufferAttribute, self).__init__(**kwargs)

    _model_name = Unicode('InterleavedBufferAttributeModel').tag(sync=True)

    data = Instance(InterleavedBuffer, allow_none=True).tag(sync=True, **widget_serialization)

    itemSize = CInt(0, allow_none=False).tag(sync=True)

    offset = CInt(0, allow_none=False).tag(sync=True)

    normalized = Bool(False, allow_none=False).tag(sync=True)


if six.PY3:
    import inspect
    # Include explicit signature since the metaclass screws it up
    InterleavedBufferAttribute.__signature__ = inspect.signature(InterleavedBufferAttribute.__init__)
