"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GeneratedJavaClientSourceCode = void 0;
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const path = require("path");
const log4js_1 = require("log4js");
const projen_1 = require("projen");
const utils_1 = require("./utils");
const languages_1 = require("../../languages");
const logger = log4js_1.getLogger();
/**
 * Generates the java client using OpenAPI Generator
 */
class GeneratedJavaClientSourceCode extends projen_1.Component {
    constructor(project, options) {
        super(project);
        this.options = options;
    }
    /**
     * @inheritDoc
     */
    synthesize() {
        super.synthesize();
        if (this.options.invokeGenerator) {
            const javaProject = this.project;
            const invokerPackage = `${javaProject.pom.groupId}.${javaProject.name}.client`;
            // Generate the java client
            logger.debug("Generating java client...");
            utils_1.invokeOpenApiGenerator({
                generator: "java",
                specPath: this.options.specPath,
                outputPath: this.project.outdir,
                generatorDirectory: languages_1.ClientLanguage.JAVA,
                additionalProperties: {
                    useSingleRequestParameter: "true",
                    groupId: javaProject.pom.groupId,
                    artifactId: javaProject.pom.artifactId,
                    artifactVersion: javaProject.pom.version,
                    invokerPackage,
                    apiPackage: `${invokerPackage}.api`,
                    modelPackage: `${invokerPackage}.model`,
                    hideGenerationTimestamp: "true",
                    additionalModelTypeAnnotations: [
                        "@lombok.AllArgsConstructor",
                        // Regular lombok builder is not used since an abstract base schema class is also annotated
                        "@lombok.experimental.SuperBuilder",
                    ].join("\\ "),
                },
                srcDir: path.join("src", "main", "java", ...invokerPackage.split(".")),
                normalizers: {
                    KEEP_ONLY_FIRST_TAG_IN_OPERATION: true,
                },
            });
        }
    }
}
exports.GeneratedJavaClientSourceCode = GeneratedJavaClientSourceCode;
//# sourceMappingURL=data:application/json;base64,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